/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.loanaccount.service;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.fineract.organisation.monetary.data.CurrencyData;
import org.apache.fineract.portfolio.loanaccount.data.LoanSummaryData;
import org.apache.fineract.portfolio.loanaccount.data.LoanTransactionBalance;
import org.apache.fineract.portfolio.loanaccount.domain.ChangedTransactionDetail;
import org.apache.fineract.portfolio.loanaccount.domain.Loan;
import org.apache.fineract.portfolio.loanaccount.domain.LoanRepaymentScheduleInstallment;
import org.apache.fineract.portfolio.loanaccount.domain.LoanRepositoryWrapper;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTransaction;
import org.apache.fineract.portfolio.loanaccount.domain.transactionprocessor.impl.AdvancedPaymentScheduleTransactionProcessor;
import org.apache.fineract.portfolio.loanaccount.loanschedule.data.LoanScheduleData;
import org.apache.fineract.portfolio.loanaccount.loanschedule.data.LoanSchedulePeriodData;
import org.apache.fineract.portfolio.loanaccount.service.CommonLoanSummaryDataProvider;
import org.apache.fineract.portfolio.loanproduct.calc.EMICalculator;
import org.apache.fineract.portfolio.loanproduct.calc.data.PeriodDueDetails;
import org.apache.fineract.portfolio.loanproduct.calc.data.ProgressiveLoanInterestScheduleModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ProgressiveLoanSummaryDataProvider
extends CommonLoanSummaryDataProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProgressiveLoanSummaryDataProvider.class);
    private final AdvancedPaymentScheduleTransactionProcessor advancedPaymentScheduleTransactionProcessor;
    private final EMICalculator emiCalculator;
    private final LoanRepositoryWrapper loanRepository;

    public boolean accept(String loanProcessingStrategyCode) {
        return loanProcessingStrategyCode.equalsIgnoreCase("advanced-payment-allocation-strategy");
    }

    public LoanSummaryData withTransactionAmountsSummary(Long loanId, LoanSummaryData defaultSummaryData, LoanScheduleData repaymentSchedule, Collection<LoanTransactionBalance> loanTransactionBalances) {
        Loan loan = this.loanRepository.findOneWithNotFoundDetection(loanId, true);
        return super.withTransactionAmountsSummary(loan, defaultSummaryData, repaymentSchedule, loanTransactionBalances);
    }

    public LoanSummaryData withTransactionAmountsSummary(Loan loan, LoanSummaryData defaultSummaryData, LoanScheduleData repaymentSchedule, Collection<LoanTransactionBalance> loanTransactionBalances) {
        return super.withTransactionAmountsSummary(loan, defaultSummaryData, repaymentSchedule, loanTransactionBalances);
    }

    private LoanRepaymentScheduleInstallment getRelatedRepaymentScheduleInstallment(Loan loan, LocalDate businessDate) {
        return loan.getRepaymentScheduleInstallments().stream().filter(i -> !i.isDownPayment() && !i.isAdditional() && !businessDate.isBefore(i.getFromDate()) && businessDate.isBefore(i.getDueDate())).findFirst().orElseGet(() -> {
            List<LoanRepaymentScheduleInstallment> list = loan.getRepaymentScheduleInstallments().stream().filter(i -> !i.isDownPayment() && !i.isAdditional()).toList();
            return !list.isEmpty() ? list.get(list.size() - 1) : null;
        });
    }

    public BigDecimal computeTotalUnpaidPayableNotDueInterestAmountOnActualPeriod(Loan loan, Collection<LoanSchedulePeriodData> periods, LocalDate businessDate, CurrencyData currency) {
        if (loan.isMatured(businessDate)) {
            return BigDecimal.ZERO;
        }
        LoanRepaymentScheduleInstallment loanRepaymentScheduleInstallment = this.getRelatedRepaymentScheduleInstallment(loan, businessDate);
        if (loan.isInterestBearing() && loanRepaymentScheduleInstallment != null) {
            if (loan.isChargedOff()) {
                return loanRepaymentScheduleInstallment.getInterestOutstanding(loan.getCurrency()).getAmount();
            }
            List<LoanTransaction> transactionsToReprocess = loan.retrieveListOfTransactionsForReprocessing().stream().filter(t -> !t.isAccrualActivity()).toList();
            Pair changedTransactionDetailProgressiveLoanInterestScheduleModelPair = this.advancedPaymentScheduleTransactionProcessor.reprocessProgressiveLoanTransactions(loan.getDisbursementDate(), businessDate, transactionsToReprocess, loan.getCurrency(), loan.getRepaymentScheduleInstallments(), loan.getActiveCharges());
            ProgressiveLoanInterestScheduleModel model = (ProgressiveLoanInterestScheduleModel)changedTransactionDetailProgressiveLoanInterestScheduleModelPair.getRight();
            if (!((ChangedTransactionDetail)changedTransactionDetailProgressiveLoanInterestScheduleModelPair.getLeft()).getCurrentTransactionToOldId().isEmpty() || !((ChangedTransactionDetail)changedTransactionDetailProgressiveLoanInterestScheduleModelPair.getLeft()).getNewTransactionMappings().isEmpty()) {
                List replayedTransactions = ((ChangedTransactionDetail)changedTransactionDetailProgressiveLoanInterestScheduleModelPair.getLeft()).getNewTransactionMappings().keySet().stream().toList();
                log.warn("Reprocessed transactions show differences: There are unsaved changes of the following transactions: {}", replayedTransactions);
            }
            if (model != null) {
                LoanRepaymentScheduleInstallment nextUnpaidInAdvanceInstallment;
                LoanRepaymentScheduleInstallment loanRepaymentScheduleInstallment2 = nextUnpaidInAdvanceInstallment = loanRepaymentScheduleInstallment.isNotFullyPaidOff() ? loanRepaymentScheduleInstallment : (LoanRepaymentScheduleInstallment)loan.getRepaymentScheduleInstallments().stream().filter(LoanRepaymentScheduleInstallment::isNotFullyPaidOff).filter(i -> i.getInstallmentNumber() != null).min(Comparator.comparingInt(LoanRepaymentScheduleInstallment::getInstallmentNumber)).orElse(null);
                if (nextUnpaidInAdvanceInstallment == null) {
                    return BigDecimal.ZERO;
                }
                PeriodDueDetails dueAmounts = this.emiCalculator.getDueAmounts(model, nextUnpaidInAdvanceInstallment.getDueDate(), businessDate);
                if (dueAmounts != null) {
                    BigDecimal interestPaid = nextUnpaidInAdvanceInstallment.getInterestPaid();
                    BigDecimal dueInterest = dueAmounts.getDueInterest().getAmount();
                    if (interestPaid == null) {
                        return dueInterest;
                    }
                    return dueInterest.subtract(interestPaid);
                }
            }
        }
        return BigDecimal.ZERO;
    }

    @Generated
    public ProgressiveLoanSummaryDataProvider(AdvancedPaymentScheduleTransactionProcessor advancedPaymentScheduleTransactionProcessor, EMICalculator emiCalculator, LoanRepositoryWrapper loanRepository) {
        this.advancedPaymentScheduleTransactionProcessor = advancedPaymentScheduleTransactionProcessor;
        this.emiCalculator = emiCalculator;
        this.loanRepository = loanRepository;
    }
}

