/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.loanaccount.service.reamortization;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Comparator;
import java.util.LinkedHashMap;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResultBuilder;
import org.apache.fineract.infrastructure.core.domain.ExternalId;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.infrastructure.core.service.ExternalIdFactory;
import org.apache.fineract.infrastructure.event.business.domain.BusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.reamortization.LoanReAmortizeBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.reamortization.LoanUndoReAmortizeBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.transaction.reamortization.LoanReAmortizeTransactionBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.transaction.reamortization.LoanUndoReAmortizeTransactionBusinessEvent;
import org.apache.fineract.infrastructure.event.business.service.BusinessEventNotifierService;
import org.apache.fineract.organisation.monetary.domain.Money;
import org.apache.fineract.portfolio.loanaccount.domain.Loan;
import org.apache.fineract.portfolio.loanaccount.domain.LoanRepaymentScheduleTransactionProcessorFactory;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTransaction;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTransactionRepository;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTransactionType;
import org.apache.fineract.portfolio.loanaccount.domain.transactionprocessor.LoanRepaymentScheduleTransactionProcessor;
import org.apache.fineract.portfolio.loanaccount.domain.transactionprocessor.MoneyHolder;
import org.apache.fineract.portfolio.loanaccount.domain.transactionprocessor.TransactionCtx;
import org.apache.fineract.portfolio.loanaccount.serialization.LoanChargeValidator;
import org.apache.fineract.portfolio.loanaccount.service.LoanAssembler;
import org.apache.fineract.portfolio.loanaccount.service.ReprocessLoanTransactionsService;
import org.apache.fineract.portfolio.loanaccount.service.reamortization.LoanReAmortizationValidator;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class LoanReAmortizationServiceImpl {
    private final LoanAssembler loanAssembler;
    private final LoanReAmortizationValidator reAmortizationValidator;
    private final ExternalIdFactory externalIdFactory;
    private final BusinessEventNotifierService businessEventNotifierService;
    private final LoanTransactionRepository loanTransactionRepository;
    private final LoanRepaymentScheduleTransactionProcessorFactory loanRepaymentScheduleTransactionProcessorFactory;
    private final LoanChargeValidator loanChargeValidator;
    private final ReprocessLoanTransactionsService reprocessLoanTransactionsService;

    public CommandProcessingResult reAmortize(Long loanId, JsonCommand command) {
        Loan loan = this.loanAssembler.assembleFrom(loanId);
        this.reAmortizationValidator.validateReAmortize(loan, command);
        LinkedHashMap<String, String> changes = new LinkedHashMap<String, String>();
        changes.put("locale", command.locale());
        changes.put("dateFormat", command.dateFormat());
        LoanTransaction reAmortizeTransaction = this.createReAmortizeTransaction(loan, command);
        LoanRepaymentScheduleTransactionProcessor loanRepaymentScheduleTransactionProcessor = this.loanRepaymentScheduleTransactionProcessorFactory.determineProcessor(loan.transactionProcessingStrategy());
        loanRepaymentScheduleTransactionProcessor.processLatestTransaction(reAmortizeTransaction, new TransactionCtx(loan.getCurrency(), loan.getRepaymentScheduleInstallments(), loan.getActiveCharges(), new MoneyHolder(loan.getTotalOverpaidAsMoney()), null));
        this.loanTransactionRepository.saveAndFlush((Object)reAmortizeTransaction);
        this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new LoanReAmortizeBusinessEvent(loan));
        this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new LoanReAmortizeTransactionBusinessEvent(reAmortizeTransaction));
        return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId((Long)reAmortizeTransaction.getId()).withEntityExternalId(reAmortizeTransaction.getExternalId()).withOfficeId(loan.getOfficeId()).withClientId(loan.getClientId()).withGroupId(loan.getGroupId()).withLoanId(command.getLoanId()).with(changes).build();
    }

    public CommandProcessingResult undoReAmortize(Long loanId, JsonCommand command) {
        Loan loan = this.loanAssembler.assembleFrom(loanId);
        this.reAmortizationValidator.validateUndoReAmortize(loan, command);
        LinkedHashMap<String, String> changes = new LinkedHashMap<String, String>();
        changes.put("locale", command.locale());
        changes.put("dateFormat", command.dateFormat());
        LoanTransaction reAmortizeTransaction = this.findLatestNonReversedReAmortizeTransaction(loan);
        if (reAmortizeTransaction == null) {
            // empty if block
        }
        this.reverseReAmortizeTransaction(reAmortizeTransaction, command);
        this.loanTransactionRepository.saveAndFlush((Object)reAmortizeTransaction);
        this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new LoanUndoReAmortizeBusinessEvent(loan));
        this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new LoanUndoReAmortizeTransactionBusinessEvent(reAmortizeTransaction));
        return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId((Long)reAmortizeTransaction.getId()).withEntityExternalId(reAmortizeTransaction.getExternalId()).withOfficeId(loan.getOfficeId()).withClientId(loan.getClientId()).withGroupId(loan.getGroupId()).withLoanId(command.getLoanId()).with(changes).build();
    }

    private void reverseReAmortizeTransaction(LoanTransaction reAmortizeTransaction, JsonCommand command) {
        ExternalId reversalExternalId = this.externalIdFactory.createFromCommand(command, "externalId");
        this.loanChargeValidator.validateRepaymentTypeTransactionNotBeforeAChargeRefund(reAmortizeTransaction.getLoan(), reAmortizeTransaction, "reversed");
        reAmortizeTransaction.reverse(reversalExternalId);
        reAmortizeTransaction.manuallyAdjustedOrReversed();
        this.reprocessLoanTransactionsService.reprocessTransactions(reAmortizeTransaction.getLoan());
    }

    private LoanTransaction findLatestNonReversedReAmortizeTransaction(Loan loan) {
        return loan.getLoanTransactions().stream().filter(LoanTransaction::isNotReversed).filter(LoanTransaction::isReAmortize).max(Comparator.comparing(LoanTransaction::getTransactionDate)).orElse(null);
    }

    private LoanTransaction createReAmortizeTransaction(Loan loan, JsonCommand command) {
        ExternalId txExternalId = this.externalIdFactory.createFromCommand(command, "externalId");
        LocalDate transactionDate = DateUtils.getBusinessLocalDate();
        Money txPrincipal = loan.getTotalPrincipalOutstandingUntil(transactionDate);
        BigDecimal txPrincipalAmount = txPrincipal.getAmount();
        return new LoanTransaction(loan, loan.getOffice(), LoanTransactionType.REAMORTIZE.getValue(), transactionDate, txPrincipalAmount, txPrincipalAmount, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, null, false, null, txExternalId);
    }

    @Generated
    public LoanReAmortizationServiceImpl(LoanAssembler loanAssembler, LoanReAmortizationValidator reAmortizationValidator, ExternalIdFactory externalIdFactory, BusinessEventNotifierService businessEventNotifierService, LoanTransactionRepository loanTransactionRepository, LoanRepaymentScheduleTransactionProcessorFactory loanRepaymentScheduleTransactionProcessorFactory, LoanChargeValidator loanChargeValidator, ReprocessLoanTransactionsService reprocessLoanTransactionsService) {
        this.loanAssembler = loanAssembler;
        this.reAmortizationValidator = reAmortizationValidator;
        this.externalIdFactory = externalIdFactory;
        this.businessEventNotifierService = businessEventNotifierService;
        this.loanTransactionRepository = loanTransactionRepository;
        this.loanRepaymentScheduleTransactionProcessorFactory = loanRepaymentScheduleTransactionProcessorFactory;
        this.loanChargeValidator = loanChargeValidator;
        this.reprocessLoanTransactionsService = reprocessLoanTransactionsService;
    }
}

