/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.savings.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.fineract.accounting.common.AccountingDropdownReadPlatformService;
import org.apache.fineract.accounting.common.AccountingEnumerations;
import org.apache.fineract.accounting.common.AccountingRuleType;
import org.apache.fineract.accounting.producttoaccountmapping.service.ProductToGLAccountMappingReadPlatformService;
import org.apache.fineract.commands.domain.CommandWrapper;
import org.apache.fineract.commands.service.CommandWrapperBuilder;
import org.apache.fineract.commands.service.PortfolioCommandSourceWritePlatformService;
import org.apache.fineract.infrastructure.core.api.ApiRequestParameterHelper;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.EnumOptionData;
import org.apache.fineract.infrastructure.core.serialization.ApiRequestJsonSerializationSettings;
import org.apache.fineract.infrastructure.core.serialization.DefaultToApiJsonSerializer;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.organisation.monetary.data.CurrencyData;
import org.apache.fineract.organisation.monetary.service.CurrencyReadPlatformService;
import org.apache.fineract.portfolio.charge.service.ChargeReadPlatformService;
import org.apache.fineract.portfolio.common.service.DropdownReadPlatformService;
import org.apache.fineract.portfolio.interestratechart.data.InterestRateChartData;
import org.apache.fineract.portfolio.interestratechart.service.InterestRateChartReadPlatformService;
import org.apache.fineract.portfolio.paymenttype.service.PaymentTypeReadPlatformService;
import org.apache.fineract.portfolio.savings.DepositAccountType;
import org.apache.fineract.portfolio.savings.DepositsApiConstants;
import org.apache.fineract.portfolio.savings.SavingsCompoundingInterestPeriodType;
import org.apache.fineract.portfolio.savings.SavingsInterestCalculationDaysInYearType;
import org.apache.fineract.portfolio.savings.SavingsInterestCalculationType;
import org.apache.fineract.portfolio.savings.SavingsPostingInterestPeriodType;
import org.apache.fineract.portfolio.savings.api.RecurringDepositProductsApiResourceSwagger;
import org.apache.fineract.portfolio.savings.data.RecurringDepositProductData;
import org.apache.fineract.portfolio.savings.service.DepositProductReadPlatformService;
import org.apache.fineract.portfolio.savings.service.DepositsDropdownReadPlatformService;
import org.apache.fineract.portfolio.savings.service.SavingsDropdownReadPlatformService;
import org.apache.fineract.portfolio.savings.service.SavingsEnumerations;
import org.apache.fineract.portfolio.tax.service.TaxReadPlatformService;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Path(value="/v1/recurringdepositproducts")
@Component
@Tag(name="Recurring Deposit Product", description="Recurring Deposits are a special kind of Term Deposits offered by MFI's. The Recurring Deposit Products (aka RD) product offerings are modeled using this API.\n\nRecurring Deposits help people with regular incomes to deposit a fixed amount every month (specified recurring frequency) into their Recurring Deposit account.\n\nWhen creating recurring deposit accounts, the details from the recurring deposit product are used to auto fill details of the recurring deposit account application process.")
public class RecurringDepositProductsApiResource {
    private final DepositProductReadPlatformService depositProductReadPlatformService;
    private final SavingsDropdownReadPlatformService savingsDropdownReadPlatformService;
    private final CurrencyReadPlatformService currencyReadPlatformService;
    private final PlatformSecurityContext context;
    private final DefaultToApiJsonSerializer<RecurringDepositProductData> toApiJsonSerializer;
    private final PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService;
    private final ApiRequestParameterHelper apiRequestParameterHelper;
    private final AccountingDropdownReadPlatformService accountingDropdownReadPlatformService;
    private final ProductToGLAccountMappingReadPlatformService accountMappingReadPlatformService;
    private final ChargeReadPlatformService chargeReadPlatformService;
    private final InterestRateChartReadPlatformService chartReadPlatformService;
    private final InterestRateChartReadPlatformService interestRateChartReadPlatformService;
    private final DepositsDropdownReadPlatformService depositsDropdownReadPlatformService;
    private final DropdownReadPlatformService dropdownReadPlatformService;
    private final PaymentTypeReadPlatformService paymentTypeReadPlatformService;
    private final TaxReadPlatformService taxReadPlatformService;

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Create a Recurring Deposit Product", description="Creates a Recurring Deposit Product\n\nMandatory Fields: name, shortName, description, currencyCode, digitsAfterDecimal,inMultiplesOf, interestCompoundingPeriodType, interestCalculationType, interestCalculationDaysInYearType, minDepositTerm, minDepositTermTypeId, recurringDepositFrequency, recurringDepositFrequencyTypeId, accountingRule, depositAmount\n\nMandatory Fields for Cash based accounting (accountingRule = 2): savingsReferenceAccountId, savingsControlAccountId, interestOnSavingsAccountId, incomeFromFeeAccountId, transfersInSuspenseAccountId, incomeFromPenaltyAccountId\n\nOptional Fields: lockinPeriodFrequency, lockinPeriodFrequencyType, maxDepositTerm, maxDepositTermTypeId, inMultiplesOfDepositTerm, inMultiplesOfDepositTermTypeId, preClosurePenalApplicable, preClosurePenalInterest, preClosurePenalInterestOnTypeId, feeToIncomeAccountMappings, penaltyToIncomeAccountMappings, charges, charts, minDepositAmount, maxDepositAmount, withHoldTax, taxGroupId")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=RecurringDepositProductsApiResourceSwagger.PostRecurringDepositProductsRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=RecurringDepositProductsApiResourceSwagger.PostRecurringDepositProductsResponse.class))})})
    public String create(@Parameter(hidden=true) String apiRequestBodyAsJson) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().createRecurringDepositProduct().withJson(apiRequestBodyAsJson).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @PUT
    @Path(value="{productId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Update a Recurring Deposit Product", description="Updates a Recurring Deposit Product")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=RecurringDepositProductsApiResourceSwagger.PutRecurringDepositProductsRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=RecurringDepositProductsApiResourceSwagger.PutRecurringDepositProductsResponse.class))})})
    public String update(@PathParam(value="productId") @Parameter(description="productId") Long productId, @Parameter(hidden=true) String apiRequestBodyAsJson) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().updateRecurringDepositProduct(productId).withJson(apiRequestBodyAsJson).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="List Recuring Deposit Products", description="Lists Recuring Deposit Products\n\nExample Requests:\n\nrecurringdepositproducts\n\n\nrecurringdepositproducts?fields=name")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(array=@ArraySchema(schema=@Schema(implementation=RecurringDepositProductsApiResourceSwagger.GetRecurringDepositProductsResponse.class)))})})
    public String retrieveAll(@Context UriInfo uriInfo) {
        this.context.authenticatedUser().validateHasReadPermission("recurringdepositproduct");
        Collection products = this.depositProductReadPlatformService.retrieveAll(DepositAccountType.RECURRING_DEPOSIT);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.toApiJsonSerializer.serialize(settings, products, DepositsApiConstants.RECURRING_DEPOSIT_PRODUCT_RESPONSE_DATA_PARAMETERS);
    }

    @GET
    @Path(value="{productId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve a Recurring Deposit Product", description="Retrieves a Recurring Deposit Product\n\nExample Requests:\n\nrecurringdepositproducts/1\n\n\nrecurringdepositproducts/1?template=true\n\n\nrecurringdepositproducts/1?fields=name,description")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=RecurringDepositProductsApiResourceSwagger.GetRecurringDepositProductsProductIdResponse.class))})})
    public String retrieveOne(@PathParam(value="productId") @Parameter(description="productId") Long productId, @Context UriInfo uriInfo) {
        this.context.authenticatedUser().validateHasReadPermission("recurringdepositproduct");
        RecurringDepositProductData recurringDepositProductData = (RecurringDepositProductData)this.depositProductReadPlatformService.retrieveOne(DepositAccountType.RECURRING_DEPOSIT, productId);
        Collection charges = this.chargeReadPlatformService.retrieveSavingsProductCharges(productId);
        recurringDepositProductData = RecurringDepositProductData.withCharges((RecurringDepositProductData)recurringDepositProductData, (Collection)charges);
        Collection charts = this.chartReadPlatformService.retrieveAllWithSlabsWithTemplate(productId);
        recurringDepositProductData = RecurringDepositProductData.withInterestChart((RecurringDepositProductData)recurringDepositProductData, (Collection)charts);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        if (recurringDepositProductData.hasAccountingEnabled()) {
            Map accountingMappings = this.accountMappingReadPlatformService.fetchAccountMappingDetailsForSavingsProduct(productId, Integer.valueOf(recurringDepositProductData.accountingRuleTypeId()));
            List paymentChannelToFundSourceMappings = this.accountMappingReadPlatformService.fetchPaymentTypeToFundSourceMappingsForSavingsProduct(productId);
            List feeToGLAccountMappings = this.accountMappingReadPlatformService.fetchFeeToIncomeAccountMappingsForSavingsProduct(productId);
            List penaltyToGLAccountMappings = this.accountMappingReadPlatformService.fetchPenaltyToIncomeAccountMappingsForSavingsProduct(productId);
            recurringDepositProductData = RecurringDepositProductData.withAccountingDetails((RecurringDepositProductData)recurringDepositProductData, (Map)accountingMappings, (Collection)paymentChannelToFundSourceMappings, (Collection)feeToGLAccountMappings, (Collection)penaltyToGLAccountMappings);
        }
        if (settings.isTemplate()) {
            recurringDepositProductData = this.handleTemplateRelatedData(recurringDepositProductData);
        }
        return this.toApiJsonSerializer.serialize(settings, (Object)recurringDepositProductData, DepositsApiConstants.RECURRING_DEPOSIT_PRODUCT_RESPONSE_DATA_PARAMETERS);
    }

    @GET
    @Path(value="template")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String retrieveTemplate(@Context UriInfo uriInfo) {
        this.context.authenticatedUser().validateHasReadPermission("recurringdepositproduct");
        RecurringDepositProductData recurringDepositProduct = this.handleTemplateRelatedData(null);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.toApiJsonSerializer.serialize(settings, (Object)recurringDepositProduct, DepositsApiConstants.RECURRING_DEPOSIT_PRODUCT_RESPONSE_DATA_PARAMETERS);
    }

    private RecurringDepositProductData handleTemplateRelatedData(RecurringDepositProductData savingsProduct) {
        EnumOptionData interestCompoundingPeriodType = SavingsEnumerations.compoundingInterestPeriodType((SavingsCompoundingInterestPeriodType)SavingsCompoundingInterestPeriodType.DAILY);
        EnumOptionData interestPostingPeriodType = SavingsEnumerations.interestPostingPeriodType((SavingsPostingInterestPeriodType)SavingsPostingInterestPeriodType.MONTHLY);
        EnumOptionData interestCalculationType = SavingsEnumerations.interestCalculationType((SavingsInterestCalculationType)SavingsInterestCalculationType.DAILY_BALANCE);
        EnumOptionData interestCalculationDaysInYearType = SavingsEnumerations.interestCalculationDaysInYearType((SavingsInterestCalculationDaysInYearType)SavingsInterestCalculationDaysInYearType.DAYS_365);
        EnumOptionData accountingRule = AccountingEnumerations.accountingRuleType((AccountingRuleType)AccountingRuleType.NONE);
        CurrencyData currency = CurrencyData.blank();
        Collection currencyOptions = this.currencyReadPlatformService.retrieveAllowedCurrencies();
        if (currencyOptions.size() == 1) {
            currency = (CurrencyData)new ArrayList(currencyOptions).get(0);
        }
        Collection interestCompoundingPeriodTypeOptions = this.savingsDropdownReadPlatformService.retrieveCompoundingInterestPeriodTypeOptions();
        Collection interestPostingPeriodTypeOptions = this.savingsDropdownReadPlatformService.retrieveInterestPostingPeriodTypeOptions();
        Collection interestCalculationTypeOptions = this.savingsDropdownReadPlatformService.retrieveInterestCalculationTypeOptions();
        Collection interestCalculationDaysInYearTypeOptions = this.savingsDropdownReadPlatformService.retrieveInterestCalculationDaysInYearTypeOptions();
        Collection lockinPeriodFrequencyTypeOptions = this.savingsDropdownReadPlatformService.retrieveLockinPeriodFrequencyTypeOptions();
        Collection withdrawalFeeTypeOptions = this.savingsDropdownReadPlatformService.retrievewithdrawalFeeTypeOptions();
        Collection paymentTypeOptions = this.paymentTypeReadPlatformService.retrieveAllPaymentTypes();
        List accountingRuleOptions = this.accountingDropdownReadPlatformService.retrieveAccountingRuleTypeOptions();
        Map accountingMappingOptions = this.accountingDropdownReadPlatformService.retrieveAccountMappingOptionsForSavingsProducts();
        Collection preClosurePenalInterestOnTypeOptions = this.depositsDropdownReadPlatformService.retrievePreClosurePenalInterestOnTypeOptions();
        boolean feeChargesOnly = true;
        Collection chargeOptions = this.chargeReadPlatformService.retrieveSavingsProductApplicableCharges(true);
        chargeOptions = CollectionUtils.isEmpty((Collection)chargeOptions) ? null : chargeOptions;
        Collection penaltyOptions = this.chargeReadPlatformService.retrieveSavingsApplicablePenalties();
        penaltyOptions = CollectionUtils.isEmpty((Collection)penaltyOptions) ? null : penaltyOptions;
        List periodFrequencyTypeOptions = this.dropdownReadPlatformService.retrievePeriodFrequencyTypeOptions();
        InterestRateChartData chartTemplate = this.interestRateChartReadPlatformService.template();
        Collection taxGroupOptions = this.taxReadPlatformService.retrieveTaxGroupsForLookUp();
        RecurringDepositProductData recurringDepositProductToReturn = null;
        recurringDepositProductToReturn = savingsProduct != null ? RecurringDepositProductData.withTemplate((RecurringDepositProductData)savingsProduct, (Collection)currencyOptions, (Collection)interestCompoundingPeriodTypeOptions, (Collection)interestPostingPeriodTypeOptions, (Collection)interestCalculationTypeOptions, (Collection)interestCalculationDaysInYearTypeOptions, (Collection)lockinPeriodFrequencyTypeOptions, (Collection)withdrawalFeeTypeOptions, (Collection)paymentTypeOptions, (Collection)accountingRuleOptions, (Map)accountingMappingOptions, (Collection)chargeOptions, (Collection)penaltyOptions, (InterestRateChartData)chartTemplate, (Collection)preClosurePenalInterestOnTypeOptions, (Collection)periodFrequencyTypeOptions, (Collection)taxGroupOptions) : RecurringDepositProductData.template((CurrencyData)currency, (EnumOptionData)interestCompoundingPeriodType, (EnumOptionData)interestPostingPeriodType, (EnumOptionData)interestCalculationType, (EnumOptionData)interestCalculationDaysInYearType, (EnumOptionData)accountingRule, (Collection)currencyOptions, (Collection)interestCompoundingPeriodTypeOptions, (Collection)interestPostingPeriodTypeOptions, (Collection)interestCalculationTypeOptions, (Collection)interestCalculationDaysInYearTypeOptions, (Collection)lockinPeriodFrequencyTypeOptions, (Collection)withdrawalFeeTypeOptions, (Collection)paymentTypeOptions, (Collection)accountingRuleOptions, (Map)accountingMappingOptions, (Collection)chargeOptions, (Collection)penaltyOptions, (InterestRateChartData)chartTemplate, (Collection)preClosurePenalInterestOnTypeOptions, (Collection)periodFrequencyTypeOptions, (Collection)taxGroupOptions);
        return recurringDepositProductToReturn;
    }

    @DELETE
    @Path(value="{productId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Delete a Recurring Deposit Product", description="Deletes a Recurring Deposit Product")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=RecurringDepositProductsApiResourceSwagger.DeleteRecurringDepositProductsProductIdResponse.class))})})
    public String delete(@PathParam(value="productId") @Parameter(description="productId") Long productId) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().deleteRecurringDepositProduct(productId).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @Generated
    public RecurringDepositProductsApiResource(DepositProductReadPlatformService depositProductReadPlatformService, SavingsDropdownReadPlatformService savingsDropdownReadPlatformService, CurrencyReadPlatformService currencyReadPlatformService, PlatformSecurityContext context, DefaultToApiJsonSerializer<RecurringDepositProductData> toApiJsonSerializer, PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService, ApiRequestParameterHelper apiRequestParameterHelper, AccountingDropdownReadPlatformService accountingDropdownReadPlatformService, ProductToGLAccountMappingReadPlatformService accountMappingReadPlatformService, ChargeReadPlatformService chargeReadPlatformService, InterestRateChartReadPlatformService chartReadPlatformService, InterestRateChartReadPlatformService interestRateChartReadPlatformService, DepositsDropdownReadPlatformService depositsDropdownReadPlatformService, DropdownReadPlatformService dropdownReadPlatformService, PaymentTypeReadPlatformService paymentTypeReadPlatformService, TaxReadPlatformService taxReadPlatformService) {
        this.depositProductReadPlatformService = depositProductReadPlatformService;
        this.savingsDropdownReadPlatformService = savingsDropdownReadPlatformService;
        this.currencyReadPlatformService = currencyReadPlatformService;
        this.context = context;
        this.toApiJsonSerializer = toApiJsonSerializer;
        this.commandsSourceWritePlatformService = commandsSourceWritePlatformService;
        this.apiRequestParameterHelper = apiRequestParameterHelper;
        this.accountingDropdownReadPlatformService = accountingDropdownReadPlatformService;
        this.accountMappingReadPlatformService = accountMappingReadPlatformService;
        this.chargeReadPlatformService = chargeReadPlatformService;
        this.chartReadPlatformService = chartReadPlatformService;
        this.interestRateChartReadPlatformService = interestRateChartReadPlatformService;
        this.depositsDropdownReadPlatformService = depositsDropdownReadPlatformService;
        this.dropdownReadPlatformService = dropdownReadPlatformService;
        this.paymentTypeReadPlatformService = paymentTypeReadPlatformService;
        this.taxReadPlatformService = taxReadPlatformService;
    }
}

