/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.savings.domain;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.util.Optional;
import org.apache.fineract.infrastructure.core.domain.AbstractAuditableWithUTCDateTimeCustom;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.organisation.monetary.domain.MonetaryCurrency;
import org.apache.fineract.organisation.monetary.domain.Money;
import org.apache.fineract.portfolio.savings.domain.RecurringDepositAccount;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;

@Entity
@Table(name="m_mandatory_savings_schedule")
public class RecurringDepositScheduleInstallment
extends AbstractAuditableWithUTCDateTimeCustom<Long>
implements PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    @ManyToOne(optional=false)
    @JoinColumn(name="savings_account_id")
    private RecurringDepositAccount account;
    @Column(name="installment", nullable=false)
    private Integer installmentNumber;
    @Column(name="fromdate", nullable=true)
    private LocalDate fromDate;
    @Column(name="duedate", nullable=false)
    private LocalDate dueDate;
    @Column(name="deposit_amount", scale=6, precision=19, nullable=true)
    private BigDecimal depositAmount;
    @Column(name="deposit_amount_completed_derived", scale=6, precision=19, nullable=true)
    private BigDecimal depositAmountCompleted;
    @Column(name="total_paid_in_advance_derived", scale=6, precision=19, nullable=true)
    private BigDecimal totalPaidInAdvance;
    @Column(name="total_paid_late_derived", scale=6, precision=19, nullable=true)
    private BigDecimal totalPaidLate;
    @Column(name="completed_derived", nullable=false)
    private boolean obligationsMet;
    @Column(name="obligations_met_on_date")
    private LocalDate obligationsMetOnDate;
    @Deprecated
    @Column(name="created_date")
    private LocalDateTime createdDateToRemove;
    @Deprecated
    @Column(name="lastmodified_date")
    private LocalDateTime lastModifiedDateToRemove;
    static final long serialVersionUID = 7704666989649241174L;

    protected RecurringDepositScheduleInstallment() {
    }

    private RecurringDepositScheduleInstallment(RecurringDepositAccount account, Integer installmentNumber, LocalDate fromDate, LocalDate dueDate, BigDecimal depositAmount, BigDecimal depositAmountCompleted, BigDecimal totalPaidInAdvance, BigDecimal totalPaidLate, boolean obligationsMet, LocalDate obligationsMetOnDate) {
        this.account = account;
        this.installmentNumber = installmentNumber;
        this.fromDate = fromDate;
        this.dueDate = dueDate;
        this.depositAmount = this.defaultToNullIfZero(depositAmount);
        this.depositAmountCompleted = depositAmountCompleted;
        this.totalPaidInAdvance = totalPaidInAdvance;
        this.totalPaidLate = totalPaidLate;
        this.obligationsMet = obligationsMet;
        this.obligationsMetOnDate = obligationsMetOnDate;
    }

    public static RecurringDepositScheduleInstallment from(RecurringDepositAccount account, Integer installmentNumber, LocalDate fromDate, LocalDate dueDate, BigDecimal depositAmount, BigDecimal depositAmountCompleted, BigDecimal totalPaidInAdvance, BigDecimal totalPaidLate, boolean obligationsMet, LocalDate obligationsMetOnDate) {
        return new RecurringDepositScheduleInstallment(account, installmentNumber, fromDate, dueDate, depositAmount, depositAmountCompleted, totalPaidInAdvance, totalPaidLate, obligationsMet, obligationsMetOnDate);
    }

    public static RecurringDepositScheduleInstallment installment(RecurringDepositAccount account, Integer installmentNumber, LocalDate dueDate, BigDecimal depositAmount) {
        LocalDate fromDate = null;
        BigDecimal depositAmountCompleted = null;
        BigDecimal totalPaidInAdvance = null;
        BigDecimal totalPaidLate = null;
        boolean obligationsMet = false;
        LocalDate obligationsMetOnDate = null;
        return new RecurringDepositScheduleInstallment(account, installmentNumber, fromDate, dueDate, depositAmount, depositAmountCompleted, totalPaidInAdvance, totalPaidLate, false, obligationsMetOnDate);
    }

    private BigDecimal defaultToNullIfZero(BigDecimal value) {
        BigDecimal result = value;
        if (BigDecimal.ZERO.compareTo(value) == 0) {
            result = null;
        }
        return result;
    }

    public boolean isObligationsMet() {
        return this._persistence_get_obligationsMet();
    }

    public boolean isNotFullyPaidOff() {
        return !this._persistence_get_obligationsMet();
    }

    public boolean isPrincipalNotCompleted(MonetaryCurrency currency) {
        return !this.isPrincipalCompleted(currency);
    }

    public boolean isPrincipalCompleted(MonetaryCurrency currency) {
        return this.getDepositAmountOutstanding(currency).isZero();
    }

    public Money getDepositAmountOutstanding(MonetaryCurrency currency) {
        Money depositAmountAccountedFor = this.getDepositAmountCompleted(currency);
        return this.getDepositAmount(currency).minus(depositAmountAccountedFor);
    }

    public Money getDepositAmountCompleted(MonetaryCurrency currency) {
        return Money.of((MonetaryCurrency)currency, (BigDecimal)this._persistence_get_depositAmountCompleted());
    }

    public Money getDepositAmount(MonetaryCurrency currency) {
        return Money.of((MonetaryCurrency)currency, (BigDecimal)this._persistence_get_depositAmount());
    }

    public LocalDate dueDate() {
        return this._persistence_get_dueDate();
    }

    public Integer installmentNumber() {
        return this._persistence_get_installmentNumber();
    }

    public Optional<OffsetDateTime> getCreatedDate() {
        return Optional.ofNullable(super.getCreatedDate().orElse(this._persistence_get_createdDateToRemove() == null ? null : this._persistence_get_createdDateToRemove().atZone(DateUtils.getSystemZoneId()).toOffsetDateTime()));
    }

    public Optional<OffsetDateTime> getLastModifiedDate() {
        return Optional.ofNullable(super.getLastModifiedDate().orElse(this._persistence_get_lastModifiedDateToRemove() == null ? null : this._persistence_get_lastModifiedDateToRemove().atZone(DateUtils.getSystemZoneId()).toOffsetDateTime()));
    }

    public Money payInstallment(LocalDate transactionDate, Money transactionAmountRemaining) {
        MonetaryCurrency currency = transactionAmountRemaining.getCurrency();
        Money depositAmountPortionOfTransaction = Money.zero((MonetaryCurrency)currency);
        Money depositAmount = this.getDepositAmountOutstanding(currency);
        if (transactionAmountRemaining.isGreaterThanOrEqualTo(depositAmount)) {
            this._persistence_set_depositAmountCompleted(this.getDepositAmountCompleted(currency).plus(depositAmount).getAmount());
            depositAmountPortionOfTransaction = depositAmountPortionOfTransaction.plus(depositAmount);
        } else {
            this._persistence_set_depositAmountCompleted(this.getDepositAmountCompleted(currency).plus(transactionAmountRemaining).getAmount());
            depositAmountPortionOfTransaction = depositAmountPortionOfTransaction.plus(transactionAmountRemaining);
        }
        this._persistence_set_depositAmountCompleted(this.defaultToNullIfZero(this._persistence_get_depositAmountCompleted()));
        this.checkIfInstallmentObligationsAreMet(transactionDate, currency);
        this.trackAdvanceAndLateTotalsForInstallment(transactionDate, currency, depositAmountPortionOfTransaction);
        return depositAmountPortionOfTransaction;
    }

    private void checkIfInstallmentObligationsAreMet(LocalDate transactionDate, MonetaryCurrency currency) {
        this._persistence_set_obligationsMet(this.getTotalOutstanding(currency).isZero());
        if (this._persistence_get_obligationsMet()) {
            this._persistence_set_obligationsMetOnDate(transactionDate);
        }
    }

    public Money getTotalOutstanding(MonetaryCurrency currency) {
        return this.getDepositAmountOutstanding(currency);
    }

    private void trackAdvanceAndLateTotalsForInstallment(LocalDate transactionDate, MonetaryCurrency currency, Money amountPaidInInstallment) {
        if (this.isInAdvance(transactionDate)) {
            this._persistence_set_totalPaidInAdvance(this.asMoney(this._persistence_get_totalPaidInAdvance(), currency).plus(amountPaidInInstallment).getAmount());
        } else if (this.isLatePayment(transactionDate)) {
            this._persistence_set_totalPaidLate(this.asMoney(this._persistence_get_totalPaidLate(), currency).plus(amountPaidInInstallment).getAmount());
        }
    }

    private boolean isInAdvance(LocalDate transactionDate) {
        return DateUtils.isBefore((LocalDate)transactionDate, (LocalDate)this.dueDate());
    }

    private boolean isLatePayment(LocalDate transactionDate) {
        return DateUtils.isAfter((LocalDate)transactionDate, (LocalDate)this.dueDate());
    }

    private Money asMoney(BigDecimal decimal, MonetaryCurrency currency) {
        return Money.of((MonetaryCurrency)currency, (BigDecimal)decimal);
    }

    public void resetDerivedFields() {
        this._persistence_set_depositAmountCompleted(null);
        this._persistence_set_totalPaidInAdvance(null);
        this._persistence_set_totalPaidLate(null);
        this._persistence_set_obligationsMet(false);
        this._persistence_set_obligationsMetOnDate(null);
    }

    public void updateDepositAmountAndResetDerivedFields(BigDecimal newDepositAmount) {
        this._persistence_set_depositAmount(newDepositAmount);
        this.resetDerivedFields();
    }

    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new RecurringDepositScheduleInstallment();
    }

    public Object _persistence_get(String string) {
        if (string == "depositAmount") {
            return this.depositAmount;
        }
        if (string == "depositAmountCompleted") {
            return this.depositAmountCompleted;
        }
        if (string == "obligationsMetOnDate") {
            return this.obligationsMetOnDate;
        }
        if (string == "dueDate") {
            return this.dueDate;
        }
        if (string == "installmentNumber") {
            return this.installmentNumber;
        }
        if (string == "fromDate") {
            return this.fromDate;
        }
        if (string == "lastModifiedDateToRemove") {
            return this.lastModifiedDateToRemove;
        }
        if (string == "createdDateToRemove") {
            return this.createdDateToRemove;
        }
        if (string == "totalPaidLate") {
            return this.totalPaidLate;
        }
        if (string == "totalPaidInAdvance") {
            return this.totalPaidInAdvance;
        }
        if (string == "obligationsMet") {
            return this.obligationsMet;
        }
        if (string == "account") {
            return this.account;
        }
        return super._persistence_get(string);
    }

    public void _persistence_set(String string, Object object) {
        if (string == "depositAmount") {
            this.depositAmount = (BigDecimal)object;
            return;
        }
        if (string == "depositAmountCompleted") {
            this.depositAmountCompleted = (BigDecimal)object;
            return;
        }
        if (string == "obligationsMetOnDate") {
            this.obligationsMetOnDate = (LocalDate)object;
            return;
        }
        if (string == "dueDate") {
            this.dueDate = (LocalDate)object;
            return;
        }
        if (string == "installmentNumber") {
            this.installmentNumber = (Integer)object;
            return;
        }
        if (string == "fromDate") {
            this.fromDate = (LocalDate)object;
            return;
        }
        if (string == "lastModifiedDateToRemove") {
            this.lastModifiedDateToRemove = (LocalDateTime)object;
            return;
        }
        if (string == "createdDateToRemove") {
            this.createdDateToRemove = (LocalDateTime)object;
            return;
        }
        if (string == "totalPaidLate") {
            this.totalPaidLate = (BigDecimal)object;
            return;
        }
        if (string == "totalPaidInAdvance") {
            this.totalPaidInAdvance = (BigDecimal)object;
            return;
        }
        if (string == "obligationsMet") {
            this.obligationsMet = (Boolean)object;
            return;
        }
        if (string == "account") {
            this.account = (RecurringDepositAccount)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public BigDecimal _persistence_get_depositAmount() {
        this._persistence_checkFetched("depositAmount");
        return this.depositAmount;
    }

    public void _persistence_set_depositAmount(BigDecimal bigDecimal) {
        this._persistence_checkFetchedForSet("depositAmount");
        this._persistence_propertyChange("depositAmount", (Object)this.depositAmount, (Object)bigDecimal);
        this.depositAmount = bigDecimal;
    }

    public BigDecimal _persistence_get_depositAmountCompleted() {
        this._persistence_checkFetched("depositAmountCompleted");
        return this.depositAmountCompleted;
    }

    public void _persistence_set_depositAmountCompleted(BigDecimal bigDecimal) {
        this._persistence_checkFetchedForSet("depositAmountCompleted");
        this._persistence_propertyChange("depositAmountCompleted", (Object)this.depositAmountCompleted, (Object)bigDecimal);
        this.depositAmountCompleted = bigDecimal;
    }

    public LocalDate _persistence_get_obligationsMetOnDate() {
        this._persistence_checkFetched("obligationsMetOnDate");
        return this.obligationsMetOnDate;
    }

    public void _persistence_set_obligationsMetOnDate(LocalDate localDate) {
        this._persistence_checkFetchedForSet("obligationsMetOnDate");
        this._persistence_propertyChange("obligationsMetOnDate", (Object)this.obligationsMetOnDate, (Object)localDate);
        this.obligationsMetOnDate = localDate;
    }

    public LocalDate _persistence_get_dueDate() {
        this._persistence_checkFetched("dueDate");
        return this.dueDate;
    }

    public void _persistence_set_dueDate(LocalDate localDate) {
        this._persistence_checkFetchedForSet("dueDate");
        this._persistence_propertyChange("dueDate", (Object)this.dueDate, (Object)localDate);
        this.dueDate = localDate;
    }

    public Integer _persistence_get_installmentNumber() {
        this._persistence_checkFetched("installmentNumber");
        return this.installmentNumber;
    }

    public void _persistence_set_installmentNumber(Integer n) {
        this._persistence_checkFetchedForSet("installmentNumber");
        this._persistence_propertyChange("installmentNumber", (Object)this.installmentNumber, (Object)n);
        this.installmentNumber = n;
    }

    public LocalDate _persistence_get_fromDate() {
        this._persistence_checkFetched("fromDate");
        return this.fromDate;
    }

    public void _persistence_set_fromDate(LocalDate localDate) {
        this._persistence_checkFetchedForSet("fromDate");
        this._persistence_propertyChange("fromDate", (Object)this.fromDate, (Object)localDate);
        this.fromDate = localDate;
    }

    public LocalDateTime _persistence_get_lastModifiedDateToRemove() {
        this._persistence_checkFetched("lastModifiedDateToRemove");
        return this.lastModifiedDateToRemove;
    }

    public void _persistence_set_lastModifiedDateToRemove(LocalDateTime localDateTime) {
        this._persistence_checkFetchedForSet("lastModifiedDateToRemove");
        this._persistence_propertyChange("lastModifiedDateToRemove", (Object)this.lastModifiedDateToRemove, (Object)localDateTime);
        this.lastModifiedDateToRemove = localDateTime;
    }

    public LocalDateTime _persistence_get_createdDateToRemove() {
        this._persistence_checkFetched("createdDateToRemove");
        return this.createdDateToRemove;
    }

    public void _persistence_set_createdDateToRemove(LocalDateTime localDateTime) {
        this._persistence_checkFetchedForSet("createdDateToRemove");
        this._persistence_propertyChange("createdDateToRemove", (Object)this.createdDateToRemove, (Object)localDateTime);
        this.createdDateToRemove = localDateTime;
    }

    public BigDecimal _persistence_get_totalPaidLate() {
        this._persistence_checkFetched("totalPaidLate");
        return this.totalPaidLate;
    }

    public void _persistence_set_totalPaidLate(BigDecimal bigDecimal) {
        this._persistence_checkFetchedForSet("totalPaidLate");
        this._persistence_propertyChange("totalPaidLate", (Object)this.totalPaidLate, (Object)bigDecimal);
        this.totalPaidLate = bigDecimal;
    }

    public BigDecimal _persistence_get_totalPaidInAdvance() {
        this._persistence_checkFetched("totalPaidInAdvance");
        return this.totalPaidInAdvance;
    }

    public void _persistence_set_totalPaidInAdvance(BigDecimal bigDecimal) {
        this._persistence_checkFetchedForSet("totalPaidInAdvance");
        this._persistence_propertyChange("totalPaidInAdvance", (Object)this.totalPaidInAdvance, (Object)bigDecimal);
        this.totalPaidInAdvance = bigDecimal;
    }

    public boolean _persistence_get_obligationsMet() {
        this._persistence_checkFetched("obligationsMet");
        return this.obligationsMet;
    }

    public void _persistence_set_obligationsMet(boolean bl) {
        this._persistence_checkFetchedForSet("obligationsMet");
        this._persistence_propertyChange("obligationsMet", (Object)new Boolean(this.obligationsMet), (Object)new Boolean(bl));
        this.obligationsMet = bl;
    }

    public RecurringDepositAccount _persistence_get_account() {
        this._persistence_checkFetched("account");
        return this.account;
    }

    public void _persistence_set_account(RecurringDepositAccount recurringDepositAccount) {
        this._persistence_checkFetchedForSet("account");
        this._persistence_propertyChange("account", (Object)this.account, (Object)recurringDepositAccount);
        this.account = recurringDepositAccount;
    }
}

