/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.savings.service;

import java.math.BigDecimal;
import java.math.MathContext;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.accounting.journalentry.service.JournalEntryWritePlatformService;
import org.apache.fineract.infrastructure.configuration.domain.ConfigurationDomainService;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResultBuilder;
import org.apache.fineract.infrastructure.core.data.DataValidatorBuilder;
import org.apache.fineract.infrastructure.core.domain.ExternalId;
import org.apache.fineract.infrastructure.core.exception.PlatformApiDataValidationException;
import org.apache.fineract.infrastructure.core.exception.PlatformServiceUnavailableException;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.organisation.holiday.domain.HolidayRepositoryWrapper;
import org.apache.fineract.organisation.monetary.domain.ApplicationCurrencyRepositoryWrapper;
import org.apache.fineract.organisation.monetary.domain.MonetaryCurrency;
import org.apache.fineract.organisation.monetary.domain.Money;
import org.apache.fineract.organisation.monetary.domain.MoneyHelper;
import org.apache.fineract.organisation.office.domain.Office;
import org.apache.fineract.organisation.staff.domain.Staff;
import org.apache.fineract.organisation.workingdays.domain.WorkingDaysRepositoryWrapper;
import org.apache.fineract.portfolio.account.PortfolioAccountType;
import org.apache.fineract.portfolio.account.data.AccountTransferDTO;
import org.apache.fineract.portfolio.account.data.PortfolioAccountData;
import org.apache.fineract.portfolio.account.domain.AccountTransferType;
import org.apache.fineract.portfolio.account.service.AccountAssociationsReadPlatformService;
import org.apache.fineract.portfolio.account.service.AccountTransfersReadPlatformService;
import org.apache.fineract.portfolio.account.service.AccountTransfersWritePlatformService;
import org.apache.fineract.portfolio.calendar.domain.Calendar;
import org.apache.fineract.portfolio.calendar.domain.CalendarEntityType;
import org.apache.fineract.portfolio.calendar.domain.CalendarFrequencyType;
import org.apache.fineract.portfolio.calendar.domain.CalendarInstance;
import org.apache.fineract.portfolio.calendar.domain.CalendarInstanceRepository;
import org.apache.fineract.portfolio.calendar.domain.CalendarType;
import org.apache.fineract.portfolio.calendar.service.CalendarUtils;
import org.apache.fineract.portfolio.charge.domain.Charge;
import org.apache.fineract.portfolio.charge.domain.ChargeRepositoryWrapper;
import org.apache.fineract.portfolio.client.domain.Client;
import org.apache.fineract.portfolio.client.exception.ClientNotActiveException;
import org.apache.fineract.portfolio.common.domain.PeriodFrequencyType;
import org.apache.fineract.portfolio.group.domain.Group;
import org.apache.fineract.portfolio.group.exception.GroupNotActiveException;
import org.apache.fineract.portfolio.note.domain.Note;
import org.apache.fineract.portfolio.note.domain.NoteRepository;
import org.apache.fineract.portfolio.paymentdetail.domain.PaymentDetail;
import org.apache.fineract.portfolio.paymentdetail.service.PaymentDetailWritePlatformService;
import org.apache.fineract.portfolio.savings.DepositAccountType;
import org.apache.fineract.portfolio.savings.SavingsAccountTransactionType;
import org.apache.fineract.portfolio.savings.data.DepositAccountTransactionDataValidator;
import org.apache.fineract.portfolio.savings.data.SavingsAccountChargeDataValidator;
import org.apache.fineract.portfolio.savings.data.SavingsAccountTransactionDTO;
import org.apache.fineract.portfolio.savings.domain.DepositAccountAssembler;
import org.apache.fineract.portfolio.savings.domain.DepositAccountDomainService;
import org.apache.fineract.portfolio.savings.domain.DepositAccountOnHoldTransactionRepository;
import org.apache.fineract.portfolio.savings.domain.DepositAccountRecurringDetail;
import org.apache.fineract.portfolio.savings.domain.FixedDepositAccount;
import org.apache.fineract.portfolio.savings.domain.RecurringDepositAccount;
import org.apache.fineract.portfolio.savings.domain.SavingsAccount;
import org.apache.fineract.portfolio.savings.domain.SavingsAccountCharge;
import org.apache.fineract.portfolio.savings.domain.SavingsAccountChargeRepositoryWrapper;
import org.apache.fineract.portfolio.savings.domain.SavingsAccountRepositoryWrapper;
import org.apache.fineract.portfolio.savings.domain.SavingsAccountStatusType;
import org.apache.fineract.portfolio.savings.domain.SavingsAccountTransaction;
import org.apache.fineract.portfolio.savings.domain.SavingsAccountTransactionRepository;
import org.apache.fineract.portfolio.savings.exception.DepositAccountTransactionNotAllowedException;
import org.apache.fineract.portfolio.savings.exception.SavingsAccountTransactionNotFoundException;
import org.apache.fineract.portfolio.savings.exception.TransactionUpdateNotAllowedException;
import org.apache.fineract.portfolio.savings.service.DepositAccountReadPlatformService;
import org.apache.fineract.portfolio.savings.service.DepositAccountWritePlatformService;
import org.apache.fineract.useradministration.domain.AppUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class DepositAccountWritePlatformServiceJpaRepositoryImpl
implements DepositAccountWritePlatformService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DepositAccountWritePlatformServiceJpaRepositoryImpl.class);
    private final PlatformSecurityContext context;
    private final SavingsAccountRepositoryWrapper savingAccountRepositoryWrapper;
    private final SavingsAccountTransactionRepository savingsAccountTransactionRepository;
    private final DepositAccountAssembler depositAccountAssembler;
    private final DepositAccountTransactionDataValidator depositAccountTransactionDataValidator;
    private final SavingsAccountChargeDataValidator savingsAccountChargeDataValidator;
    private final PaymentDetailWritePlatformService paymentDetailWritePlatformService;
    private final ApplicationCurrencyRepositoryWrapper applicationCurrencyRepositoryWrapper;
    private final JournalEntryWritePlatformService journalEntryWritePlatformService;
    private final DepositAccountDomainService depositAccountDomainService;
    private final NoteRepository noteRepository;
    private final AccountTransfersReadPlatformService accountTransfersReadPlatformService;
    private final ChargeRepositoryWrapper chargeRepository;
    private final SavingsAccountChargeRepositoryWrapper savingsAccountChargeRepository;
    private final AccountAssociationsReadPlatformService accountAssociationsReadPlatformService;
    private final AccountTransfersWritePlatformService accountTransfersWritePlatformService;
    private final DepositAccountReadPlatformService depositAccountReadPlatformService;
    private final CalendarInstanceRepository calendarInstanceRepository;
    private final ConfigurationDomainService configurationDomainService;
    private final HolidayRepositoryWrapper holidayRepository;
    private final WorkingDaysRepositoryWrapper workingDaysRepository;
    private final DepositAccountOnHoldTransactionRepository depositAccountOnHoldTransactionRepository;

    @Transactional
    public CommandProcessingResult activateFDAccount(Long savingsId, JsonCommand command) {
        AppUser user = this.context.authenticatedUser();
        boolean isSavingsInterestPostingAtCurrentPeriodEnd = this.configurationDomainService.isSavingsInterestPostingAtCurrentPeriodEnd();
        Integer financialYearBeginningMonth = this.configurationDomainService.retrieveFinancialYearBeginningMonth();
        boolean postReversals = false;
        this.depositAccountTransactionDataValidator.validateActivation(command);
        MathContext mc = MathContext.DECIMAL64;
        FixedDepositAccount account = (FixedDepositAccount)this.depositAccountAssembler.assembleFrom(savingsId, DepositAccountType.FIXED_DEPOSIT);
        this.checkClientOrGroupActive((SavingsAccount)account);
        HashSet existingTransactionIds = new HashSet();
        HashSet existingReversedTransactionIds = new HashSet();
        this.updateExistingTransactionsDetails((SavingsAccount)account, existingTransactionIds, existingReversedTransactionIds);
        Map changes = account.activate(user, command);
        Money activationChargeAmount = this.getActivationCharge(account);
        if (!changes.isEmpty()) {
            Locale locale = command.extractLocale();
            DateTimeFormatter fmt = DateTimeFormatter.ofPattern(command.dateFormat()).withLocale(locale);
            Money amountForDeposit = account.activateWithBalance().plus(activationChargeAmount);
            if (amountForDeposit.isGreaterThanZero()) {
                PortfolioAccountData portfolioAccountData = this.accountAssociationsReadPlatformService.retriveSavingsLinkedAssociation(savingsId);
                if (portfolioAccountData == null) {
                    PaymentDetail paymentDetail = null;
                    this.depositAccountDomainService.handleFDDeposit(account, fmt, account.getActivationDate(), amountForDeposit.getAmount(), paymentDetail);
                } else {
                    SavingsAccount fromSavingsAccount = null;
                    boolean isRegularTransaction = false;
                    boolean isExceptionForBalanceCheck = false;
                    AccountTransferDTO accountTransferDTO = new AccountTransferDTO(account.getActivationDate(), amountForDeposit.getAmount(), PortfolioAccountType.SAVINGS, PortfolioAccountType.SAVINGS, portfolioAccountData.getId(), (Long)account.getId(), "Account Transfer", locale, fmt, null, null, null, null, null, AccountTransferType.ACCOUNT_TRANSFER.getValue(), null, null, ExternalId.empty(), null, (SavingsAccount)account, fromSavingsAccount, Boolean.valueOf(isRegularTransaction), Boolean.valueOf(false));
                    this.accountTransfersWritePlatformService.transferFunds(accountTransferDTO);
                }
                boolean isInterestTransfer = false;
                LocalDate postInterestOnDate = null;
                if (activationChargeAmount.isGreaterThanZero()) {
                    this.payActivationCharge(account);
                }
                if (account.isBeforeLastPostingPeriod(account.getActivationDate(), false)) {
                    LocalDate today = DateUtils.getBusinessLocalDate();
                    account.postInterest(mc, today, false, isSavingsInterestPostingAtCurrentPeriodEnd, financialYearBeginningMonth, postInterestOnDate, false);
                } else {
                    LocalDate today = DateUtils.getBusinessLocalDate();
                    account.calculateInterestUsing(mc, today, false, isSavingsInterestPostingAtCurrentPeriodEnd, financialYearBeginningMonth, postInterestOnDate, false, false);
                }
                this.updateExistingTransactionsDetails((SavingsAccount)account, existingTransactionIds, existingReversedTransactionIds);
            }
            boolean isPreMatureClosure = false;
            account.updateMaturityDateAndAmount(mc, false, isSavingsInterestPostingAtCurrentPeriodEnd, financialYearBeginningMonth);
            List depositAccountOnHoldTransactions = null;
            if (account.getOnHoldFunds().compareTo(BigDecimal.ZERO) > 0) {
                depositAccountOnHoldTransactions = this.depositAccountOnHoldTransactionRepository.findBySavingsAccountAndReversedFalseOrderByCreatedDateAsc((SavingsAccount)account);
            }
            account.validateAccountBalanceDoesNotBecomeNegative(SavingsAccountTransactionType.PAY_CHARGE.name(), depositAccountOnHoldTransactions, false);
            this.savingAccountRepositoryWrapper.saveAndFlush((SavingsAccount)account);
        }
        this.postJournalEntries((SavingsAccount)account, existingTransactionIds, existingReversedTransactionIds);
        return new CommandProcessingResultBuilder().withEntityId(savingsId).withOfficeId(account.officeId()).withClientId(account.clientId()).withGroupId(account.groupId()).withSavingsId(savingsId).with(changes).build();
    }

    private Money getActivationCharge(FixedDepositAccount account) {
        Money activationChargeAmount = Money.zero((MonetaryCurrency)account.getCurrency());
        for (SavingsAccountCharge savingsAccountCharge : account.charges()) {
            if (!savingsAccountCharge.isSavingsActivation()) continue;
            activationChargeAmount = activationChargeAmount.plus(savingsAccountCharge.getAmount(account.getCurrency()));
        }
        return activationChargeAmount;
    }

    private void payActivationCharge(FixedDepositAccount account) {
        for (SavingsAccountCharge savingsAccountCharge : account.charges()) {
            if (!savingsAccountCharge.isSavingsActivation()) continue;
            account.payCharge(savingsAccountCharge, savingsAccountCharge.getAmount(account.getCurrency()), account.getActivationDate(), false, null);
        }
    }

    @Transactional
    public CommandProcessingResult activateRDAccount(Long savingsId, JsonCommand command) {
        boolean isRegularTransaction = false;
        AppUser user = this.context.authenticatedUser();
        boolean isSavingsInterestPostingAtCurrentPeriodEnd = this.configurationDomainService.isSavingsInterestPostingAtCurrentPeriodEnd();
        Integer financialYearBeginningMonth = this.configurationDomainService.retrieveFinancialYearBeginningMonth();
        boolean postReversals = false;
        this.depositAccountTransactionDataValidator.validateActivation(command);
        RecurringDepositAccount account = (RecurringDepositAccount)this.depositAccountAssembler.assembleFrom(savingsId, DepositAccountType.RECURRING_DEPOSIT);
        this.checkClientOrGroupActive((SavingsAccount)account);
        HashSet existingTransactionIds = new HashSet();
        HashSet existingReversedTransactionIds = new HashSet();
        this.updateExistingTransactionsDetails((SavingsAccount)account, existingTransactionIds, existingReversedTransactionIds);
        Map changes = account.activate(user, command);
        if (!changes.isEmpty()) {
            Locale locale = command.extractLocale();
            DateTimeFormatter fmt = DateTimeFormatter.ofPattern(command.dateFormat()).withLocale(locale);
            Money amountForDeposit = account.activateWithBalance();
            if (amountForDeposit.isGreaterThanZero()) {
                PortfolioAccountData portfolioAccountData = this.accountAssociationsReadPlatformService.retriveSavingsLinkedAssociation(savingsId);
                if (portfolioAccountData == null) {
                    this.depositAccountDomainService.handleRDDeposit(account, fmt, account.getActivationDate(), amountForDeposit.getAmount(), null, isRegularTransaction);
                } else {
                    boolean isExceptionForBalanceCheck = false;
                    SavingsAccount fromSavingsAccount = null;
                    AccountTransferDTO accountTransferDTO = new AccountTransferDTO(account.getActivationDate(), amountForDeposit.getAmount(), PortfolioAccountType.SAVINGS, PortfolioAccountType.SAVINGS, portfolioAccountData.getId(), (Long)account.getId(), "Account Transfer", locale, fmt, null, null, null, null, null, AccountTransferType.ACCOUNT_TRANSFER.getValue(), null, null, ExternalId.empty(), null, (SavingsAccount)account, fromSavingsAccount, Boolean.valueOf(isRegularTransaction), Boolean.valueOf(false));
                    this.accountTransfersWritePlatformService.transferFunds(accountTransferDTO);
                }
                this.updateExistingTransactionsDetails((SavingsAccount)account, existingTransactionIds, existingReversedTransactionIds);
            }
            MathContext mc = MathContext.DECIMAL64;
            if (!account.accountSubmittedAndActivationOnSameDate()) {
                boolean isPreMatureClosure = false;
                CalendarInstance calendarInstance = this.calendarInstanceRepository.findByEntityIdAndEntityTypeIdAndCalendarTypeId(savingsId, CalendarEntityType.SAVINGS.getValue(), CalendarType.COLLECTION.getValue());
                Calendar calendar = calendarInstance.getCalendar();
                PeriodFrequencyType frequencyType = CalendarFrequencyType.from((CalendarFrequencyType)CalendarUtils.getFrequency((String)calendar.getRecurrence()));
                Integer frequency = CalendarUtils.getInterval((String)calendar.getRecurrence());
                frequency = frequency == -1 ? 1 : frequency;
                account.generateSchedule(frequencyType, frequency, calendar);
                account.updateMaturityDateAndAmount(mc, false, isSavingsInterestPostingAtCurrentPeriodEnd, financialYearBeginningMonth);
            }
            LocalDate overdueUptoDate = DateUtils.getBusinessLocalDate();
            account.updateOverduePayments(overdueUptoDate);
            boolean isInterestTransfer = false;
            LocalDate postInterestOnDate = null;
            if (account.isBeforeLastPostingPeriod(account.getActivationDate(), false)) {
                today = DateUtils.getBusinessLocalDate();
                account.postInterest(mc, today, false, isSavingsInterestPostingAtCurrentPeriodEnd, financialYearBeginningMonth, postInterestOnDate, false, false);
            } else {
                today = DateUtils.getBusinessLocalDate();
                account.calculateInterestUsing(mc, today, false, isSavingsInterestPostingAtCurrentPeriodEnd, financialYearBeginningMonth, postInterestOnDate, false, false);
            }
            List depositAccountOnHoldTransactions = null;
            if (account.getOnHoldFunds().compareTo(BigDecimal.ZERO) > 0) {
                depositAccountOnHoldTransactions = this.depositAccountOnHoldTransactionRepository.findBySavingsAccountAndReversedFalseOrderByCreatedDateAsc((SavingsAccount)account);
            }
            account.validateAccountBalanceDoesNotBecomeNegative(SavingsAccountTransactionType.PAY_CHARGE.name(), depositAccountOnHoldTransactions, false);
            this.savingAccountRepositoryWrapper.saveAndFlush((SavingsAccount)account);
        }
        this.postJournalEntries((SavingsAccount)account, existingTransactionIds, existingReversedTransactionIds);
        return new CommandProcessingResultBuilder().withEntityId(savingsId).withOfficeId(account.officeId()).withClientId(account.clientId()).withGroupId(account.groupId()).withSavingsId(savingsId).with(changes).build();
    }

    @Transactional
    public CommandProcessingResult depositToFDAccount(Long savingsId, JsonCommand command) {
        throw new DepositAccountTransactionNotAllowedException(savingsId, "deposit", DepositAccountType.FIXED_DEPOSIT);
    }

    @Transactional
    public CommandProcessingResult updateDepositAmountForRDAccount(Long savingsId, JsonCommand command) {
        this.depositAccountTransactionDataValidator.validateDepositAmountUpdate(command);
        boolean isSavingsInterestPostingAtCurrentPeriodEnd = this.configurationDomainService.isSavingsInterestPostingAtCurrentPeriodEnd();
        Integer financialYearBeginningMonth = this.configurationDomainService.retrieveFinancialYearBeginningMonth();
        BigDecimal mandatoryRecommendedDepositAmount = command.bigDecimalValueOfParameterNamed("mandatoryRecommendedDepositAmount");
        LocalDate depositAmountUpdateEffectiveFromDate = command.localDateValueOfParameterNamed("effectiveDate");
        RecurringDepositAccount recurringDepositAccount = (RecurringDepositAccount)this.depositAccountAssembler.assembleFrom(savingsId, DepositAccountType.RECURRING_DEPOSIT);
        DepositAccountRecurringDetail recurringDetail = recurringDepositAccount.getRecurringDetail();
        Map changes = recurringDetail.updateMandatoryRecommendedDepositAmount(mandatoryRecommendedDepositAmount, depositAmountUpdateEffectiveFromDate, Boolean.valueOf(isSavingsInterestPostingAtCurrentPeriodEnd), financialYearBeginningMonth);
        return new CommandProcessingResultBuilder().withEntityId(savingsId).withOfficeId(recurringDepositAccount.officeId()).withClientId(recurringDepositAccount.clientId()).withGroupId(recurringDepositAccount.groupId()).withSavingsId(savingsId).with(changes).build();
    }

    @Transactional
    public CommandProcessingResult depositToRDAccount(Long savingsId, JsonCommand command) {
        boolean isRegularTransaction = true;
        this.depositAccountTransactionDataValidator.validate(command, DepositAccountType.RECURRING_DEPOSIT);
        RecurringDepositAccount account = (RecurringDepositAccount)this.depositAccountAssembler.assembleFrom(savingsId, DepositAccountType.RECURRING_DEPOSIT);
        this.checkClientOrGroupActive((SavingsAccount)account);
        Locale locale = command.extractLocale();
        DateTimeFormatter fmt = DateTimeFormatter.ofPattern(command.dateFormat()).withLocale(locale);
        LocalDate transactionDate = command.localDateValueOfParameterNamed("transactionDate");
        BigDecimal transactionAmount = command.bigDecimalValueOfParameterNamed("transactionAmount");
        LinkedHashMap changes = new LinkedHashMap();
        PaymentDetail paymentDetail = this.paymentDetailWritePlatformService.createAndPersistPaymentDetail(command, changes);
        SavingsAccountTransaction deposit = this.depositAccountDomainService.handleRDDeposit(account, fmt, transactionDate, transactionAmount, paymentDetail, isRegularTransaction);
        return new CommandProcessingResultBuilder().withEntityId((Long)deposit.getId()).withOfficeId(account.officeId()).withClientId(account.clientId()).withGroupId(account.groupId()).withSavingsId(savingsId).with(changes).build();
    }

    private Long saveTransactionToGenerateTransactionId(SavingsAccountTransaction transaction) {
        this.savingsAccountTransactionRepository.saveAndFlush((Object)transaction);
        return (Long)transaction.getId();
    }

    @Transactional
    public CommandProcessingResult withdrawal(Long savingsId, JsonCommand command, DepositAccountType depositAccountType) {
        boolean isRegularTransaction = true;
        this.depositAccountTransactionDataValidator.validate(command, depositAccountType);
        LocalDate transactionDate = command.localDateValueOfParameterNamed("transactionDate");
        BigDecimal transactionAmount = command.bigDecimalValueOfParameterNamed("transactionAmount");
        Locale locale = command.extractLocale();
        DateTimeFormatter fmt = DateTimeFormatter.ofPattern(command.dateFormat()).withLocale(locale);
        LinkedHashMap changes = new LinkedHashMap();
        PaymentDetail paymentDetail = this.paymentDetailWritePlatformService.createAndPersistPaymentDetail(command, changes);
        SavingsAccount account = this.depositAccountAssembler.assembleFrom(savingsId, depositAccountType);
        this.checkClientOrGroupActive(account);
        SavingsAccountTransaction withdrawal = this.depositAccountDomainService.handleWithdrawal(account, fmt, transactionDate, transactionAmount, paymentDetail, true, isRegularTransaction);
        return new CommandProcessingResultBuilder().withEntityId((Long)withdrawal.getId()).withOfficeId(account.officeId()).withClientId(account.clientId()).withGroupId(account.groupId()).withSavingsId(savingsId).with(changes).build();
    }

    @Transactional
    public CommandProcessingResult calculateInterest(Long savingsId, DepositAccountType depositAccountType) {
        boolean isSavingsInterestPostingAtCurrentPeriodEnd = this.configurationDomainService.isSavingsInterestPostingAtCurrentPeriodEnd();
        Integer financialYearBeginningMonth = this.configurationDomainService.retrieveFinancialYearBeginningMonth();
        SavingsAccount account = this.depositAccountAssembler.assembleFrom(savingsId, depositAccountType);
        this.checkClientOrGroupActive(account);
        LocalDate today = DateUtils.getBusinessLocalDate();
        boolean postReversals = false;
        MathContext mc = new MathContext(15, MoneyHelper.getRoundingMode());
        boolean isInterestTransfer = false;
        LocalDate postInterestOnDate = null;
        account.calculateInterestUsing(mc, today, isInterestTransfer, isSavingsInterestPostingAtCurrentPeriodEnd, financialYearBeginningMonth, postInterestOnDate, false, false);
        this.savingAccountRepositoryWrapper.save(account);
        return new CommandProcessingResultBuilder().withEntityId(savingsId).withOfficeId(account.officeId()).withClientId(account.clientId()).withGroupId(account.groupId()).withSavingsId(savingsId).build();
    }

    @Transactional
    public CommandProcessingResult postInterest(Long savingsId, DepositAccountType depositAccountType) {
        SavingsAccount account = this.depositAccountAssembler.assembleFrom(savingsId, depositAccountType);
        this.checkClientOrGroupActive(account);
        this.postInterest(account);
        return new CommandProcessingResultBuilder().withEntityId(savingsId).withOfficeId(account.officeId()).withClientId(account.clientId()).withGroupId(account.groupId()).withSavingsId(savingsId).build();
    }

    @Transactional
    private void postInterest(SavingsAccount account) {
        boolean isSavingsInterestPostingAtCurrentPeriodEnd = this.configurationDomainService.isSavingsInterestPostingAtCurrentPeriodEnd();
        Integer financialYearBeginningMonth = this.configurationDomainService.retrieveFinancialYearBeginningMonth();
        HashSet existingTransactionIds = new HashSet();
        HashSet existingReversedTransactionIds = new HashSet();
        this.updateExistingTransactionsDetails(account, existingTransactionIds, existingReversedTransactionIds);
        LocalDate today = DateUtils.getBusinessLocalDate();
        MathContext mc = new MathContext(10, MoneyHelper.getRoundingMode());
        boolean isInterestTransfer = false;
        LocalDate postInterestOnDate = null;
        boolean postReversals = false;
        account.postInterest(mc, today, isInterestTransfer, isSavingsInterestPostingAtCurrentPeriodEnd, financialYearBeginningMonth, postInterestOnDate, false, false);
        this.savingAccountRepositoryWrapper.saveAndFlush(account);
        this.postJournalEntries(account, existingTransactionIds, existingReversedTransactionIds);
    }

    public CommandProcessingResult undoFDTransaction(Long savingsId, Long transactionId, boolean allowAccountTransferModification) {
        throw new DepositAccountTransactionNotAllowedException(savingsId, "undo", DepositAccountType.FIXED_DEPOSIT);
    }

    public CommandProcessingResult undoRDTransaction(Long savingsId, Long transactionId, boolean allowAccountTransferModification) {
        boolean isSavingsInterestPostingAtCurrentPeriodEnd = this.configurationDomainService.isSavingsInterestPostingAtCurrentPeriodEnd();
        Integer financialYearBeginningMonth = this.configurationDomainService.retrieveFinancialYearBeginningMonth();
        RecurringDepositAccount account = (RecurringDepositAccount)this.depositAccountAssembler.assembleFrom(savingsId, DepositAccountType.RECURRING_DEPOSIT);
        HashSet existingTransactionIds = new HashSet();
        HashSet existingReversedTransactionIds = new HashSet();
        this.updateExistingTransactionsDetails((SavingsAccount)account, existingTransactionIds, existingReversedTransactionIds);
        SavingsAccountTransaction savingsAccountTransaction = this.savingsAccountTransactionRepository.findOneByIdAndSavingsAccountId(transactionId, savingsId);
        if (savingsAccountTransaction == null) {
            throw new SavingsAccountTransactionNotFoundException(savingsId, transactionId);
        }
        if (!allowAccountTransferModification && this.accountTransfersReadPlatformService.isAccountTransfer(transactionId, PortfolioAccountType.SAVINGS)) {
            throw new PlatformServiceUnavailableException("error.msg.recurring.deposit.account.transfer.transaction.update.not.allowed", "Recurring deposit account transaction:" + transactionId + " update not allowed as it involves in account transfer", new Object[]{transactionId});
        }
        LocalDate today = DateUtils.getBusinessLocalDate();
        MathContext mc = MathContext.DECIMAL64;
        if (account.isNotActive()) {
            this.throwValidationForActiveStatus(".undotransaction");
        }
        account.undoTransaction(transactionId);
        boolean isInterestTransfer = false;
        LocalDate postInterestOnDate = null;
        this.checkClientOrGroupActive((SavingsAccount)account);
        boolean postReversals = false;
        if (savingsAccountTransaction.isPostInterestCalculationRequired() && account.isBeforeLastPostingPeriod(savingsAccountTransaction.getTransactionDate(), false)) {
            account.postInterest(mc, today, isInterestTransfer, isSavingsInterestPostingAtCurrentPeriodEnd, financialYearBeginningMonth, postInterestOnDate, false, false);
        } else {
            account.calculateInterestUsing(mc, today, isInterestTransfer, isSavingsInterestPostingAtCurrentPeriodEnd, financialYearBeginningMonth, postInterestOnDate, false, false);
        }
        List depositAccountOnHoldTransactions = null;
        if (account.getOnHoldFunds().compareTo(BigDecimal.ZERO) > 0) {
            depositAccountOnHoldTransactions = this.depositAccountOnHoldTransactionRepository.findBySavingsAccountAndReversedFalseOrderByCreatedDateAsc((SavingsAccount)account);
        }
        account.validateAccountBalanceDoesNotBecomeNegative(".undotransaction", depositAccountOnHoldTransactions, false);
        boolean isPreMatureClosure = false;
        account.updateMaturityDateAndAmount(mc, false, isSavingsInterestPostingAtCurrentPeriodEnd, financialYearBeginningMonth);
        LocalDate overdueUptoDate = DateUtils.getBusinessLocalDate();
        if (savingsAccountTransaction.isDeposit()) {
            account.updateScheduleInstallments();
        }
        account.updateOverduePayments(overdueUptoDate);
        this.savingAccountRepositoryWrapper.saveAndFlush((SavingsAccount)account);
        this.postJournalEntries((SavingsAccount)account, existingTransactionIds, existingReversedTransactionIds);
        return new CommandProcessingResultBuilder().withEntityId(savingsId).withOfficeId(account.officeId()).withClientId(account.clientId()).withGroupId(account.groupId()).withSavingsId(savingsId).build();
    }

    public CommandProcessingResult adjustFDTransaction(Long savingsId, Long transactionId, JsonCommand command) {
        throw new DepositAccountTransactionNotAllowedException(savingsId, "modify", DepositAccountType.FIXED_DEPOSIT);
    }

    public CommandProcessingResult adjustRDTransaction(Long savingsId, Long transactionId, JsonCommand command) {
        this.context.authenticatedUser();
        boolean isSavingsInterestPostingAtCurrentPeriodEnd = this.configurationDomainService.isSavingsInterestPostingAtCurrentPeriodEnd();
        Integer financialYearBeginningMonth = this.configurationDomainService.retrieveFinancialYearBeginningMonth();
        Long relaxingDaysConfigForPivotDate = this.configurationDomainService.retrieveRelaxingDaysConfigForPivotDate();
        this.depositAccountTransactionDataValidator.validate(command, DepositAccountType.RECURRING_DEPOSIT);
        SavingsAccountTransaction savingsAccountTransaction = this.savingsAccountTransactionRepository.findOneByIdAndSavingsAccountId(transactionId, savingsId);
        if (savingsAccountTransaction == null) {
            throw new SavingsAccountTransactionNotFoundException(savingsId, transactionId);
        }
        if (!savingsAccountTransaction.isDeposit() && !savingsAccountTransaction.isWithdrawal() || savingsAccountTransaction.isReversed()) {
            throw new TransactionUpdateNotAllowedException(savingsId, transactionId);
        }
        if (this.accountTransfersReadPlatformService.isAccountTransfer(transactionId, PortfolioAccountType.SAVINGS)) {
            throw new PlatformServiceUnavailableException("error.msg.saving.account.transfer.transaction.update.not.allowed", "Deposit account transaction:" + transactionId + " update not allowed as it involves in account transfer", new Object[]{transactionId});
        }
        LocalDate today = DateUtils.getBusinessLocalDate();
        RecurringDepositAccount account = (RecurringDepositAccount)this.depositAccountAssembler.assembleFrom(savingsId, DepositAccountType.RECURRING_DEPOSIT);
        if (account.isNotActive()) {
            this.throwValidationForActiveStatus(".adjusttransaction");
        }
        HashSet existingTransactionIds = new HashSet();
        HashSet existingReversedTransactionIds = new HashSet();
        this.updateExistingTransactionsDetails((SavingsAccount)account, existingTransactionIds, existingReversedTransactionIds);
        Locale locale = command.extractLocale();
        DateTimeFormatter fmt = DateTimeFormatter.ofPattern(command.dateFormat()).withLocale(locale);
        LocalDate transactionDate = command.localDateValueOfParameterNamed("transactionDate");
        BigDecimal transactionAmount = command.bigDecimalValueOfParameterNamed("transactionAmount");
        LinkedHashMap changes = new LinkedHashMap();
        PaymentDetail paymentDetail = this.paymentDetailWritePlatformService.createAndPersistPaymentDetail(command, changes);
        MathContext mc = new MathContext(10, MoneyHelper.getRoundingMode());
        account.undoTransaction(transactionId);
        SavingsAccountTransaction transaction = null;
        Integer accountType = null;
        UUID refNo = UUID.randomUUID();
        if (savingsAccountTransaction.isDeposit()) {
            transactionDTO = new SavingsAccountTransactionDTO(fmt, transactionDate, transactionAmount, paymentDetail, null, accountType);
            transaction = account.deposit(transactionDTO, false, relaxingDaysConfigForPivotDate, refNo.toString());
        } else {
            transactionDTO = new SavingsAccountTransactionDTO(fmt, transactionDate, transactionAmount, paymentDetail, null, accountType);
            transaction = account.withdraw(transactionDTO, true, false, relaxingDaysConfigForPivotDate, refNo.toString());
        }
        Long newtransactionId = this.saveTransactionToGenerateTransactionId(transaction);
        boolean isInterestTransfer = false;
        LocalDate postInterestOnDate = null;
        boolean postReversals = false;
        if (account.isBeforeLastPostingPeriod(transactionDate, false) || account.isBeforeLastPostingPeriod(savingsAccountTransaction.getTransactionDate(), false)) {
            account.postInterest(mc, today, isInterestTransfer, isSavingsInterestPostingAtCurrentPeriodEnd, financialYearBeginningMonth, postInterestOnDate, false, false);
        } else {
            account.calculateInterestUsing(mc, today, isInterestTransfer, isSavingsInterestPostingAtCurrentPeriodEnd, financialYearBeginningMonth, postInterestOnDate, false, false);
        }
        List depositAccountOnHoldTransactions = null;
        if (account.getOnHoldFunds().compareTo(BigDecimal.ZERO) > 0) {
            depositAccountOnHoldTransactions = this.depositAccountOnHoldTransactionRepository.findBySavingsAccountAndReversedFalseOrderByCreatedDateAsc((SavingsAccount)account);
        }
        account.validateAccountBalanceDoesNotBecomeNegative(".adjusttransaction", depositAccountOnHoldTransactions, false);
        account.activateAccountBasedOnBalance();
        if (savingsAccountTransaction.isDeposit()) {
            account.handleScheduleInstallments(savingsAccountTransaction);
        }
        LocalDate overdueUptoDate = DateUtils.getBusinessLocalDate();
        account.updateOverduePayments(overdueUptoDate);
        this.savingAccountRepositoryWrapper.saveAndFlush((SavingsAccount)account);
        this.postJournalEntries((SavingsAccount)account, existingTransactionIds, existingReversedTransactionIds);
        return new CommandProcessingResultBuilder().withEntityId(newtransactionId).withOfficeId(account.officeId()).withClientId(account.clientId()).withGroupId(account.groupId()).withSavingsId(savingsId).with(changes).build();
    }

    private void throwValidationForActiveStatus(String actionName) {
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("savingsaccount" + actionName);
        baseDataValidator.reset().failWithCodeNoParameterAddedToErrorCode("account.is.not.active", new Object[0]);
        throw new PlatformApiDataValidationException(dataValidationErrors);
    }

    private void checkClientOrGroupActive(SavingsAccount account) {
        Client client = account.getClient();
        if (client != null && client.isNotActive()) {
            throw new ClientNotActiveException((Long)client.getId());
        }
        Group group = account.group();
        if (group != null && group.isNotActive()) {
            throw new GroupNotActiveException((Long)group.getId());
        }
    }

    public CommandProcessingResult closeFDAccount(Long savingsId, JsonCommand command) {
        AppUser user = this.context.authenticatedUser();
        boolean isPreMatureClose = false;
        this.depositAccountTransactionDataValidator.validateClosing(command, DepositAccountType.FIXED_DEPOSIT, false);
        LinkedHashMap<String, String> changes = new LinkedHashMap<String, String>();
        PaymentDetail paymentDetail = this.paymentDetailWritePlatformService.createAndPersistPaymentDetail(command, changes);
        FixedDepositAccount account = (FixedDepositAccount)this.depositAccountAssembler.assembleFrom(savingsId, DepositAccountType.FIXED_DEPOSIT);
        this.checkClientOrGroupActive((SavingsAccount)account);
        this.depositAccountDomainService.handleFDAccountClosure(account, paymentDetail, user, command, changes);
        String noteText = command.stringValueOfParameterNamed("note");
        if (StringUtils.isNotBlank((CharSequence)noteText)) {
            Note note = Note.savingNote((SavingsAccount)account, (String)noteText);
            changes.put("note", noteText);
            this.noteRepository.save((Object)note);
        }
        return new CommandProcessingResultBuilder().withEntityId(savingsId).withOfficeId(account.officeId()).withClientId(account.clientId()).withGroupId(account.groupId()).withSavingsId(savingsId).with(changes).build();
    }

    public CommandProcessingResult closeRDAccount(Long savingsId, JsonCommand command) {
        AppUser user = this.context.authenticatedUser();
        this.depositAccountTransactionDataValidator.validateClosing(command, DepositAccountType.RECURRING_DEPOSIT, false);
        LinkedHashMap<String, String> changes = new LinkedHashMap<String, String>();
        PaymentDetail paymentDetail = this.paymentDetailWritePlatformService.createAndPersistPaymentDetail(command, changes);
        RecurringDepositAccount account = (RecurringDepositAccount)this.depositAccountAssembler.assembleFrom(savingsId, DepositAccountType.RECURRING_DEPOSIT);
        this.checkClientOrGroupActive((SavingsAccount)account);
        this.depositAccountDomainService.handleRDAccountClosure(account, paymentDetail, user, command, changes);
        String noteText = command.stringValueOfParameterNamed("note");
        if (StringUtils.isNotBlank((CharSequence)noteText)) {
            Note note = Note.savingNote((SavingsAccount)account, (String)noteText);
            changes.put("note", noteText);
            this.noteRepository.save((Object)note);
        }
        return new CommandProcessingResultBuilder().withEntityId(savingsId).withOfficeId(account.officeId()).withClientId(account.clientId()).withGroupId(account.groupId()).withSavingsId(savingsId).with(changes).build();
    }

    public CommandProcessingResult prematureCloseFDAccount(Long savingsId, JsonCommand command) {
        AppUser user = this.context.authenticatedUser();
        this.depositAccountTransactionDataValidator.validateClosing(command, DepositAccountType.FIXED_DEPOSIT, true);
        LinkedHashMap<String, String> changes = new LinkedHashMap<String, String>();
        PaymentDetail paymentDetail = this.paymentDetailWritePlatformService.createAndPersistPaymentDetail(command, changes);
        FixedDepositAccount account = (FixedDepositAccount)this.depositAccountAssembler.assembleFrom(savingsId, DepositAccountType.FIXED_DEPOSIT);
        this.checkClientOrGroupActive((SavingsAccount)account);
        this.depositAccountDomainService.handleFDAccountPreMatureClosure(account, paymentDetail, user, command, changes);
        String noteText = command.stringValueOfParameterNamed("note");
        if (StringUtils.isNotBlank((CharSequence)noteText)) {
            Note note = Note.savingNote((SavingsAccount)account, (String)noteText);
            changes.put("note", noteText);
            this.noteRepository.save((Object)note);
        }
        return new CommandProcessingResultBuilder().withEntityId(savingsId).withOfficeId(account.officeId()).withClientId(account.clientId()).withGroupId(account.groupId()).withSavingsId(savingsId).with(changes).build();
    }

    public CommandProcessingResult prematureCloseRDAccount(Long savingsId, JsonCommand command) {
        AppUser user = this.context.authenticatedUser();
        this.depositAccountTransactionDataValidator.validateClosing(command, DepositAccountType.RECURRING_DEPOSIT, true);
        LinkedHashMap<String, String> changes = new LinkedHashMap<String, String>();
        PaymentDetail paymentDetail = this.paymentDetailWritePlatformService.createAndPersistPaymentDetail(command, changes);
        RecurringDepositAccount account = (RecurringDepositAccount)this.depositAccountAssembler.assembleFrom(savingsId, DepositAccountType.RECURRING_DEPOSIT);
        this.checkClientOrGroupActive((SavingsAccount)account);
        if (account.maturityDate() == null) {
            ArrayList dataValidationErrors = new ArrayList();
            DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("recurringdepositaccount.preMatureClose");
            baseDataValidator.reset().failWithCodeNoParameterAddedToErrorCode("can.not.close.as.premature", new Object[0]);
            if (!dataValidationErrors.isEmpty()) {
                throw new PlatformApiDataValidationException(dataValidationErrors);
            }
        }
        this.depositAccountDomainService.handleRDAccountPreMatureClosure(account, paymentDetail, user, command, changes);
        String noteText = command.stringValueOfParameterNamed("note");
        if (StringUtils.isNotBlank((CharSequence)noteText)) {
            Note note = Note.savingNote((SavingsAccount)account, (String)noteText);
            changes.put("note", noteText);
            this.noteRepository.save((Object)note);
        }
        return new CommandProcessingResultBuilder().withEntityId(savingsId).withOfficeId(account.officeId()).withClientId(account.clientId()).withGroupId(account.groupId()).withSavingsId(savingsId).with(changes).build();
    }

    public SavingsAccountTransaction initiateSavingsTransfer(Long accountId, LocalDate transferDate, DepositAccountType depositAccountType) {
        this.context.authenticatedUser();
        boolean isSavingsInterestPostingAtCurrentPeriodEnd = this.configurationDomainService.isSavingsInterestPostingAtCurrentPeriodEnd();
        Integer financialYearBeginningMonth = this.configurationDomainService.retrieveFinancialYearBeginningMonth();
        SavingsAccount savingsAccount = this.depositAccountAssembler.assembleFrom(accountId, depositAccountType);
        LocalDate postInterestOnDate = null;
        HashSet existingTransactionIds = new HashSet();
        HashSet existingReversedTransactionIds = new HashSet();
        this.updateExistingTransactionsDetails(savingsAccount, existingTransactionIds, existingReversedTransactionIds);
        SavingsAccountTransaction newTransferTransaction = SavingsAccountTransaction.initiateTransfer((SavingsAccount)savingsAccount, (Office)savingsAccount.office(), (LocalDate)transferDate);
        savingsAccount.addTransaction(newTransferTransaction);
        savingsAccount.setStatus(SavingsAccountStatusType.TRANSFER_IN_PROGRESS.getValue());
        MathContext mc = MathContext.DECIMAL64;
        boolean isInterestTransfer = false;
        boolean postReversals = false;
        savingsAccount.calculateInterestUsing(mc, transferDate, isInterestTransfer, isSavingsInterestPostingAtCurrentPeriodEnd, financialYearBeginningMonth, postInterestOnDate, false, false);
        this.savingsAccountTransactionRepository.save((Object)newTransferTransaction);
        this.savingAccountRepositoryWrapper.saveAndFlush(savingsAccount);
        this.postJournalEntries(savingsAccount, existingTransactionIds, existingReversedTransactionIds);
        return newTransferTransaction;
    }

    public SavingsAccountTransaction withdrawSavingsTransfer(Long accountId, LocalDate transferDate, DepositAccountType depositAccountType) {
        this.context.authenticatedUser();
        boolean isSavingsInterestPostingAtCurrentPeriodEnd = this.configurationDomainService.isSavingsInterestPostingAtCurrentPeriodEnd();
        Integer financialYearBeginningMonth = this.configurationDomainService.retrieveFinancialYearBeginningMonth();
        SavingsAccount savingsAccount = this.depositAccountAssembler.assembleFrom(accountId, depositAccountType);
        HashSet existingTransactionIds = new HashSet();
        HashSet existingReversedTransactionIds = new HashSet();
        this.updateExistingTransactionsDetails(savingsAccount, existingTransactionIds, existingReversedTransactionIds);
        SavingsAccountTransaction withdrawtransferTransaction = SavingsAccountTransaction.withdrawTransfer((SavingsAccount)savingsAccount, (Office)savingsAccount.office(), (LocalDate)transferDate);
        savingsAccount.addTransaction(withdrawtransferTransaction);
        savingsAccount.setStatus(SavingsAccountStatusType.ACTIVE.getValue());
        boolean postReversals = false;
        MathContext mc = MathContext.DECIMAL64;
        boolean isInterestTransfer = false;
        LocalDate postInterestOnDate = null;
        savingsAccount.calculateInterestUsing(mc, transferDate, isInterestTransfer, isSavingsInterestPostingAtCurrentPeriodEnd, financialYearBeginningMonth, postInterestOnDate, false, false);
        this.savingsAccountTransactionRepository.save((Object)withdrawtransferTransaction);
        this.savingAccountRepositoryWrapper.saveAndFlush(savingsAccount);
        this.postJournalEntries(savingsAccount, existingTransactionIds, existingReversedTransactionIds);
        return withdrawtransferTransaction;
    }

    public void rejectSavingsTransfer(Long accountId, DepositAccountType depositAccountType) {
        SavingsAccount savingsAccount = this.depositAccountAssembler.assembleFrom(accountId, depositAccountType);
        savingsAccount.setStatus(SavingsAccountStatusType.TRANSFER_ON_HOLD.getValue());
        this.savingAccountRepositoryWrapper.save(savingsAccount);
    }

    public SavingsAccountTransaction acceptSavingsTransfer(Long accountId, LocalDate transferDate, Office acceptedInOffice, Staff fieldOfficer, DepositAccountType depositAccountType) {
        this.context.authenticatedUser();
        boolean isSavingsInterestPostingAtCurrentPeriodEnd = this.configurationDomainService.isSavingsInterestPostingAtCurrentPeriodEnd();
        Integer financialYearBeginningMonth = this.configurationDomainService.retrieveFinancialYearBeginningMonth();
        SavingsAccount savingsAccount = this.depositAccountAssembler.assembleFrom(accountId, depositAccountType);
        HashSet existingTransactionIds = new HashSet();
        HashSet existingReversedTransactionIds = new HashSet();
        this.updateExistingTransactionsDetails(savingsAccount, existingTransactionIds, existingReversedTransactionIds);
        SavingsAccountTransaction acceptTransferTransaction = SavingsAccountTransaction.approveTransfer((SavingsAccount)savingsAccount, (Office)acceptedInOffice, (LocalDate)transferDate);
        savingsAccount.addTransaction(acceptTransferTransaction);
        savingsAccount.setStatus(SavingsAccountStatusType.ACTIVE.getValue());
        if (fieldOfficer != null) {
            savingsAccount.reassignSavingsOfficer(fieldOfficer, transferDate);
        }
        boolean isInterestTransfer = false;
        boolean postReversals = false;
        LocalDate postInterestOnDate = null;
        MathContext mc = MathContext.DECIMAL64;
        savingsAccount.calculateInterestUsing(mc, transferDate, isInterestTransfer, isSavingsInterestPostingAtCurrentPeriodEnd, financialYearBeginningMonth, postInterestOnDate, false, false);
        this.savingsAccountTransactionRepository.save((Object)acceptTransferTransaction);
        this.savingAccountRepositoryWrapper.saveAndFlush(savingsAccount);
        this.postJournalEntries(savingsAccount, existingTransactionIds, existingReversedTransactionIds);
        return acceptTransferTransaction;
    }

    @Transactional
    public CommandProcessingResult addSavingsAccountCharge(JsonCommand command, DepositAccountType depositAccountType) {
        this.context.authenticatedUser();
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("savingsaccount");
        Long savingsAccountId = command.getSavingsId();
        this.savingsAccountChargeDataValidator.validateAdd(command.json());
        SavingsAccount savingsAccount = this.depositAccountAssembler.assembleFrom(savingsAccountId, depositAccountType);
        this.checkClientOrGroupActive(savingsAccount);
        Locale locale = command.extractLocale();
        String format = command.dateFormat();
        DateTimeFormatter fmt = StringUtils.isNotBlank((CharSequence)format) ? DateTimeFormatter.ofPattern(format).withLocale(locale) : DateTimeFormatter.ofPattern("dd MM yyyy");
        Long chargeDefinitionId = command.longValueOfParameterNamed("chargeId");
        Charge chargeDefinition = this.chargeRepository.findOneWithNotFoundDetection(chargeDefinitionId);
        SavingsAccountCharge savingsAccountCharge = SavingsAccountCharge.createNewFromJson((SavingsAccount)savingsAccount, (Charge)chargeDefinition, (JsonCommand)command);
        if (savingsAccountCharge.getDueDate() != null) {
            if (!this.configurationDomainService.allowTransactionsOnHolidayEnabled() && this.holidayRepository.isHoliday(savingsAccount.officeId(), savingsAccountCharge.getDueDate())) {
                baseDataValidator.reset().parameter("dueDate").value((Object)savingsAccountCharge.getDueDate().format(fmt)).failWithCodeNoParameterAddedToErrorCode("charge.due.date.is.on.holiday", new Object[0]);
                if (!dataValidationErrors.isEmpty()) {
                    throw new PlatformApiDataValidationException(dataValidationErrors);
                }
            }
            if (!this.configurationDomainService.allowTransactionsOnNonWorkingDayEnabled() && !this.workingDaysRepository.isWorkingDay(savingsAccountCharge.getDueDate())) {
                baseDataValidator.reset().parameter("dueDate").value((Object)savingsAccountCharge.getDueDate().format(fmt)).failWithCodeNoParameterAddedToErrorCode("charge.due.date.is.a.nonworking.day", new Object[0]);
                if (!dataValidationErrors.isEmpty()) {
                    throw new PlatformApiDataValidationException(dataValidationErrors);
                }
            }
        }
        savingsAccount.addCharge(fmt, savingsAccountCharge, chargeDefinition);
        this.savingAccountRepositoryWrapper.saveAndFlush(savingsAccount);
        return new CommandProcessingResultBuilder().withEntityId((Long)savingsAccountCharge.getId()).withOfficeId(savingsAccount.officeId()).withClientId(savingsAccount.clientId()).withGroupId(savingsAccount.groupId()).withSavingsId(savingsAccountId).build();
    }

    @Transactional
    public CommandProcessingResult updateSavingsAccountCharge(JsonCommand command, DepositAccountType depositAccountType) {
        this.context.authenticatedUser();
        this.savingsAccountChargeDataValidator.validateUpdate(command.json());
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("savingsaccount");
        Long savingsAccountId = command.getSavingsId();
        Long savingsChargeId = command.entityId();
        SavingsAccount savingsAccount = this.depositAccountAssembler.assembleFrom(savingsAccountId, depositAccountType);
        this.checkClientOrGroupActive(savingsAccount);
        SavingsAccountCharge savingsAccountCharge = this.savingsAccountChargeRepository.findOneWithNotFoundDetection(savingsChargeId, savingsAccountId);
        Map changes = savingsAccountCharge.update(command);
        if (savingsAccountCharge.getDueDate() != null) {
            Locale locale = command.extractLocale();
            DateTimeFormatter fmt = DateTimeFormatter.ofPattern(command.dateFormat()).withLocale(locale);
            if (!this.configurationDomainService.allowTransactionsOnHolidayEnabled() && this.holidayRepository.isHoliday(savingsAccount.officeId(), savingsAccountCharge.getDueDate())) {
                baseDataValidator.reset().parameter("dueDate").value((Object)savingsAccountCharge.getDueDate().format(fmt)).failWithCodeNoParameterAddedToErrorCode("charge.due.date.is.on.holiday", new Object[0]);
                if (!dataValidationErrors.isEmpty()) {
                    throw new PlatformApiDataValidationException(dataValidationErrors);
                }
            }
            if (!this.configurationDomainService.allowTransactionsOnNonWorkingDayEnabled() && !this.workingDaysRepository.isWorkingDay(savingsAccountCharge.getDueDate())) {
                baseDataValidator.reset().parameter("dueDate").value((Object)savingsAccountCharge.getDueDate().format(fmt)).failWithCodeNoParameterAddedToErrorCode("charge.due.date.is.a.nonworking.day", new Object[0]);
                if (!dataValidationErrors.isEmpty()) {
                    throw new PlatformApiDataValidationException(dataValidationErrors);
                }
            }
        }
        this.savingsAccountChargeRepository.saveAndFlush(savingsAccountCharge);
        return new CommandProcessingResultBuilder().withEntityId((Long)savingsAccountCharge.getId()).withOfficeId(savingsAccountCharge.savingsAccount().officeId()).withClientId(savingsAccountCharge.savingsAccount().clientId()).withGroupId(savingsAccountCharge.savingsAccount().groupId()).withSavingsId((Long)savingsAccountCharge.savingsAccount().getId()).with(changes).build();
    }

    @Transactional
    public CommandProcessingResult waiveCharge(Long savingsAccountId, Long savingsAccountChargeId, DepositAccountType depositAccountType) {
        this.context.authenticatedUser();
        boolean isSavingsInterestPostingAtCurrentPeriodEnd = this.configurationDomainService.isSavingsInterestPostingAtCurrentPeriodEnd();
        Integer financialYearBeginningMonth = this.configurationDomainService.retrieveFinancialYearBeginningMonth();
        SavingsAccountCharge savingsAccountCharge = this.savingsAccountChargeRepository.findOneWithNotFoundDetection(savingsAccountChargeId, savingsAccountId);
        SavingsAccount account = savingsAccountCharge.savingsAccount();
        this.depositAccountAssembler.assignSavingAccountHelpers(account);
        HashSet existingTransactionIds = new HashSet();
        HashSet existingReversedTransactionIds = new HashSet();
        this.updateExistingTransactionsDetails(account, existingTransactionIds, existingReversedTransactionIds);
        account.waiveCharge(savingsAccountChargeId, false);
        boolean isInterestTransfer = false;
        LocalDate postInterestOnDate = null;
        MathContext mc = MathContext.DECIMAL64;
        boolean postReversals = false;
        if (account.isBeforeLastPostingPeriod(savingsAccountCharge.getDueDate(), false)) {
            today = DateUtils.getBusinessLocalDate();
            account.postInterest(mc, today, isInterestTransfer, isSavingsInterestPostingAtCurrentPeriodEnd, financialYearBeginningMonth, postInterestOnDate, false, false);
        } else {
            today = DateUtils.getBusinessLocalDate();
            account.calculateInterestUsing(mc, today, isInterestTransfer, isSavingsInterestPostingAtCurrentPeriodEnd, financialYearBeginningMonth, postInterestOnDate, false, false);
        }
        List depositAccountOnHoldTransactions = null;
        if (account.getOnHoldFunds().compareTo(BigDecimal.ZERO) > 0) {
            depositAccountOnHoldTransactions = this.depositAccountOnHoldTransactionRepository.findBySavingsAccountAndReversedFalseOrderByCreatedDateAsc(account);
        }
        account.validateAccountBalanceDoesNotBecomeNegative(".waivecharge", depositAccountOnHoldTransactions, false);
        this.savingAccountRepositoryWrapper.saveAndFlush(account);
        this.postJournalEntries(account, existingTransactionIds, existingReversedTransactionIds);
        return new CommandProcessingResultBuilder().withEntityId(savingsAccountChargeId).withOfficeId(account.officeId()).withClientId(account.clientId()).withGroupId(account.groupId()).withSavingsId(savingsAccountId).build();
    }

    @Transactional
    public CommandProcessingResult deleteSavingsAccountCharge(Long savingsAccountId, Long savingsAccountChargeId, JsonCommand command, DepositAccountType depositAccountType) {
        this.context.authenticatedUser();
        SavingsAccount savingsAccount = this.depositAccountAssembler.assembleFrom(savingsAccountId, depositAccountType);
        this.checkClientOrGroupActive(savingsAccount);
        SavingsAccountCharge savingsAccountCharge = this.savingsAccountChargeRepository.findOneWithNotFoundDetection(savingsAccountChargeId, savingsAccountId);
        savingsAccount.removeCharge(savingsAccountCharge);
        this.savingAccountRepositoryWrapper.saveAndFlush(savingsAccount);
        return new CommandProcessingResultBuilder().withEntityId(savingsAccountChargeId).withOfficeId(savingsAccount.officeId()).withClientId(savingsAccount.clientId()).withGroupId(savingsAccount.groupId()).withSavingsId(savingsAccountId).build();
    }

    public CommandProcessingResult payCharge(Long savingsAccountId, Long savingsAccountChargeId, JsonCommand command, DepositAccountType depositAccountType) {
        this.context.authenticatedUser();
        this.savingsAccountChargeDataValidator.validatePayCharge(command.json());
        Locale locale = command.extractLocale();
        DateTimeFormatter fmt = DateTimeFormatter.ofPattern(command.dateFormat()).withLocale(locale);
        BigDecimal amountPaid = command.bigDecimalValueOfParameterNamed("amount");
        LocalDate transactionDate = command.localDateValueOfParameterNamed("dueDate");
        SavingsAccountCharge savingsAccountCharge = this.savingsAccountChargeRepository.findOneWithNotFoundDetection(savingsAccountChargeId, savingsAccountId);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("savingsaccount");
        if (!this.configurationDomainService.allowTransactionsOnHolidayEnabled() && this.holidayRepository.isHoliday(savingsAccountCharge.savingsAccount().officeId(), transactionDate)) {
            baseDataValidator.reset().parameter("dueDate").value((Object)transactionDate.format(fmt)).failWithCodeNoParameterAddedToErrorCode("transaction.not.allowed.transaction.date.is.on.holiday", new Object[0]);
            if (!dataValidationErrors.isEmpty()) {
                throw new PlatformApiDataValidationException(dataValidationErrors);
            }
        }
        if (!this.configurationDomainService.allowTransactionsOnNonWorkingDayEnabled() && !this.workingDaysRepository.isWorkingDay(transactionDate)) {
            baseDataValidator.reset().parameter("dueDate").value((Object)transactionDate.format(fmt)).failWithCodeNoParameterAddedToErrorCode("transaction.not.allowed.transaction.date.is.a.nonworking.day", new Object[0]);
            if (!dataValidationErrors.isEmpty()) {
                throw new PlatformApiDataValidationException(dataValidationErrors);
            }
        }
        this.payCharge(savingsAccountCharge, transactionDate, amountPaid, fmt);
        return new CommandProcessingResultBuilder().withEntityId((Long)savingsAccountCharge.getId()).withOfficeId(savingsAccountCharge.savingsAccount().officeId()).withClientId(savingsAccountCharge.savingsAccount().clientId()).withGroupId(savingsAccountCharge.savingsAccount().groupId()).withSavingsId((Long)savingsAccountCharge.savingsAccount().getId()).build();
    }

    @Transactional
    public void applyChargeDue(Long savingsAccountChargeId, Long accountId, DepositAccountType depositAccountType) {
        SavingsAccountCharge savingsAccountCharge = this.savingsAccountChargeRepository.findOneWithNotFoundDetection(savingsAccountChargeId, accountId);
        LocalDate transactionDate = DateUtils.getBusinessLocalDate();
        DateTimeFormatter fmt = DateTimeFormatter.ofPattern("dd MM yyyy");
        while (DateUtils.isBefore((LocalDate)savingsAccountCharge.getDueDate(), (LocalDate)transactionDate)) {
            this.payCharge(savingsAccountCharge, transactionDate, savingsAccountCharge.amoutOutstanding(), fmt);
        }
    }

    @Transactional
    private void payCharge(SavingsAccountCharge savingsAccountCharge, LocalDate transactionDate, BigDecimal amountPaid, DateTimeFormatter formatter) {
        this.context.authenticatedUser();
        boolean isSavingsInterestPostingAtCurrentPeriodEnd = this.configurationDomainService.isSavingsInterestPostingAtCurrentPeriodEnd();
        Integer financialYearBeginningMonth = this.configurationDomainService.retrieveFinancialYearBeginningMonth();
        SavingsAccount account = savingsAccountCharge.savingsAccount();
        this.depositAccountAssembler.assignSavingAccountHelpers(account);
        HashSet existingTransactionIds = new HashSet();
        HashSet existingReversedTransactionIds = new HashSet();
        this.updateExistingTransactionsDetails(account, existingTransactionIds, existingReversedTransactionIds);
        account.payCharge(savingsAccountCharge, amountPaid, transactionDate, formatter, false, null);
        boolean isInterestTransfer = false;
        LocalDate postInterestOnDate = null;
        MathContext mc = MathContext.DECIMAL64;
        boolean postReversals = false;
        if (account.isBeforeLastPostingPeriod(transactionDate, false)) {
            today = DateUtils.getBusinessLocalDate();
            account.postInterest(mc, today, isInterestTransfer, isSavingsInterestPostingAtCurrentPeriodEnd, financialYearBeginningMonth, postInterestOnDate, false, false);
        } else {
            today = DateUtils.getBusinessLocalDate();
            account.calculateInterestUsing(mc, today, isInterestTransfer, isSavingsInterestPostingAtCurrentPeriodEnd, financialYearBeginningMonth, postInterestOnDate, false, false);
        }
        List depositAccountOnHoldTransactions = null;
        if (account.getOnHoldFunds().compareTo(BigDecimal.ZERO) > 0) {
            depositAccountOnHoldTransactions = this.depositAccountOnHoldTransactionRepository.findBySavingsAccountAndReversedFalseOrderByCreatedDateAsc(account);
        }
        account.validateAccountBalanceDoesNotBecomeNegative("." + SavingsAccountTransactionType.PAY_CHARGE.getCode(), depositAccountOnHoldTransactions, false);
        this.savingAccountRepositoryWrapper.saveAndFlush(account);
        this.postJournalEntries(account, existingTransactionIds, existingReversedTransactionIds);
    }

    @Transactional
    public void updateMaturityDetails(Long depositAccountId, DepositAccountType depositAccountType) {
        boolean isSavingsInterestPostingAtCurrentPeriodEnd = this.configurationDomainService.isSavingsInterestPostingAtCurrentPeriodEnd();
        Integer financialYearBeginningMonth = this.configurationDomainService.retrieveFinancialYearBeginningMonth();
        boolean postReversals = false;
        SavingsAccount account = this.depositAccountAssembler.assembleFrom(depositAccountId, depositAccountType);
        HashSet existingTransactionIds = new HashSet();
        HashSet existingReversedTransactionIds = new HashSet();
        this.updateExistingTransactionsDetails(account, existingTransactionIds, existingReversedTransactionIds);
        if (depositAccountType.isFixedDeposit()) {
            ((FixedDepositAccount)account).updateMaturityStatus(isSavingsInterestPostingAtCurrentPeriodEnd, financialYearBeginningMonth);
            FixedDepositAccount fdAccount = (FixedDepositAccount)account;
            if (fdAccount.isMatured() && (fdAccount.isReinvestOnClosure() || fdAccount.isTransferToSavingsOnClosure())) {
                DateTimeFormatter fmt = DateTimeFormatter.ofPattern("yyyy-MM-dd");
                HashMap changes = new HashMap();
                AppUser user = this.context.authenticatedUser();
                Long toSavingsId = fdAccount.getTransferToSavingsAccountId();
                this.depositAccountDomainService.handleFDAccountMaturityClosure(fdAccount, null, user, fmt, fdAccount.maturityDate(), fdAccount.getOnAccountClosureId(), toSavingsId, "Apply maturity instructions", changes);
                if (changes.get("reinvestedDepositId") != null) {
                    Long reinvestedDepositId = (Long)changes.get("reinvestedDepositId");
                    Money amountForDeposit = account.activateWithBalance();
                    FixedDepositAccount reinvestAccount = (FixedDepositAccount)this.depositAccountAssembler.assembleFrom(reinvestedDepositId, DepositAccountType.FIXED_DEPOSIT);
                    Money activationChargeAmount = this.getActivationCharge(reinvestAccount);
                    if (activationChargeAmount.isGreaterThanZero()) {
                        this.payActivationCharge(reinvestAccount);
                        amountForDeposit = amountForDeposit.plus(activationChargeAmount);
                    }
                    this.depositAccountDomainService.handleFDDeposit(reinvestAccount, fmt, fdAccount.maturityDate(), amountForDeposit.getAmount(), null);
                }
            }
        } else if (depositAccountType.isRecurringDeposit()) {
            ((RecurringDepositAccount)account).updateMaturityStatus(isSavingsInterestPostingAtCurrentPeriodEnd, financialYearBeginningMonth, false);
        }
        this.savingAccountRepositoryWrapper.saveAndFlush(account);
        this.postJournalEntries(account, existingTransactionIds, existingReversedTransactionIds);
    }

    private void updateExistingTransactionsDetails(SavingsAccount account, Set<Long> existingTransactionIds, Set<Long> existingReversedTransactionIds) {
        existingTransactionIds.addAll(account.findExistingTransactionIds());
        existingReversedTransactionIds.addAll(account.findExistingReversedTransactionIds());
    }

    private void postJournalEntries(SavingsAccount savingsAccount, Set<Long> existingTransactionIds, Set<Long> existingReversedTransactionIds) {
        boolean isAccountTransfer = false;
        Map accountingBridgeData = savingsAccount.deriveAccountingBridgeData(savingsAccount.getCurrency().getCode(), existingTransactionIds, existingReversedTransactionIds, isAccountTransfer, false);
        this.journalEntryWritePlatformService.createJournalEntriesForSavings(accountingBridgeData);
    }

    @Transactional
    public SavingsAccountTransaction mandatorySavingsAccountDeposit(SavingsAccountTransactionDTO accountTransactionDTO) {
        boolean isRegularTransaction = false;
        PaymentDetail paymentDetail = accountTransactionDTO.getPaymentDetail();
        if (paymentDetail != null && paymentDetail.getId() == null) {
            this.paymentDetailWritePlatformService.persistPaymentDetail(paymentDetail);
        }
        if (accountTransactionDTO.getAccountType().equals(DepositAccountType.RECURRING_DEPOSIT.getValue())) {
            RecurringDepositAccount account = (RecurringDepositAccount)this.depositAccountAssembler.assembleFrom(accountTransactionDTO.getSavingsAccountId(), DepositAccountType.RECURRING_DEPOSIT);
            return this.depositAccountDomainService.handleRDDeposit(account, accountTransactionDTO.getFormatter(), accountTransactionDTO.getTransactionDate(), accountTransactionDTO.getTransactionAmount(), paymentDetail, isRegularTransaction);
        }
        SavingsAccount account = null;
        account = accountTransactionDTO.getAccountType().equals(DepositAccountType.SAVINGS_DEPOSIT.getValue()) ? this.depositAccountAssembler.assembleFrom(accountTransactionDTO.getSavingsAccountId(), DepositAccountType.SAVINGS_DEPOSIT) : this.depositAccountAssembler.assembleFrom(accountTransactionDTO.getSavingsAccountId(), DepositAccountType.CURRENT_DEPOSIT);
        return this.depositAccountDomainService.handleSavingDeposit(account, accountTransactionDTO.getFormatter(), accountTransactionDTO.getTransactionDate(), accountTransactionDTO.getTransactionAmount(), paymentDetail, isRegularTransaction);
    }

    @Generated
    public DepositAccountWritePlatformServiceJpaRepositoryImpl(PlatformSecurityContext context, SavingsAccountRepositoryWrapper savingAccountRepositoryWrapper, SavingsAccountTransactionRepository savingsAccountTransactionRepository, DepositAccountAssembler depositAccountAssembler, DepositAccountTransactionDataValidator depositAccountTransactionDataValidator, SavingsAccountChargeDataValidator savingsAccountChargeDataValidator, PaymentDetailWritePlatformService paymentDetailWritePlatformService, ApplicationCurrencyRepositoryWrapper applicationCurrencyRepositoryWrapper, JournalEntryWritePlatformService journalEntryWritePlatformService, DepositAccountDomainService depositAccountDomainService, NoteRepository noteRepository, AccountTransfersReadPlatformService accountTransfersReadPlatformService, ChargeRepositoryWrapper chargeRepository, SavingsAccountChargeRepositoryWrapper savingsAccountChargeRepository, AccountAssociationsReadPlatformService accountAssociationsReadPlatformService, AccountTransfersWritePlatformService accountTransfersWritePlatformService, DepositAccountReadPlatformService depositAccountReadPlatformService, CalendarInstanceRepository calendarInstanceRepository, ConfigurationDomainService configurationDomainService, HolidayRepositoryWrapper holidayRepository, WorkingDaysRepositoryWrapper workingDaysRepository, DepositAccountOnHoldTransactionRepository depositAccountOnHoldTransactionRepository) {
        this.context = context;
        this.savingAccountRepositoryWrapper = savingAccountRepositoryWrapper;
        this.savingsAccountTransactionRepository = savingsAccountTransactionRepository;
        this.depositAccountAssembler = depositAccountAssembler;
        this.depositAccountTransactionDataValidator = depositAccountTransactionDataValidator;
        this.savingsAccountChargeDataValidator = savingsAccountChargeDataValidator;
        this.paymentDetailWritePlatformService = paymentDetailWritePlatformService;
        this.applicationCurrencyRepositoryWrapper = applicationCurrencyRepositoryWrapper;
        this.journalEntryWritePlatformService = journalEntryWritePlatformService;
        this.depositAccountDomainService = depositAccountDomainService;
        this.noteRepository = noteRepository;
        this.accountTransfersReadPlatformService = accountTransfersReadPlatformService;
        this.chargeRepository = chargeRepository;
        this.savingsAccountChargeRepository = savingsAccountChargeRepository;
        this.accountAssociationsReadPlatformService = accountAssociationsReadPlatformService;
        this.accountTransfersWritePlatformService = accountTransfersWritePlatformService;
        this.depositAccountReadPlatformService = depositAccountReadPlatformService;
        this.calendarInstanceRepository = calendarInstanceRepository;
        this.configurationDomainService = configurationDomainService;
        this.holidayRepository = holidayRepository;
        this.workingDaysRepository = workingDaysRepository;
        this.depositAccountOnHoldTransactionRepository = depositAccountOnHoldTransactionRepository;
    }
}

