/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.savings.service;

import jakarta.persistence.PersistenceException;
import java.math.MathContext;
import java.time.LocalDate;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.fineract.infrastructure.accountnumberformat.domain.AccountNumberFormat;
import org.apache.fineract.infrastructure.accountnumberformat.domain.AccountNumberFormatRepositoryWrapper;
import org.apache.fineract.infrastructure.accountnumberformat.domain.EntityAccountType;
import org.apache.fineract.infrastructure.configuration.domain.ConfigurationDomainService;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResultBuilder;
import org.apache.fineract.infrastructure.core.data.DataValidatorBuilder;
import org.apache.fineract.infrastructure.core.exception.ErrorHandler;
import org.apache.fineract.infrastructure.core.exception.GeneralPlatformDomainRuleException;
import org.apache.fineract.infrastructure.core.exception.PlatformApiDataValidationException;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.apache.fineract.infrastructure.event.business.domain.BusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.deposit.FixedDepositAccountCreateBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.deposit.RecurringDepositAccountCreateBusinessEvent;
import org.apache.fineract.infrastructure.event.business.service.BusinessEventNotifierService;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.organisation.staff.domain.Staff;
import org.apache.fineract.organisation.staff.domain.StaffRepositoryWrapper;
import org.apache.fineract.portfolio.account.domain.AccountAssociationType;
import org.apache.fineract.portfolio.account.domain.AccountAssociations;
import org.apache.fineract.portfolio.account.domain.AccountAssociationsRepository;
import org.apache.fineract.portfolio.account.service.AccountNumberGenerator;
import org.apache.fineract.portfolio.calendar.domain.Calendar;
import org.apache.fineract.portfolio.calendar.domain.CalendarEntityType;
import org.apache.fineract.portfolio.calendar.domain.CalendarFrequencyType;
import org.apache.fineract.portfolio.calendar.domain.CalendarInstance;
import org.apache.fineract.portfolio.calendar.domain.CalendarInstanceRepository;
import org.apache.fineract.portfolio.calendar.domain.CalendarType;
import org.apache.fineract.portfolio.calendar.service.CalendarUtils;
import org.apache.fineract.portfolio.client.domain.Client;
import org.apache.fineract.portfolio.client.domain.ClientRepositoryWrapper;
import org.apache.fineract.portfolio.client.exception.ClientNotActiveException;
import org.apache.fineract.portfolio.common.domain.PeriodFrequencyType;
import org.apache.fineract.portfolio.group.domain.Group;
import org.apache.fineract.portfolio.group.domain.GroupRepository;
import org.apache.fineract.portfolio.group.exception.CenterNotActiveException;
import org.apache.fineract.portfolio.group.exception.GroupNotActiveException;
import org.apache.fineract.portfolio.group.exception.GroupNotFoundException;
import org.apache.fineract.portfolio.note.domain.Note;
import org.apache.fineract.portfolio.note.domain.NoteRepository;
import org.apache.fineract.portfolio.savings.DepositAccountType;
import org.apache.fineract.portfolio.savings.data.DepositAccountDataValidator;
import org.apache.fineract.portfolio.savings.domain.DepositAccountAssembler;
import org.apache.fineract.portfolio.savings.domain.FixedDepositAccount;
import org.apache.fineract.portfolio.savings.domain.FixedDepositAccountRepository;
import org.apache.fineract.portfolio.savings.domain.RecurringDepositAccount;
import org.apache.fineract.portfolio.savings.domain.RecurringDepositAccountRepository;
import org.apache.fineract.portfolio.savings.domain.SavingsAccount;
import org.apache.fineract.portfolio.savings.domain.SavingsAccountChargeAssembler;
import org.apache.fineract.portfolio.savings.domain.SavingsAccountRepositoryWrapper;
import org.apache.fineract.portfolio.savings.domain.SavingsProduct;
import org.apache.fineract.portfolio.savings.domain.SavingsProductRepository;
import org.apache.fineract.portfolio.savings.exception.SavingsProductNotFoundException;
import org.apache.fineract.portfolio.savings.service.DepositApplicationProcessWritePlatformService;
import org.apache.fineract.portfolio.savings.service.SavingsAccountApplicationTransitionApiJsonValidator;
import org.apache.fineract.useradministration.domain.AppUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.transaction.annotation.Transactional;

public class DepositApplicationProcessWritePlatformServiceJpaRepositoryImpl
implements DepositApplicationProcessWritePlatformService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DepositApplicationProcessWritePlatformServiceJpaRepositoryImpl.class);
    private final PlatformSecurityContext context;
    private final SavingsAccountRepositoryWrapper savingAccountRepository;
    private final FixedDepositAccountRepository fixedDepositAccountRepository;
    private final RecurringDepositAccountRepository recurringDepositAccountRepository;
    private final DepositAccountAssembler depositAccountAssembler;
    private final DepositAccountDataValidator depositAccountDataValidator;
    private final AccountNumberGenerator accountNumberGenerator;
    private final ClientRepositoryWrapper clientRepository;
    private final GroupRepository groupRepository;
    private final SavingsProductRepository savingsProductRepository;
    private final NoteRepository noteRepository;
    private final StaffRepositoryWrapper staffRepository;
    private final SavingsAccountApplicationTransitionApiJsonValidator savingsAccountApplicationTransitionApiJsonValidator;
    private final SavingsAccountChargeAssembler savingsAccountChargeAssembler;
    private final AccountAssociationsRepository accountAssociationsRepository;
    private final FromJsonHelper fromJsonHelper;
    private final CalendarInstanceRepository calendarInstanceRepository;
    private final ConfigurationDomainService configurationDomainService;
    private final AccountNumberFormatRepositoryWrapper accountNumberFormatRepository;
    private final BusinessEventNotifierService businessEventNotifierService;

    private void handleDataIntegrityIssues(JsonCommand command, Throwable realCause, Exception dve) {
        Object[] msgArgs;
        Throwable checkEx;
        Object msgCode = "error.msg.savingsaccount";
        Object msg = "Unknown data integrity issue with savings account.";
        String param = null;
        Throwable throwable = checkEx = realCause == null ? dve : realCause;
        if (checkEx.getMessage().contains("sa_account_no_UNIQUE")) {
            String accountNo = command.stringValueOfParameterNamed("accountNo");
            msgCode = (String)msgCode + ".duplicate.accountNo";
            msg = "Savings account with accountNo " + accountNo + " already exists";
            param = "accountNo";
            msgArgs = new Object[]{accountNo, dve};
        } else if (checkEx.getMessage().contains("sa_external_id_UNIQUE")) {
            String externalId = command.stringValueOfParameterNamed("externalId");
            msgCode = (String)msgCode + ".duplicate.externalId";
            msg = "Savings account with externalId " + externalId + " already exists";
            param = "externalId";
            msgArgs = new Object[]{externalId, dve};
        } else {
            msgCode = (String)msgCode + ".unknown.data.integrity.issue";
            msgArgs = new Object[]{dve};
        }
        log.error("Error occured.", (Throwable)dve);
        throw ErrorHandler.getMappable((Throwable)dve, (String)msgCode, (String)msg, (String)param, (Object[])msgArgs);
    }

    @Transactional
    public CommandProcessingResult submitFDApplication(JsonCommand command) {
        try {
            Long savingsAccountId;
            this.depositAccountDataValidator.validateFixedDepositForSubmit(command.json());
            AppUser submittedBy = this.context.authenticatedUser();
            boolean isSavingsInterestPostingAtCurrentPeriodEnd = this.configurationDomainService.isSavingsInterestPostingAtCurrentPeriodEnd();
            Integer financialYearBeginningMonth = this.configurationDomainService.retrieveFinancialYearBeginningMonth();
            FixedDepositAccount account = (FixedDepositAccount)this.depositAccountAssembler.assembleFrom(command, submittedBy, DepositAccountType.FIXED_DEPOSIT);
            MathContext mc = MathContext.DECIMAL64;
            boolean isPreMatureClosure = false;
            account.updateMaturityDateAndAmountBeforeAccountActivation(mc, false, isSavingsInterestPostingAtCurrentPeriodEnd, financialYearBeginningMonth);
            this.fixedDepositAccountRepository.saveAndFlush((Object)account);
            if (account.isAccountNumberRequiresAutoGeneration()) {
                AccountNumberFormat accountNumberFormat = this.accountNumberFormatRepository.findByAccountType(EntityAccountType.CLIENT);
                account.updateAccountNo(this.accountNumberGenerator.generate((SavingsAccount)account, accountNumberFormat));
                this.savingAccountRepository.save((SavingsAccount)account);
            }
            if ((savingsAccountId = command.longValueOfParameterNamed("linkAccountId")) != null) {
                SavingsAccount savingsAccount = this.depositAccountAssembler.assembleFrom(savingsAccountId, DepositAccountType.SAVINGS_DEPOSIT);
                this.depositAccountDataValidator.validatelinkedSavingsAccount(savingsAccount, (SavingsAccount)account);
                boolean isActive = true;
                AccountAssociations accountAssociations = AccountAssociations.associateSavingsAccount((SavingsAccount)account, (SavingsAccount)savingsAccount, (Integer)AccountAssociationType.LINKED_ACCOUNT_ASSOCIATION.getValue(), (boolean)isActive);
                this.accountAssociationsRepository.save((Object)accountAssociations);
            }
            Long savingsId = (Long)account.getId();
            this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new FixedDepositAccountCreateBusinessEvent(account));
            return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId(savingsId).withOfficeId(account.officeId()).withClientId(account.clientId()).withGroupId(account.groupId()).withSavingsId(savingsId).build();
        }
        catch (DataAccessException dve) {
            this.handleDataIntegrityIssues(command, dve.getMostSpecificCause(), (Exception)((Object)dve));
            return CommandProcessingResult.empty();
        }
        catch (PersistenceException dve) {
            Throwable throwable = ExceptionUtils.getRootCause((Throwable)dve.getCause());
            this.handleDataIntegrityIssues(command, throwable, (Exception)((Object)dve));
            return CommandProcessingResult.empty();
        }
    }

    @Transactional
    public CommandProcessingResult submitRDApplication(JsonCommand command) {
        try {
            this.depositAccountDataValidator.validateRecurringDepositForSubmit(command.json());
            AppUser submittedBy = this.context.authenticatedUser();
            boolean isSavingsInterestPostingAtCurrentPeriodEnd = this.configurationDomainService.isSavingsInterestPostingAtCurrentPeriodEnd();
            Integer financialYearBeginningMonth = this.configurationDomainService.retrieveFinancialYearBeginningMonth();
            RecurringDepositAccount account = (RecurringDepositAccount)this.depositAccountAssembler.assembleFrom(command, submittedBy, DepositAccountType.RECURRING_DEPOSIT);
            this.recurringDepositAccountRepository.save((Object)account);
            if (account.isAccountNumberRequiresAutoGeneration()) {
                AccountNumberFormat accountNumberFormat = this.accountNumberFormatRepository.findByAccountType(EntityAccountType.SAVINGS);
                account.updateAccountNo(this.accountNumberGenerator.generate((SavingsAccount)account, accountNumberFormat));
            }
            Long savingsId = (Long)account.getId();
            CalendarInstance calendarInstance = this.getCalendarInstance(command, account);
            this.calendarInstanceRepository.save((Object)calendarInstance);
            MathContext mc = MathContext.DECIMAL64;
            Calendar calendar = calendarInstance.getCalendar();
            PeriodFrequencyType frequencyType = CalendarFrequencyType.from((CalendarFrequencyType)CalendarUtils.getFrequency((String)calendar.getRecurrence()));
            Integer frequency = CalendarUtils.getInterval((String)calendar.getRecurrence());
            frequency = frequency == -1 ? 1 : frequency;
            account.generateSchedule(frequencyType, frequency, calendar);
            boolean isPreMatureClosure = false;
            account.updateMaturityDateAndAmount(mc, false, isSavingsInterestPostingAtCurrentPeriodEnd, financialYearBeginningMonth);
            account.validateApplicableInterestRate();
            this.savingAccountRepository.save((SavingsAccount)account);
            this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new RecurringDepositAccountCreateBusinessEvent(account));
            return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId(savingsId).withOfficeId(account.officeId()).withClientId(account.clientId()).withGroupId(account.groupId()).withSavingsId(savingsId).build();
        }
        catch (DataAccessException dve) {
            this.handleDataIntegrityIssues(command, dve.getMostSpecificCause(), (Exception)((Object)dve));
            return CommandProcessingResult.empty();
        }
        catch (PersistenceException dve) {
            Throwable throwable = ExceptionUtils.getRootCause((Throwable)dve.getCause());
            this.handleDataIntegrityIssues(command, throwable, (Exception)((Object)dve));
            return CommandProcessingResult.empty();
        }
    }

    private CalendarInstance getCalendarInstance(JsonCommand command, RecurringDepositAccount account) {
        CalendarInstance calendarInstance = null;
        boolean isCalendarInherited = command.booleanPrimitiveValueOfParameterNamed("isCalendarInherited");
        if (isCalendarInherited) {
            Set groups = account.getClient().getGroups();
            Long groupId = null;
            if (groups.isEmpty()) {
                String defaultUserMessage = "Client does not belong to group/center. Cannot follow group/center meeting frequency.";
                throw new GeneralPlatformDomainRuleException("error.msg.recurring.deposit.account.cannot.create.not.belongs.to.any.groups.to.follow.meeting.frequency", "Client does not belong to group/center. Cannot follow group/center meeting frequency.", new Object[]{account.clientId()});
            }
            if (groups.size() > 1) {
                String defaultUserMessage = "Client belongs to more than one group. Cannot support recurring deposit.";
                throw new GeneralPlatformDomainRuleException("error.msg.recurring.deposit.account.cannot.create.belongs.to.multiple.groups", "Client belongs to more than one group. Cannot support recurring deposit.", new Object[]{account.clientId()});
            }
            Group group = (Group)groups.iterator().next();
            Group parent = group.getParent();
            Integer entityType = CalendarEntityType.GROUPS.getValue();
            if (parent != null) {
                groupId = (Long)parent.getId();
                entityType = CalendarEntityType.CENTERS.getValue();
            } else {
                groupId = (Long)group.getId();
            }
            CalendarInstance parentCalendarInstance = this.calendarInstanceRepository.findByEntityIdAndEntityTypeIdAndCalendarTypeId(groupId, entityType, CalendarType.COLLECTION.getValue());
            if (parentCalendarInstance == null) {
                String defaultUserMessage = "Meeting frequency is not attached to the Group/Center to which the client belongs to.";
                throw new GeneralPlatformDomainRuleException("error.msg.meeting.frequency.not.attached.to.group.to.which.client.belongs.to", "Meeting frequency is not attached to the Group/Center to which the client belongs to.", new Object[]{account.clientId()});
            }
            calendarInstance = CalendarInstance.from((Calendar)parentCalendarInstance.getCalendar(), (Long)((Long)account.getId()), (Integer)CalendarEntityType.SAVINGS.getValue());
        } else {
            LocalDate calendarStartDate = account.depositStartDate();
            Integer frequencyType = command.integerValueSansLocaleOfParameterNamed("recurringFrequencyType");
            PeriodFrequencyType periodFrequencyType = PeriodFrequencyType.fromInt((Integer)frequencyType);
            Integer frequency = command.integerValueSansLocaleOfParameterNamed("recurringFrequency");
            Integer repeatsOnDay = calendarStartDate.get(ChronoField.DAY_OF_WEEK);
            String title = "recurring_savings_" + String.valueOf(account.getId());
            Calendar calendar = Calendar.createRepeatingCalendar((String)title, (LocalDate)calendarStartDate, (Integer)CalendarType.COLLECTION.getValue(), (CalendarFrequencyType)CalendarFrequencyType.from((PeriodFrequencyType)periodFrequencyType), (Integer)frequency, (Integer)repeatsOnDay, null);
            calendarInstance = CalendarInstance.from((Calendar)calendar, (Long)((Long)account.getId()), (Integer)CalendarEntityType.SAVINGS.getValue());
        }
        if (calendarInstance == null) {
            String defaultUserMessage = "No valid recurring details available for recurring depost account creation.";
            throw new GeneralPlatformDomainRuleException("error.msg.recurring.deposit.account.cannot.create.no.valid.recurring.details.available", "No valid recurring details available for recurring depost account creation.", new Object[]{account.clientId()});
        }
        return calendarInstance;
    }

    @Transactional
    public CommandProcessingResult modifyFDApplication(Long accountId, JsonCommand command) {
        try {
            this.depositAccountDataValidator.validateFixedDepositForUpdate(command.json());
            boolean isSavingsInterestPostingAtCurrentPeriodEnd = this.configurationDomainService.isSavingsInterestPostingAtCurrentPeriodEnd();
            Integer financialYearBeginningMonth = this.configurationDomainService.retrieveFinancialYearBeginningMonth();
            LinkedHashMap<String, Long> changes = new LinkedHashMap<String, Long>(20);
            FixedDepositAccount account = (FixedDepositAccount)this.depositAccountAssembler.assembleFrom(accountId, DepositAccountType.FIXED_DEPOSIT);
            this.checkClientOrGroupActive((SavingsAccount)account);
            account.modifyApplication(command, changes);
            account.validateNewApplicationState(DepositAccountType.FIXED_DEPOSIT.resourceName());
            if (!changes.isEmpty()) {
                this.updateFDAndRDCommonChanges(changes, command, (SavingsAccount)account);
                MathContext mc = MathContext.DECIMAL64;
                boolean isPreMatureClosure = false;
                account.updateMaturityDateAndAmountBeforeAccountActivation(mc, false, isSavingsInterestPostingAtCurrentPeriodEnd, financialYearBeginningMonth);
                this.savingAccountRepository.save((SavingsAccount)account);
            }
            boolean isLinkedAccRequired = command.booleanPrimitiveValueOfParameterNamed("transferInterestToSavings");
            Long savingsAccountId = command.longValueOfParameterNamed("linkAccountId");
            AccountAssociations accountAssociations = this.accountAssociationsRepository.findBySavingsIdAndType(accountId, AccountAssociationType.LINKED_ACCOUNT_ASSOCIATION.getValue());
            if (savingsAccountId == null) {
                if (accountAssociations != null) {
                    if (this.fromJsonHelper.parameterExists("linkAccountId", command.parsedJson())) {
                        this.accountAssociationsRepository.delete((Object)accountAssociations);
                        changes.put("linkAccountId", null);
                        if (isLinkedAccRequired) {
                            this.depositAccountDataValidator.throwLinkedAccountRequiredError();
                        }
                    }
                } else if (isLinkedAccRequired) {
                    this.depositAccountDataValidator.throwLinkedAccountRequiredError();
                }
            } else {
                SavingsAccount savingsAccount;
                boolean isModified = false;
                if (accountAssociations == null) {
                    isModified = true;
                } else {
                    savingsAccount = accountAssociations.linkedSavingsAccount();
                    if (savingsAccount == null || !((Long)savingsAccount.getId()).equals(savingsAccountId)) {
                        isModified = true;
                    }
                }
                if (isModified) {
                    savingsAccount = this.depositAccountAssembler.assembleFrom(savingsAccountId, DepositAccountType.SAVINGS_DEPOSIT);
                    this.depositAccountDataValidator.validatelinkedSavingsAccount(savingsAccount, (SavingsAccount)account);
                    if (accountAssociations == null) {
                        boolean isActive = true;
                        accountAssociations = AccountAssociations.associateSavingsAccount((SavingsAccount)account, (SavingsAccount)savingsAccount, (Integer)AccountAssociationType.LINKED_ACCOUNT_ASSOCIATION.getValue(), (boolean)isActive);
                    } else {
                        accountAssociations.updateLinkedSavingsAccount(savingsAccount);
                    }
                    changes.put("linkAccountId", savingsAccountId);
                    this.accountAssociationsRepository.save((Object)accountAssociations);
                }
            }
            return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId(accountId).withOfficeId(account.officeId()).withClientId(account.clientId()).withGroupId(account.groupId()).withSavingsId(accountId).with(changes).build();
        }
        catch (DataAccessException dve) {
            this.handleDataIntegrityIssues(command, dve.getMostSpecificCause(), (Exception)((Object)dve));
            return CommandProcessingResult.resourceResult((Long)-1L);
        }
        catch (PersistenceException dve) {
            Throwable throwable = ExceptionUtils.getRootCause((Throwable)dve.getCause());
            this.handleDataIntegrityIssues(command, throwable, (Exception)((Object)dve));
            return CommandProcessingResult.resourceResult((Long)-1L);
        }
    }

    @Transactional
    public CommandProcessingResult modifyRDApplication(Long accountId, JsonCommand command) {
        try {
            this.depositAccountDataValidator.validateRecurringDepositForUpdate(command.json());
            boolean isSavingsInterestPostingAtCurrentPeriodEnd = this.configurationDomainService.isSavingsInterestPostingAtCurrentPeriodEnd();
            Integer financialYearBeginningMonth = this.configurationDomainService.retrieveFinancialYearBeginningMonth();
            LinkedHashMap changes = new LinkedHashMap(20);
            RecurringDepositAccount account = (RecurringDepositAccount)this.depositAccountAssembler.assembleFrom(accountId, DepositAccountType.RECURRING_DEPOSIT);
            this.checkClientOrGroupActive((SavingsAccount)account);
            account.modifyApplication(command, changes);
            account.validateNewApplicationState(DepositAccountType.RECURRING_DEPOSIT.resourceName());
            if (!changes.isEmpty()) {
                this.updateFDAndRDCommonChanges(changes, command, (SavingsAccount)account);
                MathContext mc = MathContext.DECIMAL64;
                CalendarInstance calendarInstance = this.calendarInstanceRepository.findByEntityIdAndEntityTypeIdAndCalendarTypeId(accountId, CalendarEntityType.SAVINGS.getValue(), CalendarType.COLLECTION.getValue());
                Calendar calendar = calendarInstance.getCalendar();
                PeriodFrequencyType frequencyType = CalendarFrequencyType.from((CalendarFrequencyType)CalendarUtils.getFrequency((String)calendar.getRecurrence()));
                Integer frequency = CalendarUtils.getInterval((String)calendar.getRecurrence());
                frequency = frequency == -1 ? 1 : frequency;
                account.generateSchedule(frequencyType, frequency, calendar);
                boolean isPreMatureClosure = false;
                account.updateMaturityDateAndAmount(mc, false, isSavingsInterestPostingAtCurrentPeriodEnd, financialYearBeginningMonth);
                account.validateApplicableInterestRate();
                this.savingAccountRepository.save((SavingsAccount)account);
            }
            if (!account.isCalendarInherited()) {
                LocalDate calendarStartDate = account.depositStartDate();
                Integer frequencyType = command.integerValueSansLocaleOfParameterNamed("recurringFrequencyType");
                PeriodFrequencyType periodFrequencyType = PeriodFrequencyType.fromInt((Integer)frequencyType);
                Integer frequency = command.integerValueSansLocaleOfParameterNamed("recurringFrequency");
                Integer repeatsOnDay = calendarStartDate.get(ChronoField.DAY_OF_WEEK);
                CalendarInstance calendarInstance = this.calendarInstanceRepository.findByEntityIdAndEntityTypeIdAndCalendarTypeId(accountId, CalendarEntityType.SAVINGS.getValue(), CalendarType.COLLECTION.getValue());
                Calendar calendar = calendarInstance.getCalendar();
                calendar.updateRepeatingCalendar(calendarStartDate, CalendarFrequencyType.from((PeriodFrequencyType)periodFrequencyType), frequency, repeatsOnDay, null);
                this.calendarInstanceRepository.save((Object)calendarInstance);
            }
            return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId(accountId).withOfficeId(account.officeId()).withClientId(account.clientId()).withGroupId(account.groupId()).withSavingsId(accountId).with(changes).build();
        }
        catch (DataAccessException dve) {
            this.handleDataIntegrityIssues(command, dve.getMostSpecificCause(), (Exception)((Object)dve));
            return CommandProcessingResult.resourceResult((Long)-1L);
        }
        catch (PersistenceException dve) {
            Throwable throwable = ExceptionUtils.getRootCause((Throwable)dve.getCause());
            this.handleDataIntegrityIssues(command, throwable, (Exception)((Object)dve));
            return CommandProcessingResult.resourceResult((Long)-1L);
        }
    }

    private void updateFDAndRDCommonChanges(Map<String, Object> changes, JsonCommand command, SavingsAccount account) {
        Set charges;
        boolean updated;
        if (changes.containsKey("clientId")) {
            Long clientId = command.longValueOfParameterNamed("clientId");
            if (clientId != null) {
                client = this.clientRepository.findOneWithNotFoundDetection(clientId);
                if (client.isNotActive()) {
                    throw new ClientNotActiveException(clientId);
                }
                account.update(client);
            } else {
                client = null;
                account.update(client);
            }
        }
        if (changes.containsKey("groupId")) {
            Long groupId = command.longValueOfParameterNamed("groupId");
            if (groupId != null) {
                group = (Group)this.groupRepository.findById((Object)groupId).orElseThrow(() -> new GroupNotFoundException(groupId));
                if (group.isNotActive()) {
                    if (group.isCenter()) {
                        throw new CenterNotActiveException(groupId);
                    }
                    throw new GroupNotActiveException(groupId);
                }
                account.update(group);
            } else {
                group = null;
                account.update(group);
            }
        }
        if (changes.containsKey("productId")) {
            Long productId = command.longValueOfParameterNamed("productId");
            SavingsProduct product = (SavingsProduct)this.savingsProductRepository.findById((Object)productId).orElseThrow(() -> new SavingsProductNotFoundException(productId));
            account.update(product);
        }
        if (changes.containsKey("fieldOfficerId")) {
            Long fieldOfficerId = command.longValueOfParameterNamed("fieldOfficerId");
            Staff fieldOfficer = null;
            if (fieldOfficerId != null) {
                fieldOfficer = this.staffRepository.findOneWithNotFoundDetection(fieldOfficerId);
            } else {
                changes.put("fieldOfficerId", "");
            }
            account.update(fieldOfficer);
        }
        if (changes.containsKey("charges") && !(updated = account.update(charges = this.savingsAccountChargeAssembler.fromParsedJson(command.parsedJson(), account.getCurrency().getCode())))) {
            changes.remove("charges");
        }
    }

    @Transactional
    public CommandProcessingResult deleteApplication(Long savingsId, DepositAccountType depositAccountType) {
        SavingsAccount account = this.depositAccountAssembler.assembleFrom(savingsId, depositAccountType);
        this.checkClientOrGroupActive(account);
        if (account.isNotSubmittedAndPendingApproval()) {
            ArrayList dataValidationErrors = new ArrayList();
            DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource(depositAccountType.resourceName() + ".delete");
            baseDataValidator.reset().parameter("activatedOnDate").failWithCodeNoParameterAddedToErrorCode("not.in.submittedandpendingapproval.state", new Object[0]);
            if (!dataValidationErrors.isEmpty()) {
                throw new PlatformApiDataValidationException(dataValidationErrors);
            }
        }
        List relatedNotes = this.noteRepository.findBySavingsAccount(account);
        this.noteRepository.deleteAllInBatch((Iterable)relatedNotes);
        this.savingAccountRepository.delete(account);
        return new CommandProcessingResultBuilder().withEntityId(savingsId).withOfficeId(account.officeId()).withClientId(account.clientId()).withGroupId(account.groupId()).withSavingsId(savingsId).build();
    }

    @Transactional
    public CommandProcessingResult approveApplication(Long savingsId, JsonCommand command, DepositAccountType depositAccountType) {
        AppUser currentUser = this.context.authenticatedUser();
        this.savingsAccountApplicationTransitionApiJsonValidator.validateApproval(command.json());
        SavingsAccount savingsAccount = this.depositAccountAssembler.assembleFrom(savingsId, depositAccountType);
        this.checkClientOrGroupActive(savingsAccount);
        Map changes = savingsAccount.approveApplication(currentUser, command);
        if (!changes.isEmpty()) {
            this.savingAccountRepository.save(savingsAccount);
            String noteText = command.stringValueOfParameterNamed("note");
            if (StringUtils.isNotBlank((CharSequence)noteText)) {
                Note note = Note.savingNote((SavingsAccount)savingsAccount, (String)noteText);
                changes.put("note", noteText);
                this.noteRepository.save((Object)note);
            }
        }
        return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId(savingsId).withOfficeId(savingsAccount.officeId()).withClientId(savingsAccount.clientId()).withGroupId(savingsAccount.groupId()).withSavingsId(savingsId).with(changes).build();
    }

    @Transactional
    public CommandProcessingResult undoApplicationApproval(Long savingsId, JsonCommand command, DepositAccountType depositAccountType) {
        this.context.authenticatedUser();
        this.savingsAccountApplicationTransitionApiJsonValidator.validateForUndo(command.json());
        SavingsAccount savingsAccount = this.depositAccountAssembler.assembleFrom(savingsId, depositAccountType);
        this.checkClientOrGroupActive(savingsAccount);
        Map changes = savingsAccount.undoApplicationApproval();
        if (!changes.isEmpty()) {
            this.savingAccountRepository.save(savingsAccount);
            String noteText = command.stringValueOfParameterNamed("note");
            if (StringUtils.isNotBlank((CharSequence)noteText)) {
                Note note = Note.savingNote((SavingsAccount)savingsAccount, (String)noteText);
                changes.put("note", noteText);
                this.noteRepository.save((Object)note);
            }
        }
        return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId(savingsId).withOfficeId(savingsAccount.officeId()).withClientId(savingsAccount.clientId()).withGroupId(savingsAccount.groupId()).withSavingsId(savingsId).with(changes).build();
    }

    @Transactional
    public CommandProcessingResult rejectApplication(Long savingsId, JsonCommand command, DepositAccountType depositAccountType) {
        AppUser currentUser = this.context.authenticatedUser();
        this.savingsAccountApplicationTransitionApiJsonValidator.validateRejection(command.json());
        SavingsAccount savingsAccount = this.depositAccountAssembler.assembleFrom(savingsId, depositAccountType);
        this.checkClientOrGroupActive(savingsAccount);
        Map changes = savingsAccount.rejectApplication(currentUser, command);
        if (!changes.isEmpty()) {
            this.savingAccountRepository.save(savingsAccount);
            String noteText = command.stringValueOfParameterNamed("note");
            if (StringUtils.isNotBlank((CharSequence)noteText)) {
                Note note = Note.savingNote((SavingsAccount)savingsAccount, (String)noteText);
                changes.put("note", noteText);
                this.noteRepository.save((Object)note);
            }
        }
        return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId(savingsId).withOfficeId(savingsAccount.officeId()).withClientId(savingsAccount.clientId()).withGroupId(savingsAccount.groupId()).withSavingsId(savingsId).with(changes).build();
    }

    @Transactional
    public CommandProcessingResult applicantWithdrawsFromApplication(Long savingsId, JsonCommand command, DepositAccountType depositAccountType) {
        AppUser currentUser = this.context.authenticatedUser();
        this.savingsAccountApplicationTransitionApiJsonValidator.validateApplicantWithdrawal(command.json());
        SavingsAccount savingsAccount = this.depositAccountAssembler.assembleFrom(savingsId, depositAccountType);
        this.checkClientOrGroupActive(savingsAccount);
        Map changes = savingsAccount.applicantWithdrawsFromApplication(currentUser, command);
        if (!changes.isEmpty()) {
            this.savingAccountRepository.save(savingsAccount);
            String noteText = command.stringValueOfParameterNamed("note");
            if (StringUtils.isNotBlank((CharSequence)noteText)) {
                Note note = Note.savingNote((SavingsAccount)savingsAccount, (String)noteText);
                changes.put("note", noteText);
                this.noteRepository.save((Object)note);
            }
        }
        return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId(savingsId).withOfficeId(savingsAccount.officeId()).withClientId(savingsAccount.clientId()).withGroupId(savingsAccount.groupId()).withSavingsId(savingsId).with(changes).build();
    }

    private void checkClientOrGroupActive(SavingsAccount account) {
        Client client = account.getClient();
        if (client != null && client.isNotActive()) {
            throw new ClientNotActiveException((Long)client.getId());
        }
        Group group = account.group();
        if (group != null && group.isNotActive()) {
            if (group.isCenter()) {
                throw new CenterNotActiveException((Long)group.getId());
            }
            throw new GroupNotActiveException((Long)group.getId());
        }
    }

    @Generated
    public DepositApplicationProcessWritePlatformServiceJpaRepositoryImpl(PlatformSecurityContext context, SavingsAccountRepositoryWrapper savingAccountRepository, FixedDepositAccountRepository fixedDepositAccountRepository, RecurringDepositAccountRepository recurringDepositAccountRepository, DepositAccountAssembler depositAccountAssembler, DepositAccountDataValidator depositAccountDataValidator, AccountNumberGenerator accountNumberGenerator, ClientRepositoryWrapper clientRepository, GroupRepository groupRepository, SavingsProductRepository savingsProductRepository, NoteRepository noteRepository, StaffRepositoryWrapper staffRepository, SavingsAccountApplicationTransitionApiJsonValidator savingsAccountApplicationTransitionApiJsonValidator, SavingsAccountChargeAssembler savingsAccountChargeAssembler, AccountAssociationsRepository accountAssociationsRepository, FromJsonHelper fromJsonHelper, CalendarInstanceRepository calendarInstanceRepository, ConfigurationDomainService configurationDomainService, AccountNumberFormatRepositoryWrapper accountNumberFormatRepository, BusinessEventNotifierService businessEventNotifierService) {
        this.context = context;
        this.savingAccountRepository = savingAccountRepository;
        this.fixedDepositAccountRepository = fixedDepositAccountRepository;
        this.recurringDepositAccountRepository = recurringDepositAccountRepository;
        this.depositAccountAssembler = depositAccountAssembler;
        this.depositAccountDataValidator = depositAccountDataValidator;
        this.accountNumberGenerator = accountNumberGenerator;
        this.clientRepository = clientRepository;
        this.groupRepository = groupRepository;
        this.savingsProductRepository = savingsProductRepository;
        this.noteRepository = noteRepository;
        this.staffRepository = staffRepository;
        this.savingsAccountApplicationTransitionApiJsonValidator = savingsAccountApplicationTransitionApiJsonValidator;
        this.savingsAccountChargeAssembler = savingsAccountChargeAssembler;
        this.accountAssociationsRepository = accountAssociationsRepository;
        this.fromJsonHelper = fromJsonHelper;
        this.calendarInstanceRepository = calendarInstanceRepository;
        this.configurationDomainService = configurationDomainService;
        this.accountNumberFormatRepository = accountNumberFormatRepository;
        this.businessEventNotifierService = businessEventNotifierService;
    }
}

