/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.savings.service;

import jakarta.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.math.MathContext;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.domain.LocalDateInterval;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.organisation.monetary.data.CurrencyData;
import org.apache.fineract.organisation.monetary.domain.MonetaryCurrency;
import org.apache.fineract.organisation.monetary.domain.Money;
import org.apache.fineract.portfolio.savings.DepositAccountType;
import org.apache.fineract.portfolio.savings.SavingsCompoundingInterestPeriodType;
import org.apache.fineract.portfolio.savings.SavingsInterestCalculationDaysInYearType;
import org.apache.fineract.portfolio.savings.SavingsInterestCalculationType;
import org.apache.fineract.portfolio.savings.SavingsPostingInterestPeriodType;
import org.apache.fineract.portfolio.savings.data.SavingsAccountData;
import org.apache.fineract.portfolio.savings.data.SavingsAccountTransactionData;
import org.apache.fineract.portfolio.savings.domain.SavingsAccountChargesPaidByData;
import org.apache.fineract.portfolio.savings.domain.SavingsAccountTransactionDataComparator;
import org.apache.fineract.portfolio.savings.domain.SavingsHelper;
import org.apache.fineract.portfolio.savings.domain.interest.PostingPeriod;
import org.apache.fineract.portfolio.savings.service.SavingsAccountInterestPostingService;
import org.apache.fineract.portfolio.tax.service.TaxUtils;

public class SavingsAccountInterestPostingServiceImpl
implements SavingsAccountInterestPostingService {
    private final SavingsHelper savingsHelper;

    public SavingsAccountData postInterest(MathContext mc, LocalDate interestPostingUpToDate, boolean isInterestTransfer, boolean isSavingsInterestPostingAtCurrentPeriodEnd, Integer financialYearBeginningMonth, LocalDate postInterestOnDate, boolean backdatedTxnsAllowedTill, SavingsAccountData savingsAccountData) {
        Money interestPostedToDate = Money.zero((CurrencyData)savingsAccountData.getCurrency());
        LocalDate startInterestDate = this.getStartInterestCalculationDate(savingsAccountData);
        if (backdatedTxnsAllowedTill && savingsAccountData.getSummary().getInterestPostedTillDate() != null) {
            interestPostedToDate = Money.of((CurrencyData)savingsAccountData.getCurrency(), (BigDecimal)savingsAccountData.getSummary().getTotalInterestPosted());
            savingsAccountData.setStartInterestCalculationDate(savingsAccountData.getSummary().getInterestPostedTillDate());
        } else {
            savingsAccountData.setStartInterestCalculationDate(startInterestDate);
        }
        List postingPeriods = this.calculateInterestUsing(mc, interestPostingUpToDate, isInterestTransfer, isSavingsInterestPostingAtCurrentPeriodEnd, financialYearBeginningMonth, postInterestOnDate, backdatedTxnsAllowedTill, savingsAccountData);
        boolean recalucateDailyBalanceDetails = false;
        boolean applyWithHoldTax = this.isWithHoldTaxApplicableForInterestPosting(savingsAccountData);
        ArrayList withholdTransactions = new ArrayList();
        withholdTransactions.addAll(this.findWithHoldSavingsTransactionsWithPivotConfig(savingsAccountData));
        for (PostingPeriod interestPostingPeriod : postingPeriods) {
            LocalDate interestPostingTransactionDate = interestPostingPeriod.dateOfPostingTransaction();
            Money interestEarnedToBePostedForPeriod = interestPostingPeriod.getInterestEarned();
            if (DateUtils.isAfter((LocalDate)interestPostingTransactionDate, (LocalDate)interestPostingUpToDate)) continue;
            interestPostedToDate = interestPostedToDate.plus(interestEarnedToBePostedForPeriod);
            SavingsAccountTransactionData postingTransaction = this.findInterestPostingTransactionFor(interestPostingTransactionDate, savingsAccountData);
            if (postingTransaction == null) {
                SavingsAccountTransactionData newPostingTransaction = interestEarnedToBePostedForPeriod.isGreaterThanOrEqualTo(Money.zero((CurrencyData)savingsAccountData.getCurrency())) ? SavingsAccountTransactionData.interestPosting((SavingsAccountData)savingsAccountData, (LocalDate)interestPostingTransactionDate, (Money)interestEarnedToBePostedForPeriod, (boolean)interestPostingPeriod.isUserPosting()) : SavingsAccountTransactionData.overdraftInterest((SavingsAccountData)savingsAccountData, (LocalDate)interestPostingTransactionDate, (Money)interestEarnedToBePostedForPeriod.negated(), (boolean)interestPostingPeriod.isUserPosting());
                savingsAccountData.updateTransactions(newPostingTransaction);
                if (applyWithHoldTax) {
                    this.createWithHoldTransaction(interestEarnedToBePostedForPeriod.getAmount(), interestPostingTransactionDate, savingsAccountData);
                }
                recalucateDailyBalanceDetails = true;
                continue;
            }
            boolean correctionRequired = false;
            correctionRequired = postingTransaction.isInterestPostingAndNotReversed() ? postingTransaction.hasNotAmount(interestEarnedToBePostedForPeriod) : postingTransaction.hasNotAmount(interestEarnedToBePostedForPeriod.negated());
            if (!correctionRequired) continue;
            boolean applyWithHoldTaxForOldTransaction = false;
            postingTransaction.reverse();
            SavingsAccountTransactionData withholdTransaction = this.findTransactionFor(interestPostingTransactionDate, withholdTransactions);
            if (withholdTransaction != null) {
                withholdTransaction.reverse();
                applyWithHoldTaxForOldTransaction = true;
            }
            SavingsAccountTransactionData newPostingTransaction = interestEarnedToBePostedForPeriod.isGreaterThanOrEqualTo(Money.zero((CurrencyData)savingsAccountData.getCurrency())) ? SavingsAccountTransactionData.interestPosting((SavingsAccountData)savingsAccountData, (LocalDate)interestPostingTransactionDate, (Money)interestEarnedToBePostedForPeriod, (boolean)interestPostingPeriod.isUserPosting()) : SavingsAccountTransactionData.overdraftInterest((SavingsAccountData)savingsAccountData, (LocalDate)interestPostingTransactionDate, (Money)interestEarnedToBePostedForPeriod.negated(), (boolean)interestPostingPeriod.isUserPosting());
            savingsAccountData.updateTransactions(newPostingTransaction);
            if (applyWithHoldTaxForOldTransaction) {
                this.createWithHoldTransaction(interestEarnedToBePostedForPeriod.getAmount(), interestPostingTransactionDate, savingsAccountData);
            }
            recalucateDailyBalanceDetails = true;
        }
        if (recalucateDailyBalanceDetails) {
            Money openingAccountBalance = Money.zero((CurrencyData)savingsAccountData.getCurrency());
            if (backdatedTxnsAllowedTill) {
                openingAccountBalance = savingsAccountData.getSummary().getLastInterestCalculationDate() == null ? Money.zero((CurrencyData)savingsAccountData.getCurrency()) : Money.of((CurrencyData)savingsAccountData.getCurrency(), (BigDecimal)savingsAccountData.getSummary().getRunningBalanceOnPivotDate());
            }
            this.recalculateDailyBalances(openingAccountBalance, interestPostingUpToDate, backdatedTxnsAllowedTill, savingsAccountData);
        }
        if (!backdatedTxnsAllowedTill) {
            savingsAccountData.getSummary().updateSummary(savingsAccountData.getCurrency(), savingsAccountData.getSavingsAccountTransactionSummaryWrapper(), savingsAccountData.getSavingsAccountTransactionData());
        } else {
            savingsAccountData.getSummary().updateSummaryWithPivotConfig(savingsAccountData.getCurrency(), savingsAccountData.getSavingsAccountTransactionSummaryWrapper(), null, savingsAccountData.getSavingsAccountTransactionData());
        }
        return savingsAccountData;
    }

    protected SavingsAccountTransactionData findTransactionFor(LocalDate postingDate, List<SavingsAccountTransactionData> transactions) {
        SavingsAccountTransactionData transaction = null;
        for (SavingsAccountTransactionData savingsAccountTransaction : transactions) {
            if (!savingsAccountTransaction.occursOn(postingDate)) continue;
            transaction = savingsAccountTransaction;
            break;
        }
        return transaction;
    }

    public List<PostingPeriod> calculateInterestUsing(MathContext mc, LocalDate upToInterestCalculationDate, boolean isInterestTransfer, boolean isSavingsInterestPostingAtCurrentPeriodEnd, Integer financialYearBeginningMonth, LocalDate postInterestOnDate, boolean backdatedTxnsAllowedTill, SavingsAccountData savingsAccountData) {
        SavingsAccountTransactionData transaction;
        Money openingAccountBalance = null;
        openingAccountBalance = backdatedTxnsAllowedTill ? Money.of((CurrencyData)savingsAccountData.getCurrency(), (BigDecimal)savingsAccountData.getSummary().getRunningBalanceOnPivotDate()) : Money.zero((CurrencyData)savingsAccountData.getCurrency());
        this.recalculateDailyBalances(openingAccountBalance, upToInterestCalculationDate, backdatedTxnsAllowedTill, savingsAccountData);
        SavingsPostingInterestPeriodType postingPeriodType = SavingsPostingInterestPeriodType.fromInt((Integer)savingsAccountData.getInterestPostingPeriodTypeId());
        SavingsCompoundingInterestPeriodType compoundingPeriodType = SavingsCompoundingInterestPeriodType.fromInt((Integer)savingsAccountData.getInterestCompoundingPeriodTypeId());
        SavingsInterestCalculationDaysInYearType daysInYearType = SavingsInterestCalculationDaysInYearType.fromInt((Integer)savingsAccountData.getInterestCalculationDaysInYearTypeId());
        List postedAsOnDates = this.getManualPostingDates(savingsAccountData);
        if (postInterestOnDate != null) {
            postedAsOnDates.add(postInterestOnDate);
        }
        List postingPeriodIntervals = this.savingsHelper.determineInterestPostingPeriods(savingsAccountData.getStartInterestCalculationDate(), upToInterestCalculationDate, postingPeriodType, financialYearBeginningMonth, postedAsOnDates);
        ArrayList<PostingPeriod> allPostingPeriods = new ArrayList<PostingPeriod>();
        Money periodStartingBalance = savingsAccountData.getStartInterestCalculationDate() != null && !savingsAccountData.getStartInterestCalculationDate().equals(savingsAccountData.getActivationLocalDate()) ? ((transaction = this.retrieveLastTransaction(savingsAccountData)) == null ? Money.zero((CurrencyData)savingsAccountData.getCurrency()) : Money.of((CurrencyData)savingsAccountData.getCurrency(), (BigDecimal)savingsAccountData.getSummary().getRunningBalanceOnPivotDate())) : Money.zero((CurrencyData)savingsAccountData.getCurrency());
        SavingsInterestCalculationType interestCalculationType = SavingsInterestCalculationType.fromInt((Integer)savingsAccountData.getInterestCalculationTypeId());
        BigDecimal interestRateAsFraction = this.getEffectiveInterestRateAsFraction(mc, upToInterestCalculationDate, savingsAccountData);
        BigDecimal overdraftInterestRateAsFraction = this.getEffectiveOverdraftInterestRateAsFraction(mc, savingsAccountData);
        Collection interestPostTransactions = this.savingsHelper.fetchPostInterestTransactionIds(savingsAccountData.getId());
        Money minBalanceForInterestCalculation = Money.of((CurrencyData)savingsAccountData.getCurrency(), (BigDecimal)this.minBalanceForInterestCalculation(savingsAccountData));
        Money minOverdraftForInterestCalculation = Money.of((CurrencyData)savingsAccountData.getCurrency(), (BigDecimal)savingsAccountData.getMinOverdraftForInterestCalculation());
        MonetaryCurrency monetaryCurrency = MonetaryCurrency.fromCurrencyData((CurrencyData)savingsAccountData.getCurrency());
        for (LocalDateInterval periodInterval : postingPeriodIntervals) {
            boolean isUserPosting = false;
            if (postedAsOnDates.contains(periodInterval.endDate().plusDays(1L))) {
                isUserPosting = true;
            }
            PostingPeriod postingPeriod = PostingPeriod.createFromDTO((LocalDateInterval)periodInterval, (Money)periodStartingBalance, (List)this.retreiveOrderedNonInterestPostingTransactions(savingsAccountData), (MonetaryCurrency)monetaryCurrency, (SavingsCompoundingInterestPeriodType)compoundingPeriodType, (SavingsInterestCalculationType)interestCalculationType, (BigDecimal)interestRateAsFraction, (long)daysInYearType.getValue().intValue(), (LocalDate)upToInterestCalculationDate, (Collection)interestPostTransactions, (boolean)isInterestTransfer, (Money)minBalanceForInterestCalculation, (boolean)isSavingsInterestPostingAtCurrentPeriodEnd, (BigDecimal)overdraftInterestRateAsFraction, (Money)minOverdraftForInterestCalculation, (boolean)isUserPosting, (int)financialYearBeginningMonth, (boolean)savingsAccountData.isAllowOverdraft());
            periodStartingBalance = postingPeriod.closingBalance();
            allPostingPeriods.add(postingPeriod);
        }
        this.savingsHelper.calculateInterestForAllPostingPeriods(monetaryCurrency, allPostingPeriods, this.getLockedInUntilLocalDate(savingsAccountData), Boolean.valueOf(false));
        savingsAccountData.getSummary().updateFromInterestPeriodSummaries(monetaryCurrency, allPostingPeriods);
        if (backdatedTxnsAllowedTill) {
            savingsAccountData.getSummary().updateSummaryWithPivotConfig(savingsAccountData.getCurrency(), savingsAccountData.getSavingsAccountTransactionSummaryWrapper(), null, savingsAccountData.getSavingsAccountTransactionData());
        } else {
            savingsAccountData.getSummary().updateSummary(savingsAccountData.getCurrency(), savingsAccountData.getSavingsAccountTransactionSummaryWrapper(), savingsAccountData.getSavingsAccountTransactionData());
        }
        return allPostingPeriods;
    }

    private List<SavingsAccountTransactionData> retreiveOrderedNonInterestPostingTransactions(SavingsAccountData savingsAccountData) {
        List listOfTransactionsSorted = this.retrieveListOfTransactions(savingsAccountData);
        ArrayList<SavingsAccountTransactionData> orderedNonInterestPostingTransactions = new ArrayList<SavingsAccountTransactionData>();
        for (SavingsAccountTransactionData transaction : listOfTransactionsSorted) {
            if (transaction.isInterestPostingAndNotReversed() || transaction.isOverdraftInterestAndNotReversed() || !transaction.isNotReversed() || transaction.isReversalTransaction()) continue;
            orderedNonInterestPostingTransactions.add(transaction);
        }
        orderedNonInterestPostingTransactions.sort((Comparator<SavingsAccountTransactionData>)new SavingsAccountTransactionDataComparator());
        return orderedNonInterestPostingTransactions;
    }

    private List<SavingsAccountTransactionData> retrieveListOfTransactions(SavingsAccountData savingsAccountData) {
        ArrayList<SavingsAccountTransactionData> listOfTransactionsSorted = new ArrayList<SavingsAccountTransactionData>();
        listOfTransactionsSorted.addAll(savingsAccountData.getSavingsAccountTransactionData());
        SavingsAccountTransactionDataComparator transactionComparator = new SavingsAccountTransactionDataComparator();
        Collections.sort(listOfTransactionsSorted, transactionComparator);
        return listOfTransactionsSorted;
    }

    protected LocalDate getLockedInUntilLocalDate(SavingsAccountData savingsAccount) {
        LocalDate lockedInUntilLocalDate = savingsAccount.getLockedInUntilDate();
        return lockedInUntilLocalDate == null ? savingsAccount.getActivationLocalDate() : lockedInUntilLocalDate;
    }

    private BigDecimal minBalanceForInterestCalculation(SavingsAccountData savingsAccountData) {
        return savingsAccountData.getMinBalanceForInterestCalculation();
    }

    private BigDecimal getEffectiveOverdraftInterestRateAsFraction(MathContext mc, SavingsAccountData savingsAccountData) {
        return savingsAccountData.getNominalAnnualInterestRateOverdraft() != null ? savingsAccountData.getNominalAnnualInterestRateOverdraft().divide(BigDecimal.valueOf(100L), mc) : BigDecimal.ZERO;
    }

    private BigDecimal getEffectiveInterestRateAsFraction(MathContext mc, LocalDate upToInterestCalculationDate, SavingsAccountData savingsAccountData) {
        return savingsAccountData.getNominalAnnualInterestRate().divide(BigDecimal.valueOf(100L), mc);
    }

    public List<SavingsAccountTransactionData> getTransactions(SavingsAccountData savingsAccountData) {
        return savingsAccountData.getSavingsAccountTransactionData();
    }

    private SavingsAccountTransactionData retrieveLastTransaction(@NotNull SavingsAccountData savingsAccountData) {
        List transactions = savingsAccountData.getSavingsAccountTransactionData();
        if (transactions == null || transactions.isEmpty()) {
            return savingsAccountData.getLastSavingsAccountTransaction();
        }
        if (transactions.size() == 1) {
            return (SavingsAccountTransactionData)transactions.get(0);
        }
        ArrayList listOfTransactionsSorted = new ArrayList(transactions);
        listOfTransactionsSorted.sort(new SavingsAccountTransactionDataComparator());
        return (SavingsAccountTransactionData)listOfTransactionsSorted.get(0);
    }

    public LocalDate getStartInterestCalculationDate(SavingsAccountData savingsAccountData) {
        LocalDate startInterestCalculationLocalDate = null;
        startInterestCalculationLocalDate = savingsAccountData.getStartInterestCalculationDate() != null ? savingsAccountData.getStartInterestCalculationDate() : this.getActivationLocalDate(savingsAccountData);
        return startInterestCalculationLocalDate;
    }

    public LocalDate getActivationLocalDate(SavingsAccountData savingsAccountData) {
        LocalDate activationLocalDate = null;
        if (savingsAccountData.getActivationLocalDate() != null) {
            activationLocalDate = savingsAccountData.getActivationLocalDate();
        }
        return activationLocalDate;
    }

    public List<LocalDate> getManualPostingDates(SavingsAccountData savingsAccountData) {
        ArrayList<LocalDate> transactions = new ArrayList<LocalDate>();
        for (SavingsAccountTransactionData trans : savingsAccountData.getSavingsAccountTransactionData()) {
            if (!trans.isInterestPosting() || !trans.isNotReversed() || trans.isReversalTransaction() || !trans.isManualTransaction()) continue;
            transactions.add(trans.getTransactionDate());
        }
        return transactions;
    }

    protected void recalculateDailyBalances(Money openingAccountBalance, LocalDate interestPostingUpToDate, boolean backdatedTxnsAllowedTill, SavingsAccountData savingsAccountData) {
        Money runningBalance = openingAccountBalance.copy();
        List accountTransactionsSorted = this.retrieveListOfTransactions(savingsAccountData);
        boolean isTransactionsModified = false;
        for (SavingsAccountTransactionData transaction : accountTransactionsSorted) {
            if (transaction.isReversed() || transaction.isReversalTransaction()) {
                transaction.zeroBalanceFields();
                continue;
            }
            Money overdraftAmount = Money.zero((CurrencyData)savingsAccountData.getCurrency());
            Money transactionAmount = Money.zero((CurrencyData)savingsAccountData.getCurrency());
            if (transaction.isCredit() || transaction.isAmountRelease()) {
                if (runningBalance.isLessThanZero()) {
                    Money diffAmount = Money.of((CurrencyData)savingsAccountData.getCurrency(), (BigDecimal)transaction.getAmount()).plus(runningBalance);
                    overdraftAmount = diffAmount.isGreaterThanZero() ? Money.of((CurrencyData)savingsAccountData.getCurrency(), (BigDecimal)transaction.getAmount()).minus(diffAmount) : Money.of((CurrencyData)savingsAccountData.getCurrency(), (BigDecimal)transaction.getAmount());
                }
                transactionAmount = transactionAmount.plus(transaction.getAmount());
            } else if (transaction.isDebit() || transaction.isAmountOnHold()) {
                if (runningBalance.isLessThanZero()) {
                    overdraftAmount = Money.of((CurrencyData)savingsAccountData.getCurrency(), (BigDecimal)transaction.getAmount());
                }
                transactionAmount = transactionAmount.minus(transaction.getAmount());
            }
            runningBalance = runningBalance.plus(transactionAmount);
            if (!transaction.getRunningBalance(transactionAmount.getCurrency()).isEqualTo(runningBalance)) {
                transaction.updateRunningBalance(runningBalance);
            }
            if (overdraftAmount.isZero() && runningBalance.isLessThanZero()) {
                overdraftAmount = overdraftAmount.plus(runningBalance.getAmount().negate());
            }
            if (transaction.getId() == null && overdraftAmount.isGreaterThanZero()) {
                transaction.updateOverdraftAmount(overdraftAmount.getAmount());
                continue;
            }
            if (!overdraftAmount.isNotEqualTo(Money.of((CurrencyData)savingsAccountData.getCurrency(), (BigDecimal)transaction.getOverdraftAmount()))) continue;
            SavingsAccountTransactionData accountTransaction = SavingsAccountTransactionData.copyTransaction((SavingsAccountTransactionData)transaction);
            if (transaction.isChargeTransaction()) {
                Set chargesPaidBy = transaction.getSavingsAccountChargesPaid();
                HashSet newChargePaidBy = new HashSet();
                chargesPaidBy.forEach(x -> newChargePaidBy.add(SavingsAccountChargesPaidByData.instance((Long)x.getChargeId(), (BigDecimal)x.getAmount())));
                accountTransaction.getSavingsAccountChargesPaid().addAll(newChargePaidBy);
            }
            transaction.reverse();
            if (overdraftAmount.isGreaterThanZero()) {
                accountTransaction.updateOverdraftAmount(overdraftAmount.getAmount());
            }
            accountTransaction.updateRunningBalance(runningBalance);
            this.addTransactionToExisting(accountTransaction, savingsAccountData);
            isTransactionsModified = true;
        }
        if (isTransactionsModified) {
            accountTransactionsSorted = this.retrieveListOfTransactions(savingsAccountData);
        }
        this.resetAccountTransactionsEndOfDayBalances(accountTransactionsSorted, interestPostingUpToDate, savingsAccountData);
    }

    public void addTransactionToExisting(SavingsAccountTransactionData transaction, SavingsAccountData savingsAccountData) {
        savingsAccountData.updateTransactions(transaction);
    }

    private List<SavingsAccountTransactionData> findWithHoldSavingsTransactionsWithPivotConfig(SavingsAccountData savingsAccountData) {
        ArrayList<SavingsAccountTransactionData> withholdTransactions = new ArrayList<SavingsAccountTransactionData>();
        List trans = savingsAccountData.getSavingsAccountTransactionData();
        for (SavingsAccountTransactionData transaction : trans) {
            if (!transaction.isWithHoldTaxAndNotReversed()) continue;
            withholdTransactions.add(transaction);
        }
        return withholdTransactions;
    }

    private boolean createWithHoldTransaction(BigDecimal amount, LocalDate date, SavingsAccountData savingsAccountData) {
        Map taxSplit;
        BigDecimal totalTax;
        boolean isTaxAdded = false;
        if (savingsAccountData.getTaxGroup() != null && savingsAccountData.getTaxGroup().getTaxAssociations() != null && amount.compareTo(BigDecimal.ZERO) > 0 && (totalTax = TaxUtils.totalTaxDataAmount((Map)(taxSplit = TaxUtils.splitTaxData((BigDecimal)amount, (LocalDate)date, savingsAccountData.getTaxGroup().getTaxAssociations().stream().collect(Collectors.toSet()), (int)amount.scale())))).compareTo(BigDecimal.ZERO) > 0) {
            SavingsAccountTransactionData withholdTransaction = SavingsAccountTransactionData.withHoldTax((SavingsAccountData)savingsAccountData, (LocalDate)date, (Money)Money.of((CurrencyData)savingsAccountData.getCurrency(), (BigDecimal)totalTax), (Map)taxSplit);
            savingsAccountData.getSavingsAccountTransactionData().add(withholdTransaction);
            isTaxAdded = true;
        }
        return isTaxAdded;
    }

    protected SavingsAccountTransactionData findInterestPostingTransactionFor(LocalDate postingDate, SavingsAccountData savingsAccountData) {
        SavingsAccountTransactionData postingTransation = null;
        List trans = savingsAccountData.getSavingsAccountTransactionData();
        for (SavingsAccountTransactionData transaction : trans) {
            if (!transaction.isInterestPostingAndNotReversed() && !transaction.isOverdraftInterestAndNotReversed() || !transaction.occursOn(postingDate) || transaction.isReversalTransaction()) continue;
            postingTransation = transaction;
            break;
        }
        return postingTransation;
    }

    protected void resetAccountTransactionsEndOfDayBalances(List<SavingsAccountTransactionData> accountTransactionsSorted, LocalDate interestPostingUpToDate, SavingsAccountData savingsAccountData) {
        LocalDate endOfBalanceDate = interestPostingUpToDate;
        for (int i = accountTransactionsSorted.size() - 1; i >= 0; --i) {
            SavingsAccountTransactionData transaction = accountTransactionsSorted.get(i);
            if (!transaction.isNotReversed() || transaction.isReversalTransaction() || transaction.isInterestPostingAndNotReversed() || transaction.isOverdraftInterestAndNotReversed()) continue;
            transaction.updateCumulativeBalanceAndDates(MonetaryCurrency.fromCurrencyData((CurrencyData)savingsAccountData.getCurrency()), endOfBalanceDate);
            endOfBalanceDate = transaction.getTransactionDate().minusDays(1L);
        }
    }

    private boolean isWithHoldTaxApplicableForInterestPosting(SavingsAccountData savingsAccountData) {
        return this.withHoldTax(savingsAccountData) && this.depositAccountType(savingsAccountData).isSavingsDeposit();
    }

    private boolean withHoldTax(SavingsAccountData savingsAccountData) {
        return savingsAccountData.isWithHoldTax();
    }

    public DepositAccountType depositAccountType(SavingsAccountData savingsAccountData) {
        return savingsAccountData.depositAccountType();
    }

    @Generated
    public SavingsAccountInterestPostingServiceImpl(SavingsHelper savingsHelper) {
        this.savingsHelper = savingsHelper;
    }
}

