/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.savings.service;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import jakarta.persistence.PersistenceException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.fineract.commands.domain.CommandWrapper;
import org.apache.fineract.commands.service.CommandProcessingService;
import org.apache.fineract.commands.service.CommandWrapperBuilder;
import org.apache.fineract.infrastructure.accountnumberformat.domain.AccountNumberFormat;
import org.apache.fineract.infrastructure.accountnumberformat.domain.AccountNumberFormatRepositoryWrapper;
import org.apache.fineract.infrastructure.accountnumberformat.domain.EntityAccountType;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResultBuilder;
import org.apache.fineract.infrastructure.core.data.DataValidatorBuilder;
import org.apache.fineract.infrastructure.core.exception.ErrorHandler;
import org.apache.fineract.infrastructure.core.exception.PlatformApiDataValidationException;
import org.apache.fineract.infrastructure.dataqueries.data.EntityTables;
import org.apache.fineract.infrastructure.dataqueries.data.StatusEnum;
import org.apache.fineract.infrastructure.dataqueries.service.EntityDatatableChecksWritePlatformService;
import org.apache.fineract.infrastructure.event.business.domain.BusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.savings.SavingsApproveBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.savings.SavingsCreateBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.savings.SavingsRejectBusinessEvent;
import org.apache.fineract.infrastructure.event.business.service.BusinessEventNotifierService;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.organisation.monetary.domain.Money;
import org.apache.fineract.organisation.staff.domain.Staff;
import org.apache.fineract.organisation.staff.domain.StaffRepositoryWrapper;
import org.apache.fineract.portfolio.account.service.AccountNumberGenerator;
import org.apache.fineract.portfolio.client.domain.Client;
import org.apache.fineract.portfolio.client.domain.ClientRepositoryWrapper;
import org.apache.fineract.portfolio.client.exception.ClientNotActiveException;
import org.apache.fineract.portfolio.group.domain.Group;
import org.apache.fineract.portfolio.group.domain.GroupRepository;
import org.apache.fineract.portfolio.group.domain.GroupRepositoryWrapper;
import org.apache.fineract.portfolio.group.exception.CenterNotActiveException;
import org.apache.fineract.portfolio.group.exception.GroupNotActiveException;
import org.apache.fineract.portfolio.group.exception.GroupNotFoundException;
import org.apache.fineract.portfolio.note.domain.Note;
import org.apache.fineract.portfolio.note.domain.NoteRepository;
import org.apache.fineract.portfolio.savings.data.SavingsAccountDataDTO;
import org.apache.fineract.portfolio.savings.data.SavingsAccountDataValidator;
import org.apache.fineract.portfolio.savings.domain.GSIMRepositoy;
import org.apache.fineract.portfolio.savings.domain.GroupSavingsIndividualMonitoring;
import org.apache.fineract.portfolio.savings.domain.SavingsAccount;
import org.apache.fineract.portfolio.savings.domain.SavingsAccountAssembler;
import org.apache.fineract.portfolio.savings.domain.SavingsAccountChargeAssembler;
import org.apache.fineract.portfolio.savings.domain.SavingsAccountRepositoryWrapper;
import org.apache.fineract.portfolio.savings.domain.SavingsAccountStatusType;
import org.apache.fineract.portfolio.savings.domain.SavingsProduct;
import org.apache.fineract.portfolio.savings.domain.SavingsProductRepository;
import org.apache.fineract.portfolio.savings.exception.SavingsProductNotFoundException;
import org.apache.fineract.portfolio.savings.service.GroupSavingsIndividualMonitoringWritePlatformService;
import org.apache.fineract.portfolio.savings.service.SavingsAccountApplicationTransitionApiJsonValidator;
import org.apache.fineract.portfolio.savings.service.SavingsAccountDomainService;
import org.apache.fineract.portfolio.savings.service.SavingsAccountWritePlatformService;
import org.apache.fineract.portfolio.savings.service.SavingsApplicationProcessWritePlatformService;
import org.apache.fineract.useradministration.domain.AppUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.transaction.annotation.Transactional;

public class SavingsApplicationProcessWritePlatformServiceJpaRepositoryImpl
implements SavingsApplicationProcessWritePlatformService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SavingsApplicationProcessWritePlatformServiceJpaRepositoryImpl.class);
    private final PlatformSecurityContext context;
    private final SavingsAccountRepositoryWrapper savingAccountRepository;
    private final SavingsAccountAssembler savingAccountAssembler;
    private final SavingsAccountDataValidator savingsAccountDataValidator;
    private final AccountNumberGenerator accountNumberGenerator;
    private final ClientRepositoryWrapper clientRepository;
    private final GroupRepository groupRepository;
    private final SavingsProductRepository savingsProductRepository;
    private final NoteRepository noteRepository;
    private final StaffRepositoryWrapper staffRepository;
    private final SavingsAccountApplicationTransitionApiJsonValidator savingsAccountApplicationTransitionApiJsonValidator;
    private final SavingsAccountChargeAssembler savingsAccountChargeAssembler;
    private final CommandProcessingService commandProcessingService;
    private final SavingsAccountDomainService savingsAccountDomainService;
    private final SavingsAccountWritePlatformService savingsAccountWritePlatformService;
    private final AccountNumberFormatRepositoryWrapper accountNumberFormatRepository;
    private final BusinessEventNotifierService businessEventNotifierService;
    private final EntityDatatableChecksWritePlatformService entityDatatableChecksWritePlatformService;
    private final GSIMRepositoy gsimRepository;
    private final GroupRepositoryWrapper groupRepositoryWrapper;
    private final GroupSavingsIndividualMonitoringWritePlatformService gsimWritePlatformService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public CommandProcessingResult submitGSIMApplication(JsonCommand command) {
        Object lock;
        CommandProcessingResult result = null;
        JsonArray gsimApplications = command.arrayOfParameterNamed("clientArray");
        Object object = lock = new Object();
        synchronized (object) {
            for (JsonElement gsimApplication : gsimApplications) {
                result = this.submitApplication(JsonCommand.fromExistingCommand((JsonCommand)command, (JsonElement)gsimApplication, (Long)gsimApplication.getAsJsonObject().get("clientId").getAsLong()));
            }
        }
        return result;
    }

    @Transactional
    public CommandProcessingResult submitApplication(JsonCommand command) {
        try {
            this.savingsAccountDataValidator.validateForSubmit(command.json());
            AppUser submittedBy = this.context.authenticatedUser();
            SavingsAccount account = this.savingAccountAssembler.assembleFrom(command, submittedBy);
            this.savingAccountRepository.save(account);
            Object accountNumber = "";
            GroupSavingsIndividualMonitoring gsimAccount = null;
            BigDecimal applicationId = BigDecimal.ZERO;
            Boolean isLastChildApplication = false;
            if (account.isAccountNumberRequiresAutoGeneration()) {
                AccountNumberFormat accountNumberFormat = this.accountNumberFormatRepository.findByAccountType(EntityAccountType.SAVINGS);
                if (account.getAccountTypes() == 5) {
                    Long groupId = command.longValueOfParameterNamed("groupId");
                    if (command.bigDecimalValueOfParameterNamedDefaultToNullIfZero("applicationId") != null) {
                        applicationId = command.bigDecimalValueOfParameterNamedDefaultToNullIfZero("applicationId");
                    }
                    if (command.booleanObjectValueOfParameterNamed("lastApplication") != null) {
                        isLastChildApplication = command.booleanPrimitiveValueOfParameterNamed("lastApplication");
                    }
                    Group group = this.groupRepositoryWrapper.findOneWithNotFoundDetection(groupId);
                    if (command.booleanObjectValueOfParameterNamed("isParentAccount") != null) {
                        if (this.gsimRepository.count() != 0L) {
                            accountNumber = this.accountNumberGenerator.generate(account, accountNumberFormat);
                            account.updateAccountNo((String)accountNumber + "1");
                            gsimAccount = this.gsimWritePlatformService.addGSIMAccountInfo((String)accountNumber, group, BigDecimal.ZERO, Long.valueOf(1L), Boolean.valueOf(true), SavingsAccountStatusType.SUBMITTED_AND_PENDING_APPROVAL.getValue(), applicationId);
                            account.setGsim(gsimAccount);
                            this.savingAccountRepository.saveAndFlush(account);
                        } else {
                            accountNumber = this.accountNumberGenerator.generate(account, accountNumberFormat);
                            account.updateAccountNo((String)accountNumber + "1");
                            this.gsimWritePlatformService.addGSIMAccountInfo((String)accountNumber, group, BigDecimal.ZERO, Long.valueOf(1L), Boolean.valueOf(true), SavingsAccountStatusType.SUBMITTED_AND_PENDING_APPROVAL.getValue(), applicationId);
                            account.setGsim(this.gsimRepository.findOneByAccountNumber((String)accountNumber));
                            this.savingAccountRepository.saveAndFlush(account);
                        }
                    } else {
                        if (this.gsimRepository.count() != 0L) {
                            gsimAccount = this.gsimRepository.findOneByIsAcceptingChildAndApplicationId(true, applicationId);
                            accountNumber = gsimAccount.getAccountNumber() + (gsimAccount.getChildAccountsCount() + 1L);
                            account.updateAccountNo((String)accountNumber);
                            this.gsimWritePlatformService.incrementChildAccountCount(gsimAccount);
                            account.setGsim(gsimAccount);
                            this.savingAccountRepository.saveAndFlush(account);
                        } else {
                            accountNumber = this.accountNumberGenerator.generate(account, accountNumberFormat);
                            account.updateAccountNo((String)accountNumber + "1");
                            this.gsimWritePlatformService.addGSIMAccountInfo((String)accountNumber, group, BigDecimal.ZERO, Long.valueOf(1L), Boolean.valueOf(true), SavingsAccountStatusType.SUBMITTED_AND_PENDING_APPROVAL.getValue(), applicationId);
                            account.setGsim(gsimAccount);
                            this.savingAccountRepository.saveAndFlush(account);
                        }
                        if (isLastChildApplication.booleanValue()) {
                            this.gsimWritePlatformService.resetIsAcceptingChild(this.gsimRepository.findOneByIsAcceptingChildAndApplicationId(true, applicationId));
                        }
                    }
                } else {
                    this.generateAccountNumber(account);
                }
            }
            Long savingsId = (Long)account.getId();
            if (command.parameterExists("datatables")) {
                this.entityDatatableChecksWritePlatformService.saveDatatables(StatusEnum.CREATE.getValue(), EntityTables.SAVINGS.getName(), savingsId, account.productId(), command.arrayOfParameterNamed("datatables"));
            }
            this.entityDatatableChecksWritePlatformService.runTheCheckForProduct(savingsId, EntityTables.SAVINGS.getName(), StatusEnum.CREATE.getValue(), EntityTables.SAVINGS.getForeignKeyColumnNameOnDatatable(), account.productId().longValue());
            this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new SavingsCreateBusinessEvent(account));
            return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId(savingsId).withOfficeId(account.officeId()).withClientId(account.clientId()).withGroupId(account.groupId()).withSavingsId(savingsId).withGsimId(Long.valueOf(gsimAccount == null ? 0L : (Long)gsimAccount.getId())).build();
        }
        catch (DataAccessException dve) {
            this.handleDataIntegrityIssues(command, dve.getMostSpecificCause(), (Exception)((Object)dve));
            return CommandProcessingResult.empty();
        }
        catch (PersistenceException dve) {
            Throwable throwable = ExceptionUtils.getRootCause((Throwable)dve.getCause());
            this.handleDataIntegrityIssues(command, throwable, (Exception)((Object)dve));
            return CommandProcessingResult.empty();
        }
    }

    private void generateAccountNumber(SavingsAccount account) {
        if (account.isAccountNumberRequiresAutoGeneration()) {
            AccountNumberFormat accountNumberFormat = this.accountNumberFormatRepository.findByAccountType(EntityAccountType.SAVINGS);
            account.updateAccountNo(this.accountNumberGenerator.generate(account, accountNumberFormat));
            this.savingAccountRepository.saveAndFlush(account);
        }
    }

    @Transactional
    public CommandProcessingResult modifyGSIMApplication(Long gsimId, JsonCommand command) {
        Long parentSavingId = gsimId;
        List childSavings = this.savingAccountRepository.findByGsimId(parentSavingId);
        CommandProcessingResult result = null;
        for (SavingsAccount account : childSavings) {
            result = this.modifyApplication((Long)account.getId(), command);
        }
        return result;
    }

    @Transactional
    public CommandProcessingResult modifyApplication(Long savingsId, JsonCommand command) {
        try {
            this.savingsAccountDataValidator.validateForUpdate(command.json());
            LinkedHashMap<String, String> changes = new LinkedHashMap<String, String>(20);
            SavingsAccount account = this.savingAccountAssembler.assembleFrom(savingsId, false);
            this.checkClientOrGroupActive(account);
            account.modifyApplication(command, changes);
            account.validateNewApplicationState("savingsaccount");
            account.validateAccountValuesWithProduct();
            if (!changes.isEmpty()) {
                Set charges;
                boolean updated;
                if (changes.containsKey("clientId")) {
                    Long clientId = command.longValueOfParameterNamed("clientId");
                    if (clientId != null) {
                        client = this.clientRepository.findOneWithNotFoundDetection(clientId);
                        if (client.isNotActive()) {
                            throw new ClientNotActiveException(clientId);
                        }
                        account.update(client);
                    } else {
                        client = null;
                        account.update(client);
                    }
                }
                if (changes.containsKey("groupId")) {
                    Long groupId = command.longValueOfParameterNamed("groupId");
                    if (groupId != null) {
                        group = (Group)this.groupRepository.findById((Object)groupId).orElseThrow(() -> new GroupNotFoundException(groupId));
                        if (group.isNotActive()) {
                            if (group.isCenter()) {
                                throw new CenterNotActiveException(groupId);
                            }
                            throw new GroupNotActiveException(groupId);
                        }
                        account.update(group);
                    } else {
                        group = null;
                        account.update(group);
                    }
                }
                if (changes.containsKey("productId")) {
                    Long productId = command.longValueOfParameterNamed("productId");
                    SavingsProduct product = (SavingsProduct)this.savingsProductRepository.findById((Object)productId).orElseThrow(() -> new SavingsProductNotFoundException(productId));
                    account.update(product);
                }
                if (changes.containsKey("fieldOfficerId")) {
                    Long fieldOfficerId = command.longValueOfParameterNamed("fieldOfficerId");
                    Staff fieldOfficer = null;
                    if (fieldOfficerId != null) {
                        fieldOfficer = this.staffRepository.findOneWithNotFoundDetection(fieldOfficerId);
                    } else {
                        changes.put("fieldOfficerId", "");
                    }
                    account.update(fieldOfficer);
                }
                if (changes.containsKey("charges") && !(updated = account.update(charges = this.savingsAccountChargeAssembler.fromParsedJson(command.parsedJson(), account.getCurrency().getCode())))) {
                    changes.remove("charges");
                }
                this.savingAccountRepository.saveAndFlush(account);
            }
            return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId(savingsId).withOfficeId(account.officeId()).withClientId(account.clientId()).withGroupId(account.groupId()).withSavingsId(savingsId).with(changes).build();
        }
        catch (DataAccessException dve) {
            this.handleDataIntegrityIssues(command, dve.getMostSpecificCause(), (Exception)((Object)dve));
            return CommandProcessingResult.resourceResult((Long)-1L);
        }
        catch (PersistenceException dve) {
            Throwable throwable = ExceptionUtils.getRootCause((Throwable)dve.getCause());
            this.handleDataIntegrityIssues(command, throwable, (Exception)((Object)dve));
            return CommandProcessingResult.empty();
        }
    }

    @Transactional
    public CommandProcessingResult deleteApplication(Long savingsId) {
        SavingsAccount account = this.savingAccountAssembler.assembleFrom(savingsId, false);
        this.checkClientOrGroupActive(account);
        if (account.isNotSubmittedAndPendingApproval()) {
            ArrayList dataValidationErrors = new ArrayList();
            DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("savingsaccount.delete");
            baseDataValidator.reset().parameter("activatedOnDate").failWithCodeNoParameterAddedToErrorCode("not.in.submittedandpendingapproval.state", new Object[0]);
            if (!dataValidationErrors.isEmpty()) {
                throw new PlatformApiDataValidationException(dataValidationErrors);
            }
        }
        List relatedNotes = this.noteRepository.findBySavingsAccount(account);
        this.noteRepository.deleteAllInBatch((Iterable)relatedNotes);
        this.savingAccountRepository.delete(account);
        return new CommandProcessingResultBuilder().withEntityId(savingsId).withOfficeId(account.officeId()).withClientId(account.clientId()).withGroupId(account.groupId()).withSavingsId(savingsId).build();
    }

    @Transactional
    public CommandProcessingResult approveGSIMApplication(Long gsimId, JsonCommand command) {
        Long parentSavingId = gsimId;
        GroupSavingsIndividualMonitoring parentSavings = (GroupSavingsIndividualMonitoring)this.gsimRepository.findById((Object)parentSavingId).orElseThrow();
        List childSavings = this.savingAccountRepository.findByGsimId(gsimId);
        CommandProcessingResult result = null;
        int count = 0;
        for (SavingsAccount account : childSavings) {
            result = this.approveApplication((Long)account.getId(), command);
            if (result == null || (long)(++count) != parentSavings.getChildAccountsCount()) continue;
            parentSavings.setSavingsStatus(SavingsAccountStatusType.APPROVED.getValue());
            this.gsimRepository.save((Object)parentSavings);
        }
        return result;
    }

    @Transactional
    public CommandProcessingResult approveApplication(Long savingsId, JsonCommand command) {
        AppUser currentUser = this.context.authenticatedUser();
        this.savingsAccountApplicationTransitionApiJsonValidator.validateApproval(command.json());
        SavingsAccount savingsAccount = this.savingAccountAssembler.assembleFrom(savingsId, false);
        this.checkClientOrGroupActive(savingsAccount);
        this.entityDatatableChecksWritePlatformService.runTheCheckForProduct(savingsId, EntityTables.SAVINGS.getName(), StatusEnum.APPROVE.getValue(), EntityTables.SAVINGS.getForeignKeyColumnNameOnDatatable(), savingsAccount.productId().longValue());
        Map changes = savingsAccount.approveApplication(currentUser, command);
        if (!changes.isEmpty()) {
            this.savingAccountRepository.save(savingsAccount);
            String noteText = command.stringValueOfParameterNamed("note");
            if (StringUtils.isNotBlank((CharSequence)noteText)) {
                Note note = Note.savingNote((SavingsAccount)savingsAccount, (String)noteText);
                changes.put("note", noteText);
                this.noteRepository.save((Object)note);
            }
        }
        this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new SavingsApproveBusinessEvent(savingsAccount));
        return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId(savingsId).withOfficeId(savingsAccount.officeId()).withClientId(savingsAccount.clientId()).withGroupId(savingsAccount.groupId()).withSavingsId(savingsId).with(changes).build();
    }

    @Transactional
    public CommandProcessingResult undoGSIMApplicationApproval(Long gsimId, JsonCommand command) {
        Long parentSavingId = gsimId;
        GroupSavingsIndividualMonitoring parentSavings = (GroupSavingsIndividualMonitoring)this.gsimRepository.findById((Object)parentSavingId).orElseThrow();
        List childSavings = this.savingAccountRepository.findByGsimId(gsimId);
        CommandProcessingResult result = null;
        int count = 0;
        for (SavingsAccount account : childSavings) {
            result = this.undoApplicationApproval((Long)account.getId(), command);
            if (result == null || (long)(++count) != parentSavings.getChildAccountsCount()) continue;
            parentSavings.setSavingsStatus(SavingsAccountStatusType.SUBMITTED_AND_PENDING_APPROVAL.getValue());
            this.gsimRepository.save((Object)parentSavings);
        }
        return result;
    }

    @Transactional
    public CommandProcessingResult undoApplicationApproval(Long savingsId, JsonCommand command) {
        this.context.authenticatedUser();
        this.savingsAccountApplicationTransitionApiJsonValidator.validateForUndo(command.json());
        SavingsAccount savingsAccount = this.savingAccountAssembler.assembleFrom(savingsId, false);
        this.checkClientOrGroupActive(savingsAccount);
        Map changes = savingsAccount.undoApplicationApproval();
        if (!changes.isEmpty()) {
            this.savingAccountRepository.save(savingsAccount);
            String noteText = command.stringValueOfParameterNamed("note");
            if (StringUtils.isNotBlank((CharSequence)noteText)) {
                Note note = Note.savingNote((SavingsAccount)savingsAccount, (String)noteText);
                changes.put("note", noteText);
                this.noteRepository.save((Object)note);
            }
        }
        return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId(savingsId).withOfficeId(savingsAccount.officeId()).withClientId(savingsAccount.clientId()).withGroupId(savingsAccount.groupId()).withSavingsId(savingsId).with(changes).build();
    }

    @Transactional
    public CommandProcessingResult rejectGSIMApplication(Long gsimId, JsonCommand command) {
        Long parentSavingId = gsimId;
        GroupSavingsIndividualMonitoring parentSavings = (GroupSavingsIndividualMonitoring)this.gsimRepository.findById((Object)parentSavingId).orElseThrow();
        List childSavings = this.savingAccountRepository.findByGsimId(gsimId);
        CommandProcessingResult result = null;
        int count = 0;
        for (SavingsAccount account : childSavings) {
            result = this.rejectApplication((Long)account.getId(), command);
            if (result == null || (long)(++count) != parentSavings.getChildAccountsCount()) continue;
            parentSavings.setSavingsStatus(SavingsAccountStatusType.REJECTED.getValue());
            this.gsimRepository.save((Object)parentSavings);
        }
        return result;
    }

    @Transactional
    public CommandProcessingResult rejectApplication(Long savingsId, JsonCommand command) {
        AppUser currentUser = this.context.authenticatedUser();
        this.savingsAccountApplicationTransitionApiJsonValidator.validateRejection(command.json());
        SavingsAccount savingsAccount = this.savingAccountAssembler.assembleFrom(savingsId, false);
        this.checkClientOrGroupActive(savingsAccount);
        this.entityDatatableChecksWritePlatformService.runTheCheckForProduct(savingsId, EntityTables.SAVINGS.getName(), StatusEnum.REJECTED.getValue(), EntityTables.SAVINGS.getForeignKeyColumnNameOnDatatable(), savingsAccount.productId().longValue());
        Map changes = savingsAccount.rejectApplication(currentUser, command);
        if (!changes.isEmpty()) {
            this.savingAccountRepository.save(savingsAccount);
            String noteText = command.stringValueOfParameterNamed("note");
            if (StringUtils.isNotBlank((CharSequence)noteText)) {
                Note note = Note.savingNote((SavingsAccount)savingsAccount, (String)noteText);
                changes.put("note", noteText);
                this.noteRepository.save((Object)note);
            }
        }
        this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new SavingsRejectBusinessEvent(savingsAccount));
        return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId(savingsId).withOfficeId(savingsAccount.officeId()).withClientId(savingsAccount.clientId()).withGroupId(savingsAccount.groupId()).withSavingsId(savingsId).with(changes).build();
    }

    @Transactional
    public CommandProcessingResult applicantWithdrawsFromApplication(Long savingsId, JsonCommand command) {
        AppUser currentUser = this.context.authenticatedUser();
        this.savingsAccountApplicationTransitionApiJsonValidator.validateApplicantWithdrawal(command.json());
        SavingsAccount savingsAccount = this.savingAccountAssembler.assembleFrom(savingsId, false);
        this.checkClientOrGroupActive(savingsAccount);
        this.entityDatatableChecksWritePlatformService.runTheCheckForProduct(savingsId, EntityTables.SAVINGS.getName(), StatusEnum.WITHDRAWN.getValue(), EntityTables.SAVINGS.getForeignKeyColumnNameOnDatatable(), savingsAccount.productId().longValue());
        Map changes = savingsAccount.applicantWithdrawsFromApplication(currentUser, command);
        if (!changes.isEmpty()) {
            this.savingAccountRepository.save(savingsAccount);
            String noteText = command.stringValueOfParameterNamed("note");
            if (StringUtils.isNotBlank((CharSequence)noteText)) {
                Note note = Note.savingNote((SavingsAccount)savingsAccount, (String)noteText);
                changes.put("note", noteText);
                this.noteRepository.save((Object)note);
            }
        }
        return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId(savingsId).withOfficeId(savingsAccount.officeId()).withClientId(savingsAccount.clientId()).withGroupId(savingsAccount.groupId()).withSavingsId(savingsId).with(changes).build();
    }

    private void checkClientOrGroupActive(SavingsAccount account) {
        Client client = account.getClient();
        if (client != null && client.isNotActive()) {
            throw new ClientNotActiveException((Long)client.getId());
        }
        Group group = account.group();
        if (group != null && group.isNotActive()) {
            if (group.isCenter()) {
                throw new CenterNotActiveException((Long)group.getId());
            }
            throw new GroupNotActiveException((Long)group.getId());
        }
    }

    public CommandProcessingResult createActiveApplication(SavingsAccountDataDTO savingsAccountDataDTO) {
        CommandWrapper commandWrapper = new CommandWrapperBuilder().savingsAccountActivation(null).build();
        boolean rollbackTransaction = this.commandProcessingService.validateRollbackCommand(commandWrapper, savingsAccountDataDTO.getAppliedBy());
        SavingsAccount account = this.savingAccountAssembler.assembleFrom(savingsAccountDataDTO.getClient(), savingsAccountDataDTO.getGroup(), savingsAccountDataDTO.getSavingsProduct(), savingsAccountDataDTO.getApplicationDate(), savingsAccountDataDTO.getAppliedBy());
        account.approveAndActivateApplication(savingsAccountDataDTO.getApplicationDate(), savingsAccountDataDTO.getAppliedBy());
        Money amountForDeposit = account.activateWithBalance();
        HashSet existingTransactionIds = new HashSet();
        HashSet existingReversedTransactionIds = new HashSet();
        if (amountForDeposit.isGreaterThanZero()) {
            this.savingAccountRepository.save(account);
        }
        this.savingsAccountWritePlatformService.processPostActiveActions(account, savingsAccountDataDTO.getFmt(), existingTransactionIds, existingReversedTransactionIds);
        this.savingAccountRepository.saveAndFlush(account);
        this.generateAccountNumber(account);
        this.savingsAccountDomainService.postJournalEntries(account, existingTransactionIds, existingReversedTransactionIds, false);
        return new CommandProcessingResultBuilder().withSavingsId((Long)account.getId()).setRollbackTransaction(rollbackTransaction).build();
    }

    private void handleDataIntegrityIssues(JsonCommand command, Throwable realCause, Exception dve) {
        Object[] msgArgs;
        Throwable checkEx;
        Object msgCode = "error.msg.savingsaccount";
        Object msg = "Unknown data integrity issue with savings account.";
        String param = null;
        Throwable throwable = checkEx = realCause == null ? dve : realCause;
        if (checkEx.getMessage().contains("sa_account_no_UNIQUE")) {
            String accountNo = command.stringValueOfParameterNamed("accountNo");
            msgCode = (String)msgCode + ".duplicate.accountNo";
            msg = "Savings account with accountNo " + accountNo + " already exists";
            param = "accountNo";
            msgArgs = new Object[]{accountNo, dve};
        } else if (checkEx.getMessage().contains("sa_externalid_UNIQUE")) {
            String externalId = command.stringValueOfParameterNamed("externalId");
            msgCode = (String)msgCode + ".duplicate.externalId";
            msg = "Savings account with externalId " + externalId + " already exists";
            param = "externalId";
            msgArgs = new Object[]{externalId, dve};
        } else {
            msgCode = (String)msgCode + ".unknown.data.integrity.issue";
            msgArgs = new Object[]{dve};
        }
        log.error("Error occured.", (Throwable)dve);
        throw ErrorHandler.getMappable((Throwable)dve, (String)msgCode, (String)msg, (String)param, (Object[])msgArgs);
    }

    @Generated
    public SavingsApplicationProcessWritePlatformServiceJpaRepositoryImpl(PlatformSecurityContext context, SavingsAccountRepositoryWrapper savingAccountRepository, SavingsAccountAssembler savingAccountAssembler, SavingsAccountDataValidator savingsAccountDataValidator, AccountNumberGenerator accountNumberGenerator, ClientRepositoryWrapper clientRepository, GroupRepository groupRepository, SavingsProductRepository savingsProductRepository, NoteRepository noteRepository, StaffRepositoryWrapper staffRepository, SavingsAccountApplicationTransitionApiJsonValidator savingsAccountApplicationTransitionApiJsonValidator, SavingsAccountChargeAssembler savingsAccountChargeAssembler, CommandProcessingService commandProcessingService, SavingsAccountDomainService savingsAccountDomainService, SavingsAccountWritePlatformService savingsAccountWritePlatformService, AccountNumberFormatRepositoryWrapper accountNumberFormatRepository, BusinessEventNotifierService businessEventNotifierService, EntityDatatableChecksWritePlatformService entityDatatableChecksWritePlatformService, GSIMRepositoy gsimRepository, GroupRepositoryWrapper groupRepositoryWrapper, GroupSavingsIndividualMonitoringWritePlatformService gsimWritePlatformService) {
        this.context = context;
        this.savingAccountRepository = savingAccountRepository;
        this.savingAccountAssembler = savingAccountAssembler;
        this.savingsAccountDataValidator = savingsAccountDataValidator;
        this.accountNumberGenerator = accountNumberGenerator;
        this.clientRepository = clientRepository;
        this.groupRepository = groupRepository;
        this.savingsProductRepository = savingsProductRepository;
        this.noteRepository = noteRepository;
        this.staffRepository = staffRepository;
        this.savingsAccountApplicationTransitionApiJsonValidator = savingsAccountApplicationTransitionApiJsonValidator;
        this.savingsAccountChargeAssembler = savingsAccountChargeAssembler;
        this.commandProcessingService = commandProcessingService;
        this.savingsAccountDomainService = savingsAccountDomainService;
        this.savingsAccountWritePlatformService = savingsAccountWritePlatformService;
        this.accountNumberFormatRepository = accountNumberFormatRepository;
        this.businessEventNotifierService = businessEventNotifierService;
        this.entityDatatableChecksWritePlatformService = entityDatatableChecksWritePlatformService;
        this.gsimRepository = gsimRepository;
        this.groupRepositoryWrapper = groupRepositoryWrapper;
        this.gsimWritePlatformService = gsimWritePlatformService;
    }
}

