/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.savings.service.search;

import com.google.gson.JsonObject;
import jakarta.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Predicate;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.infrastructure.core.service.MathUtil;
import org.apache.fineract.infrastructure.core.service.PagedLocalRequest;
import org.apache.fineract.infrastructure.core.service.database.DatabaseSpecificSQLGenerator;
import org.apache.fineract.infrastructure.core.service.database.SqlOperator;
import org.apache.fineract.infrastructure.dataqueries.data.DataTableValidator;
import org.apache.fineract.infrastructure.dataqueries.data.EntityTables;
import org.apache.fineract.infrastructure.dataqueries.data.ResultsetColumnHeaderData;
import org.apache.fineract.infrastructure.dataqueries.service.GenericDataService;
import org.apache.fineract.infrastructure.dataqueries.service.ReadWriteNonCoreDataService;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.portfolio.savings.SavingsAccountTransactionType;
import org.apache.fineract.portfolio.savings.data.SavingsAccountTransactionData;
import org.apache.fineract.portfolio.savings.service.SavingsAccountReadPlatformServiceImpl;
import org.apache.fineract.portfolio.savings.service.search.SavingsAccountTransactionSearchService;
import org.apache.fineract.portfolio.search.data.AdvancedQueryData;
import org.apache.fineract.portfolio.search.data.AdvancedQueryRequest;
import org.apache.fineract.portfolio.search.data.ColumnFilterData;
import org.apache.fineract.portfolio.search.data.TableQueryData;
import org.apache.fineract.portfolio.search.data.TransactionSearchRequest;
import org.apache.fineract.portfolio.search.service.SearchUtil;
import org.jetbrains.annotations.Nullable;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.support.PageableExecutionUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.transaction.annotation.Transactional;

/*
 * Exception performing whole class analysis ignored.
 */
@Transactional(readOnly=true)
public class SavingsAccountTransactionsSearchServiceImpl
implements SavingsAccountTransactionSearchService {
    private final PlatformSecurityContext context;
    private final GenericDataService genericDataService;
    private final DatabaseSpecificSQLGenerator sqlGenerator;
    private final ReadWriteNonCoreDataService datatableService;
    private final DataTableValidator dataTableValidator;
    private final JdbcTemplate jdbcTemplate;
    private final SearchUtil searchUtil;

    public Page<SavingsAccountTransactionData> searchTransactions(@NotNull Long savingsId, @NotNull TransactionSearchRequest searchParameters) {
        PageRequest sortPageable;
        this.context.authenticatedUser().validateHasReadPermission("savingsaccount");
        String apptable = EntityTables.SAVINGS_TRANSACTION.getApptableName();
        Map headersByName = this.searchUtil.mapHeadersToName((Collection)this.genericDataService.fillResultsetColumnHeaders(apptable));
        PageRequest pageable = searchParameters.getPageable();
        if (pageable.getSort().isSorted()) {
            List orders = pageable.getSort().toList();
            sortPageable = pageable.withSort(Sort.by(orders.stream().map(e -> e.withProperty(this.searchUtil.validateToJdbcColumnName(e.getProperty(), headersByName, false))).toList()));
        } else {
            sortPageable = pageable = pageable.withSort(Sort.Direction.DESC, new String[]{"transaction_date", "created_on_utc", "id"});
        }
        ArrayList<ColumnFilterData> columnFilters = new ArrayList<ColumnFilterData>();
        columnFilters.add(ColumnFilterData.eq((String)"savings_account_id", (String)savingsId.toString()));
        columnFilters.add(ColumnFilterData.eq((String)"is_reversal", (String)Boolean.FALSE.toString()));
        SavingsAccountTransactionsSearchServiceImpl.addFromToFilter((String)"transaction_date", (String)DateUtils.format((LocalDate)searchParameters.getFromDate()), (String)DateUtils.format((LocalDate)searchParameters.getToDate()), columnFilters);
        SavingsAccountTransactionsSearchServiceImpl.addFromToFilter((String)"submitted_on_date", (String)DateUtils.format((LocalDate)searchParameters.getFromSubmittedDate()), (String)DateUtils.format((LocalDate)searchParameters.getToSubmittedDate()), columnFilters);
        SavingsAccountTransactionsSearchServiceImpl.addFromToFilter((String)"amount", (String)MathUtil.formatToSql((BigDecimal)searchParameters.getFromAmount()), (String)MathUtil.formatToSql((BigDecimal)searchParameters.getToAmount()), columnFilters);
        Page emptyResult = PageableExecutionUtils.getPage(new ArrayList(0), (Pageable)pageable, () -> 0L);
        if (SavingsAccountTransactionsSearchServiceImpl.addTransactionTypesFilter((TransactionSearchRequest)searchParameters, columnFilters) == null) {
            return emptyResult;
        }
        String alias = "tr";
        StringBuilder where = new StringBuilder();
        ArrayList params = new ArrayList();
        this.searchUtil.buildQueryCondition(columnFilters, where, params, alias, headersByName, null, null, null, false, this.sqlGenerator);
        SavingsAccountReadPlatformServiceImpl.SavingsAccountTransactionsMapper tm = new SavingsAccountReadPlatformServiceImpl.SavingsAccountTransactionsMapper();
        Object[] args = params.toArray();
        String countQuery = "SELECT COUNT(*) " + tm.from() + String.valueOf(where);
        Integer totalElements = (Integer)this.jdbcTemplate.queryForObject(countQuery, Integer.class, args);
        if (totalElements == null || totalElements == 0) {
            return emptyResult;
        }
        StringBuilder query = new StringBuilder().append("SELECT ").append(tm.schema()).append((CharSequence)where);
        query.append(" ").append(this.sqlGenerator.buildOrderBy(sortPageable.getSort().toList(), alias, false));
        if (pageable.isPaged()) {
            query.append(" ").append(this.sqlGenerator.limit(pageable.getPageSize(), (int)pageable.getOffset()));
        }
        List results = this.jdbcTemplate.query(query.toString(), (RowMapper)tm, args);
        return PageableExecutionUtils.getPage((List)results, (Pageable)pageable, () -> totalElements.intValue());
    }

    private static void addFromToFilter(@NotNull String column, String fromValue, String toValue, @NotNull List<ColumnFilterData> columnFilters) {
        if (fromValue != null) {
            columnFilters.add(toValue == null ? ColumnFilterData.create((String)column, (SqlOperator)SqlOperator.GTE, (String[])new String[]{fromValue}) : ColumnFilterData.btw((String)column, (String)fromValue, (String)toValue));
        } else if (toValue != null) {
            columnFilters.add(ColumnFilterData.create((String)column, (SqlOperator)SqlOperator.LTE, (String[])new String[]{toValue}));
        }
    }

    @Nullable
    private static Boolean addTransactionTypesFilter(@NotNull TransactionSearchRequest searchParameters, List<ColumnFilterData> columnFilters) {
        Predicate<SavingsAccountTransactionType> filter = null;
        Boolean credit = searchParameters.getCredit();
        Boolean debit = searchParameters.getDebit();
        if (credit != null) {
            Predicate<SavingsAccountTransactionType> cf = SavingsAccountTransactionType::isCreditEntryType;
            Predicate<SavingsAccountTransactionType> predicate = filter = credit != false ? cf : Predicate.not(cf);
        }
        if (debit != null) {
            Predicate<SavingsAccountTransactionType> df = SavingsAccountTransactionType::isDebitEntryType;
            if (!debit.booleanValue()) {
                df = Predicate.not(df);
            }
            Predicate<SavingsAccountTransactionType> predicate = credit == null ? df : (filter = credit != false && debit != false ? filter.or(df) : filter.and(df));
        }
        if (searchParameters.getTypes() != null) {
            List<String> types = Arrays.asList(searchParameters.getTypes());
            Predicate<SavingsAccountTransactionType> tf = t -> types.contains(String.valueOf(t.getId()));
            Predicate<SavingsAccountTransactionType> predicate = filter = filter == null ? tf : filter.and(tf);
        }
        if (filter != null) {
            List filteredTypes = SavingsAccountTransactionType.getFiltered(filter = filter.and(SavingsAccountTransactionType::isValid));
            if (filteredTypes.isEmpty()) {
                return null;
            }
            String[] values = (String[])filteredTypes.stream().map(t -> String.valueOf(t.getId())).toArray(String[]::new);
            columnFilters.add(ColumnFilterData.create((String)"transaction_type_enum", (SqlOperator)SqlOperator.IN, (String[])values));
            return true;
        }
        return false;
    }

    public Page<JsonObject> queryAdvanced(@NotNull Long savingsId, @NotNull PagedLocalRequest<AdvancedQueryRequest> pagedRequest) {
        PageRequest sortPageable;
        PageRequest pageable;
        ArrayList<String> selectColumns;
        List<String> resultColumns;
        ArrayList<ColumnFilterData> columnFilters;
        this.context.authenticatedUser().validateHasReadPermission("savingsaccount");
        String apptable = EntityTables.SAVINGS_TRANSACTION.getApptableName();
        AdvancedQueryRequest queryRequest = (AdvancedQueryRequest)pagedRequest.getRequest().orElseThrow();
        this.dataTableValidator.validateTableSearch(queryRequest);
        List columnHeaders = this.genericDataService.fillResultsetColumnHeaders(apptable);
        Map headersByName = this.searchUtil.mapHeadersToName((Collection)columnHeaders);
        String pkColumn = this.searchUtil.getFiltered((Collection)columnHeaders, ResultsetColumnHeaderData::getIsColumnPrimaryKey).getColumnName();
        AdvancedQueryData baseQuery = queryRequest.getBaseQuery();
        List datatableQueries = queryRequest.getDatatableQueries();
        if (baseQuery == null) {
            columnFilters = new ArrayList<ColumnFilterData>();
            resultColumns = new ArrayList();
            selectColumns = new ArrayList<String>();
        } else {
            columnFilters = baseQuery.getNonNullFilters();
            columnFilters.forEach(e -> e.setColumn(this.searchUtil.validateToJdbcColumnName(e.getColumn(), headersByName, false)));
            resultColumns = baseQuery.getNonNullResultColumns();
            selectColumns = new ArrayList(this.searchUtil.validateToJdbcColumnNames(resultColumns, headersByName, true));
        }
        columnFilters.add(0, ColumnFilterData.eq((String)"savings_account_id", (String)savingsId.toString()));
        if (resultColumns.isEmpty() && !queryRequest.hasResultColumn()) {
            resultColumns.add(pkColumn);
            selectColumns.add(pkColumn);
        }
        if ((pageable = pagedRequest.toPageable()).getSort().isSorted()) {
            List orders = pageable.getSort().toList();
            sortPageable = pageable.withSort(Sort.by(orders.stream().map(e -> e.withProperty(this.searchUtil.validateToJdbcColumnName(e.getProperty(), headersByName, false))).toList()));
        } else {
            sortPageable = pageable = pageable.withSort(Sort.Direction.DESC, new String[]{pkColumn});
        }
        String alias = "main";
        String dateFormat = pagedRequest.getDateFormat();
        String dateTimeFormat = pagedRequest.getDateTimeFormat();
        Locale locale = pagedRequest.getLocaleObject();
        StringBuilder select = new StringBuilder(this.sqlGenerator.buildSelect(selectColumns, alias, false));
        StringBuilder from = new StringBuilder(" ").append(this.sqlGenerator.buildFrom(apptable, alias, false));
        StringBuilder where = new StringBuilder();
        ArrayList params = new ArrayList();
        this.searchUtil.buildQueryCondition(columnFilters, where, params, alias, headersByName, dateFormat, dateTimeFormat, locale, false, this.sqlGenerator);
        if (datatableQueries != null) {
            StringBuilder dataSelect = new StringBuilder();
            StringBuilder dataFrom = new StringBuilder();
            StringBuilder dataWhere = new StringBuilder();
            ArrayList dataParams = new ArrayList();
            for (int i = 0; i < datatableQueries.size(); ++i) {
                TableQueryData tableQuery = (TableQueryData)datatableQueries.get(i);
                boolean added = this.datatableService.buildDataQueryEmbedded(EntityTables.SAVINGS_TRANSACTION, tableQuery.getTable(), tableQuery.getQuery(), selectColumns, dataSelect, dataFrom, dataWhere, dataParams, alias, "d" + i, dateFormat, dateTimeFormat, locale);
                if (added) {
                    if (!dataSelect.isEmpty()) {
                        select.append(select.isEmpty() ? "SELECT " : ", ").append((CharSequence)dataSelect);
                    }
                    if (!dataFrom.isEmpty()) {
                        from.append(" ").append((CharSequence)dataFrom);
                    }
                    if (!dataWhere.isEmpty()) {
                        where.append(where.isEmpty() ? " WHERE " : " AND ").append((CharSequence)dataWhere);
                    }
                    params.addAll(dataParams);
                    dataSelect.setLength(0);
                    dataFrom.setLength(0);
                    dataWhere.setLength(0);
                    dataParams.clear();
                }
                resultColumns.addAll(tableQuery.getQuery().getNonNullResultColumns());
            }
        }
        ArrayList results = new ArrayList();
        Object[] args = params.toArray();
        String countQuery = "SELECT COUNT(*)" + String.valueOf(from) + String.valueOf(where);
        Integer totalElements = (Integer)this.jdbcTemplate.queryForObject(countQuery, Integer.class, args);
        if (totalElements == null || totalElements == 0) {
            return PageableExecutionUtils.getPage(results, (Pageable)pageable, () -> 0L);
        }
        StringBuilder query = new StringBuilder().append((CharSequence)select).append((CharSequence)from).append((CharSequence)where);
        query.append(" ").append(this.sqlGenerator.buildOrderBy(sortPageable.getSort().toList(), null, false));
        if (pageable.isPaged()) {
            query.append(" ").append(this.sqlGenerator.limit(pageable.getPageSize(), (int)pageable.getOffset()));
        }
        SqlRowSet rowSet = this.jdbcTemplate.queryForRowSet(query.toString(), args);
        while (rowSet.next()) {
            this.searchUtil.extractJsonResult(rowSet, selectColumns, resultColumns, results);
        }
        return PageableExecutionUtils.getPage(results, (Pageable)pageable, () -> totalElements.intValue());
    }

    @Generated
    public SavingsAccountTransactionsSearchServiceImpl(PlatformSecurityContext context, GenericDataService genericDataService, DatabaseSpecificSQLGenerator sqlGenerator, ReadWriteNonCoreDataService datatableService, DataTableValidator dataTableValidator, JdbcTemplate jdbcTemplate, SearchUtil searchUtil) {
        this.context = context;
        this.genericDataService = genericDataService;
        this.sqlGenerator = sqlGenerator;
        this.datatableService = datatableService;
        this.dataTableValidator = dataTableValidator;
        this.jdbcTemplate = jdbcTemplate;
        this.searchUtil = searchUtil;
    }
}

