/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.search.service;

import java.util.Collection;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.service.database.DatabaseSpecificSQLGenerator;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.organisation.office.service.OfficeReadPlatformService;
import org.apache.fineract.portfolio.loanproduct.service.LoanProductReadPlatformService;
import org.apache.fineract.portfolio.search.data.AdHocQuerySearchConditions;
import org.apache.fineract.portfolio.search.data.AdHocSearchQueryData;
import org.apache.fineract.portfolio.search.data.SearchConditions;
import org.apache.fineract.portfolio.search.data.SearchData;
import org.apache.fineract.portfolio.search.service.SearchReadPlatformService;
import org.apache.fineract.portfolio.search.service.SearchReadPlatformServiceImpl;
import org.apache.fineract.useradministration.domain.AppUser;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class SearchReadPlatformServiceImpl
implements SearchReadPlatformService {
    private final NamedParameterJdbcTemplate namedParameterJdbcTemplate;
    private final PlatformSecurityContext context;
    private final LoanProductReadPlatformService loanProductReadPlatformService;
    private final OfficeReadPlatformService officeReadPlatformService;
    private final DatabaseSpecificSQLGenerator sqlGenerator;

    public Collection<SearchData> retriveMatchingData(SearchConditions searchConditions) {
        AppUser currentUser = this.context.authenticatedUser();
        String hierarchy = currentUser.getOffice().getHierarchy();
        SearchMapper rm = new SearchMapper();
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("hierarchy", (Object)(hierarchy + "%"));
        if (searchConditions.getExactMatch().booleanValue()) {
            params.addValue("search", (Object)searchConditions.getSearchQuery());
        } else {
            params.addValue("search", (Object)("%" + searchConditions.getSearchQuery() + "%"));
        }
        return this.namedParameterJdbcTemplate.query(this.searchSchema(searchConditions), (SqlParameterSource)params, (RowMapper)rm);
    }

    public String searchSchema(SearchConditions searchConditions) {
        String union = " union ";
        String clientMatchSql = "( (select 'CLIENT' as entityType, c.id as entityId, c.display_name as entityName, c.external_id as entityExternalId, c.account_no as entityAccountNo  , c.office_id as parentId, o.name as parentName, c.mobile_no as entityMobileNo,c.status_enum as entityStatusEnum, null as subEntityType, null as parentType  from m_client c join m_office o on o.id = c.office_id where o.hierarchy like :hierarchy and (c.account_no like :search or c.display_name like :search or c.external_id like :search or c.mobile_no like :search))  order by c.id desc)";
        String loanMatchSql = "( (select 'LOAN' as entityType, l.id as entityId, pl.name as entityName, l.external_id as entityExternalId, l.account_no as entityAccountNo  , coalesce(c.id,g.id) as parentId, coalesce(c.display_name,g.display_name) as parentName, null as entityMobileNo, l.loan_status_id as entityStatusEnum, null as subEntityType, CASE WHEN g.id is null THEN 'client' ELSE 'group' END as parentType  from m_loan l left join m_client c on l.client_id = c.id left join m_group g ON l.group_id = g.id left join m_office o on o.id = c.office_id left join m_product_loan pl on pl.id=l.product_id where (o.hierarchy IS NULL OR o.hierarchy like :hierarchy) and (l.account_no like :search or l.external_id like :search))  order by l.id desc)";
        String savingMatchSql = "( (select 'SAVING' as entityType, s.id as entityId, sp.name as entityName, s.external_id as entityExternalId, s.account_no as entityAccountNo  , coalesce(c.id,g.id) as parentId, coalesce(c.display_name, g.display_name) as parentName, null as entityMobileNo, s.status_enum as entityStatusEnum, concat(s.deposit_type_enum, '') as subEntityType, CASE WHEN g.id is null THEN 'client' ELSE 'group' END as parentType  from m_savings_account s left join m_client c on s.client_id = c.id left join m_group g ON s.group_id = g.id left join m_office o on o.id = c.office_id left join m_savings_product sp on sp.id=s.product_id  where (o.hierarchy IS NULL OR o.hierarchy like :hierarchy) and (s.account_no like :search or s.external_id like :search))  order by s.id desc)";
        String shareMatchSql = "( (select 'SHARE' as entityType, s.id as entityId, sp.name as entityName, s.external_id as entityExternalId, s.account_no as entityAccountNo  , c.id as parentId, c.display_name as parentName, null as entityMobileNo, s.status_enum as entityStatusEnum, null as subEntityType, 'client' as parentType  from m_share_account s left join m_client c on s.client_id = c.id left join m_office o on o.id = c.office_id left join m_share_product sp on sp.id=s.product_id  where (o.hierarchy IS NULL OR o.hierarchy like :hierarchy) and (s.account_no like :search or s.external_id like :search))  order by s.id desc)";
        String clientIdentifierMatchSql = "( (select 'CLIENTIDENTIFIER' as entityType, ci.id as entityId, ci.document_key as entityName,  null as entityExternalId, null as entityAccountNo, c.id as parentId, c.display_name as parentName,null as entityMobileNo, c.status_enum as entityStatusEnum, null as subEntityType, null as parentType  from m_client_identifier ci join m_client c on ci.client_id=c.id join m_office o on o.id = c.office_id  where o.hierarchy like :hierarchy and ci.document_key like :search )  order by ci.id desc)";
        String groupMatchSql = "( (select CASE WHEN g.level_id=1 THEN 'CENTER' ELSE 'GROUP' END as entityType, g.id as entityId, g.display_name as entityName, g.external_id as entityExternalId, g.account_no as entityAccountNo,  g.office_id as parentId, o.name as parentName, null as entityMobileNo, g.status_enum as entityStatusEnum, null as subEntityType, null as parentType  from m_group g join m_office o on o.id = g.office_id where o.hierarchy like :hierarchy and (g.account_no like :search or g.display_name like :search or g.external_id like :search ))  order by g.id desc)";
        StringBuilder sql = new StringBuilder();
        if (searchConditions.isClientSearch().booleanValue()) {
            sql.append("( (select 'CLIENT' as entityType, c.id as entityId, c.display_name as entityName, c.external_id as entityExternalId, c.account_no as entityAccountNo  , c.office_id as parentId, o.name as parentName, c.mobile_no as entityMobileNo,c.status_enum as entityStatusEnum, null as subEntityType, null as parentType  from m_client c join m_office o on o.id = c.office_id where o.hierarchy like :hierarchy and (c.account_no like :search or c.display_name like :search or c.external_id like :search or c.mobile_no like :search))  order by c.id desc)").append(" union ");
        }
        if (searchConditions.isLoanSeach().booleanValue()) {
            sql.append("( (select 'LOAN' as entityType, l.id as entityId, pl.name as entityName, l.external_id as entityExternalId, l.account_no as entityAccountNo  , coalesce(c.id,g.id) as parentId, coalesce(c.display_name,g.display_name) as parentName, null as entityMobileNo, l.loan_status_id as entityStatusEnum, null as subEntityType, CASE WHEN g.id is null THEN 'client' ELSE 'group' END as parentType  from m_loan l left join m_client c on l.client_id = c.id left join m_group g ON l.group_id = g.id left join m_office o on o.id = c.office_id left join m_product_loan pl on pl.id=l.product_id where (o.hierarchy IS NULL OR o.hierarchy like :hierarchy) and (l.account_no like :search or l.external_id like :search))  order by l.id desc)").append(" union ");
        }
        if (searchConditions.isSavingSeach().booleanValue()) {
            sql.append("( (select 'SAVING' as entityType, s.id as entityId, sp.name as entityName, s.external_id as entityExternalId, s.account_no as entityAccountNo  , coalesce(c.id,g.id) as parentId, coalesce(c.display_name, g.display_name) as parentName, null as entityMobileNo, s.status_enum as entityStatusEnum, concat(s.deposit_type_enum, '') as subEntityType, CASE WHEN g.id is null THEN 'client' ELSE 'group' END as parentType  from m_savings_account s left join m_client c on s.client_id = c.id left join m_group g ON s.group_id = g.id left join m_office o on o.id = c.office_id left join m_savings_product sp on sp.id=s.product_id  where (o.hierarchy IS NULL OR o.hierarchy like :hierarchy) and (s.account_no like :search or s.external_id like :search))  order by s.id desc)").append(" union ");
        }
        if (searchConditions.isShareSeach().booleanValue()) {
            sql.append("( (select 'SHARE' as entityType, s.id as entityId, sp.name as entityName, s.external_id as entityExternalId, s.account_no as entityAccountNo  , c.id as parentId, c.display_name as parentName, null as entityMobileNo, s.status_enum as entityStatusEnum, null as subEntityType, 'client' as parentType  from m_share_account s left join m_client c on s.client_id = c.id left join m_office o on o.id = c.office_id left join m_share_product sp on sp.id=s.product_id  where (o.hierarchy IS NULL OR o.hierarchy like :hierarchy) and (s.account_no like :search or s.external_id like :search))  order by s.id desc)").append(" union ");
        }
        if (searchConditions.isClientIdentifierSearch().booleanValue()) {
            sql.append("( (select 'CLIENTIDENTIFIER' as entityType, ci.id as entityId, ci.document_key as entityName,  null as entityExternalId, null as entityAccountNo, c.id as parentId, c.display_name as parentName,null as entityMobileNo, c.status_enum as entityStatusEnum, null as subEntityType, null as parentType  from m_client_identifier ci join m_client c on ci.client_id=c.id join m_office o on o.id = c.office_id  where o.hierarchy like :hierarchy and ci.document_key like :search )  order by ci.id desc)").append(" union ");
        }
        if (searchConditions.isGroupSearch().booleanValue()) {
            sql.append("( (select CASE WHEN g.level_id=1 THEN 'CENTER' ELSE 'GROUP' END as entityType, g.id as entityId, g.display_name as entityName, g.external_id as entityExternalId, g.account_no as entityAccountNo,  g.office_id as parentId, o.name as parentName, null as entityMobileNo, g.status_enum as entityStatusEnum, null as subEntityType, null as parentType  from m_group g join m_office o on o.id = g.office_id where o.hierarchy like :hierarchy and (g.account_no like :search or g.display_name like :search or g.external_id like :search ))  order by g.id desc)").append(" union ");
        }
        sql.replace(sql.lastIndexOf(" union "), sql.length(), "");
        sql.append(" ").append(this.sqlGenerator.limit(50, 0));
        return sql.toString();
    }

    public AdHocSearchQueryData retrieveAdHocQueryTemplate() {
        this.context.authenticatedUser();
        Collection loanProducts = this.loanProductReadPlatformService.retrieveAllLoanProductsForLookup();
        Collection offices = this.officeReadPlatformService.retrieveAllOfficesForDropdown();
        return AdHocSearchQueryData.template((Collection)loanProducts, (Collection)offices);
    }

    public Collection<AdHocSearchQueryData> retrieveAdHocQueryMatchingData(AdHocQuerySearchConditions searchConditions) {
        this.context.authenticatedUser();
        AdHocQuerySearchMapper rm = new AdHocQuerySearchMapper();
        MapSqlParameterSource params = new MapSqlParameterSource();
        return this.namedParameterJdbcTemplate.query(rm.schema(searchConditions, params), (SqlParameterSource)params, (RowMapper)rm);
    }

    @Generated
    public SearchReadPlatformServiceImpl(NamedParameterJdbcTemplate namedParameterJdbcTemplate, PlatformSecurityContext context, LoanProductReadPlatformService loanProductReadPlatformService, OfficeReadPlatformService officeReadPlatformService, DatabaseSpecificSQLGenerator sqlGenerator) {
        this.namedParameterJdbcTemplate = namedParameterJdbcTemplate;
        this.context = context;
        this.loanProductReadPlatformService = loanProductReadPlatformService;
        this.officeReadPlatformService = officeReadPlatformService;
        this.sqlGenerator = sqlGenerator;
    }
}

