/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.self.account.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.apache.fineract.commands.domain.CommandWrapper;
import org.apache.fineract.commands.service.CommandWrapperBuilder;
import org.apache.fineract.commands.service.PortfolioCommandSourceWritePlatformService;
import org.apache.fineract.infrastructure.core.api.ApiRequestParameterHelper;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.EnumOptionData;
import org.apache.fineract.infrastructure.core.serialization.ApiRequestJsonSerializationSettings;
import org.apache.fineract.infrastructure.core.serialization.DefaultToApiJsonSerializer;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.portfolio.account.PortfolioAccountType;
import org.apache.fineract.portfolio.account.service.AccountTransferEnumerations;
import org.apache.fineract.portfolio.self.account.api.SelfBeneficiariesTPTApiResourceSwagger;
import org.apache.fineract.portfolio.self.account.data.SelfBeneficiariesTPTData;
import org.apache.fineract.portfolio.self.account.service.SelfBeneficiariesTPTReadPlatformService;
import org.springframework.stereotype.Component;

@Path(value="/v1/self/beneficiaries/tpt")
@Component
@Tag(name="Self Third Party Transfer", description="")
public class SelfBeneficiariesTPTApiResource {
    private final PlatformSecurityContext context;
    private final DefaultToApiJsonSerializer<SelfBeneficiariesTPTData> toApiJsonSerializer;
    private final PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService;
    private final ApiRequestParameterHelper apiRequestParameterHelper;
    private final SelfBeneficiariesTPTReadPlatformService readPlatformService;
    private static final Set<String> RESPONSE_DATA_PARAMETERS = new HashSet<String>(Arrays.asList("name", "officeName", "accountNumber", "accountType", "transferLimit", "id", "clientName", "accountTypeOptions"));

    @GET
    @Path(value="template")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Beneficiary Third Party Transfer Template", description="Returns Account Type enumerations. Self User is expected to know office name and account number to be able to add beneficiary.\n\nExample Requests:\n\n/self/beneficiaries/tpt/template")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=SelfBeneficiariesTPTApiResourceSwagger.GetSelfBeneficiariesTPTTemplateResponse.class))})})
    public String template(@Context UriInfo uriInfo) {
        EnumOptionData loanAccountType = AccountTransferEnumerations.accountType((PortfolioAccountType)PortfolioAccountType.LOAN);
        EnumOptionData savingsAccountType = AccountTransferEnumerations.accountType((PortfolioAccountType)PortfolioAccountType.SAVINGS);
        List<EnumOptionData> accountTypeOptions = Arrays.asList(savingsAccountType, loanAccountType);
        SelfBeneficiariesTPTData templateData = new SelfBeneficiariesTPTData(accountTypeOptions);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.toApiJsonSerializer.serialize(settings, (Object)templateData, RESPONSE_DATA_PARAMETERS);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Add TPT Beneficiary", description="Api to add third party beneficiary linked to current user.\n\nParameter Definitions\n\nname : Nick name for beneficiary, should be unique for an self service user\n\nofficeName : Office Name of beneficiary(not id)\n\naccountNumber : Account Number of beneficiary(not id)\n\ntransferLimit : Each transfer initiated to this account will not exceed this amount\n\nExample Requests:\n\n/self/beneficiaries/tpt\n\nMandatory Fields: name, officeName, accountNumber, accountType\n\nOptional Fields: transferLimit")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=SelfBeneficiariesTPTApiResourceSwagger.PostSelfBeneficiariesTPTRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=SelfBeneficiariesTPTApiResourceSwagger.PostSelfBeneficiariesTPTResponse.class))})})
    public String add(@Parameter(hidden=true) String apiRequestBodyAsJson) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().addSelfServiceBeneficiaryTPT().withJson(apiRequestBodyAsJson).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @PUT
    @Path(value="{beneficiaryId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Update TPT Beneficiary", description="Api to update third party beneficiary linked to current user.\n\nExample Requests:\n\n/self/beneficiaries/tpt/{beneficiaryId}\n\nOptional Fields: name, transferLimit")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=SelfBeneficiariesTPTApiResourceSwagger.PutSelfBeneficiariesTPTBeneficiaryIdRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=SelfBeneficiariesTPTApiResourceSwagger.PutSelfBeneficiariesTPTBeneficiaryIdResponse.class))})})
    public String update(@PathParam(value="beneficiaryId") @Parameter(description="beneficiaryId") Long beneficiaryId, @Parameter(hidden=true) String apiRequestBodyAsJson) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().updateSelfServiceBeneficiaryTPT(beneficiaryId).withJson(apiRequestBodyAsJson).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @DELETE
    @Path(value="{beneficiaryId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Delete TPT Beneficiary", description="Api to delete third party beneficiary linked to current user.\n\nExample Requests:\n\n/self/beneficiaries/tpt/{beneficiaryId}")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=SelfBeneficiariesTPTApiResourceSwagger.DeleteSelfBeneficiariesTPTBeneficiaryIdResponse.class))})})
    public String delete(@PathParam(value="beneficiaryId") Long beneficiaryId, @Parameter(hidden=true) String apiRequestBodyAsJson) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().deleteSelfServiceBeneficiaryTPT(beneficiaryId).withJson(apiRequestBodyAsJson).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Get All TPT Beneficiary", description="Api to get all third party beneficiary linked to current user.\n\nExample Requests:\n\n/self/beneficiaries/tpt")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(array=@ArraySchema(schema=@Schema(implementation=SelfBeneficiariesTPTApiResourceSwagger.GetSelfBeneficiariesTPTResponse.class)))})})
    public String retrieveAll(@Context UriInfo uriInfo) {
        this.context.authenticatedUser().validateHasReadPermission("SSBENEFICIARYTPT");
        Collection beneficiaries = this.readPlatformService.retrieveAll();
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.toApiJsonSerializer.serialize(settings, beneficiaries, RESPONSE_DATA_PARAMETERS);
    }

    @Generated
    public SelfBeneficiariesTPTApiResource(PlatformSecurityContext context, DefaultToApiJsonSerializer<SelfBeneficiariesTPTData> toApiJsonSerializer, PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService, ApiRequestParameterHelper apiRequestParameterHelper, SelfBeneficiariesTPTReadPlatformService readPlatformService) {
        this.context = context;
        this.toApiJsonSerializer = toApiJsonSerializer;
        this.commandsSourceWritePlatformService = commandsSourceWritePlatformService;
        this.apiRequestParameterHelper = apiRequestParameterHelper;
        this.readPlatformService = readPlatformService;
    }
}

