/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.self.account.domain;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import jakarta.persistence.UniqueConstraint;
import java.util.HashMap;
import java.util.Map;
import org.apache.fineract.infrastructure.core.domain.AbstractPersistableCustom;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;

@Entity
@Table(name="m_selfservice_beneficiaries_tpt", uniqueConstraints={@UniqueConstraint(columnNames={"name", "app_user_id", "is_active"}, name="name")})
public class SelfBeneficiariesTPT
extends AbstractPersistableCustom<Long>
implements PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    @Column(name="app_user_id", nullable=false)
    private Long appUserId;
    @Column(name="name", length=50, nullable=false)
    private String name;
    @Column(name="office_id", nullable=false)
    private Long officeId;
    @Column(name="client_id", nullable=false)
    private Long clientId;
    @Column(name="account_id", nullable=false)
    private Long accountId;
    @Column(name="account_type", nullable=false)
    private Integer accountType;
    @Column(name="transfer_limit", nullable=true)
    private Long transferLimit;
    @Column(name="is_active", nullable=false)
    private boolean isActive = true;
    static final long serialVersionUID = -3677656179188530352L;

    protected SelfBeneficiariesTPT() {
    }

    public SelfBeneficiariesTPT(Long appUserId, String name, Long officeId, Long clientId, Long accountId, Integer accountType, Long transferLimit) {
        this.appUserId = appUserId;
        this.name = name;
        this.officeId = officeId;
        this.clientId = clientId;
        this.accountId = accountId;
        this.accountType = accountType;
        this.transferLimit = transferLimit;
    }

    public String getName() {
        return this._persistence_get_name();
    }

    public void setName(String name) {
        this._persistence_set_name(name);
    }

    public Long getTransferLimit() {
        return this._persistence_get_transferLimit();
    }

    public void setTransferLimit(Long transferLimit) {
        this._persistence_set_transferLimit(transferLimit);
    }

    public boolean isActive() {
        return this._persistence_get_isActive();
    }

    public void setActive(boolean isActive) {
        this._persistence_set_isActive(isActive);
    }

    public Long getAppUserId() {
        return this._persistence_get_appUserId();
    }

    public Long getOfficeId() {
        return this._persistence_get_officeId();
    }

    public Long getClientId() {
        return this._persistence_get_clientId();
    }

    public Long getAccountId() {
        return this._persistence_get_accountId();
    }

    public Integer getAccountType() {
        return this._persistence_get_accountType();
    }

    public Map<String, Object> update(String newName, Long newTransferLimit) {
        HashMap<String, Object> changes = new HashMap<String, Object>();
        if (!this._persistence_get_name().equals(newName)) {
            this._persistence_set_name(newName);
            changes.put("name", newName);
        }
        if (this._persistence_get_transferLimit() != null && !this._persistence_get_transferLimit().equals(newTransferLimit) || this._persistence_get_transferLimit() == null && newTransferLimit != null) {
            this._persistence_set_transferLimit(newTransferLimit);
            changes.put("transferLimit", newTransferLimit);
        }
        return changes;
    }

    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new SelfBeneficiariesTPT();
    }

    public Object _persistence_get(String string) {
        if (string == "accountId") {
            return this.accountId;
        }
        if (string == "clientId") {
            return this.clientId;
        }
        if (string == "transferLimit") {
            return this.transferLimit;
        }
        if (string == "officeId") {
            return this.officeId;
        }
        if (string == "accountType") {
            return this.accountType;
        }
        if (string == "name") {
            return this.name;
        }
        if (string == "appUserId") {
            return this.appUserId;
        }
        if (string == "isActive") {
            return this.isActive;
        }
        return super._persistence_get(string);
    }

    public void _persistence_set(String string, Object object) {
        if (string == "accountId") {
            this.accountId = (Long)object;
            return;
        }
        if (string == "clientId") {
            this.clientId = (Long)object;
            return;
        }
        if (string == "transferLimit") {
            this.transferLimit = (Long)object;
            return;
        }
        if (string == "officeId") {
            this.officeId = (Long)object;
            return;
        }
        if (string == "accountType") {
            this.accountType = (Integer)object;
            return;
        }
        if (string == "name") {
            this.name = (String)object;
            return;
        }
        if (string == "appUserId") {
            this.appUserId = (Long)object;
            return;
        }
        if (string == "isActive") {
            this.isActive = (Boolean)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public Long _persistence_get_accountId() {
        this._persistence_checkFetched("accountId");
        return this.accountId;
    }

    public void _persistence_set_accountId(Long l) {
        this._persistence_checkFetchedForSet("accountId");
        this._persistence_propertyChange("accountId", (Object)this.accountId, (Object)l);
        this.accountId = l;
    }

    public Long _persistence_get_clientId() {
        this._persistence_checkFetched("clientId");
        return this.clientId;
    }

    public void _persistence_set_clientId(Long l) {
        this._persistence_checkFetchedForSet("clientId");
        this._persistence_propertyChange("clientId", (Object)this.clientId, (Object)l);
        this.clientId = l;
    }

    public Long _persistence_get_transferLimit() {
        this._persistence_checkFetched("transferLimit");
        return this.transferLimit;
    }

    public void _persistence_set_transferLimit(Long l) {
        this._persistence_checkFetchedForSet("transferLimit");
        this._persistence_propertyChange("transferLimit", (Object)this.transferLimit, (Object)l);
        this.transferLimit = l;
    }

    public Long _persistence_get_officeId() {
        this._persistence_checkFetched("officeId");
        return this.officeId;
    }

    public void _persistence_set_officeId(Long l) {
        this._persistence_checkFetchedForSet("officeId");
        this._persistence_propertyChange("officeId", (Object)this.officeId, (Object)l);
        this.officeId = l;
    }

    public Integer _persistence_get_accountType() {
        this._persistence_checkFetched("accountType");
        return this.accountType;
    }

    public void _persistence_set_accountType(Integer n) {
        this._persistence_checkFetchedForSet("accountType");
        this._persistence_propertyChange("accountType", (Object)this.accountType, (Object)n);
        this.accountType = n;
    }

    public String _persistence_get_name() {
        this._persistence_checkFetched("name");
        return this.name;
    }

    public void _persistence_set_name(String string) {
        this._persistence_checkFetchedForSet("name");
        this._persistence_propertyChange("name", (Object)this.name, (Object)string);
        this.name = string;
    }

    public Long _persistence_get_appUserId() {
        this._persistence_checkFetched("appUserId");
        return this.appUserId;
    }

    public void _persistence_set_appUserId(Long l) {
        this._persistence_checkFetchedForSet("appUserId");
        this._persistence_propertyChange("appUserId", (Object)this.appUserId, (Object)l);
        this.appUserId = l;
    }

    public boolean _persistence_get_isActive() {
        this._persistence_checkFetched("isActive");
        return this.isActive;
    }

    public void _persistence_set_isActive(boolean bl) {
        this._persistence_checkFetchedForSet("isActive");
        this._persistence_propertyChange("isActive", (Object)new Boolean(this.isActive), (Object)new Boolean(bl));
        this.isActive = bl;
    }
}

