/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.self.products.api;

import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import lombok.Generated;
import org.apache.fineract.portfolio.savings.api.SavingsProductsApiResource;
import org.apache.fineract.portfolio.self.client.service.AppuserClientMapperReadService;
import org.springframework.stereotype.Component;

@Path(value="/v1/self/savingsproducts")
@Component
@Tag(name="Self Savings Products", description="")
public class SelfSavingsProductsApiResource {
    private final SavingsProductsApiResource savingsProductsApiResource;
    private final AppuserClientMapperReadService appUserClientMapperReadService;

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String retrieveAll(@QueryParam(value="clientId") Long clientId, @Context UriInfo uriInfo) {
        this.appUserClientMapperReadService.validateAppuserClientsMapping(clientId);
        return this.savingsProductsApiResource.retrieveAll(uriInfo);
    }

    @GET
    @Path(value="{productId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String retrieveOne(@PathParam(value="productId") Long productId, @QueryParam(value="clientId") Long clientId, @Context UriInfo uriInfo) {
        this.appUserClientMapperReadService.validateAppuserClientsMapping(clientId);
        return this.savingsProductsApiResource.retrieveOne(productId, uriInfo);
    }

    @Generated
    public SelfSavingsProductsApiResource(SavingsProductsApiResource savingsProductsApiResource, AppuserClientMapperReadService appUserClientMapperReadService) {
        this.savingsProductsApiResource = savingsProductsApiResource;
        this.appUserClientMapperReadService = appUserClientMapperReadService;
    }
}

