/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.self.products.api;

import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import lombok.Generated;
import org.apache.fineract.portfolio.products.api.ProductsApiResource;
import org.apache.fineract.portfolio.self.client.service.AppuserClientMapperReadService;
import org.springframework.stereotype.Component;

@Path(value="/v1/self/products/share")
@Component
@Tag(name="Self Share Products", description="")
public class SelfShareProductsApiResource {
    private final ProductsApiResource productsApiResource;
    private final AppuserClientMapperReadService appUserClientMapperReadService;

    @GET
    @Path(value="{productId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String retrieveProduct(@QueryParam(value="clientId") Long clientId, @PathParam(value="productId") Long productId, @PathParam(value="type") String productType, @Context UriInfo uriInfo) {
        this.appUserClientMapperReadService.validateAppuserClientsMapping(clientId);
        return this.productsApiResource.retrieveProduct(productId, "share", uriInfo);
    }

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String retrieveAllProducts(@QueryParam(value="clientId") Long clientId, @QueryParam(value="offset") Integer offset, @QueryParam(value="limit") Integer limit, @Context UriInfo uriInfo) {
        this.appUserClientMapperReadService.validateAppuserClientsMapping(clientId);
        return this.productsApiResource.retrieveAllProducts("share", offset, limit, uriInfo);
    }

    @Generated
    public SelfShareProductsApiResource(ProductsApiResource productsApiResource, AppuserClientMapperReadService appUserClientMapperReadService) {
        this.productsApiResource = productsApiResource;
        this.appUserClientMapperReadService = appUserClientMapperReadService;
    }
}

