/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.self.security.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import lombok.Generated;
import org.apache.fineract.infrastructure.security.api.AuthenticationApiResource;
import org.apache.fineract.infrastructure.security.api.AuthenticationApiResourceSwagger;
import org.apache.fineract.portfolio.self.security.api.SelfAuthenticationApiResourceSwagger;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(value={"fineract.security.basicauth.enabled"})
@Path(value="/v1/self/authentication")
@Tag(name="Self Authentication", description="Authenticates the credentials provided and returns the set roles and permissions allowed")
public class SelfAuthenticationApiResource {
    private final AuthenticationApiResource authenticationApiResource;

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Verify authentication", description="Authenticates the credentials provided and returns the set roles and permissions allowed.\n\nPlease visit this link for more info - https://fineract.apache.org/legacy-docs/apiLive.htm#selfbasicauth")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=AuthenticationApiResourceSwagger.PostAuthenticationRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=SelfAuthenticationApiResourceSwagger.PostSelfAuthenticationResponse.class))})})
    public String authenticate(String apiRequestBodyAsJson) {
        return this.authenticationApiResource.authenticate(apiRequestBodyAsJson, true);
    }

    @Generated
    public SelfAuthenticationApiResource(AuthenticationApiResource authenticationApiResource) {
        this.authenticationApiResource = authenticationApiResource;
    }
}

