/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.self.security.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.infrastructure.core.exception.InvalidJsonException;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.portfolio.self.security.api.SelfUserApiResourceSwagger;
import org.apache.fineract.useradministration.api.UsersApiResource;
import org.apache.fineract.useradministration.domain.AppUser;
import org.springframework.stereotype.Component;

@Path(value="/v1/self/user")
@Component
@Tag(name="Self User", description="")
public class SelfUserApiResource {
    private final UsersApiResource usersApiResource;
    private final PlatformSecurityContext context;
    private final FromJsonHelper fromApiJsonHelper;
    private static final Set<String> SUPPORTED_PARAMETERS = new HashSet<String>(Arrays.asList("password", "repeatPassword"));

    @PUT
    @Operation(summary="Update User", description="This API can be used by Self Service user to update their own user information. Currently, \"password\" and \"repeatPassword\" are the only parameters accepted.")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=SelfUserApiResourceSwagger.PutSelfUserRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=SelfUserApiResourceSwagger.PutSelfUserResponse.class))})})
    public String update(@Parameter(hidden=true) String apiRequestBodyAsJson) {
        if (StringUtils.isBlank((CharSequence)apiRequestBodyAsJson)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, apiRequestBodyAsJson, (Collection)SUPPORTED_PARAMETERS);
        AppUser appUser = this.context.authenticatedUser();
        return this.usersApiResource.update((Long)appUser.getId(), apiRequestBodyAsJson);
    }

    @Generated
    public SelfUserApiResource(UsersApiResource usersApiResource, PlatformSecurityContext context, FromJsonHelper fromApiJsonHelper) {
        this.usersApiResource = usersApiResource;
        this.context = context;
        this.fromApiJsonHelper = fromApiJsonHelper;
    }
}

