/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.self.shareaccounts.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.api.ApiRequestParameterHelper;
import org.apache.fineract.infrastructure.core.serialization.ApiRequestJsonSerializationSettings;
import org.apache.fineract.infrastructure.core.serialization.DefaultToApiJsonSerializer;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.portfolio.accounts.api.AccountsApiResource;
import org.apache.fineract.portfolio.accounts.data.AccountData;
import org.apache.fineract.portfolio.accounts.exceptions.ShareAccountNotFoundException;
import org.apache.fineract.portfolio.charge.service.ChargeReadPlatformService;
import org.apache.fineract.portfolio.client.exception.ClientNotFoundException;
import org.apache.fineract.portfolio.products.data.ProductData;
import org.apache.fineract.portfolio.products.service.ShareProductReadPlatformService;
import org.apache.fineract.portfolio.self.client.service.AppuserClientMapperReadService;
import org.apache.fineract.portfolio.self.shareaccounts.api.SelfShareAccountsApiResourceSwagger;
import org.apache.fineract.portfolio.self.shareaccounts.data.SelfShareAccountsDataValidator;
import org.apache.fineract.portfolio.self.shareaccounts.service.AppUserShareAccountsMapperReadPlatformService;
import org.apache.fineract.portfolio.shareaccounts.data.ShareAccountData;
import org.apache.fineract.portfolio.shareaccounts.service.ShareAccountReadPlatformService;
import org.apache.fineract.useradministration.domain.AppUser;
import org.springframework.stereotype.Component;

@Path(value="/v1/self/shareaccounts")
@Component
@Tag(name="Self Share Accounts", description="")
public class SelfShareAccountsApiResource {
    private final PlatformSecurityContext context;
    private final AccountsApiResource accountsApiResource;
    private final ShareAccountReadPlatformService readPlatformService;
    private final ApiRequestParameterHelper apiRequestParameterHelper;
    private final DefaultToApiJsonSerializer<AccountData> toApiJsonSerializer;
    private final AppuserClientMapperReadService appuserClientMapperReadService;
    private final SelfShareAccountsDataValidator selfShareAccountsDataValidator;
    private final ShareProductReadPlatformService shareProductReadPlatformService;
    private final ChargeReadPlatformService chargeReadPlatformService;
    private final AppUserShareAccountsMapperReadPlatformService appUserShareAccountsMapperReadPlatformService;

    @GET
    @Path(value="template")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve Share Account Template", description="This is a convenience resource. It can be useful when building maintenance user interface screens for client applications. The template data returned consists of any or all of:\nField Defaults\n\nAllowed Value Lists\n\n\nArguments\n\nclientId:Integer mandatory\nproductId:Integer optionalIf entered, productId, productName and selectedProduct fields are returned.\nExample Requests:\n\nself/shareaccounts/template?clientId=14\n\nself/shareaccounts/template?clientId=14&productId=3\n")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(array=@ArraySchema(schema=@Schema(implementation=SelfShareAccountsApiResourceSwagger.GetShareAccountsClientIdProductIdResponse.class)))})})
    public String template(@QueryParam(value="clientId") @Parameter(name="clientId") Long clientId, @QueryParam(value="productId") @Parameter(name="productId") Long productId, @Context UriInfo uriInfo) {
        this.validateAppuserClientsMapping(clientId);
        Collection<Object> productOptions = new ArrayList<ProductData>();
        if (productId != null) {
            boolean includeTemplate = true;
            productOptions.add(this.shareProductReadPlatformService.retrieveOne(productId, true));
        } else {
            productOptions = this.shareProductReadPlatformService.retrieveAllForLookup();
        }
        String clientName = null;
        Collection chargeOptions = this.chargeReadPlatformService.retrieveSharesApplicableCharges();
        ShareAccountData accountData = new ShareAccountData(clientId, clientName, productOptions, chargeOptions);
        return this.toApiJsonSerializer.serialize((Object)accountData);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Submit new share application", description="Mandatory fields:\n\nclientId, productId, submittedDate, savingsAccountId, requestedShares, applicationDate\n\n\nOptional Fields\n\naccountNo, externalId\n\n\nInherited from Product (if not provided)\n\nminimumActivePeriod, minimumActivePeriodFrequencyType, lockinPeriodFrequency, lockinPeriodFrequencyType.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(array=@ArraySchema(schema=@Schema(implementation=SelfShareAccountsApiResourceSwagger.PostNewShareApplicationResponse.class)))})})
    public String createAccount(String apiRequestBodyAsJson) {
        HashMap attr = this.selfShareAccountsDataValidator.validateShareAccountApplication(apiRequestBodyAsJson);
        Long clientId = (Long)attr.get("clientId");
        this.validateAppuserClientsMapping(clientId);
        String accountType = "share";
        return this.accountsApiResource.createAccount(accountType, apiRequestBodyAsJson);
    }

    @GET
    @Path(value="{accountId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve a share application/account", description="\n\n\nExample Requests:\n\nself/shareaccounts/12\n")
    public String retrieveShareAccount(@PathParam(value="accountId") Long accountId, @Context UriInfo uriInfo) {
        this.validateAppuserShareAccountMapping(accountId);
        boolean includeTemplate = false;
        ShareAccountData accountData = this.readPlatformService.retrieveOne(accountId, false);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.toApiJsonSerializer.serialize(settings, (Object)accountData, this.readPlatformService.getResponseDataParams());
    }

    private void validateAppuserShareAccountMapping(Long accountId) {
        AppUser user = this.context.authenticatedUser();
        boolean isMapped = this.appUserShareAccountsMapperReadPlatformService.isShareAccountsMappedToUser(accountId, (Long)user.getId());
        if (!isMapped) {
            throw new ShareAccountNotFoundException(accountId);
        }
    }

    private void validateAppuserClientsMapping(Long clientId) {
        AppUser user = this.context.authenticatedUser();
        boolean mappedClientId = this.appuserClientMapperReadService.isClientMappedToUser(clientId, (Long)user.getId());
        if (!mappedClientId) {
            throw new ClientNotFoundException(clientId);
        }
    }

    @Generated
    public SelfShareAccountsApiResource(PlatformSecurityContext context, AccountsApiResource accountsApiResource, ShareAccountReadPlatformService readPlatformService, ApiRequestParameterHelper apiRequestParameterHelper, DefaultToApiJsonSerializer<AccountData> toApiJsonSerializer, AppuserClientMapperReadService appuserClientMapperReadService, SelfShareAccountsDataValidator selfShareAccountsDataValidator, ShareProductReadPlatformService shareProductReadPlatformService, ChargeReadPlatformService chargeReadPlatformService, AppUserShareAccountsMapperReadPlatformService appUserShareAccountsMapperReadPlatformService) {
        this.context = context;
        this.accountsApiResource = accountsApiResource;
        this.readPlatformService = readPlatformService;
        this.apiRequestParameterHelper = apiRequestParameterHelper;
        this.toApiJsonSerializer = toApiJsonSerializer;
        this.appuserClientMapperReadService = appuserClientMapperReadService;
        this.selfShareAccountsDataValidator = selfShareAccountsDataValidator;
        this.shareProductReadPlatformService = shareProductReadPlatformService;
        this.chargeReadPlatformService = chargeReadPlatformService;
        this.appUserShareAccountsMapperReadPlatformService = appUserShareAccountsMapperReadPlatformService;
    }
}

