/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.shareaccounts.domain;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import java.math.BigDecimal;
import java.math.MathContext;
import org.apache.fineract.infrastructure.core.domain.AbstractPersistableCustom;
import org.apache.fineract.organisation.monetary.domain.MonetaryCurrency;
import org.apache.fineract.organisation.monetary.domain.Money;
import org.apache.fineract.organisation.monetary.domain.MoneyHelper;
import org.apache.fineract.portfolio.charge.domain.Charge;
import org.apache.fineract.portfolio.charge.domain.ChargeCalculationType;
import org.apache.fineract.portfolio.charge.domain.ChargeTimeType;
import org.apache.fineract.portfolio.shareaccounts.domain.ShareAccount;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;

@Entity
@Table(name="m_share_account_charge")
public class ShareAccountCharge
extends AbstractPersistableCustom<Long>
implements PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    @ManyToOne(optional=false)
    @JoinColumn(name="account_id", referencedColumnName="id", nullable=false)
    private ShareAccount shareAccount;
    @ManyToOne(optional=false)
    @JoinColumn(name="charge_id", referencedColumnName="id", nullable=false)
    private Charge charge;
    @Column(name="charge_time_enum", nullable=false)
    private Integer chargeTime;
    @Column(name="charge_calculation_enum")
    private Integer chargeCalculation;
    @Column(name="calculation_percentage", scale=6, precision=19, nullable=true)
    private BigDecimal percentage;
    @Column(name="calculation_on_amount", scale=6, precision=19, nullable=true)
    private BigDecimal amountPercentageAppliedTo;
    @Column(name="amount", scale=6, precision=19, nullable=false)
    private BigDecimal amount;
    @Column(name="amount_paid_derived", scale=6, precision=19, nullable=true)
    private BigDecimal amountPaid;
    @Column(name="amount_waived_derived", scale=6, precision=19, nullable=true)
    private BigDecimal amountWaived;
    @Column(name="amount_writtenoff_derived", scale=6, precision=19, nullable=true)
    private BigDecimal amountWrittenOff;
    @Column(name="amount_outstanding_derived", scale=6, precision=19, nullable=false)
    private BigDecimal amountOutstanding;
    @Column(name="is_paid_derived", nullable=false)
    private boolean paid = false;
    @Column(name="waived", nullable=false)
    private boolean waived = false;
    @Column(name="is_active", nullable=false)
    private boolean active = true;
    @Column(name="charge_amount_or_percentage")
    private BigDecimal amountOrPercentage;
    static final long serialVersionUID = -7533098098521255983L;

    public static ShareAccountCharge createNewWithoutShareAccount(Charge chargeDefinition, BigDecimal amountPayable, ChargeTimeType chargeTime, ChargeCalculationType chargeCalculation, boolean status) {
        return new ShareAccountCharge(null, chargeDefinition, amountPayable, chargeTime, chargeCalculation, status);
    }

    protected ShareAccountCharge() {
    }

    private ShareAccountCharge(ShareAccount shareAccount, Charge chargeDefinition, BigDecimal amount, ChargeTimeType chargeTime, ChargeCalculationType chargeCalculation, boolean status) {
        this.shareAccount = shareAccount;
        this.charge = chargeDefinition;
        this.chargeTime = chargeTime == null ? chargeDefinition.getChargeTimeType() : chargeTime.getValue();
        this.chargeCalculation = chargeDefinition.getChargeCalculation();
        if (chargeCalculation != null) {
            this.chargeCalculation = chargeCalculation.getValue();
        }
        BigDecimal chargeAmount = chargeDefinition.getAmount();
        if (amount != null) {
            chargeAmount = amount;
        }
        BigDecimal transactionAmount = new BigDecimal(0);
        this.populateDerivedFields(transactionAmount, chargeAmount);
        this.paid = this.determineIfFullyPaid();
        this.active = status;
    }

    private void populateDerivedFields(BigDecimal transactionAmount, BigDecimal chargeAmount) {
        this._persistence_set_amountOrPercentage(chargeAmount);
        if (this._persistence_get_chargeCalculation().equals(ChargeCalculationType.FLAT.getValue())) {
            this._persistence_set_percentage(null);
            this._persistence_set_amount(BigDecimal.ZERO);
            this._persistence_set_amountPercentageAppliedTo(null);
            this._persistence_set_amountPaid(null);
            this._persistence_set_amountOutstanding(BigDecimal.ZERO);
            this._persistence_set_amountWaived(null);
            this._persistence_set_amountWrittenOff(null);
        } else if (this._persistence_get_chargeCalculation().equals(ChargeCalculationType.PERCENT_OF_AMOUNT.getValue())) {
            this._persistence_set_percentage(chargeAmount);
            this._persistence_set_amountPercentageAppliedTo(transactionAmount);
            this._persistence_set_amount(this.percentageOf(this._persistence_get_amountPercentageAppliedTo(), this._persistence_get_percentage()));
            this._persistence_set_amountPaid(null);
            this._persistence_set_amountOutstanding(this.calculateOutstanding());
            this._persistence_set_amountWaived(null);
            this._persistence_set_amountWrittenOff(null);
        }
    }

    public void markAsFullyPaid() {
        this._persistence_set_amountPaid(this._persistence_get_amount());
        this._persistence_set_amountOutstanding(BigDecimal.ZERO);
        this._persistence_set_paid(true);
    }

    public void resetToOriginal(MonetaryCurrency currency) {
        this._persistence_set_amount(BigDecimal.ZERO);
        this._persistence_set_amountPaid(BigDecimal.ZERO);
        this._persistence_set_amountWaived(BigDecimal.ZERO);
        this._persistence_set_amountWrittenOff(BigDecimal.ZERO);
        this._persistence_set_amountOutstanding(this.calculateAmountOutstanding(currency));
        this._persistence_set_paid(false);
        this._persistence_set_waived(false);
    }

    public void undoPayment(MonetaryCurrency currency, Money transactionAmount) {
        Money amountPaid = this.getAmountPaid(currency);
        amountPaid = amountPaid.minus(transactionAmount);
        this._persistence_set_amountPaid(amountPaid.getAmount());
        this._persistence_set_amountOutstanding(this.calculateAmountOutstanding(currency));
        this._persistence_set_paid(false);
        this._persistence_set_active(true);
    }

    public Money waive(MonetaryCurrency currency) {
        Money amountWaivedToDate = Money.of((MonetaryCurrency)currency, (BigDecimal)this._persistence_get_amountWaived());
        Money amountOutstanding = Money.of((MonetaryCurrency)currency, (BigDecimal)this._persistence_get_amountOutstanding());
        this._persistence_set_amountWaived(amountWaivedToDate.plus(amountOutstanding).getAmount());
        this._persistence_set_amountOutstanding(BigDecimal.ZERO);
        this._persistence_set_waived(true);
        return amountOutstanding;
    }

    public void undoWaiver(MonetaryCurrency currency, Money transactionAmount) {
        Money amountWaived = this.getAmountWaived(currency);
        amountWaived = amountWaived.minus(transactionAmount);
        this._persistence_set_amountWaived(amountWaived.getAmount());
        this._persistence_set_amountOutstanding(this.calculateAmountOutstanding(currency));
        this._persistence_set_waived(false);
        this._persistence_set_active(true);
    }

    public Money pay(MonetaryCurrency currency, Money amountPaid) {
        Money amountPaidToDate = Money.of((MonetaryCurrency)currency, (BigDecimal)this._persistence_get_amountPaid());
        Money amountOutstanding = Money.of((MonetaryCurrency)currency, (BigDecimal)this._persistence_get_amountOutstanding());
        amountPaidToDate = amountPaidToDate.plus(amountPaid);
        amountOutstanding = amountOutstanding.minus(amountPaid);
        this._persistence_set_amountPaid(amountPaidToDate.getAmount());
        this._persistence_set_amountOutstanding(amountOutstanding.getAmount());
        this._persistence_set_paid(this.determineIfFullyPaid());
        return Money.of((MonetaryCurrency)currency, (BigDecimal)this._persistence_get_amountOutstanding());
    }

    private BigDecimal calculateAmountOutstanding(MonetaryCurrency currency) {
        return this.getAmount(currency).minus(this.getAmountWaived(currency)).minus(this.getAmountPaid(currency)).getAmount();
    }

    public void update(ShareAccount shareAccount) {
        this._persistence_set_shareAccount(shareAccount);
    }

    public void update(BigDecimal transactionAmount, BigDecimal amount) {
        this.populateDerivedFields(transactionAmount, amount);
    }

    private boolean isGreaterThanZero(BigDecimal value) {
        return value.compareTo(BigDecimal.ZERO) > 0;
    }

    private boolean determineIfFullyPaid() {
        return BigDecimal.ZERO.compareTo(this.calculateOutstanding()) == 0;
    }

    private BigDecimal calculateOutstanding() {
        BigDecimal amountPaidLocal = BigDecimal.ZERO;
        if (this._persistence_get_amountPaid() != null) {
            amountPaidLocal = this._persistence_get_amountPaid();
        }
        BigDecimal amountWaivedLocal = BigDecimal.ZERO;
        if (this._persistence_get_amountWaived() != null) {
            amountWaivedLocal = this._persistence_get_amountWaived();
        }
        BigDecimal amountWrittenOffLocal = BigDecimal.ZERO;
        if (this._persistence_get_amountWrittenOff() != null) {
            amountWrittenOffLocal = this._persistence_get_amountWrittenOff();
        }
        BigDecimal totalAccountedFor = amountPaidLocal.add(amountWaivedLocal).add(amountWrittenOffLocal);
        return this._persistence_get_amount().subtract(totalAccountedFor);
    }

    private BigDecimal percentageOf(BigDecimal value, BigDecimal percentage) {
        BigDecimal percentageOf = BigDecimal.ZERO;
        if (this.isGreaterThanZero(value)) {
            MathContext mc = new MathContext(8, MoneyHelper.getRoundingMode());
            BigDecimal multiplicand = percentage.divide(BigDecimal.valueOf(100L), mc);
            percentageOf = value.multiply(multiplicand, mc);
        }
        return percentageOf;
    }

    public BigDecimal percentageOrAmount() {
        return this._persistence_get_amountOrPercentage();
    }

    public BigDecimal amoutOutstanding() {
        return this._persistence_get_amountOutstanding();
    }

    public boolean isNotFullyPaid() {
        return !this.isPaid();
    }

    public boolean isPaid() {
        return this._persistence_get_paid();
    }

    public boolean isWaived() {
        return this._persistence_get_waived();
    }

    public boolean isPaidOrPartiallyPaid(MonetaryCurrency currency) {
        Money amountWaivedOrWrittenOff = this.getAmountWaived(currency).plus(this.getAmountWrittenOff(currency));
        return Money.of((MonetaryCurrency)currency, (BigDecimal)this._persistence_get_amountPaid()).plus(amountWaivedOrWrittenOff).isGreaterThanZero();
    }

    public Money getAmount(MonetaryCurrency currency) {
        return Money.of((MonetaryCurrency)currency, (BigDecimal)this._persistence_get_amount());
    }

    private Money getAmountPaid(MonetaryCurrency currency) {
        return Money.of((MonetaryCurrency)currency, (BigDecimal)this._persistence_get_amountPaid());
    }

    public Money getAmountWaived(MonetaryCurrency currency) {
        return Money.of((MonetaryCurrency)currency, (BigDecimal)this._persistence_get_amountWaived());
    }

    public Money getAmountWrittenOff(MonetaryCurrency currency) {
        return Money.of((MonetaryCurrency)currency, (BigDecimal)this._persistence_get_amountWrittenOff());
    }

    public Money getAmountOutstanding(MonetaryCurrency currency) {
        return Money.of((MonetaryCurrency)currency, (BigDecimal)this._persistence_get_amountOutstanding());
    }

    public Money updatePaidAmountBy(Money incrementBy) {
        Money amountPaidToDate = Money.of((MonetaryCurrency)incrementBy.getCurrency(), (BigDecimal)this._persistence_get_amountPaid());
        Money amountPaidOnThisCharge = Money.zero((MonetaryCurrency)incrementBy.getCurrency());
        amountPaidOnThisCharge = incrementBy;
        amountPaidToDate = amountPaidToDate.plus(incrementBy);
        this._persistence_set_amountPaid(amountPaidToDate.getAmount());
        Money amountExpected = Money.of((MonetaryCurrency)incrementBy.getCurrency(), (BigDecimal)this._persistence_get_amountPaid());
        this._persistence_set_amountOutstanding(amountExpected.minus(amountPaidToDate).getAmount());
        this._persistence_set_paid(this.determineIfFullyPaid());
        return amountPaidOnThisCharge;
    }

    public String name() {
        return this._persistence_get_charge().getName();
    }

    public String currencyCode() {
        return this._persistence_get_charge().getCurrencyCode();
    }

    public Charge getCharge() {
        return this._persistence_get_charge();
    }

    public ShareAccount shareAccount() {
        return this._persistence_get_shareAccount();
    }

    public boolean isShareAccountActivation() {
        return ChargeTimeType.fromInt((Integer)this._persistence_get_chargeTime()).isShareAccountActivation();
    }

    public boolean isShareAccountClosure() {
        return ChargeTimeType.fromInt((Integer)this._persistence_get_chargeTime()).isSavingsClosure();
    }

    public boolean hasCurrencyCodeOf(String matchingCurrencyCode) {
        if (this.currencyCode() == null || matchingCurrencyCode == null) {
            return false;
        }
        return this.currencyCode().equalsIgnoreCase(matchingCurrencyCode);
    }

    public BigDecimal updateWithdralFeeAmount(BigDecimal transactionAmount) {
        BigDecimal amountPaybale = BigDecimal.ZERO;
        if (ChargeCalculationType.fromInt((Integer)this._persistence_get_chargeCalculation()).isFlat()) {
            amountPaybale = this._persistence_get_amount();
        } else if (ChargeCalculationType.fromInt((Integer)this._persistence_get_chargeCalculation()).isPercentageOfAmount()) {
            amountPaybale = transactionAmount.multiply(this._persistence_get_percentage()).divide(BigDecimal.valueOf(100L));
        }
        this._persistence_set_amountOutstanding(amountPaybale);
        return amountPaybale;
    }

    public boolean isActive() {
        return this._persistence_get_active();
    }

    public boolean isNotActive() {
        return !this.isActive();
    }

    public Long getChargeId() {
        return (Long)this._persistence_get_charge().getId();
    }

    public boolean isSharesPurchaseCharge() {
        return ChargeTimeType.fromInt((Integer)this._persistence_get_chargeTime()).isSharesPurchase();
    }

    public boolean isSharesRedeemCharge() {
        return ChargeTimeType.fromInt((Integer)this._persistence_get_chargeTime()).isSharesRedeem();
    }

    public Integer getChargeTimeType() {
        return this._persistence_get_chargeTime();
    }

    public BigDecimal deriveChargeAmount(BigDecimal transactionAmount, MonetaryCurrency currency) {
        BigDecimal toReturnAmount = this._persistence_get_amountOrPercentage();
        if (ChargeCalculationType.fromInt((Integer)this._persistence_get_chargeCalculation()) == ChargeCalculationType.PERCENT_OF_AMOUNT) {
            toReturnAmount = Money.of((MonetaryCurrency)currency, (BigDecimal)this.percentageOf(transactionAmount, this._persistence_get_percentage())).getAmount();
            this._persistence_set_amountPercentageAppliedTo(transactionAmount);
            this._persistence_set_amount(Money.of((MonetaryCurrency)currency, (BigDecimal)this.percentageOf(this._persistence_get_amountPercentageAppliedTo(), this._persistence_get_percentage())).getAmount());
            this._persistence_set_amountPaid(null);
            this._persistence_set_amountOutstanding(this.calculateOutstanding());
            this._persistence_set_amountWaived(null);
            this._persistence_set_amountWrittenOff(null);
        } else {
            this._persistence_set_amount(this._persistence_get_amountOrPercentage());
            this._persistence_set_amountOutstanding(this.calculateOutstanding());
            this._persistence_set_amountWaived(null);
            this._persistence_set_amountWrittenOff(null);
        }
        return toReturnAmount;
    }

    public BigDecimal updateChargeDetailsForAdditionalSharesRequest(BigDecimal transactionAmount, MonetaryCurrency currency) {
        BigDecimal toReturnAmount = this._persistence_get_amountOrPercentage();
        if (ChargeCalculationType.fromInt((Integer)this._persistence_get_chargeCalculation()) == ChargeCalculationType.PERCENT_OF_AMOUNT) {
            toReturnAmount = Money.of((MonetaryCurrency)currency, (BigDecimal)this.percentageOf(transactionAmount, this._persistence_get_percentage())).getAmount();
            this._persistence_set_amountPercentageAppliedTo(this._persistence_get_amountPercentageAppliedTo().add(transactionAmount));
            this._persistence_set_amount(Money.of((MonetaryCurrency)currency, (BigDecimal)this.percentageOf(this._persistence_get_amountPercentageAppliedTo(), this._persistence_get_percentage())).getAmount());
            this._persistence_set_amountOutstanding(this.calculateOutstanding());
            this._persistence_set_amountWaived(null);
            this._persistence_set_amountWrittenOff(null);
        } else {
            this._persistence_set_amount(this._persistence_get_amount().add(this._persistence_get_amountOrPercentage()));
            this._persistence_set_amountOutstanding(this.calculateOutstanding());
            this._persistence_set_amountWaived(null);
            this._persistence_set_amountWrittenOff(null);
        }
        return toReturnAmount;
    }

    public void setActive(boolean active) {
        this._persistence_set_active(active);
    }

    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new ShareAccountCharge();
    }

    public Object _persistence_get(String string) {
        if (string == "amountOrPercentage") {
            return this.amountOrPercentage;
        }
        if (string == "amount") {
            return this.amount;
        }
        if (string == "charge") {
            return this.charge;
        }
        if (string == "amountOutstanding") {
            return this.amountOutstanding;
        }
        if (string == "chargeTime") {
            return this.chargeTime;
        }
        if (string == "shareAccount") {
            return this.shareAccount;
        }
        if (string == "active") {
            return this.active;
        }
        if (string == "chargeCalculation") {
            return this.chargeCalculation;
        }
        if (string == "amountWaived") {
            return this.amountWaived;
        }
        if (string == "amountPercentageAppliedTo") {
            return this.amountPercentageAppliedTo;
        }
        if (string == "waived") {
            return this.waived;
        }
        if (string == "amountPaid") {
            return this.amountPaid;
        }
        if (string == "amountWrittenOff") {
            return this.amountWrittenOff;
        }
        if (string == "percentage") {
            return this.percentage;
        }
        if (string == "paid") {
            return this.paid;
        }
        return super._persistence_get(string);
    }

    public void _persistence_set(String string, Object object) {
        if (string == "amountOrPercentage") {
            this.amountOrPercentage = (BigDecimal)object;
            return;
        }
        if (string == "amount") {
            this.amount = (BigDecimal)object;
            return;
        }
        if (string == "charge") {
            this.charge = (Charge)object;
            return;
        }
        if (string == "amountOutstanding") {
            this.amountOutstanding = (BigDecimal)object;
            return;
        }
        if (string == "chargeTime") {
            this.chargeTime = (Integer)object;
            return;
        }
        if (string == "shareAccount") {
            this.shareAccount = (ShareAccount)object;
            return;
        }
        if (string == "active") {
            this.active = (Boolean)object;
            return;
        }
        if (string == "chargeCalculation") {
            this.chargeCalculation = (Integer)object;
            return;
        }
        if (string == "amountWaived") {
            this.amountWaived = (BigDecimal)object;
            return;
        }
        if (string == "amountPercentageAppliedTo") {
            this.amountPercentageAppliedTo = (BigDecimal)object;
            return;
        }
        if (string == "waived") {
            this.waived = (Boolean)object;
            return;
        }
        if (string == "amountPaid") {
            this.amountPaid = (BigDecimal)object;
            return;
        }
        if (string == "amountWrittenOff") {
            this.amountWrittenOff = (BigDecimal)object;
            return;
        }
        if (string == "percentage") {
            this.percentage = (BigDecimal)object;
            return;
        }
        if (string == "paid") {
            this.paid = (Boolean)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public BigDecimal _persistence_get_amountOrPercentage() {
        this._persistence_checkFetched("amountOrPercentage");
        return this.amountOrPercentage;
    }

    public void _persistence_set_amountOrPercentage(BigDecimal bigDecimal) {
        this._persistence_checkFetchedForSet("amountOrPercentage");
        this._persistence_propertyChange("amountOrPercentage", (Object)this.amountOrPercentage, (Object)bigDecimal);
        this.amountOrPercentage = bigDecimal;
    }

    public BigDecimal _persistence_get_amount() {
        this._persistence_checkFetched("amount");
        return this.amount;
    }

    public void _persistence_set_amount(BigDecimal bigDecimal) {
        this._persistence_checkFetchedForSet("amount");
        this._persistence_propertyChange("amount", (Object)this.amount, (Object)bigDecimal);
        this.amount = bigDecimal;
    }

    public Charge _persistence_get_charge() {
        this._persistence_checkFetched("charge");
        return this.charge;
    }

    public void _persistence_set_charge(Charge charge) {
        this._persistence_checkFetchedForSet("charge");
        this._persistence_propertyChange("charge", (Object)this.charge, (Object)charge);
        this.charge = charge;
    }

    public BigDecimal _persistence_get_amountOutstanding() {
        this._persistence_checkFetched("amountOutstanding");
        return this.amountOutstanding;
    }

    public void _persistence_set_amountOutstanding(BigDecimal bigDecimal) {
        this._persistence_checkFetchedForSet("amountOutstanding");
        this._persistence_propertyChange("amountOutstanding", (Object)this.amountOutstanding, (Object)bigDecimal);
        this.amountOutstanding = bigDecimal;
    }

    public Integer _persistence_get_chargeTime() {
        this._persistence_checkFetched("chargeTime");
        return this.chargeTime;
    }

    public void _persistence_set_chargeTime(Integer n) {
        this._persistence_checkFetchedForSet("chargeTime");
        this._persistence_propertyChange("chargeTime", (Object)this.chargeTime, (Object)n);
        this.chargeTime = n;
    }

    public ShareAccount _persistence_get_shareAccount() {
        this._persistence_checkFetched("shareAccount");
        return this.shareAccount;
    }

    public void _persistence_set_shareAccount(ShareAccount shareAccount) {
        this._persistence_checkFetchedForSet("shareAccount");
        this._persistence_propertyChange("shareAccount", (Object)this.shareAccount, (Object)shareAccount);
        this.shareAccount = shareAccount;
    }

    public boolean _persistence_get_active() {
        this._persistence_checkFetched("active");
        return this.active;
    }

    public void _persistence_set_active(boolean bl) {
        this._persistence_checkFetchedForSet("active");
        this._persistence_propertyChange("active", (Object)new Boolean(this.active), (Object)new Boolean(bl));
        this.active = bl;
    }

    public Integer _persistence_get_chargeCalculation() {
        this._persistence_checkFetched("chargeCalculation");
        return this.chargeCalculation;
    }

    public void _persistence_set_chargeCalculation(Integer n) {
        this._persistence_checkFetchedForSet("chargeCalculation");
        this._persistence_propertyChange("chargeCalculation", (Object)this.chargeCalculation, (Object)n);
        this.chargeCalculation = n;
    }

    public BigDecimal _persistence_get_amountWaived() {
        this._persistence_checkFetched("amountWaived");
        return this.amountWaived;
    }

    public void _persistence_set_amountWaived(BigDecimal bigDecimal) {
        this._persistence_checkFetchedForSet("amountWaived");
        this._persistence_propertyChange("amountWaived", (Object)this.amountWaived, (Object)bigDecimal);
        this.amountWaived = bigDecimal;
    }

    public BigDecimal _persistence_get_amountPercentageAppliedTo() {
        this._persistence_checkFetched("amountPercentageAppliedTo");
        return this.amountPercentageAppliedTo;
    }

    public void _persistence_set_amountPercentageAppliedTo(BigDecimal bigDecimal) {
        this._persistence_checkFetchedForSet("amountPercentageAppliedTo");
        this._persistence_propertyChange("amountPercentageAppliedTo", (Object)this.amountPercentageAppliedTo, (Object)bigDecimal);
        this.amountPercentageAppliedTo = bigDecimal;
    }

    public boolean _persistence_get_waived() {
        this._persistence_checkFetched("waived");
        return this.waived;
    }

    public void _persistence_set_waived(boolean bl) {
        this._persistence_checkFetchedForSet("waived");
        this._persistence_propertyChange("waived", (Object)new Boolean(this.waived), (Object)new Boolean(bl));
        this.waived = bl;
    }

    public BigDecimal _persistence_get_amountPaid() {
        this._persistence_checkFetched("amountPaid");
        return this.amountPaid;
    }

    public void _persistence_set_amountPaid(BigDecimal bigDecimal) {
        this._persistence_checkFetchedForSet("amountPaid");
        this._persistence_propertyChange("amountPaid", (Object)this.amountPaid, (Object)bigDecimal);
        this.amountPaid = bigDecimal;
    }

    public BigDecimal _persistence_get_amountWrittenOff() {
        this._persistence_checkFetched("amountWrittenOff");
        return this.amountWrittenOff;
    }

    public void _persistence_set_amountWrittenOff(BigDecimal bigDecimal) {
        this._persistence_checkFetchedForSet("amountWrittenOff");
        this._persistence_propertyChange("amountWrittenOff", (Object)this.amountWrittenOff, (Object)bigDecimal);
        this.amountWrittenOff = bigDecimal;
    }

    public BigDecimal _persistence_get_percentage() {
        this._persistence_checkFetched("percentage");
        return this.percentage;
    }

    public void _persistence_set_percentage(BigDecimal bigDecimal) {
        this._persistence_checkFetchedForSet("percentage");
        this._persistence_propertyChange("percentage", (Object)this.percentage, (Object)bigDecimal);
        this.percentage = bigDecimal;
    }

    public boolean _persistence_get_paid() {
        this._persistence_checkFetched("paid");
        return this.paid;
    }

    public void _persistence_set_paid(boolean bl) {
        this._persistence_checkFetchedForSet("paid");
        this._persistence_propertyChange("paid", (Object)new Boolean(this.paid), (Object)new Boolean(bl));
        this.paid = bl;
    }
}

