/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.shareaccounts.service;

import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.infrastructure.core.service.Page;
import org.apache.fineract.infrastructure.core.service.PaginationHelper;
import org.apache.fineract.infrastructure.core.service.database.DatabaseSpecificSQLGenerator;
import org.apache.fineract.portfolio.accounts.constants.ShareAccountApiConstants;
import org.apache.fineract.portfolio.accounts.data.AccountData;
import org.apache.fineract.portfolio.accounts.exceptions.ShareAccountNotFoundException;
import org.apache.fineract.portfolio.charge.data.ChargeData;
import org.apache.fineract.portfolio.charge.service.ChargeReadPlatformService;
import org.apache.fineract.portfolio.charge.util.ConvertChargeDataToSpecificChargeData;
import org.apache.fineract.portfolio.client.data.ClientData;
import org.apache.fineract.portfolio.client.service.ClientReadPlatformService;
import org.apache.fineract.portfolio.products.service.ShareProductReadPlatformService;
import org.apache.fineract.portfolio.savings.DepositAccountType;
import org.apache.fineract.portfolio.savings.service.SavingsAccountReadPlatformService;
import org.apache.fineract.portfolio.shareaccounts.data.ShareAccountChargeData;
import org.apache.fineract.portfolio.shareaccounts.data.ShareAccountData;
import org.apache.fineract.portfolio.shareaccounts.data.ShareAccountDividendData;
import org.apache.fineract.portfolio.shareaccounts.domain.PurchasedSharesStatusType;
import org.apache.fineract.portfolio.shareaccounts.domain.ShareAccountStatusType;
import org.apache.fineract.portfolio.shareaccounts.service.PurchasedSharesReadPlatformService;
import org.apache.fineract.portfolio.shareaccounts.service.ShareAccountChargeReadPlatformService;
import org.apache.fineract.portfolio.shareaccounts.service.ShareAccountReadPlatformService;
import org.apache.fineract.portfolio.shareaccounts.service.ShareAccountReadPlatformServiceImpl;
import org.apache.fineract.portfolio.shareproducts.data.ShareProductData;
import org.apache.fineract.portfolio.shareproducts.data.ShareProductMarketPriceData;
import org.apache.fineract.portfolio.shareproducts.service.ShareProductDropdownReadPlatformService;
import org.springframework.context.ApplicationContext;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

public class ShareAccountReadPlatformServiceImpl
implements ShareAccountReadPlatformService {
    private final ApplicationContext applicationContext;
    private final ChargeReadPlatformService chargeReadPlatformService;
    private final ShareProductDropdownReadPlatformService shareProductDropdownReadPlatformService;
    private final SavingsAccountReadPlatformService savingsAccountReadPlatformService;
    private final ClientReadPlatformService clientReadPlatformService;
    private final ShareAccountChargeReadPlatformService shareAccountChargeReadPlatformService;
    private final PurchasedSharesReadPlatformService purchasedSharesReadPlatformService;
    private final JdbcTemplate jdbcTemplate;
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private final PaginationHelper shareAccountDataPaginationHelper;
    private final DatabaseSpecificSQLGenerator sqlGenerator;

    public ShareAccountData retrieveTemplate(Long clientId, Long productId) {
        ShareAccountData toReturn = null;
        String serviceName = "shareReadPlatformService";
        ShareProductReadPlatformService service = (ShareProductReadPlatformService)this.applicationContext.getBean(serviceName);
        ClientData client = this.clientReadPlatformService.retrieveOne(clientId);
        if (productId != null) {
            ShareProductData productData = (ShareProductData)service.retrieveOne(productId, false);
            BigDecimal marketPrice = this.deriveMarketPrice(productData);
            Collection productCharges = this.chargeReadPlatformService.retrieveShareProductCharges(productId);
            Collection charges = this.convertChargesToShareAccountCharges(productCharges);
            Collection lockinPeriodFrequencyTypeOptions = this.shareProductDropdownReadPlatformService.retrieveLockinPeriodFrequencyTypeOptions();
            Collection minimumActivePeriodFrequencyTypeOptions = this.shareProductDropdownReadPlatformService.retrieveMinimumActivePeriodFrequencyTypeOptions();
            Collection clientSavingsAccounts = this.savingsAccountReadPlatformService.retrieveActiveForLookup(clientId, DepositAccountType.SAVINGS_DEPOSIT, productData.getCurrency().getCode());
            toReturn = new ShareAccountData(client.getId(), client.getDisplayName(), productData.getCurrency(), charges, marketPrice, minimumActivePeriodFrequencyTypeOptions, lockinPeriodFrequencyTypeOptions, clientSavingsAccounts, productData.getNominalShares());
        } else {
            Collection productOptions = service.retrieveAllForLookup();
            Collection chargeOptions = this.chargeReadPlatformService.retrieveSharesApplicableCharges();
            toReturn = new ShareAccountData(client.getId(), client.getDisplayName(), productOptions, chargeOptions);
        }
        return toReturn;
    }

    private BigDecimal deriveMarketPrice(ShareProductData shareProductData) {
        BigDecimal marketValue = shareProductData.getUnitPrice();
        Collection marketDataSet = shareProductData.getMarketPrice();
        if (marketDataSet != null && !marketDataSet.isEmpty()) {
            LocalDate currentDate = DateUtils.getBusinessLocalDate();
            for (ShareProductMarketPriceData data : marketDataSet) {
                LocalDate fromDate = data.getFromDate();
                if (!DateUtils.isBefore((LocalDate)fromDate, (LocalDate)currentDate)) continue;
                marketValue = data.getShareValue();
            }
        }
        return marketValue;
    }

    public ShareAccountData retrieveOne(Long id, boolean includeTemplate) {
        Collection charges = this.shareAccountChargeReadPlatformService.retrieveAccountCharges(id, "active");
        Collection purchasedShares = this.purchasedSharesReadPlatformService.retrievePurchasedShares(id);
        ShareAccountMapper mapper = new ShareAccountMapper(charges, purchasedShares);
        String query = "select " + mapper.schema() + "where sa.id=?";
        ShareAccountData data = (ShareAccountData)this.jdbcTemplate.queryForObject(query, (RowMapper)mapper, new Object[]{id});
        String serviceName = "shareReadPlatformService";
        ShareProductReadPlatformService service = (ShareProductReadPlatformService)this.applicationContext.getBean(serviceName);
        ShareProductData productData = (ShareProductData)service.retrieveOne(data.getProductId(), false);
        BigDecimal currentMarketPrice = this.deriveMarketPrice(productData);
        data.setCurrentMarketPrice(currentMarketPrice);
        if (!includeTemplate) {
            Collection dividends = this.retrieveAssociatedDividends(id);
            data.setDividends(dividends);
        }
        if (includeTemplate) {
            Collection lockinPeriodFrequencyTypeOptions;
            Collection minimumActivePeriodFrequencyTypeOptions = lockinPeriodFrequencyTypeOptions = this.shareProductDropdownReadPlatformService.retrieveLockinPeriodFrequencyTypeOptions();
            Collection clientSavingsAccounts = this.savingsAccountReadPlatformService.retrieveActiveForLookup(data.getClientId(), DepositAccountType.SAVINGS_DEPOSIT, productData.getCurrency().getCode());
            Collection productOptions = service.retrieveAllForLookup();
            Collection chargeOptions = this.chargeReadPlatformService.retrieveSharesApplicableCharges();
            data = ShareAccountData.template((ShareAccountData)data, (Collection)productOptions, (Collection)chargeOptions, (Collection)clientSavingsAccounts, (Collection)lockinPeriodFrequencyTypeOptions, (Collection)minimumActivePeriodFrequencyTypeOptions);
        }
        return data;
    }

    private Collection<ShareAccountDividendData> retrieveAssociatedDividends(Long shareAccountId) {
        ShareAccountDividendRowMapper mapper = new ShareAccountDividendRowMapper();
        String query = "select " + mapper.schema() + "where sadd.account_id=?";
        return this.jdbcTemplate.query(query, (RowMapper)mapper, new Object[]{shareAccountId});
    }

    public Page<AccountData> retrieveAll(Integer offSet, Integer limit) {
        Collection charges = null;
        Collection purchasedShares = null;
        ShareAccountMapper mapper = new ShareAccountMapper(charges, purchasedShares);
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("select " + this.sqlGenerator.calcFoundRows() + " ");
        sqlBuilder.append(mapper.schema());
        sqlBuilder.append(" where sa.status_enum = ? ");
        if (limit != null) {
            sqlBuilder.append(" limit ").append(limit);
        }
        if (offSet != null) {
            sqlBuilder.append(" offset ").append(offSet);
        }
        Object[] whereClauseItemsitems = new Object[]{ShareAccountStatusType.ACTIVE.getValue()};
        return this.shareAccountDataPaginationHelper.fetchPage(this.jdbcTemplate, sqlBuilder.toString(), whereClauseItemsitems, (RowMapper)mapper);
    }

    public Set<String> getResponseDataParams() {
        return ShareAccountApiConstants.supportedParameters;
    }

    public Collection<ShareAccountData> retrieveAllShareAccountDataForDividends(Long id, boolean fetchInActiveAccounts, LocalDate startDate) {
        ShareAccountMapperForDividents mapper = new ShareAccountMapperForDividents();
        StringBuilder sb = new StringBuilder("select ");
        sb.append(mapper.schema);
        sb.append(" where sa.product_id = ? ");
        ArrayList<Number> params = new ArrayList<Number>(3);
        params.add(id);
        params.add(ShareAccountStatusType.ACTIVE.getValue());
        if (fetchInActiveAccounts) {
            String formattedStartDate = DATE_TIME_FORMATTER.format(startDate);
            sb.append(" and (sa.status_enum = ? or (sa.status_enum = ? ");
            sb.append(" and sa.closed_date > '" + formattedStartDate + "')) ");
            params.add(ShareAccountStatusType.CLOSED.getValue());
        } else {
            sb.append(" and sa.status_enum = ? ");
        }
        sb.append(" and saps.status_enum = ?");
        sb.append(" order by sa.id");
        params.add(PurchasedSharesStatusType.APPROVED.getValue());
        Object[] whereClauseItems = params.toArray();
        return this.jdbcTemplate.query(con -> {
            PreparedStatement preparedStatement = con.prepareStatement(sb.toString(), 1005, 1008);
            for (int i = 0; i < whereClauseItems.length; ++i) {
                preparedStatement.setObject(i + 1, whereClauseItems[i]);
            }
            return preparedStatement;
        }, (RowMapper)mapper);
    }

    public Collection<ShareAccountChargeData> convertChargesToShareAccountCharges(Collection<ChargeData> productCharges) {
        ArrayList<ShareAccountChargeData> savingsCharges = new ArrayList<ShareAccountChargeData>();
        for (ChargeData chargeData : productCharges) {
            ShareAccountChargeData savingsCharge = ConvertChargeDataToSpecificChargeData.toShareAccountChargeData((ChargeData)chargeData);
            savingsCharges.add(savingsCharge);
        }
        return savingsCharges;
    }

    public String retrieveAccountNumberByAccountId(Long accountId) {
        try {
            String sql = "select s.account_no from m_share_account s where s.id = ?";
            return (String)this.jdbcTemplate.queryForObject("select s.account_no from m_share_account s where s.id = ?", String.class, new Object[]{accountId});
        }
        catch (EmptyResultDataAccessException e) {
            throw new ShareAccountNotFoundException(accountId, e);
        }
    }

    @Generated
    public ShareAccountReadPlatformServiceImpl(ApplicationContext applicationContext, ChargeReadPlatformService chargeReadPlatformService, ShareProductDropdownReadPlatformService shareProductDropdownReadPlatformService, SavingsAccountReadPlatformService savingsAccountReadPlatformService, ClientReadPlatformService clientReadPlatformService, ShareAccountChargeReadPlatformService shareAccountChargeReadPlatformService, PurchasedSharesReadPlatformService purchasedSharesReadPlatformService, JdbcTemplate jdbcTemplate, PaginationHelper shareAccountDataPaginationHelper, DatabaseSpecificSQLGenerator sqlGenerator) {
        this.applicationContext = applicationContext;
        this.chargeReadPlatformService = chargeReadPlatformService;
        this.shareProductDropdownReadPlatformService = shareProductDropdownReadPlatformService;
        this.savingsAccountReadPlatformService = savingsAccountReadPlatformService;
        this.clientReadPlatformService = clientReadPlatformService;
        this.shareAccountChargeReadPlatformService = shareAccountChargeReadPlatformService;
        this.purchasedSharesReadPlatformService = purchasedSharesReadPlatformService;
        this.jdbcTemplate = jdbcTemplate;
        this.shareAccountDataPaginationHelper = shareAccountDataPaginationHelper;
        this.sqlGenerator = sqlGenerator;
    }
}

