/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.tax.service;

import java.util.Collection;
import java.util.Map;
import lombok.Generated;
import org.apache.fineract.accounting.common.AccountingDropdownReadPlatformService;
import org.apache.fineract.portfolio.tax.data.TaxComponentData;
import org.apache.fineract.portfolio.tax.data.TaxGroupData;
import org.apache.fineract.portfolio.tax.service.TaxReadPlatformService;
import org.apache.fineract.portfolio.tax.service.TaxReadPlatformServiceImpl;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

public class TaxReadPlatformServiceImpl
implements TaxReadPlatformService {
    private static final TaxComponentMapper TAX_COMPONENT_MAPPER = new TaxComponentMapper();
    private static final TaxGroupMapper TAX_GROUP_MAPPER = new TaxGroupMapper();
    private static final TaxComponentLookUpMapper TAX_COMPONENT_LOOK_UP_MAPPER = new TaxComponentLookUpMapper();
    private static final TaxGroupLookUpMapper TAX_GROUP_LOOK_UP_MAPPER = new TaxGroupLookUpMapper();
    private final JdbcTemplate jdbcTemplate;
    private final AccountingDropdownReadPlatformService accountingDropdownReadPlatformService;

    public Collection<TaxComponentData> retrieveAllTaxComponents() {
        String sql = "select " + TAX_COMPONENT_MAPPER.getSchema();
        return this.jdbcTemplate.query(sql, (RowMapper)TAX_COMPONENT_MAPPER);
    }

    public TaxComponentData retrieveTaxComponentData(Long id) {
        String sql = "select " + TAX_COMPONENT_MAPPER.getSchema() + " where tc.id=?";
        return (TaxComponentData)this.jdbcTemplate.queryForObject(sql, (RowMapper)TAX_COMPONENT_MAPPER, new Object[]{id});
    }

    public TaxComponentData retrieveTaxComponentTemplate() {
        return TaxComponentData.template((Map)this.accountingDropdownReadPlatformService.retrieveAccountMappingOptions(), (Collection)this.accountingDropdownReadPlatformService.retrieveGLAccountTypeOptions());
    }

    public Collection<TaxGroupData> retrieveAllTaxGroups() {
        String sql = "select " + TAX_GROUP_MAPPER.getSchema();
        return this.jdbcTemplate.query(sql, (RowMapper)TAX_GROUP_MAPPER);
    }

    public TaxGroupData retrieveTaxGroupData(Long id) {
        String sql = "select " + TAX_GROUP_MAPPER.getSchema() + " where tg.id=?";
        return (TaxGroupData)this.jdbcTemplate.queryForObject(sql, (RowMapper)TAX_GROUP_MAPPER, new Object[]{id});
    }

    public TaxGroupData retrieveTaxGroupWithTemplate(Long id) {
        TaxGroupData taxGroupData = this.retrieveTaxGroupData(id);
        taxGroupData = TaxGroupData.template((TaxGroupData)taxGroupData, (Collection)this.retrieveTaxComponentsForLookUp());
        return taxGroupData;
    }

    public TaxGroupData retrieveTaxGroupTemplate() {
        return TaxGroupData.template((Collection)this.retrieveTaxComponentsForLookUp());
    }

    private Collection<TaxComponentData> retrieveTaxComponentsForLookUp() {
        String sql = "select " + TAX_COMPONENT_LOOK_UP_MAPPER.getSchema();
        return this.jdbcTemplate.query(sql, (RowMapper)TAX_COMPONENT_LOOK_UP_MAPPER);
    }

    public Collection<TaxGroupData> retrieveTaxGroupsForLookUp() {
        String sql = "select " + TAX_GROUP_LOOK_UP_MAPPER.getSchema();
        return this.jdbcTemplate.query(sql, (RowMapper)TAX_GROUP_LOOK_UP_MAPPER);
    }

    @Generated
    public TaxReadPlatformServiceImpl(JdbcTemplate jdbcTemplate, AccountingDropdownReadPlatformService accountingDropdownReadPlatformService) {
        this.jdbcTemplate = jdbcTemplate;
        this.accountingDropdownReadPlatformService = accountingDropdownReadPlatformService;
    }
}

