/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.transfer.service;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResultBuilder;
import org.apache.fineract.infrastructure.core.exception.GeneralPlatformDomainRuleException;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.organisation.office.domain.Office;
import org.apache.fineract.organisation.office.domain.OfficeRepositoryWrapper;
import org.apache.fineract.organisation.staff.domain.Staff;
import org.apache.fineract.organisation.staff.domain.StaffRepositoryWrapper;
import org.apache.fineract.portfolio.calendar.domain.Calendar;
import org.apache.fineract.portfolio.calendar.domain.CalendarEntityType;
import org.apache.fineract.portfolio.calendar.domain.CalendarInstance;
import org.apache.fineract.portfolio.calendar.domain.CalendarInstanceRepository;
import org.apache.fineract.portfolio.calendar.domain.CalendarType;
import org.apache.fineract.portfolio.calendar.service.CalendarUtils;
import org.apache.fineract.portfolio.client.domain.Client;
import org.apache.fineract.portfolio.client.domain.ClientRepositoryWrapper;
import org.apache.fineract.portfolio.client.domain.ClientStatus;
import org.apache.fineract.portfolio.client.domain.ClientTransferDetails;
import org.apache.fineract.portfolio.client.domain.ClientTransferDetailsRepositoryWrapper;
import org.apache.fineract.portfolio.client.exception.ClientHasBeenClosedException;
import org.apache.fineract.portfolio.group.domain.Group;
import org.apache.fineract.portfolio.group.domain.GroupRepositoryWrapper;
import org.apache.fineract.portfolio.group.exception.ClientNotInGroupException;
import org.apache.fineract.portfolio.group.exception.GroupNotActiveException;
import org.apache.fineract.portfolio.loanaccount.domain.Loan;
import org.apache.fineract.portfolio.loanaccount.domain.LoanRepositoryWrapper;
import org.apache.fineract.portfolio.loanaccount.service.LoanOfficerService;
import org.apache.fineract.portfolio.loanaccount.service.LoanWritePlatformService;
import org.apache.fineract.portfolio.note.service.NoteWritePlatformService;
import org.apache.fineract.portfolio.savings.domain.SavingsAccount;
import org.apache.fineract.portfolio.savings.domain.SavingsAccountRepositoryWrapper;
import org.apache.fineract.portfolio.savings.service.SavingsAccountWritePlatformService;
import org.apache.fineract.portfolio.transfer.data.TransfersDataValidator;
import org.apache.fineract.portfolio.transfer.exception.ClientNotAwaitingTransferApprovalException;
import org.apache.fineract.portfolio.transfer.exception.ClientNotAwaitingTransferApprovalOrOnHoldException;
import org.apache.fineract.portfolio.transfer.exception.TransferNotSupportedException;
import org.apache.fineract.portfolio.transfer.service.TransferEventType;
import org.apache.fineract.portfolio.transfer.service.TransferWritePlatformService;
import org.apache.fineract.portfolio.transfer.service.TransferWritePlatformServiceJpaRepositoryImpl;
import org.springframework.transaction.annotation.Transactional;

public class TransferWritePlatformServiceJpaRepositoryImpl
implements TransferWritePlatformService {
    private final ClientRepositoryWrapper clientRepositoryWrapper;
    private final OfficeRepositoryWrapper officeRepository;
    private final CalendarInstanceRepository calendarInstanceRepository;
    private final GroupRepositoryWrapper groupRepository;
    private final LoanWritePlatformService loanWritePlatformService;
    private final SavingsAccountWritePlatformService savingsAccountWritePlatformService;
    private final LoanRepositoryWrapper loanRepositoryWrapper;
    private final SavingsAccountRepositoryWrapper savingsAccountRepositoryWrapper;
    private final TransfersDataValidator transfersDataValidator;
    private final NoteWritePlatformService noteWritePlatformService;
    private final StaffRepositoryWrapper staffRepositoryWrapper;
    private final ClientTransferDetailsRepositoryWrapper clientTransferDetailsRepositoryWrapper;
    private final PlatformSecurityContext context;
    private final LoanOfficerService loanOfficerService;

    @Transactional
    public CommandProcessingResult transferClientsBetweenGroups(Long sourceGroupId, JsonCommand jsonCommand) {
        this.transfersDataValidator.validateForClientsTransferBetweenGroups(jsonCommand.json());
        Group sourceGroup = this.groupRepository.findOneWithNotFoundDetection(sourceGroupId);
        Long destinationGroupId = jsonCommand.longValueOfParameterNamed("destinationGroupId");
        Group destinationGroup = this.groupRepository.findOneWithNotFoundDetection(destinationGroupId);
        Long staffId = jsonCommand.longValueOfParameterNamed("staffId");
        Boolean inheritDestinationGroupLoanOfficer = jsonCommand.booleanObjectValueOfParameterNamed("inheritDestinationGroupLoanOfficer");
        Staff staff = null;
        Office sourceOffice = sourceGroup.getOffice();
        if (staffId != null) {
            staff = this.staffRepositoryWrapper.findByOfficeHierarchyWithNotFoundDetection(staffId, sourceOffice.getHierarchy());
        }
        List clients = this.assembleListOfClients(jsonCommand);
        if (sourceGroupId.equals(destinationGroupId)) {
            throw new TransferNotSupportedException(TransferNotSupportedException.TransferNotSupportedReason.SOURCE_AND_DESTINATION_GROUP_CANNOT_BE_SAME, new Object[]{sourceGroupId, destinationGroupId});
        }
        if (!((Long)sourceOffice.getId()).equals(destinationGroup.getOffice().getId())) {
            throw new TransferNotSupportedException(TransferNotSupportedException.TransferNotSupportedReason.BULK_CLIENT_TRANSFER_ACROSS_BRANCHES, new Object[]{sourceGroupId, destinationGroupId});
        }
        for (Client client : clients) {
            this.transferClientBetweenGroups(sourceGroup, client, destinationGroup, inheritDestinationGroupLoanOfficer, staff);
        }
        return new CommandProcessingResultBuilder().withEntityId(sourceGroupId).build();
    }

    @Transactional
    public void transferClientBetweenGroups(Group sourceGroup, Client client, Group destinationGroup, Boolean inheritDestinationGroupLoanOfficer, Staff newLoanOfficer) {
        if (!sourceGroup.hasClientAsMember(client)) {
            throw new ClientNotInGroupException((Long)client.getId(), (Long)sourceGroup.getId());
        }
        if (client.isNotActive()) {
            throw new ClientHasBeenClosedException((Long)client.getId());
        }
        CalendarInstance sourceGroupCalendarInstance = this.calendarInstanceRepository.findByEntityIdAndEntityTypeIdAndCalendarTypeId((Long)sourceGroup.getId(), CalendarEntityType.GROUPS.getValue(), CalendarType.COLLECTION.getValue());
        List activeLoanCalendarInstances = this.calendarInstanceRepository.findCalendarInstancesForActiveLoansByGroupIdAndClientId((Long)sourceGroup.getId(), (Long)client.getId());
        if (sourceGroupCalendarInstance != null && !activeLoanCalendarInstances.isEmpty()) {
            CalendarInstance destinationGroupCalendarInstance = this.calendarInstanceRepository.findByEntityIdAndEntityTypeIdAndCalendarTypeId((Long)destinationGroup.getId(), CalendarEntityType.GROUPS.getValue(), CalendarType.COLLECTION.getValue());
            if (destinationGroupCalendarInstance == null) {
                throw new TransferNotSupportedException(TransferNotSupportedException.TransferNotSupportedReason.DESTINATION_GROUP_HAS_NO_MEETING, new Object[]{destinationGroup.getId()});
            }
            Calendar sourceGroupCalendar = sourceGroupCalendarInstance.getCalendar();
            Calendar destinationGroupCalendar = destinationGroupCalendarInstance.getCalendar();
            if (!CalendarUtils.isFrequencySame((String)sourceGroupCalendar.getRecurrence(), (String)destinationGroupCalendar.getRecurrence()) || !CalendarUtils.isIntervalSame((String)sourceGroupCalendar.getRecurrence(), (String)destinationGroupCalendar.getRecurrence())) {
                throw new TransferNotSupportedException(TransferNotSupportedException.TransferNotSupportedReason.DESTINATION_GROUP_MEETING_FREQUENCY_MISMATCH, new Object[]{sourceGroup.getId(), destinationGroup.getId()});
            }
            for (CalendarInstance calendarInstance : activeLoanCalendarInstances) {
                calendarInstance.updateCalendar(destinationGroupCalendar);
                this.calendarInstanceRepository.saveAndFlush((Object)calendarInstance);
            }
            this.loanWritePlatformService.applyMeetingDateChanges(destinationGroupCalendar, (Collection)activeLoanCalendarInstances);
        }
        Staff destinationGroupLoanOfficer = destinationGroup.getStaff();
        if (((Long)sourceGroup.getId()).equals(destinationGroup.getId()) && newLoanOfficer != null) {
            client.updateStaff(newLoanOfficer);
        } else if (destinationGroupLoanOfficer != null) {
            client.updateStaff(destinationGroupLoanOfficer);
        }
        client.getGroups().add(destinationGroup);
        this.clientRepositoryWrapper.saveAndFlush(client);
        List allClientJLGLoans = this.loanRepositoryWrapper.findByClientIdAndGroupId((Long)client.getId(), (Long)sourceGroup.getId());
        for (Loan loan : allClientJLGLoans) {
            if (!loan.getStatus().isActiveOrAwaitingApprovalOrDisbursal()) continue;
            loan.updateGroup(destinationGroup);
            if (inheritDestinationGroupLoanOfficer != null && inheritDestinationGroupLoanOfficer.booleanValue() && destinationGroupLoanOfficer != null) {
                this.loanOfficerService.reassignLoanOfficer(loan, destinationGroupLoanOfficer, DateUtils.getBusinessLocalDate());
            } else if (newLoanOfficer != null) {
                this.loanOfficerService.reassignLoanOfficer(loan, newLoanOfficer, DateUtils.getBusinessLocalDate());
            }
            this.loanRepositoryWrapper.saveAndFlush(loan);
        }
        if (!((Long)sourceGroup.getId()).equals(destinationGroup.getId())) {
            client.getGroups().remove(sourceGroup);
        }
    }

    @Transactional
    public CommandProcessingResult proposeAndAcceptClientTransfer(Long clientId, JsonCommand jsonCommand) {
        this.transfersDataValidator.validateForProposeAndAcceptClientTransfer(jsonCommand.json());
        Long destinationOfficeId = jsonCommand.longValueOfParameterNamed("destinationOfficeId");
        Office office = this.officeRepository.findOneWithNotFoundDetection(destinationOfficeId);
        Client client = this.clientRepositoryWrapper.findOneWithNotFoundDetection(clientId, true);
        this.handleClientTransferLifecycleEvent(client, office, TransferEventType.PROPOSAL, jsonCommand);
        this.clientRepositoryWrapper.saveAndFlush(client);
        this.handleClientTransferLifecycleEvent(client, client.getTransferToOffice(), TransferEventType.ACCEPTANCE, jsonCommand);
        this.clientRepositoryWrapper.saveAndFlush(client);
        return new CommandProcessingResultBuilder().withClientId(clientId).withEntityId(clientId).build();
    }

    @Transactional
    public CommandProcessingResult proposeClientTransfer(Long clientId, JsonCommand jsonCommand) {
        this.transfersDataValidator.validateForProposeClientTransfer(jsonCommand.json());
        Long destinationOfficeId = jsonCommand.longValueOfParameterNamed("destinationOfficeId");
        Office office = this.officeRepository.findOneWithNotFoundDetection(destinationOfficeId);
        Client client = this.clientRepositoryWrapper.findOneWithNotFoundDetection(clientId);
        if (((Long)client.getOffice().getId()).equals(destinationOfficeId)) {
            throw new GeneralPlatformDomainRuleException("error.msg.cannot.transfer.client.as.selected.office.and.current.office.are.same", "error.msg.cannot.transfer.client.as.selected.office.and.current.office.are.same", new Object[]{office.getName()});
        }
        this.handleClientTransferLifecycleEvent(client, office, TransferEventType.PROPOSAL, jsonCommand);
        this.clientRepositoryWrapper.saveAndFlush(client);
        return new CommandProcessingResultBuilder().withClientId(clientId).withEntityId(clientId).build();
    }

    @Transactional
    public CommandProcessingResult acceptClientTransfer(Long clientId, JsonCommand jsonCommand) {
        this.transfersDataValidator.validateForAcceptClientTransfer(jsonCommand.json());
        Client client = this.clientRepositoryWrapper.findOneWithNotFoundDetection(clientId, true);
        this.validateClientAwaitingTransferAcceptance(client);
        this.handleClientTransferLifecycleEvent(client, client.getTransferToOffice(), TransferEventType.ACCEPTANCE, jsonCommand);
        this.clientRepositoryWrapper.saveAndFlush(client);
        return new CommandProcessingResultBuilder().withClientId(clientId).withEntityId(clientId).build();
    }

    @Transactional
    public CommandProcessingResult withdrawClientTransfer(Long clientId, JsonCommand jsonCommand) {
        this.transfersDataValidator.validateForWithdrawClientTransfer(jsonCommand.json());
        Client client = this.clientRepositoryWrapper.findOneWithNotFoundDetection(clientId);
        this.validateClientAwaitingTransferAcceptanceOnHold(client);
        this.handleClientTransferLifecycleEvent(client, client.getOffice(), TransferEventType.WITHDRAWAL, jsonCommand);
        this.clientRepositoryWrapper.saveAndFlush(client);
        return new CommandProcessingResultBuilder().withClientId(clientId).withEntityId(clientId).build();
    }

    @Transactional
    public CommandProcessingResult rejectClientTransfer(Long clientId, JsonCommand jsonCommand) {
        this.transfersDataValidator.validateForRejectClientTransfer(jsonCommand.json());
        Client client = this.clientRepositoryWrapper.findOneWithNotFoundDetection(clientId);
        this.handleClientTransferLifecycleEvent(client, client.getOffice(), TransferEventType.REJECTION, jsonCommand);
        this.clientRepositoryWrapper.saveAndFlush(client);
        return new CommandProcessingResultBuilder().withClientId(clientId).withEntityId(clientId).build();
    }

    private void handleClientTransferLifecycleEvent(Client client, Office destinationOffice, TransferEventType transferEventType, JsonCommand jsonCommand) {
        Staff staff = null;
        Group destinationGroup = null;
        Long staffId = jsonCommand.longValueOfParameterNamed("staffId");
        Long destinationGroupId = jsonCommand.longValueOfParameterNamed("destinationGroupId");
        LocalDate transferDate = jsonCommand.localDateValueOfParameterNamed("transferDate");
        if (staffId != null) {
            staff = this.staffRepositoryWrapper.findByOfficeHierarchyWithNotFoundDetection(staffId, destinationOffice.getHierarchy());
        }
        if (transferEventType.isAcceptance() && destinationGroupId != null) {
            destinationGroup = this.groupRepository.findByOfficeWithNotFoundDetection(destinationGroupId, destinationOffice);
        }
        if (this.loanRepositoryWrapper.doNonClosedLoanAccountsExistForClient((Long)client.getId())) {
            for (Loan loan : this.loanRepositoryWrapper.findLoanByClientId((Long)client.getId())) {
                if (!loan.isDisbursed() || loan.isClosed()) continue;
                switch (1.$SwitchMap$org$apache$fineract$portfolio$transfer$service$TransferEventType[transferEventType.ordinal()]) {
                    case 1: {
                        this.loanWritePlatformService.acceptLoanTransfer(loan, loan.getLastUserTransactionDate(), destinationOffice, staff);
                        break;
                    }
                    case 2: {
                        this.loanWritePlatformService.initiateLoanTransfer(loan, transferDate);
                        break;
                    }
                    case 3: {
                        this.loanWritePlatformService.rejectLoanTransfer(loan);
                        break;
                    }
                    case 4: {
                        this.loanWritePlatformService.withdrawLoanTransfer(loan, loan.getLastUserTransactionDate());
                    }
                }
            }
        }
        if (this.savingsAccountRepositoryWrapper.doNonClosedSavingAccountsExistForClient((Long)client.getId())) {
            for (SavingsAccount savingsAccount : this.savingsAccountRepositoryWrapper.findSavingAccountByClientId((Long)client.getId())) {
                if (!savingsAccount.isActivated() || savingsAccount.isClosed()) continue;
                switch (1.$SwitchMap$org$apache$fineract$portfolio$transfer$service$TransferEventType[transferEventType.ordinal()]) {
                    case 1: {
                        this.savingsAccountWritePlatformService.acceptSavingsTransfer(savingsAccount, savingsAccount.retrieveLastTransactionDate(), destinationOffice, staff);
                        break;
                    }
                    case 2: {
                        this.savingsAccountWritePlatformService.initiateSavingsTransfer(savingsAccount, transferDate);
                        break;
                    }
                    case 3: {
                        this.savingsAccountWritePlatformService.rejectSavingsTransfer(savingsAccount);
                        break;
                    }
                    case 4: {
                        this.savingsAccountWritePlatformService.withdrawSavingsTransfer(savingsAccount, savingsAccount.retrieveLastTransactionDate());
                    }
                }
            }
        }
        switch (1.$SwitchMap$org$apache$fineract$portfolio$transfer$service$TransferEventType[transferEventType.ordinal()]) {
            case 1: {
                client.setStatus(ClientStatus.ACTIVE.getValue());
                client.updateTransferToOffice(null);
                client.updateOffice(destinationOffice);
                client.updateOfficeJoiningDate(client.getProposedTransferDate());
                client.updateProposedTransferDate(null);
                if (client.getGroups().size() == 1) {
                    if (destinationGroup == null) {
                        throw new TransferNotSupportedException(TransferNotSupportedException.TransferNotSupportedReason.CLIENT_DESTINATION_GROUP_NOT_SPECIFIED, new Object[]{client.getId()});
                    }
                    if (!destinationGroup.isActive()) {
                        throw new GroupNotActiveException((Long)destinationGroup.getId());
                    }
                    this.transferClientBetweenGroups((Group)client.getGroups().iterator().next(), client, destinationGroup, Boolean.valueOf(true), staff);
                    break;
                }
                if (client.getGroups().size() == 0 && destinationGroup != null) {
                    client.getGroups().add(destinationGroup);
                    client.updateStaff(destinationGroup.getStaff());
                    if (staff == null) break;
                    client.updateStaff(staff);
                    break;
                }
                if (destinationGroup != null || staff == null) break;
                client.updateStaff(staff);
                break;
            }
            case 2: {
                client.setStatus(ClientStatus.TRANSFER_IN_PROGRESS.getValue());
                client.updateTransferToOffice(destinationOffice);
                client.updateProposedTransferDate(transferDate);
                break;
            }
            case 3: {
                client.setStatus(ClientStatus.TRANSFER_ON_HOLD.getValue());
                client.updateTransferToOffice(null);
                client.updateProposedTransferDate(null);
                break;
            }
            case 4: {
                client.setStatus(ClientStatus.ACTIVE.getValue());
                client.updateTransferToOffice(null);
                client.updateProposedTransferDate(null);
            }
        }
        this.noteWritePlatformService.createAndPersistClientNote(client, jsonCommand);
        this.clientTransferDetailsRepositoryWrapper.save(ClientTransferDetails.instance((Long)((Long)client.getId()), (Long)((Long)client.getOffice().getId()), (Long)((Long)destinationOffice.getId()), (LocalDate)transferDate, (Integer)transferEventType.getValue(), (LocalDate)DateUtils.getBusinessLocalDate(), (Long)((Long)this.context.authenticatedUser().getId())));
    }

    private List<Client> assembleListOfClients(JsonCommand command) {
        JsonArray clientsArray;
        ArrayList<Client> clients = new ArrayList<Client>();
        if (command.parameterExists("clients") && (clientsArray = command.arrayOfParameterNamed("clients")) != null) {
            for (int i = 0; i < clientsArray.size(); ++i) {
                JsonObject jsonObject = clientsArray.get(i).getAsJsonObject();
                if (!jsonObject.has("id")) continue;
                Long id = jsonObject.get("id").getAsLong();
                Client client = this.clientRepositoryWrapper.findOneWithNotFoundDetection(id);
                clients.add(client);
            }
        }
        return clients;
    }

    private void validateClientAwaitingTransferAcceptance(Client client) {
        if (!client.isTransferInProgress()) {
            throw new ClientNotAwaitingTransferApprovalException((Long)client.getId());
        }
    }

    private void validateClientAwaitingTransferAcceptanceOnHold(Client client) {
        if (!client.isTransferInProgressOrOnHold()) {
            throw new ClientNotAwaitingTransferApprovalOrOnHoldException((Long)client.getId());
        }
    }

    @Generated
    public TransferWritePlatformServiceJpaRepositoryImpl(ClientRepositoryWrapper clientRepositoryWrapper, OfficeRepositoryWrapper officeRepository, CalendarInstanceRepository calendarInstanceRepository, GroupRepositoryWrapper groupRepository, LoanWritePlatformService loanWritePlatformService, SavingsAccountWritePlatformService savingsAccountWritePlatformService, LoanRepositoryWrapper loanRepositoryWrapper, SavingsAccountRepositoryWrapper savingsAccountRepositoryWrapper, TransfersDataValidator transfersDataValidator, NoteWritePlatformService noteWritePlatformService, StaffRepositoryWrapper staffRepositoryWrapper, ClientTransferDetailsRepositoryWrapper clientTransferDetailsRepositoryWrapper, PlatformSecurityContext context, LoanOfficerService loanOfficerService) {
        this.clientRepositoryWrapper = clientRepositoryWrapper;
        this.officeRepository = officeRepository;
        this.calendarInstanceRepository = calendarInstanceRepository;
        this.groupRepository = groupRepository;
        this.loanWritePlatformService = loanWritePlatformService;
        this.savingsAccountWritePlatformService = savingsAccountWritePlatformService;
        this.loanRepositoryWrapper = loanRepositoryWrapper;
        this.savingsAccountRepositoryWrapper = savingsAccountRepositoryWrapper;
        this.transfersDataValidator = transfersDataValidator;
        this.noteWritePlatformService = noteWritePlatformService;
        this.staffRepositoryWrapper = staffRepositoryWrapper;
        this.clientTransferDetailsRepositoryWrapper = clientTransferDetailsRepositoryWrapper;
        this.context = context;
        this.loanOfficerService = loanOfficerService;
    }
}

