/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.client.util;

import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.time.Duration;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import org.apache.fineract.client.auth.ApiKeyAuth;
import org.apache.fineract.client.auth.HttpBasicAuth;
import org.apache.fineract.client.services.AccountNumberFormatApi;
import org.apache.fineract.client.services.AccountTransfersApi;
import org.apache.fineract.client.services.AccountingClosureApi;
import org.apache.fineract.client.services.AccountingRulesApi;
import org.apache.fineract.client.services.AdhocQueryApiApi;
import org.apache.fineract.client.services.AuditsApi;
import org.apache.fineract.client.services.AuthenticationHttpBasicApi;
import org.apache.fineract.client.services.BatchApiApi;
import org.apache.fineract.client.services.BusinessDateManagementApi;
import org.apache.fineract.client.services.BusinessStepConfigurationApi;
import org.apache.fineract.client.services.CacheApi;
import org.apache.fineract.client.services.CashierJournalsApi;
import org.apache.fineract.client.services.CashiersApi;
import org.apache.fineract.client.services.CentersApi;
import org.apache.fineract.client.services.ChargesApi;
import org.apache.fineract.client.services.ClientApi;
import org.apache.fineract.client.services.ClientChargesApi;
import org.apache.fineract.client.services.ClientIdentifierApi;
import org.apache.fineract.client.services.ClientSearchV2Api;
import org.apache.fineract.client.services.ClientTransactionApi;
import org.apache.fineract.client.services.ClientsAddressApi;
import org.apache.fineract.client.services.CodeValuesApi;
import org.apache.fineract.client.services.CodesApi;
import org.apache.fineract.client.services.CurrencyApi;
import org.apache.fineract.client.services.DataTablesApi;
import org.apache.fineract.client.services.DefaultApi;
import org.apache.fineract.client.services.DelinquencyRangeAndBucketsManagementApi;
import org.apache.fineract.client.services.DocumentsApiFixed;
import org.apache.fineract.client.services.EntityDataTableApi;
import org.apache.fineract.client.services.EntityFieldConfigurationApi;
import org.apache.fineract.client.services.ExternalAssetOwnerLoanProductAttributesApi;
import org.apache.fineract.client.services.ExternalAssetOwnersApi;
import org.apache.fineract.client.services.ExternalEventConfigurationApi;
import org.apache.fineract.client.services.ExternalServicesApi;
import org.apache.fineract.client.services.FetchAuthenticatedUserDetailsApi;
import org.apache.fineract.client.services.FixedDepositAccountApi;
import org.apache.fineract.client.services.FixedDepositProductApi;
import org.apache.fineract.client.services.FloatingRatesApi;
import org.apache.fineract.client.services.GeneralLedgerAccountApi;
import org.apache.fineract.client.services.GlobalConfigurationApi;
import org.apache.fineract.client.services.GroupsApi;
import org.apache.fineract.client.services.HolidaysApi;
import org.apache.fineract.client.services.HooksApi;
import org.apache.fineract.client.services.ImagesApi;
import org.apache.fineract.client.services.InterestRateChartApi;
import org.apache.fineract.client.services.InterestRateSlabAKAInterestBandsApi;
import org.apache.fineract.client.services.JournalEntriesApi;
import org.apache.fineract.client.services.ListReportMailingJobHistoryApi;
import org.apache.fineract.client.services.LoanAccountLockApi;
import org.apache.fineract.client.services.LoanChargesApi;
import org.apache.fineract.client.services.LoanCobCatchUpApi;
import org.apache.fineract.client.services.LoanCollateralApi;
import org.apache.fineract.client.services.LoanDisbursementDetailsApi;
import org.apache.fineract.client.services.LoanInterestPauseApi;
import org.apache.fineract.client.services.LoanProductsApi;
import org.apache.fineract.client.services.LoanReschedulingApi;
import org.apache.fineract.client.services.LoanTransactionsApi;
import org.apache.fineract.client.services.LoansApi;
import org.apache.fineract.client.services.LoansPointInTimeApi;
import org.apache.fineract.client.services.MakerCheckerOr4EyeFunctionalityApi;
import org.apache.fineract.client.services.MappingFinancialActivitiesToAccountsApi;
import org.apache.fineract.client.services.MixMappingApi;
import org.apache.fineract.client.services.MixReportApi;
import org.apache.fineract.client.services.MixTaxonomyApi;
import org.apache.fineract.client.services.NotesApi;
import org.apache.fineract.client.services.NotificationApi;
import org.apache.fineract.client.services.OfficesApi;
import org.apache.fineract.client.services.PasswordPreferencesApi;
import org.apache.fineract.client.services.PaymentTypeApi;
import org.apache.fineract.client.services.PeriodicAccrualAccountingApi;
import org.apache.fineract.client.services.PermissionsApi;
import org.apache.fineract.client.services.PocketApi;
import org.apache.fineract.client.services.ProvisioningCategoryApi;
import org.apache.fineract.client.services.ProvisioningCriteriaApi;
import org.apache.fineract.client.services.ProvisioningEntriesApi;
import org.apache.fineract.client.services.RecurringDepositAccountApi;
import org.apache.fineract.client.services.RecurringDepositAccountTransactionsApi;
import org.apache.fineract.client.services.RecurringDepositProductApi;
import org.apache.fineract.client.services.ReportMailingJobsApi;
import org.apache.fineract.client.services.ReportsApi;
import org.apache.fineract.client.services.RescheduleLoansApi;
import org.apache.fineract.client.services.RolesApi;
import org.apache.fineract.client.services.RunReportsApi;
import org.apache.fineract.client.services.SavingsAccountApi;
import org.apache.fineract.client.services.SavingsAccountTransactionsApi;
import org.apache.fineract.client.services.SavingsChargesApi;
import org.apache.fineract.client.services.SavingsProductApi;
import org.apache.fineract.client.services.SchedulerApi;
import org.apache.fineract.client.services.SchedulerJobApi;
import org.apache.fineract.client.services.ScoreCardApi;
import org.apache.fineract.client.services.SearchApiApi;
import org.apache.fineract.client.services.SelfAccountTransferApi;
import org.apache.fineract.client.services.SelfAuthenticationApi;
import org.apache.fineract.client.services.SelfClientApi;
import org.apache.fineract.client.services.SelfDividendApi;
import org.apache.fineract.client.services.SelfLoanProductsApi;
import org.apache.fineract.client.services.SelfLoansApi;
import org.apache.fineract.client.services.SelfRunReportApi;
import org.apache.fineract.client.services.SelfSavingsAccountApi;
import org.apache.fineract.client.services.SelfScoreCardApi;
import org.apache.fineract.client.services.SelfServiceRegistrationApi;
import org.apache.fineract.client.services.SelfShareAccountsApi;
import org.apache.fineract.client.services.SelfSpmApi;
import org.apache.fineract.client.services.SelfThirdPartyTransferApi;
import org.apache.fineract.client.services.SelfUserApi;
import org.apache.fineract.client.services.SelfUserDetailsApi;
import org.apache.fineract.client.services.ShareAccountApi;
import org.apache.fineract.client.services.SpmApiLookUpTableApi;
import org.apache.fineract.client.services.SpmSurveysApi;
import org.apache.fineract.client.services.StaffApi;
import org.apache.fineract.client.services.StandingInstructionsApi;
import org.apache.fineract.client.services.StandingInstructionsHistoryApi;
import org.apache.fineract.client.services.TaxComponentsApi;
import org.apache.fineract.client.services.TaxGroupApi;
import org.apache.fineract.client.services.TellerCashManagementApi;
import org.apache.fineract.client.services.UserGeneratedDocumentsApi;
import org.apache.fineract.client.services.UsersApi;
import org.apache.fineract.client.services.WorkingDaysApi;
import org.apache.fineract.client.util.JSON;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.scalars.ScalarsConverterFactory;

public final class FineractClient {
    public static final String DATE_FORMAT = "yyyy-MM-dd";
    private final OkHttpClient okHttpClient;
    private final Retrofit retrofit;
    public final AccountingClosureApi glClosures;
    public final AccountingRulesApi accountingRules;
    public final AccountNumberFormatApi accountNumberFormats;
    public final AccountTransfersApi accountTransfers;
    public final AdhocQueryApiApi adhocQuery;
    public final AuditsApi audits;
    public final AuthenticationHttpBasicApi authentication;
    public final BatchApiApi batches;
    public final BusinessDateManagementApi businessDateManagement;
    public final BusinessStepConfigurationApi businessStepConfiguration;
    public final CacheApi caches;
    public final CashierJournalsApi cashiersJournal;
    public final CashiersApi cashiers;
    public final CentersApi centers;
    public final ChargesApi charges;
    public final ClientApi clients;
    public final ClientSearchV2Api clientSearchV2;
    public final ClientChargesApi clientCharges;
    public final ClientIdentifierApi clientIdentifiers;
    public final ClientsAddressApi clientAddresses;
    public final ClientTransactionApi clientTransactions;
    public final CodesApi codes;
    public final CodeValuesApi codeValues;
    public final CurrencyApi currencies;
    public final DataTablesApi dataTables;
    @Deprecated
    public final DefaultApi legacy;
    public final DocumentsApiFixed documents;
    public final DelinquencyRangeAndBucketsManagementApi delinquencyRangeAndBucketsManagement;
    public final EntityDataTableApi entityDatatableChecks;
    public final EntityFieldConfigurationApi entityFieldConfigurations;
    public final ExternalEventConfigurationApi externalEventConfigurationApi;
    public final ExternalServicesApi externalServices;
    public final FetchAuthenticatedUserDetailsApi userDetails;
    public final FixedDepositAccountApi fixedDepositAccounts;
    public final FixedDepositProductApi fixedDepositProducts;
    public final FloatingRatesApi floatingRates;
    public final GeneralLedgerAccountApi glAccounts;
    public final GlobalConfigurationApi globalConfigurations;
    public final GroupsApi groups;
    public final HolidaysApi holidays;
    public final HooksApi hooks;
    public final ImagesApi images;
    public final InterestRateChartApi interestRateCharts;
    public final InterestRateSlabAKAInterestBandsApi interestRateChartLabs;
    public final JournalEntriesApi journalEntries;
    public final ListReportMailingJobHistoryApi reportMailings;
    public final LoanChargesApi loanCharges;
    public final LoanCobCatchUpApi loanCobCatchUpApi;
    public final LoanCollateralApi loanCollaterals;
    public final LoanProductsApi loanProducts;
    public final LoanReschedulingApi loanSchedules;
    public final LoansPointInTimeApi loansPointInTimeApi;
    public final LoansApi loans;
    public final LoanDisbursementDetailsApi loanDisbursementDetails;
    public final LoanTransactionsApi loanTransactions;
    public final MakerCheckerOr4EyeFunctionalityApi makerCheckers;
    public final MappingFinancialActivitiesToAccountsApi financialActivyAccountMappings;
    public final MixMappingApi mixMappings;
    public final MixReportApi mixReports;
    public final MixTaxonomyApi mixTaxonomies;
    public final NotesApi notes;
    public final NotificationApi notifications;
    public final OfficesApi offices;
    public final PasswordPreferencesApi passwordPreferences;
    public final PaymentTypeApi paymentTypes;
    public final PeriodicAccrualAccountingApi periodicAccrualAccounting;
    public final PermissionsApi permissions;
    public final PocketApi selfPockets;
    public final ProvisioningCategoryApi provisioningCategories;
    public final ProvisioningCriteriaApi provisioningCriterias;
    public final ProvisioningEntriesApi provisioningEntries;
    public final RecurringDepositAccountApi recurringDepositAccounts;
    public final RecurringDepositAccountTransactionsApi recurringDepositAccountTransactions;
    public final RecurringDepositProductApi recurringDepositProducts;
    public final ReportMailingJobsApi reportMailingJobs;
    public final ReportsApi reports;
    public final RescheduleLoansApi rescheduleLoans;
    public final RolesApi roles;
    public final RunReportsApi reportsRun;
    public final SavingsAccountApi savingsAccounts;
    public final SavingsChargesApi savingsAccountCharges;
    public final SavingsProductApi savingsProducts;
    public final SavingsAccountTransactionsApi savingsTransactions;
    public final SchedulerApi jobsScheduler;
    public final SchedulerJobApi jobs;
    public final ScoreCardApi surveyScorecards;
    public final SearchApiApi search;
    public final SelfAccountTransferApi selfAccountTransfers;
    public final SelfAuthenticationApi selfAuthentication;
    public final SelfClientApi selfClients;
    public final SelfDividendApi selfShareProducts;
    public final SelfLoanProductsApi selfLoanProducts;
    public final SelfLoansApi selfLoans;
    public final SelfRunReportApi selfReportsRun;
    public final SelfSavingsAccountApi selfSavingsAccounts;
    public final SelfScoreCardApi selfSurveyScorecards;
    public final SelfServiceRegistrationApi selfRegistration;
    public final SelfShareAccountsApi selfShareAccounts;
    public final SelfSpmApi selfSurveys;
    public final SelfThirdPartyTransferApi selfThirdPartyBeneficiaries;
    public final SelfUserApi selfUser;
    public final SelfUserDetailsApi selfUserDetails;
    public final ShareAccountApi shareAccounts;
    public final SpmApiLookUpTableApi surveyLookupTables;
    public final SpmSurveysApi surveys;
    public final StaffApi staff;
    public final StandingInstructionsApi standingInstructions;
    public final StandingInstructionsHistoryApi standingInstructionsHistory;
    public final TaxComponentsApi taxComponents;
    public final TaxGroupApi taxGroups;
    public final TellerCashManagementApi tellers;
    public final UserGeneratedDocumentsApi templates;
    public final UsersApi users;
    public final WorkingDaysApi workingDays;
    public final LoanInterestPauseApi loanInterestPauseApi;
    public final ExternalAssetOwnersApi externalAssetOwners;
    public final ExternalAssetOwnerLoanProductAttributesApi externalAssetOwnerLoanProductAttributes;
    public final LoanAccountLockApi loanAccountLockApi;

    private FineractClient(OkHttpClient okHttpClient, Retrofit retrofit) {
        this.okHttpClient = okHttpClient;
        this.retrofit = retrofit;
        this.loanAccountLockApi = (LoanAccountLockApi)retrofit.create(LoanAccountLockApi.class);
        this.externalAssetOwners = (ExternalAssetOwnersApi)retrofit.create(ExternalAssetOwnersApi.class);
        this.externalAssetOwnerLoanProductAttributes = (ExternalAssetOwnerLoanProductAttributesApi)retrofit.create(ExternalAssetOwnerLoanProductAttributesApi.class);
        this.glClosures = (AccountingClosureApi)retrofit.create(AccountingClosureApi.class);
        this.accountingRules = (AccountingRulesApi)retrofit.create(AccountingRulesApi.class);
        this.accountNumberFormats = (AccountNumberFormatApi)retrofit.create(AccountNumberFormatApi.class);
        this.accountTransfers = (AccountTransfersApi)retrofit.create(AccountTransfersApi.class);
        this.adhocQuery = (AdhocQueryApiApi)retrofit.create(AdhocQueryApiApi.class);
        this.audits = (AuditsApi)retrofit.create(AuditsApi.class);
        this.authentication = (AuthenticationHttpBasicApi)retrofit.create(AuthenticationHttpBasicApi.class);
        this.batches = (BatchApiApi)retrofit.create(BatchApiApi.class);
        this.businessDateManagement = (BusinessDateManagementApi)retrofit.create(BusinessDateManagementApi.class);
        this.businessStepConfiguration = (BusinessStepConfigurationApi)retrofit.create(BusinessStepConfigurationApi.class);
        this.externalEventConfigurationApi = (ExternalEventConfigurationApi)retrofit.create(ExternalEventConfigurationApi.class);
        this.caches = (CacheApi)retrofit.create(CacheApi.class);
        this.cashiersJournal = (CashierJournalsApi)retrofit.create(CashierJournalsApi.class);
        this.cashiers = (CashiersApi)retrofit.create(CashiersApi.class);
        this.centers = (CentersApi)retrofit.create(CentersApi.class);
        this.charges = (ChargesApi)retrofit.create(ChargesApi.class);
        this.clients = (ClientApi)retrofit.create(ClientApi.class);
        this.clientSearchV2 = (ClientSearchV2Api)retrofit.create(ClientSearchV2Api.class);
        this.clientCharges = (ClientChargesApi)retrofit.create(ClientChargesApi.class);
        this.clientIdentifiers = (ClientIdentifierApi)retrofit.create(ClientIdentifierApi.class);
        this.clientAddresses = (ClientsAddressApi)retrofit.create(ClientsAddressApi.class);
        this.clientTransactions = (ClientTransactionApi)retrofit.create(ClientTransactionApi.class);
        this.codes = (CodesApi)retrofit.create(CodesApi.class);
        this.codeValues = (CodeValuesApi)retrofit.create(CodeValuesApi.class);
        this.currencies = (CurrencyApi)retrofit.create(CurrencyApi.class);
        this.dataTables = (DataTablesApi)retrofit.create(DataTablesApi.class);
        this.delinquencyRangeAndBucketsManagement = (DelinquencyRangeAndBucketsManagementApi)retrofit.create(DelinquencyRangeAndBucketsManagementApi.class);
        this.legacy = (DefaultApi)retrofit.create(DefaultApi.class);
        this.documents = (DocumentsApiFixed)retrofit.create(DocumentsApiFixed.class);
        this.entityDatatableChecks = (EntityDataTableApi)retrofit.create(EntityDataTableApi.class);
        this.entityFieldConfigurations = (EntityFieldConfigurationApi)retrofit.create(EntityFieldConfigurationApi.class);
        this.externalServices = (ExternalServicesApi)retrofit.create(ExternalServicesApi.class);
        this.userDetails = (FetchAuthenticatedUserDetailsApi)retrofit.create(FetchAuthenticatedUserDetailsApi.class);
        this.fixedDepositAccounts = (FixedDepositAccountApi)retrofit.create(FixedDepositAccountApi.class);
        this.fixedDepositProducts = (FixedDepositProductApi)retrofit.create(FixedDepositProductApi.class);
        this.floatingRates = (FloatingRatesApi)retrofit.create(FloatingRatesApi.class);
        this.glAccounts = (GeneralLedgerAccountApi)retrofit.create(GeneralLedgerAccountApi.class);
        this.globalConfigurations = (GlobalConfigurationApi)retrofit.create(GlobalConfigurationApi.class);
        this.groups = (GroupsApi)retrofit.create(GroupsApi.class);
        this.holidays = (HolidaysApi)retrofit.create(HolidaysApi.class);
        this.hooks = (HooksApi)retrofit.create(HooksApi.class);
        this.images = (ImagesApi)retrofit.create(ImagesApi.class);
        this.interestRateCharts = (InterestRateChartApi)retrofit.create(InterestRateChartApi.class);
        this.interestRateChartLabs = (InterestRateSlabAKAInterestBandsApi)retrofit.create(InterestRateSlabAKAInterestBandsApi.class);
        this.journalEntries = (JournalEntriesApi)retrofit.create(JournalEntriesApi.class);
        this.reportMailings = (ListReportMailingJobHistoryApi)retrofit.create(ListReportMailingJobHistoryApi.class);
        this.loanCharges = (LoanChargesApi)retrofit.create(LoanChargesApi.class);
        this.loanCobCatchUpApi = (LoanCobCatchUpApi)retrofit.create(LoanCobCatchUpApi.class);
        this.loanCollaterals = (LoanCollateralApi)retrofit.create(LoanCollateralApi.class);
        this.loanProducts = (LoanProductsApi)retrofit.create(LoanProductsApi.class);
        this.loanSchedules = (LoanReschedulingApi)retrofit.create(LoanReschedulingApi.class);
        this.loansPointInTimeApi = (LoansPointInTimeApi)retrofit.create(LoansPointInTimeApi.class);
        this.loans = (LoansApi)retrofit.create(LoansApi.class);
        this.loanDisbursementDetails = (LoanDisbursementDetailsApi)retrofit.create(LoanDisbursementDetailsApi.class);
        this.loanTransactions = (LoanTransactionsApi)retrofit.create(LoanTransactionsApi.class);
        this.makerCheckers = (MakerCheckerOr4EyeFunctionalityApi)retrofit.create(MakerCheckerOr4EyeFunctionalityApi.class);
        this.financialActivyAccountMappings = (MappingFinancialActivitiesToAccountsApi)retrofit.create(MappingFinancialActivitiesToAccountsApi.class);
        this.jobs = (SchedulerJobApi)retrofit.create(SchedulerJobApi.class);
        this.mixMappings = (MixMappingApi)retrofit.create(MixMappingApi.class);
        this.mixReports = (MixReportApi)retrofit.create(MixReportApi.class);
        this.mixTaxonomies = (MixTaxonomyApi)retrofit.create(MixTaxonomyApi.class);
        this.notes = (NotesApi)retrofit.create(NotesApi.class);
        this.notifications = (NotificationApi)retrofit.create(NotificationApi.class);
        this.offices = (OfficesApi)retrofit.create(OfficesApi.class);
        this.passwordPreferences = (PasswordPreferencesApi)retrofit.create(PasswordPreferencesApi.class);
        this.paymentTypes = (PaymentTypeApi)retrofit.create(PaymentTypeApi.class);
        this.periodicAccrualAccounting = (PeriodicAccrualAccountingApi)retrofit.create(PeriodicAccrualAccountingApi.class);
        this.permissions = (PermissionsApi)retrofit.create(PermissionsApi.class);
        this.selfPockets = (PocketApi)retrofit.create(PocketApi.class);
        this.provisioningCategories = (ProvisioningCategoryApi)retrofit.create(ProvisioningCategoryApi.class);
        this.provisioningCriterias = (ProvisioningCriteriaApi)retrofit.create(ProvisioningCriteriaApi.class);
        this.provisioningEntries = (ProvisioningEntriesApi)retrofit.create(ProvisioningEntriesApi.class);
        this.recurringDepositAccounts = (RecurringDepositAccountApi)retrofit.create(RecurringDepositAccountApi.class);
        this.recurringDepositAccountTransactions = (RecurringDepositAccountTransactionsApi)retrofit.create(RecurringDepositAccountTransactionsApi.class);
        this.recurringDepositProducts = (RecurringDepositProductApi)retrofit.create(RecurringDepositProductApi.class);
        this.reportMailingJobs = (ReportMailingJobsApi)retrofit.create(ReportMailingJobsApi.class);
        this.reports = (ReportsApi)retrofit.create(ReportsApi.class);
        this.rescheduleLoans = (RescheduleLoansApi)retrofit.create(RescheduleLoansApi.class);
        this.roles = (RolesApi)retrofit.create(RolesApi.class);
        this.reportsRun = (RunReportsApi)retrofit.create(RunReportsApi.class);
        this.savingsAccounts = (SavingsAccountApi)retrofit.create(SavingsAccountApi.class);
        this.savingsAccountCharges = (SavingsChargesApi)retrofit.create(SavingsChargesApi.class);
        this.savingsProducts = (SavingsProductApi)retrofit.create(SavingsProductApi.class);
        this.savingsTransactions = (SavingsAccountTransactionsApi)retrofit.create(SavingsAccountTransactionsApi.class);
        this.jobsScheduler = (SchedulerApi)retrofit.create(SchedulerApi.class);
        this.surveyScorecards = (ScoreCardApi)retrofit.create(ScoreCardApi.class);
        this.search = (SearchApiApi)retrofit.create(SearchApiApi.class);
        this.selfAccountTransfers = (SelfAccountTransferApi)retrofit.create(SelfAccountTransferApi.class);
        this.selfAuthentication = (SelfAuthenticationApi)retrofit.create(SelfAuthenticationApi.class);
        this.selfClients = (SelfClientApi)retrofit.create(SelfClientApi.class);
        this.selfShareProducts = (SelfDividendApi)retrofit.create(SelfDividendApi.class);
        this.selfLoanProducts = (SelfLoanProductsApi)retrofit.create(SelfLoanProductsApi.class);
        this.selfLoans = (SelfLoansApi)retrofit.create(SelfLoansApi.class);
        this.selfReportsRun = (SelfRunReportApi)retrofit.create(SelfRunReportApi.class);
        this.selfSavingsAccounts = (SelfSavingsAccountApi)retrofit.create(SelfSavingsAccountApi.class);
        this.selfSurveyScorecards = (SelfScoreCardApi)retrofit.create(SelfScoreCardApi.class);
        this.selfRegistration = (SelfServiceRegistrationApi)retrofit.create(SelfServiceRegistrationApi.class);
        this.selfShareAccounts = (SelfShareAccountsApi)retrofit.create(SelfShareAccountsApi.class);
        this.selfSurveys = (SelfSpmApi)retrofit.create(SelfSpmApi.class);
        this.selfThirdPartyBeneficiaries = (SelfThirdPartyTransferApi)retrofit.create(SelfThirdPartyTransferApi.class);
        this.selfUser = (SelfUserApi)retrofit.create(SelfUserApi.class);
        this.selfUserDetails = (SelfUserDetailsApi)retrofit.create(SelfUserDetailsApi.class);
        this.shareAccounts = (ShareAccountApi)retrofit.create(ShareAccountApi.class);
        this.surveyLookupTables = (SpmApiLookUpTableApi)retrofit.create(SpmApiLookUpTableApi.class);
        this.surveys = (SpmSurveysApi)retrofit.create(SpmSurveysApi.class);
        this.staff = (StaffApi)retrofit.create(StaffApi.class);
        this.standingInstructions = (StandingInstructionsApi)retrofit.create(StandingInstructionsApi.class);
        this.standingInstructionsHistory = (StandingInstructionsHistoryApi)retrofit.create(StandingInstructionsHistoryApi.class);
        this.taxComponents = (TaxComponentsApi)retrofit.create(TaxComponentsApi.class);
        this.taxGroups = (TaxGroupApi)retrofit.create(TaxGroupApi.class);
        this.tellers = (TellerCashManagementApi)retrofit.create(TellerCashManagementApi.class);
        this.templates = (UserGeneratedDocumentsApi)retrofit.create(UserGeneratedDocumentsApi.class);
        this.users = (UsersApi)retrofit.create(UsersApi.class);
        this.workingDays = (WorkingDaysApi)retrofit.create(WorkingDaysApi.class);
        this.loanInterestPauseApi = (LoanInterestPauseApi)retrofit.create(LoanInterestPauseApi.class);
    }

    public static Builder builder() {
        return new Builder();
    }

    public OkHttpClient okHttpClient() {
        return this.okHttpClient;
    }

    public HttpUrl baseURL() {
        return this.retrofit.baseUrl();
    }

    public <S> S createService(Class<S> serviceClass) {
        return (S)this.retrofit.create(serviceClass);
    }

    public static final class Builder {
        private static final Logger log = LoggerFactory.getLogger(Builder.class);
        private final JSON json = new JSON();
        private final OkHttpClient.Builder okBuilder = new OkHttpClient.Builder();
        private final Retrofit.Builder retrofitBuilder = new Retrofit.Builder().addConverterFactory((Converter.Factory)ScalarsConverterFactory.create()).addConverterFactory((Converter.Factory)JSON.GsonCustomConverterFactory.create(this.json.getGson()));
        private String baseURL;
        private String tenant;
        private String username;
        private String password;

        private Builder() {
        }

        public Builder baseURL(String baseURL) {
            this.baseURL = baseURL;
            return this;
        }

        public Builder tenant(String tenant) {
            this.tenant = tenant;
            return this;
        }

        public Builder basicAuth(String username, String password) {
            this.username = username;
            this.password = password;
            return this;
        }

        public Builder logging(HttpLoggingInterceptor.Level level) {
            HttpLoggingInterceptor logging = new HttpLoggingInterceptor();
            logging.setLevel(level);
            this.okBuilder.addInterceptor((Interceptor)logging);
            return this;
        }

        public Builder readTimeout(Duration timeout) {
            this.okBuilder.readTimeout(timeout);
            return this;
        }

        public Builder insecure(boolean insecure) {
            if (insecure) {
                HostnameVerifier insecureHostnameVerifier = (hostname, session) -> true;
                this.okBuilder.hostnameVerifier(insecureHostnameVerifier);
                try {
                    X509TrustManager insecureX509TrustManager = new X509TrustManager(){

                        @Override
                        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                        }

                        @Override
                        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                        }

                        @Override
                        public X509Certificate[] getAcceptedIssuers() {
                            return new X509Certificate[0];
                        }
                    };
                    SSLContext sslContext = SSLContext.getInstance("SSL");
                    sslContext.init(null, new TrustManager[]{insecureX509TrustManager}, new SecureRandom());
                    SSLSocketFactory insecureSslSocketFactory = sslContext.getSocketFactory();
                    this.okBuilder.sslSocketFactory(insecureSslSocketFactory, insecureX509TrustManager);
                }
                catch (KeyManagementException | NoSuchAlgorithmException e) {
                    throw new IllegalStateException("insecure() SSL configuration failed", e);
                }
            }
            return this;
        }

        public FineractClient build() {
            this.retrofitBuilder.baseUrl(this.has("baseURL", this.baseURL));
            if (this.tenant != null) {
                ApiKeyAuth tenantAuth = new ApiKeyAuth("header", "fineract-platform-tenantid");
                tenantAuth.setApiKey(this.has("tenant", this.tenant));
                this.okBuilder.addInterceptor((Interceptor)tenantAuth);
            } else {
                log.warn("Tenant hasn't been configured for the client");
            }
            if (this.username != null && this.password != null) {
                HttpBasicAuth basicAuth = new HttpBasicAuth();
                basicAuth.setCredentials(this.has("username", this.username), this.has("password", this.password));
                this.okBuilder.addInterceptor((Interceptor)basicAuth);
            } else {
                log.warn("Username and password haven't been configured for the client");
            }
            OkHttpClient okHttpClient = this.okBuilder.build();
            this.retrofitBuilder.client(okHttpClient);
            return new FineractClient(okHttpClient, this.retrofitBuilder.build());
        }

        public Retrofit.Builder getRetrofitBuilder() {
            return this.retrofitBuilder;
        }

        public OkHttpClient.Builder getOkBuilder() {
            return this.okBuilder;
        }

        private <T> T has(String propertyName, T value) throws IllegalStateException {
            if (value == null) {
                throw new IllegalStateException("Must call " + propertyName + "(...) to create valid Builder");
            }
            return value;
        }
    }
}

