/*
 * Apache Fineract REST API
 * Apache Fineract is a secure, multi-tenanted microfinance platform. The goal of the Apache Fineract API is to empower developers to build apps on top of the Apache Fineract Platform. The https://cui.fineract.dev[reference app] (username: mifos, password: password) works on the same demo tenant as the interactive links in this documentation. Until we complete the new REST API documentation you still have the legacy documentation available https://fineract.apache.org/legacy-docs/apiLive.htm[here]. Please check https://fineract.apache.org/docs/current[the Fineract documentation] for more information.
 *
 * The version of the OpenAPI document: 1.11.0
 * Contact: dev@fineract.apache.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.apache.fineract.client.models;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.fineract.client.models.FloatingRatePeriod;

/**
 * FloatingRate
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", comments = "Generator version: 7.8.0")
public class FloatingRate {
  public static final String SERIALIZED_NAME_ACTIVE = "active";
  @SerializedName(SERIALIZED_NAME_ACTIVE)
  private Boolean active;

  public static final String SERIALIZED_NAME_BASE_LENDING_RATE = "baseLendingRate";
  @SerializedName(SERIALIZED_NAME_BASE_LENDING_RATE)
  private Boolean baseLendingRate;

  public static final String SERIALIZED_NAME_CREATED_BY = "createdBy";
  @SerializedName(SERIALIZED_NAME_CREATED_BY)
  private Long createdBy;

  public static final String SERIALIZED_NAME_CREATED_DATE = "createdDate";
  @SerializedName(SERIALIZED_NAME_CREATED_DATE)
  private OffsetDateTime createdDate;

  public static final String SERIALIZED_NAME_FLOATING_RATE_PERIODS = "floatingRatePeriods";
  @SerializedName(SERIALIZED_NAME_FLOATING_RATE_PERIODS)
  private List<FloatingRatePeriod> floatingRatePeriods;

  public static final String SERIALIZED_NAME_ID = "id";
  @SerializedName(SERIALIZED_NAME_ID)
  private Long id;

  public static final String SERIALIZED_NAME_LAST_MODIFIED_BY = "lastModifiedBy";
  @SerializedName(SERIALIZED_NAME_LAST_MODIFIED_BY)
  private Long lastModifiedBy;

  public static final String SERIALIZED_NAME_LAST_MODIFIED_DATE = "lastModifiedDate";
  @SerializedName(SERIALIZED_NAME_LAST_MODIFIED_DATE)
  private OffsetDateTime lastModifiedDate;

  public static final String SERIALIZED_NAME_NAME = "name";
  @SerializedName(SERIALIZED_NAME_NAME)
  private String name;

  public static final String SERIALIZED_NAME_NEW = "new";
  @SerializedName(SERIALIZED_NAME_NEW)
  private Boolean _new;

  public FloatingRate() {
  }

  public FloatingRate active(Boolean active) {
    
    this.active = active;
    return this;
  }

  /**
   * Get active
   * @return active
   */
  @javax.annotation.Nullable

  public Boolean getActive() {
    return active;
  }


  public void setActive(Boolean active) {
    this.active = active;
  }

  public FloatingRate baseLendingRate(Boolean baseLendingRate) {
    
    this.baseLendingRate = baseLendingRate;
    return this;
  }

  /**
   * Get baseLendingRate
   * @return baseLendingRate
   */
  @javax.annotation.Nullable

  public Boolean getBaseLendingRate() {
    return baseLendingRate;
  }


  public void setBaseLendingRate(Boolean baseLendingRate) {
    this.baseLendingRate = baseLendingRate;
  }

  public FloatingRate createdBy(Long createdBy) {
    
    this.createdBy = createdBy;
    return this;
  }

  /**
   * Get createdBy
   * @return createdBy
   */
  @javax.annotation.Nonnull

  public Long getCreatedBy() {
    return createdBy;
  }


  public void setCreatedBy(Long createdBy) {
    this.createdBy = createdBy;
  }

  public FloatingRate createdDate(OffsetDateTime createdDate) {
    
    this.createdDate = createdDate;
    return this;
  }

  /**
   * Get createdDate
   * @return createdDate
   */
  @javax.annotation.Nonnull

  public OffsetDateTime getCreatedDate() {
    return createdDate;
  }


  public void setCreatedDate(OffsetDateTime createdDate) {
    this.createdDate = createdDate;
  }

  public FloatingRate floatingRatePeriods(List<FloatingRatePeriod> floatingRatePeriods) {
    
    this.floatingRatePeriods = floatingRatePeriods;
    return this;
  }

  public FloatingRate addFloatingRatePeriodsItem(FloatingRatePeriod floatingRatePeriodsItem) {
    if (this.floatingRatePeriods == null) {
      this.floatingRatePeriods = new ArrayList<>();
    }
    this.floatingRatePeriods.add(floatingRatePeriodsItem);
    return this;
  }

  /**
   * Get floatingRatePeriods
   * @return floatingRatePeriods
   */
  @javax.annotation.Nullable

  public List<FloatingRatePeriod> getFloatingRatePeriods() {
    return floatingRatePeriods;
  }


  public void setFloatingRatePeriods(List<FloatingRatePeriod> floatingRatePeriods) {
    this.floatingRatePeriods = floatingRatePeriods;
  }

  public FloatingRate id(Long id) {
    
    this.id = id;
    return this;
  }

  /**
   * Get id
   * @return id
   */
  @javax.annotation.Nullable

  public Long getId() {
    return id;
  }


  public void setId(Long id) {
    this.id = id;
  }

  public FloatingRate lastModifiedBy(Long lastModifiedBy) {
    
    this.lastModifiedBy = lastModifiedBy;
    return this;
  }

  /**
   * Get lastModifiedBy
   * @return lastModifiedBy
   */
  @javax.annotation.Nonnull

  public Long getLastModifiedBy() {
    return lastModifiedBy;
  }


  public void setLastModifiedBy(Long lastModifiedBy) {
    this.lastModifiedBy = lastModifiedBy;
  }

  public FloatingRate lastModifiedDate(OffsetDateTime lastModifiedDate) {
    
    this.lastModifiedDate = lastModifiedDate;
    return this;
  }

  /**
   * Get lastModifiedDate
   * @return lastModifiedDate
   */
  @javax.annotation.Nonnull

  public OffsetDateTime getLastModifiedDate() {
    return lastModifiedDate;
  }


  public void setLastModifiedDate(OffsetDateTime lastModifiedDate) {
    this.lastModifiedDate = lastModifiedDate;
  }

  public FloatingRate name(String name) {
    
    this.name = name;
    return this;
  }

  /**
   * Get name
   * @return name
   */
  @javax.annotation.Nullable

  public String getName() {
    return name;
  }


  public void setName(String name) {
    this.name = name;
  }

  public FloatingRate _new(Boolean _new) {
    
    this._new = _new;
    return this;
  }

  /**
   * Get _new
   * @return _new
   */
  @javax.annotation.Nullable

  public Boolean getNew() {
    return _new;
  }


  public void setNew(Boolean _new) {
    this._new = _new;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    FloatingRate floatingRate = (FloatingRate) o;
    return Objects.equals(this.active, floatingRate.active) &&
        Objects.equals(this.baseLendingRate, floatingRate.baseLendingRate) &&
        Objects.equals(this.createdBy, floatingRate.createdBy) &&
        Objects.equals(this.createdDate, floatingRate.createdDate) &&
        Objects.equals(this.floatingRatePeriods, floatingRate.floatingRatePeriods) &&
        Objects.equals(this.id, floatingRate.id) &&
        Objects.equals(this.lastModifiedBy, floatingRate.lastModifiedBy) &&
        Objects.equals(this.lastModifiedDate, floatingRate.lastModifiedDate) &&
        Objects.equals(this.name, floatingRate.name) &&
        Objects.equals(this._new, floatingRate._new);
  }

  @Override
  public int hashCode() {
    return Objects.hash(active, baseLendingRate, createdBy, createdDate, floatingRatePeriods, id, lastModifiedBy, lastModifiedDate, name, _new);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class FloatingRate {\n");
    sb.append("    active: ").append(toIndentedString(active)).append("\n");
    sb.append("    baseLendingRate: ").append(toIndentedString(baseLendingRate)).append("\n");
    sb.append("    createdBy: ").append(toIndentedString(createdBy)).append("\n");
    sb.append("    createdDate: ").append(toIndentedString(createdDate)).append("\n");
    sb.append("    floatingRatePeriods: ").append(toIndentedString(floatingRatePeriods)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    lastModifiedBy: ").append(toIndentedString(lastModifiedBy)).append("\n");
    sb.append("    lastModifiedDate: ").append(toIndentedString(lastModifiedDate)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    _new: ").append(toIndentedString(_new)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

