/*
 * Apache Fineract REST API
 * Apache Fineract is a secure, multi-tenanted microfinance platform. The goal of the Apache Fineract API is to empower developers to build apps on top of the Apache Fineract Platform. The https://cui.fineract.dev[reference app] (username: mifos, password: password) works on the same demo tenant as the interactive links in this documentation. Until we complete the new REST API documentation you still have the legacy documentation available https://fineract.apache.org/legacy-docs/apiLive.htm[here]. Please check https://fineract.apache.org/docs/current[the Fineract documentation] for more information.
 *
 * The version of the OpenAPI document: 1.11.0
 * Contact: dev@fineract.apache.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.apache.fineract.client.models;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.Map;
import org.apache.fineract.client.models.ExternalId;

/**
 * InteropTransactionData
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", comments = "Generator version: 7.8.0")
public class InteropTransactionData {
  public static final String SERIALIZED_NAME_ACCOUNT_BALANCE = "accountBalance";
  @SerializedName(SERIALIZED_NAME_ACCOUNT_BALANCE)
  private BigDecimal accountBalance;

  public static final String SERIALIZED_NAME_ACCOUNT_ID = "accountId";
  @SerializedName(SERIALIZED_NAME_ACCOUNT_ID)
  private String accountId;

  public static final String SERIALIZED_NAME_AMOUNT = "amount";
  @SerializedName(SERIALIZED_NAME_AMOUNT)
  private BigDecimal amount;

  public static final String SERIALIZED_NAME_BOOKING_DATE_TIME = "bookingDateTime";
  @SerializedName(SERIALIZED_NAME_BOOKING_DATE_TIME)
  private LocalDate bookingDateTime;

  public static final String SERIALIZED_NAME_CHANGES = "changes";
  @SerializedName(SERIALIZED_NAME_CHANGES)
  private Map<String, Object> changes;

  public static final String SERIALIZED_NAME_CHARGE_AMOUNT = "chargeAmount";
  @SerializedName(SERIALIZED_NAME_CHARGE_AMOUNT)
  private BigDecimal chargeAmount;

  public static final String SERIALIZED_NAME_CLIENT_ID = "clientId";
  @SerializedName(SERIALIZED_NAME_CLIENT_ID)
  private Long clientId;

  public static final String SERIALIZED_NAME_COMMAND_ID = "commandId";
  @SerializedName(SERIALIZED_NAME_COMMAND_ID)
  private Long commandId;

  public static final String SERIALIZED_NAME_CREDIT_BUREAU_REPORT_DATA = "creditBureauReportData";
  @SerializedName(SERIALIZED_NAME_CREDIT_BUREAU_REPORT_DATA)
  private Map<String, Object> creditBureauReportData;

  public static final String SERIALIZED_NAME_CURRENCY = "currency";
  @SerializedName(SERIALIZED_NAME_CURRENCY)
  private String currency;

  public static final String SERIALIZED_NAME_GLIM_ID = "glimId";
  @SerializedName(SERIALIZED_NAME_GLIM_ID)
  private Long glimId;

  public static final String SERIALIZED_NAME_GROUP_ID = "groupId";
  @SerializedName(SERIALIZED_NAME_GROUP_ID)
  private Long groupId;

  public static final String SERIALIZED_NAME_GSIM_ID = "gsimId";
  @SerializedName(SERIALIZED_NAME_GSIM_ID)
  private Long gsimId;

  public static final String SERIALIZED_NAME_LOAN_EXTERNAL_ID = "loanExternalId";
  @SerializedName(SERIALIZED_NAME_LOAN_EXTERNAL_ID)
  private ExternalId loanExternalId;

  public static final String SERIALIZED_NAME_LOAN_ID = "loanId";
  @SerializedName(SERIALIZED_NAME_LOAN_ID)
  private Long loanId;

  public static final String SERIALIZED_NAME_NOTE = "note";
  @SerializedName(SERIALIZED_NAME_NOTE)
  private String note;

  public static final String SERIALIZED_NAME_OFFICE_ID = "officeId";
  @SerializedName(SERIALIZED_NAME_OFFICE_ID)
  private Long officeId;

  public static final String SERIALIZED_NAME_PRODUCT_ID = "productId";
  @SerializedName(SERIALIZED_NAME_PRODUCT_ID)
  private Long productId;

  public static final String SERIALIZED_NAME_RESOURCE_EXTERNAL_ID = "resourceExternalId";
  @SerializedName(SERIALIZED_NAME_RESOURCE_EXTERNAL_ID)
  private ExternalId resourceExternalId;

  public static final String SERIALIZED_NAME_RESOURCE_ID = "resourceId";
  @SerializedName(SERIALIZED_NAME_RESOURCE_ID)
  private Long resourceId;

  public static final String SERIALIZED_NAME_RESOURCE_IDENTIFIER = "resourceIdentifier";
  @SerializedName(SERIALIZED_NAME_RESOURCE_IDENTIFIER)
  private String resourceIdentifier;

  public static final String SERIALIZED_NAME_ROLLBACK_TRANSACTION = "rollbackTransaction";
  @SerializedName(SERIALIZED_NAME_ROLLBACK_TRANSACTION)
  private Boolean rollbackTransaction;

  public static final String SERIALIZED_NAME_SAVING_TRANSACTION_ID = "savingTransactionId";
  @SerializedName(SERIALIZED_NAME_SAVING_TRANSACTION_ID)
  private String savingTransactionId;

  public static final String SERIALIZED_NAME_SAVINGS_ID = "savingsId";
  @SerializedName(SERIALIZED_NAME_SAVINGS_ID)
  private Long savingsId;

  public static final String SERIALIZED_NAME_SUB_RESOURCE_EXTERNAL_ID = "subResourceExternalId";
  @SerializedName(SERIALIZED_NAME_SUB_RESOURCE_EXTERNAL_ID)
  private ExternalId subResourceExternalId;

  public static final String SERIALIZED_NAME_SUB_RESOURCE_ID = "subResourceId";
  @SerializedName(SERIALIZED_NAME_SUB_RESOURCE_ID)
  private Long subResourceId;

  public static final String SERIALIZED_NAME_TRANSACTION_ID = "transactionId";
  @SerializedName(SERIALIZED_NAME_TRANSACTION_ID)
  private String transactionId;

  /**
   * Gets or Sets transactionType
   */
  @JsonAdapter(TransactionTypeEnum.Adapter.class)
  public enum TransactionTypeEnum {
    INVALID("INVALID"),
    
    DEPOSIT("DEPOSIT"),
    
    WITHDRAWAL("WITHDRAWAL"),
    
    INTEREST_POSTING("INTEREST_POSTING"),
    
    WITHDRAWAL_FEE("WITHDRAWAL_FEE"),
    
    ANNUAL_FEE("ANNUAL_FEE"),
    
    WAIVE_CHARGES("WAIVE_CHARGES"),
    
    PAY_CHARGE("PAY_CHARGE"),
    
    DIVIDEND_PAYOUT("DIVIDEND_PAYOUT"),
    
    ACCRUAL("ACCRUAL"),
    
    INITIATE_TRANSFER("INITIATE_TRANSFER"),
    
    APPROVE_TRANSFER("APPROVE_TRANSFER"),
    
    WITHDRAW_TRANSFER("WITHDRAW_TRANSFER"),
    
    REJECT_TRANSFER("REJECT_TRANSFER"),
    
    WRITTEN_OFF("WRITTEN_OFF"),
    
    OVERDRAFT_INTEREST("OVERDRAFT_INTEREST"),
    
    WITHHOLD_TAX("WITHHOLD_TAX"),
    
    ESCHEAT("ESCHEAT"),
    
    AMOUNT_HOLD("AMOUNT_HOLD"),
    
    AMOUNT_RELEASE("AMOUNT_RELEASE");

    private String value;

    TransactionTypeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static TransactionTypeEnum fromValue(String value) {
      for (TransactionTypeEnum b : TransactionTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<TransactionTypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final TransactionTypeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public TransactionTypeEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return TransactionTypeEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_TRANSACTION_TYPE = "transactionType";
  @SerializedName(SERIALIZED_NAME_TRANSACTION_TYPE)
  private TransactionTypeEnum transactionType;

  public static final String SERIALIZED_NAME_VALUE_DATE_TIME = "valueDateTime";
  @SerializedName(SERIALIZED_NAME_VALUE_DATE_TIME)
  private LocalDate valueDateTime;

  public InteropTransactionData() {
  }

  public InteropTransactionData accountBalance(BigDecimal accountBalance) {
    
    this.accountBalance = accountBalance;
    return this;
  }

  /**
   * Get accountBalance
   * @return accountBalance
   */
  @javax.annotation.Nonnull

  public BigDecimal getAccountBalance() {
    return accountBalance;
  }


  public void setAccountBalance(BigDecimal accountBalance) {
    this.accountBalance = accountBalance;
  }

  public InteropTransactionData accountId(String accountId) {
    
    this.accountId = accountId;
    return this;
  }

  /**
   * Get accountId
   * @return accountId
   */
  @javax.annotation.Nonnull

  public String getAccountId() {
    return accountId;
  }


  public void setAccountId(String accountId) {
    this.accountId = accountId;
  }

  public InteropTransactionData amount(BigDecimal amount) {
    
    this.amount = amount;
    return this;
  }

  /**
   * Get amount
   * @return amount
   */
  @javax.annotation.Nonnull

  public BigDecimal getAmount() {
    return amount;
  }


  public void setAmount(BigDecimal amount) {
    this.amount = amount;
  }

  public InteropTransactionData bookingDateTime(LocalDate bookingDateTime) {
    
    this.bookingDateTime = bookingDateTime;
    return this;
  }

  /**
   * Get bookingDateTime
   * @return bookingDateTime
   */
  @javax.annotation.Nonnull

  public LocalDate getBookingDateTime() {
    return bookingDateTime;
  }


  public void setBookingDateTime(LocalDate bookingDateTime) {
    this.bookingDateTime = bookingDateTime;
  }

  public InteropTransactionData changes(Map<String, Object> changes) {
    
    this.changes = changes;
    return this;
  }

  public InteropTransactionData putChangesItem(String key, Object changesItem) {
    if (this.changes == null) {
      this.changes = new HashMap<>();
    }
    this.changes.put(key, changesItem);
    return this;
  }

  /**
   * Get changes
   * @return changes
   */
  @javax.annotation.Nullable

  public Map<String, Object> getChanges() {
    return changes;
  }


  public void setChanges(Map<String, Object> changes) {
    this.changes = changes;
  }

  public InteropTransactionData chargeAmount(BigDecimal chargeAmount) {
    
    this.chargeAmount = chargeAmount;
    return this;
  }

  /**
   * Get chargeAmount
   * @return chargeAmount
   */
  @javax.annotation.Nullable

  public BigDecimal getChargeAmount() {
    return chargeAmount;
  }


  public void setChargeAmount(BigDecimal chargeAmount) {
    this.chargeAmount = chargeAmount;
  }

  public InteropTransactionData clientId(Long clientId) {
    
    this.clientId = clientId;
    return this;
  }

  /**
   * Get clientId
   * @return clientId
   */
  @javax.annotation.Nullable

  public Long getClientId() {
    return clientId;
  }


  public void setClientId(Long clientId) {
    this.clientId = clientId;
  }

  public InteropTransactionData commandId(Long commandId) {
    
    this.commandId = commandId;
    return this;
  }

  /**
   * Get commandId
   * @return commandId
   */
  @javax.annotation.Nullable

  public Long getCommandId() {
    return commandId;
  }


  public void setCommandId(Long commandId) {
    this.commandId = commandId;
  }

  public InteropTransactionData creditBureauReportData(Map<String, Object> creditBureauReportData) {
    
    this.creditBureauReportData = creditBureauReportData;
    return this;
  }

  public InteropTransactionData putCreditBureauReportDataItem(String key, Object creditBureauReportDataItem) {
    if (this.creditBureauReportData == null) {
      this.creditBureauReportData = new HashMap<>();
    }
    this.creditBureauReportData.put(key, creditBureauReportDataItem);
    return this;
  }

  /**
   * Get creditBureauReportData
   * @return creditBureauReportData
   */
  @javax.annotation.Nullable

  public Map<String, Object> getCreditBureauReportData() {
    return creditBureauReportData;
  }


  public void setCreditBureauReportData(Map<String, Object> creditBureauReportData) {
    this.creditBureauReportData = creditBureauReportData;
  }

  public InteropTransactionData currency(String currency) {
    
    this.currency = currency;
    return this;
  }

  /**
   * Get currency
   * @return currency
   */
  @javax.annotation.Nonnull

  public String getCurrency() {
    return currency;
  }


  public void setCurrency(String currency) {
    this.currency = currency;
  }

  public InteropTransactionData glimId(Long glimId) {
    
    this.glimId = glimId;
    return this;
  }

  /**
   * Get glimId
   * @return glimId
   */
  @javax.annotation.Nullable

  public Long getGlimId() {
    return glimId;
  }


  public void setGlimId(Long glimId) {
    this.glimId = glimId;
  }

  public InteropTransactionData groupId(Long groupId) {
    
    this.groupId = groupId;
    return this;
  }

  /**
   * Get groupId
   * @return groupId
   */
  @javax.annotation.Nullable

  public Long getGroupId() {
    return groupId;
  }


  public void setGroupId(Long groupId) {
    this.groupId = groupId;
  }

  public InteropTransactionData gsimId(Long gsimId) {
    
    this.gsimId = gsimId;
    return this;
  }

  /**
   * Get gsimId
   * @return gsimId
   */
  @javax.annotation.Nullable

  public Long getGsimId() {
    return gsimId;
  }


  public void setGsimId(Long gsimId) {
    this.gsimId = gsimId;
  }

  public InteropTransactionData loanExternalId(ExternalId loanExternalId) {
    
    this.loanExternalId = loanExternalId;
    return this;
  }

  /**
   * Get loanExternalId
   * @return loanExternalId
   */
  @javax.annotation.Nullable

  public ExternalId getLoanExternalId() {
    return loanExternalId;
  }


  public void setLoanExternalId(ExternalId loanExternalId) {
    this.loanExternalId = loanExternalId;
  }

  public InteropTransactionData loanId(Long loanId) {
    
    this.loanId = loanId;
    return this;
  }

  /**
   * Get loanId
   * @return loanId
   */
  @javax.annotation.Nullable

  public Long getLoanId() {
    return loanId;
  }


  public void setLoanId(Long loanId) {
    this.loanId = loanId;
  }

  public InteropTransactionData note(String note) {
    
    this.note = note;
    return this;
  }

  /**
   * Get note
   * @return note
   */
  @javax.annotation.Nullable

  public String getNote() {
    return note;
  }


  public void setNote(String note) {
    this.note = note;
  }

  public InteropTransactionData officeId(Long officeId) {
    
    this.officeId = officeId;
    return this;
  }

  /**
   * Get officeId
   * @return officeId
   */
  @javax.annotation.Nullable

  public Long getOfficeId() {
    return officeId;
  }


  public void setOfficeId(Long officeId) {
    this.officeId = officeId;
  }

  public InteropTransactionData productId(Long productId) {
    
    this.productId = productId;
    return this;
  }

  /**
   * Get productId
   * @return productId
   */
  @javax.annotation.Nullable

  public Long getProductId() {
    return productId;
  }


  public void setProductId(Long productId) {
    this.productId = productId;
  }

  public InteropTransactionData resourceExternalId(ExternalId resourceExternalId) {
    
    this.resourceExternalId = resourceExternalId;
    return this;
  }

  /**
   * Get resourceExternalId
   * @return resourceExternalId
   */
  @javax.annotation.Nullable

  public ExternalId getResourceExternalId() {
    return resourceExternalId;
  }


  public void setResourceExternalId(ExternalId resourceExternalId) {
    this.resourceExternalId = resourceExternalId;
  }

  public InteropTransactionData resourceId(Long resourceId) {
    
    this.resourceId = resourceId;
    return this;
  }

  /**
   * Get resourceId
   * @return resourceId
   */
  @javax.annotation.Nullable

  public Long getResourceId() {
    return resourceId;
  }


  public void setResourceId(Long resourceId) {
    this.resourceId = resourceId;
  }

  public InteropTransactionData resourceIdentifier(String resourceIdentifier) {
    
    this.resourceIdentifier = resourceIdentifier;
    return this;
  }

  /**
   * Get resourceIdentifier
   * @return resourceIdentifier
   */
  @javax.annotation.Nullable

  public String getResourceIdentifier() {
    return resourceIdentifier;
  }


  public void setResourceIdentifier(String resourceIdentifier) {
    this.resourceIdentifier = resourceIdentifier;
  }

  public InteropTransactionData rollbackTransaction(Boolean rollbackTransaction) {
    
    this.rollbackTransaction = rollbackTransaction;
    return this;
  }

  /**
   * Get rollbackTransaction
   * @return rollbackTransaction
   */
  @javax.annotation.Nullable

  public Boolean getRollbackTransaction() {
    return rollbackTransaction;
  }


  public void setRollbackTransaction(Boolean rollbackTransaction) {
    this.rollbackTransaction = rollbackTransaction;
  }

  public InteropTransactionData savingTransactionId(String savingTransactionId) {
    
    this.savingTransactionId = savingTransactionId;
    return this;
  }

  /**
   * Get savingTransactionId
   * @return savingTransactionId
   */
  @javax.annotation.Nonnull

  public String getSavingTransactionId() {
    return savingTransactionId;
  }


  public void setSavingTransactionId(String savingTransactionId) {
    this.savingTransactionId = savingTransactionId;
  }

  public InteropTransactionData savingsId(Long savingsId) {
    
    this.savingsId = savingsId;
    return this;
  }

  /**
   * Get savingsId
   * @return savingsId
   */
  @javax.annotation.Nullable

  public Long getSavingsId() {
    return savingsId;
  }


  public void setSavingsId(Long savingsId) {
    this.savingsId = savingsId;
  }

  public InteropTransactionData subResourceExternalId(ExternalId subResourceExternalId) {
    
    this.subResourceExternalId = subResourceExternalId;
    return this;
  }

  /**
   * Get subResourceExternalId
   * @return subResourceExternalId
   */
  @javax.annotation.Nullable

  public ExternalId getSubResourceExternalId() {
    return subResourceExternalId;
  }


  public void setSubResourceExternalId(ExternalId subResourceExternalId) {
    this.subResourceExternalId = subResourceExternalId;
  }

  public InteropTransactionData subResourceId(Long subResourceId) {
    
    this.subResourceId = subResourceId;
    return this;
  }

  /**
   * Get subResourceId
   * @return subResourceId
   */
  @javax.annotation.Nullable

  public Long getSubResourceId() {
    return subResourceId;
  }


  public void setSubResourceId(Long subResourceId) {
    this.subResourceId = subResourceId;
  }

  public InteropTransactionData transactionId(String transactionId) {
    
    this.transactionId = transactionId;
    return this;
  }

  /**
   * Get transactionId
   * @return transactionId
   */
  @javax.annotation.Nullable

  public String getTransactionId() {
    return transactionId;
  }


  public void setTransactionId(String transactionId) {
    this.transactionId = transactionId;
  }

  public InteropTransactionData transactionType(TransactionTypeEnum transactionType) {
    
    this.transactionType = transactionType;
    return this;
  }

  /**
   * Get transactionType
   * @return transactionType
   */
  @javax.annotation.Nonnull

  public TransactionTypeEnum getTransactionType() {
    return transactionType;
  }


  public void setTransactionType(TransactionTypeEnum transactionType) {
    this.transactionType = transactionType;
  }

  public InteropTransactionData valueDateTime(LocalDate valueDateTime) {
    
    this.valueDateTime = valueDateTime;
    return this;
  }

  /**
   * Get valueDateTime
   * @return valueDateTime
   */
  @javax.annotation.Nonnull

  public LocalDate getValueDateTime() {
    return valueDateTime;
  }


  public void setValueDateTime(LocalDate valueDateTime) {
    this.valueDateTime = valueDateTime;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    InteropTransactionData interopTransactionData = (InteropTransactionData) o;
    return Objects.equals(this.accountBalance, interopTransactionData.accountBalance) &&
        Objects.equals(this.accountId, interopTransactionData.accountId) &&
        Objects.equals(this.amount, interopTransactionData.amount) &&
        Objects.equals(this.bookingDateTime, interopTransactionData.bookingDateTime) &&
        Objects.equals(this.changes, interopTransactionData.changes) &&
        Objects.equals(this.chargeAmount, interopTransactionData.chargeAmount) &&
        Objects.equals(this.clientId, interopTransactionData.clientId) &&
        Objects.equals(this.commandId, interopTransactionData.commandId) &&
        Objects.equals(this.creditBureauReportData, interopTransactionData.creditBureauReportData) &&
        Objects.equals(this.currency, interopTransactionData.currency) &&
        Objects.equals(this.glimId, interopTransactionData.glimId) &&
        Objects.equals(this.groupId, interopTransactionData.groupId) &&
        Objects.equals(this.gsimId, interopTransactionData.gsimId) &&
        Objects.equals(this.loanExternalId, interopTransactionData.loanExternalId) &&
        Objects.equals(this.loanId, interopTransactionData.loanId) &&
        Objects.equals(this.note, interopTransactionData.note) &&
        Objects.equals(this.officeId, interopTransactionData.officeId) &&
        Objects.equals(this.productId, interopTransactionData.productId) &&
        Objects.equals(this.resourceExternalId, interopTransactionData.resourceExternalId) &&
        Objects.equals(this.resourceId, interopTransactionData.resourceId) &&
        Objects.equals(this.resourceIdentifier, interopTransactionData.resourceIdentifier) &&
        Objects.equals(this.rollbackTransaction, interopTransactionData.rollbackTransaction) &&
        Objects.equals(this.savingTransactionId, interopTransactionData.savingTransactionId) &&
        Objects.equals(this.savingsId, interopTransactionData.savingsId) &&
        Objects.equals(this.subResourceExternalId, interopTransactionData.subResourceExternalId) &&
        Objects.equals(this.subResourceId, interopTransactionData.subResourceId) &&
        Objects.equals(this.transactionId, interopTransactionData.transactionId) &&
        Objects.equals(this.transactionType, interopTransactionData.transactionType) &&
        Objects.equals(this.valueDateTime, interopTransactionData.valueDateTime);
  }

  @Override
  public int hashCode() {
    return Objects.hash(accountBalance, accountId, amount, bookingDateTime, changes, chargeAmount, clientId, commandId, creditBureauReportData, currency, glimId, groupId, gsimId, loanExternalId, loanId, note, officeId, productId, resourceExternalId, resourceId, resourceIdentifier, rollbackTransaction, savingTransactionId, savingsId, subResourceExternalId, subResourceId, transactionId, transactionType, valueDateTime);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class InteropTransactionData {\n");
    sb.append("    accountBalance: ").append(toIndentedString(accountBalance)).append("\n");
    sb.append("    accountId: ").append(toIndentedString(accountId)).append("\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    bookingDateTime: ").append(toIndentedString(bookingDateTime)).append("\n");
    sb.append("    changes: ").append(toIndentedString(changes)).append("\n");
    sb.append("    chargeAmount: ").append(toIndentedString(chargeAmount)).append("\n");
    sb.append("    clientId: ").append(toIndentedString(clientId)).append("\n");
    sb.append("    commandId: ").append(toIndentedString(commandId)).append("\n");
    sb.append("    creditBureauReportData: ").append(toIndentedString(creditBureauReportData)).append("\n");
    sb.append("    currency: ").append(toIndentedString(currency)).append("\n");
    sb.append("    glimId: ").append(toIndentedString(glimId)).append("\n");
    sb.append("    groupId: ").append(toIndentedString(groupId)).append("\n");
    sb.append("    gsimId: ").append(toIndentedString(gsimId)).append("\n");
    sb.append("    loanExternalId: ").append(toIndentedString(loanExternalId)).append("\n");
    sb.append("    loanId: ").append(toIndentedString(loanId)).append("\n");
    sb.append("    note: ").append(toIndentedString(note)).append("\n");
    sb.append("    officeId: ").append(toIndentedString(officeId)).append("\n");
    sb.append("    productId: ").append(toIndentedString(productId)).append("\n");
    sb.append("    resourceExternalId: ").append(toIndentedString(resourceExternalId)).append("\n");
    sb.append("    resourceId: ").append(toIndentedString(resourceId)).append("\n");
    sb.append("    resourceIdentifier: ").append(toIndentedString(resourceIdentifier)).append("\n");
    sb.append("    rollbackTransaction: ").append(toIndentedString(rollbackTransaction)).append("\n");
    sb.append("    savingTransactionId: ").append(toIndentedString(savingTransactionId)).append("\n");
    sb.append("    savingsId: ").append(toIndentedString(savingsId)).append("\n");
    sb.append("    subResourceExternalId: ").append(toIndentedString(subResourceExternalId)).append("\n");
    sb.append("    subResourceId: ").append(toIndentedString(subResourceId)).append("\n");
    sb.append("    transactionId: ").append(toIndentedString(transactionId)).append("\n");
    sb.append("    transactionType: ").append(toIndentedString(transactionType)).append("\n");
    sb.append("    valueDateTime: ").append(toIndentedString(valueDateTime)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

