/*
 * Apache Fineract REST API
 * Apache Fineract is a secure, multi-tenanted microfinance platform. The goal of the Apache Fineract API is to empower developers to build apps on top of the Apache Fineract Platform. The https://cui.fineract.dev[reference app] (username: mifos, password: password) works on the same demo tenant as the interactive links in this documentation. Until we complete the new REST API documentation you still have the legacy documentation available https://fineract.apache.org/legacy-docs/apiLive.htm[here]. Please check https://fineract.apache.org/docs/current[the Fineract documentation] for more information.
 *
 * The version of the OpenAPI document: 1.11.0
 * Contact: dev@fineract.apache.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.apache.fineract.client.models;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.fineract.client.models.ExtensionData;
import org.apache.fineract.client.models.ExternalId;

/**
 * InteropTransferResponseData
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", comments = "Generator version: 7.8.0")
public class InteropTransferResponseData {
  public static final String SERIALIZED_NAME_CHANGES = "changes";
  @SerializedName(SERIALIZED_NAME_CHANGES)
  private Map<String, Object> changes;

  public static final String SERIALIZED_NAME_CLIENT_ID = "clientId";
  @SerializedName(SERIALIZED_NAME_CLIENT_ID)
  private Long clientId;

  public static final String SERIALIZED_NAME_COMMAND_ID = "commandId";
  @SerializedName(SERIALIZED_NAME_COMMAND_ID)
  private Long commandId;

  public static final String SERIALIZED_NAME_COMPLETED_TIMESTAMP = "completedTimestamp";
  @SerializedName(SERIALIZED_NAME_COMPLETED_TIMESTAMP)
  private String completedTimestamp;

  public static final String SERIALIZED_NAME_CREDIT_BUREAU_REPORT_DATA = "creditBureauReportData";
  @SerializedName(SERIALIZED_NAME_CREDIT_BUREAU_REPORT_DATA)
  private Map<String, Object> creditBureauReportData;

  public static final String SERIALIZED_NAME_EXPIRATION = "expiration";
  @SerializedName(SERIALIZED_NAME_EXPIRATION)
  private String expiration;

  public static final String SERIALIZED_NAME_EXTENSION_LIST = "extensionList";
  @SerializedName(SERIALIZED_NAME_EXTENSION_LIST)
  private List<ExtensionData> extensionList;

  public static final String SERIALIZED_NAME_GLIM_ID = "glimId";
  @SerializedName(SERIALIZED_NAME_GLIM_ID)
  private Long glimId;

  public static final String SERIALIZED_NAME_GROUP_ID = "groupId";
  @SerializedName(SERIALIZED_NAME_GROUP_ID)
  private Long groupId;

  public static final String SERIALIZED_NAME_GSIM_ID = "gsimId";
  @SerializedName(SERIALIZED_NAME_GSIM_ID)
  private Long gsimId;

  public static final String SERIALIZED_NAME_LOAN_EXTERNAL_ID = "loanExternalId";
  @SerializedName(SERIALIZED_NAME_LOAN_EXTERNAL_ID)
  private ExternalId loanExternalId;

  public static final String SERIALIZED_NAME_LOAN_ID = "loanId";
  @SerializedName(SERIALIZED_NAME_LOAN_ID)
  private Long loanId;

  public static final String SERIALIZED_NAME_OFFICE_ID = "officeId";
  @SerializedName(SERIALIZED_NAME_OFFICE_ID)
  private Long officeId;

  public static final String SERIALIZED_NAME_PRODUCT_ID = "productId";
  @SerializedName(SERIALIZED_NAME_PRODUCT_ID)
  private Long productId;

  public static final String SERIALIZED_NAME_RESOURCE_EXTERNAL_ID = "resourceExternalId";
  @SerializedName(SERIALIZED_NAME_RESOURCE_EXTERNAL_ID)
  private ExternalId resourceExternalId;

  public static final String SERIALIZED_NAME_RESOURCE_ID = "resourceId";
  @SerializedName(SERIALIZED_NAME_RESOURCE_ID)
  private Long resourceId;

  public static final String SERIALIZED_NAME_RESOURCE_IDENTIFIER = "resourceIdentifier";
  @SerializedName(SERIALIZED_NAME_RESOURCE_IDENTIFIER)
  private String resourceIdentifier;

  public static final String SERIALIZED_NAME_ROLLBACK_TRANSACTION = "rollbackTransaction";
  @SerializedName(SERIALIZED_NAME_ROLLBACK_TRANSACTION)
  private Boolean rollbackTransaction;

  public static final String SERIALIZED_NAME_SAVINGS_ID = "savingsId";
  @SerializedName(SERIALIZED_NAME_SAVINGS_ID)
  private Long savingsId;

  /**
   * Gets or Sets state
   */
  @JsonAdapter(StateEnum.Adapter.class)
  public enum StateEnum {
    ACCEPTED("ACCEPTED"),
    
    REJECTED("REJECTED");

    private String value;

    StateEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static StateEnum fromValue(String value) {
      for (StateEnum b : StateEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<StateEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final StateEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public StateEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return StateEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_STATE = "state";
  @SerializedName(SERIALIZED_NAME_STATE)
  private StateEnum state;

  public static final String SERIALIZED_NAME_SUB_RESOURCE_EXTERNAL_ID = "subResourceExternalId";
  @SerializedName(SERIALIZED_NAME_SUB_RESOURCE_EXTERNAL_ID)
  private ExternalId subResourceExternalId;

  public static final String SERIALIZED_NAME_SUB_RESOURCE_ID = "subResourceId";
  @SerializedName(SERIALIZED_NAME_SUB_RESOURCE_ID)
  private Long subResourceId;

  public static final String SERIALIZED_NAME_TRANSACTION_CODE = "transactionCode";
  @SerializedName(SERIALIZED_NAME_TRANSACTION_CODE)
  private String transactionCode;

  public static final String SERIALIZED_NAME_TRANSACTION_ID = "transactionId";
  @SerializedName(SERIALIZED_NAME_TRANSACTION_ID)
  private String transactionId;

  public static final String SERIALIZED_NAME_TRANSFER_CODE = "transferCode";
  @SerializedName(SERIALIZED_NAME_TRANSFER_CODE)
  private String transferCode;

  public InteropTransferResponseData() {
  }

  public InteropTransferResponseData changes(Map<String, Object> changes) {
    
    this.changes = changes;
    return this;
  }

  public InteropTransferResponseData putChangesItem(String key, Object changesItem) {
    if (this.changes == null) {
      this.changes = new HashMap<>();
    }
    this.changes.put(key, changesItem);
    return this;
  }

  /**
   * Get changes
   * @return changes
   */
  @javax.annotation.Nullable

  public Map<String, Object> getChanges() {
    return changes;
  }


  public void setChanges(Map<String, Object> changes) {
    this.changes = changes;
  }

  public InteropTransferResponseData clientId(Long clientId) {
    
    this.clientId = clientId;
    return this;
  }

  /**
   * Get clientId
   * @return clientId
   */
  @javax.annotation.Nullable

  public Long getClientId() {
    return clientId;
  }


  public void setClientId(Long clientId) {
    this.clientId = clientId;
  }

  public InteropTransferResponseData commandId(Long commandId) {
    
    this.commandId = commandId;
    return this;
  }

  /**
   * Get commandId
   * @return commandId
   */
  @javax.annotation.Nullable

  public Long getCommandId() {
    return commandId;
  }


  public void setCommandId(Long commandId) {
    this.commandId = commandId;
  }

  public InteropTransferResponseData completedTimestamp(String completedTimestamp) {
    
    this.completedTimestamp = completedTimestamp;
    return this;
  }

  /**
   * Get completedTimestamp
   * @return completedTimestamp
   */
  @javax.annotation.Nullable

  public String getCompletedTimestamp() {
    return completedTimestamp;
  }


  public void setCompletedTimestamp(String completedTimestamp) {
    this.completedTimestamp = completedTimestamp;
  }

  public InteropTransferResponseData creditBureauReportData(Map<String, Object> creditBureauReportData) {
    
    this.creditBureauReportData = creditBureauReportData;
    return this;
  }

  public InteropTransferResponseData putCreditBureauReportDataItem(String key, Object creditBureauReportDataItem) {
    if (this.creditBureauReportData == null) {
      this.creditBureauReportData = new HashMap<>();
    }
    this.creditBureauReportData.put(key, creditBureauReportDataItem);
    return this;
  }

  /**
   * Get creditBureauReportData
   * @return creditBureauReportData
   */
  @javax.annotation.Nullable

  public Map<String, Object> getCreditBureauReportData() {
    return creditBureauReportData;
  }


  public void setCreditBureauReportData(Map<String, Object> creditBureauReportData) {
    this.creditBureauReportData = creditBureauReportData;
  }

  public InteropTransferResponseData expiration(String expiration) {
    
    this.expiration = expiration;
    return this;
  }

  /**
   * Get expiration
   * @return expiration
   */
  @javax.annotation.Nullable

  public String getExpiration() {
    return expiration;
  }


  public void setExpiration(String expiration) {
    this.expiration = expiration;
  }

  public InteropTransferResponseData extensionList(List<ExtensionData> extensionList) {
    
    this.extensionList = extensionList;
    return this;
  }

  public InteropTransferResponseData addExtensionListItem(ExtensionData extensionListItem) {
    if (this.extensionList == null) {
      this.extensionList = new ArrayList<>();
    }
    this.extensionList.add(extensionListItem);
    return this;
  }

  /**
   * Get extensionList
   * @return extensionList
   */
  @javax.annotation.Nullable

  public List<ExtensionData> getExtensionList() {
    return extensionList;
  }


  public void setExtensionList(List<ExtensionData> extensionList) {
    this.extensionList = extensionList;
  }

  public InteropTransferResponseData glimId(Long glimId) {
    
    this.glimId = glimId;
    return this;
  }

  /**
   * Get glimId
   * @return glimId
   */
  @javax.annotation.Nullable

  public Long getGlimId() {
    return glimId;
  }


  public void setGlimId(Long glimId) {
    this.glimId = glimId;
  }

  public InteropTransferResponseData groupId(Long groupId) {
    
    this.groupId = groupId;
    return this;
  }

  /**
   * Get groupId
   * @return groupId
   */
  @javax.annotation.Nullable

  public Long getGroupId() {
    return groupId;
  }


  public void setGroupId(Long groupId) {
    this.groupId = groupId;
  }

  public InteropTransferResponseData gsimId(Long gsimId) {
    
    this.gsimId = gsimId;
    return this;
  }

  /**
   * Get gsimId
   * @return gsimId
   */
  @javax.annotation.Nullable

  public Long getGsimId() {
    return gsimId;
  }


  public void setGsimId(Long gsimId) {
    this.gsimId = gsimId;
  }

  public InteropTransferResponseData loanExternalId(ExternalId loanExternalId) {
    
    this.loanExternalId = loanExternalId;
    return this;
  }

  /**
   * Get loanExternalId
   * @return loanExternalId
   */
  @javax.annotation.Nullable

  public ExternalId getLoanExternalId() {
    return loanExternalId;
  }


  public void setLoanExternalId(ExternalId loanExternalId) {
    this.loanExternalId = loanExternalId;
  }

  public InteropTransferResponseData loanId(Long loanId) {
    
    this.loanId = loanId;
    return this;
  }

  /**
   * Get loanId
   * @return loanId
   */
  @javax.annotation.Nullable

  public Long getLoanId() {
    return loanId;
  }


  public void setLoanId(Long loanId) {
    this.loanId = loanId;
  }

  public InteropTransferResponseData officeId(Long officeId) {
    
    this.officeId = officeId;
    return this;
  }

  /**
   * Get officeId
   * @return officeId
   */
  @javax.annotation.Nullable

  public Long getOfficeId() {
    return officeId;
  }


  public void setOfficeId(Long officeId) {
    this.officeId = officeId;
  }

  public InteropTransferResponseData productId(Long productId) {
    
    this.productId = productId;
    return this;
  }

  /**
   * Get productId
   * @return productId
   */
  @javax.annotation.Nullable

  public Long getProductId() {
    return productId;
  }


  public void setProductId(Long productId) {
    this.productId = productId;
  }

  public InteropTransferResponseData resourceExternalId(ExternalId resourceExternalId) {
    
    this.resourceExternalId = resourceExternalId;
    return this;
  }

  /**
   * Get resourceExternalId
   * @return resourceExternalId
   */
  @javax.annotation.Nullable

  public ExternalId getResourceExternalId() {
    return resourceExternalId;
  }


  public void setResourceExternalId(ExternalId resourceExternalId) {
    this.resourceExternalId = resourceExternalId;
  }

  public InteropTransferResponseData resourceId(Long resourceId) {
    
    this.resourceId = resourceId;
    return this;
  }

  /**
   * Get resourceId
   * @return resourceId
   */
  @javax.annotation.Nullable

  public Long getResourceId() {
    return resourceId;
  }


  public void setResourceId(Long resourceId) {
    this.resourceId = resourceId;
  }

  public InteropTransferResponseData resourceIdentifier(String resourceIdentifier) {
    
    this.resourceIdentifier = resourceIdentifier;
    return this;
  }

  /**
   * Get resourceIdentifier
   * @return resourceIdentifier
   */
  @javax.annotation.Nullable

  public String getResourceIdentifier() {
    return resourceIdentifier;
  }


  public void setResourceIdentifier(String resourceIdentifier) {
    this.resourceIdentifier = resourceIdentifier;
  }

  public InteropTransferResponseData rollbackTransaction(Boolean rollbackTransaction) {
    
    this.rollbackTransaction = rollbackTransaction;
    return this;
  }

  /**
   * Get rollbackTransaction
   * @return rollbackTransaction
   */
  @javax.annotation.Nullable

  public Boolean getRollbackTransaction() {
    return rollbackTransaction;
  }


  public void setRollbackTransaction(Boolean rollbackTransaction) {
    this.rollbackTransaction = rollbackTransaction;
  }

  public InteropTransferResponseData savingsId(Long savingsId) {
    
    this.savingsId = savingsId;
    return this;
  }

  /**
   * Get savingsId
   * @return savingsId
   */
  @javax.annotation.Nullable

  public Long getSavingsId() {
    return savingsId;
  }


  public void setSavingsId(Long savingsId) {
    this.savingsId = savingsId;
  }

  public InteropTransferResponseData state(StateEnum state) {
    
    this.state = state;
    return this;
  }

  /**
   * Get state
   * @return state
   */
  @javax.annotation.Nonnull

  public StateEnum getState() {
    return state;
  }


  public void setState(StateEnum state) {
    this.state = state;
  }

  public InteropTransferResponseData subResourceExternalId(ExternalId subResourceExternalId) {
    
    this.subResourceExternalId = subResourceExternalId;
    return this;
  }

  /**
   * Get subResourceExternalId
   * @return subResourceExternalId
   */
  @javax.annotation.Nullable

  public ExternalId getSubResourceExternalId() {
    return subResourceExternalId;
  }


  public void setSubResourceExternalId(ExternalId subResourceExternalId) {
    this.subResourceExternalId = subResourceExternalId;
  }

  public InteropTransferResponseData subResourceId(Long subResourceId) {
    
    this.subResourceId = subResourceId;
    return this;
  }

  /**
   * Get subResourceId
   * @return subResourceId
   */
  @javax.annotation.Nullable

  public Long getSubResourceId() {
    return subResourceId;
  }


  public void setSubResourceId(Long subResourceId) {
    this.subResourceId = subResourceId;
  }

  public InteropTransferResponseData transactionCode(String transactionCode) {
    
    this.transactionCode = transactionCode;
    return this;
  }

  /**
   * Get transactionCode
   * @return transactionCode
   */
  @javax.annotation.Nonnull

  public String getTransactionCode() {
    return transactionCode;
  }


  public void setTransactionCode(String transactionCode) {
    this.transactionCode = transactionCode;
  }

  public InteropTransferResponseData transactionId(String transactionId) {
    
    this.transactionId = transactionId;
    return this;
  }

  /**
   * Get transactionId
   * @return transactionId
   */
  @javax.annotation.Nullable

  public String getTransactionId() {
    return transactionId;
  }


  public void setTransactionId(String transactionId) {
    this.transactionId = transactionId;
  }

  public InteropTransferResponseData transferCode(String transferCode) {
    
    this.transferCode = transferCode;
    return this;
  }

  /**
   * Get transferCode
   * @return transferCode
   */
  @javax.annotation.Nonnull

  public String getTransferCode() {
    return transferCode;
  }


  public void setTransferCode(String transferCode) {
    this.transferCode = transferCode;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    InteropTransferResponseData interopTransferResponseData = (InteropTransferResponseData) o;
    return Objects.equals(this.changes, interopTransferResponseData.changes) &&
        Objects.equals(this.clientId, interopTransferResponseData.clientId) &&
        Objects.equals(this.commandId, interopTransferResponseData.commandId) &&
        Objects.equals(this.completedTimestamp, interopTransferResponseData.completedTimestamp) &&
        Objects.equals(this.creditBureauReportData, interopTransferResponseData.creditBureauReportData) &&
        Objects.equals(this.expiration, interopTransferResponseData.expiration) &&
        Objects.equals(this.extensionList, interopTransferResponseData.extensionList) &&
        Objects.equals(this.glimId, interopTransferResponseData.glimId) &&
        Objects.equals(this.groupId, interopTransferResponseData.groupId) &&
        Objects.equals(this.gsimId, interopTransferResponseData.gsimId) &&
        Objects.equals(this.loanExternalId, interopTransferResponseData.loanExternalId) &&
        Objects.equals(this.loanId, interopTransferResponseData.loanId) &&
        Objects.equals(this.officeId, interopTransferResponseData.officeId) &&
        Objects.equals(this.productId, interopTransferResponseData.productId) &&
        Objects.equals(this.resourceExternalId, interopTransferResponseData.resourceExternalId) &&
        Objects.equals(this.resourceId, interopTransferResponseData.resourceId) &&
        Objects.equals(this.resourceIdentifier, interopTransferResponseData.resourceIdentifier) &&
        Objects.equals(this.rollbackTransaction, interopTransferResponseData.rollbackTransaction) &&
        Objects.equals(this.savingsId, interopTransferResponseData.savingsId) &&
        Objects.equals(this.state, interopTransferResponseData.state) &&
        Objects.equals(this.subResourceExternalId, interopTransferResponseData.subResourceExternalId) &&
        Objects.equals(this.subResourceId, interopTransferResponseData.subResourceId) &&
        Objects.equals(this.transactionCode, interopTransferResponseData.transactionCode) &&
        Objects.equals(this.transactionId, interopTransferResponseData.transactionId) &&
        Objects.equals(this.transferCode, interopTransferResponseData.transferCode);
  }

  @Override
  public int hashCode() {
    return Objects.hash(changes, clientId, commandId, completedTimestamp, creditBureauReportData, expiration, extensionList, glimId, groupId, gsimId, loanExternalId, loanId, officeId, productId, resourceExternalId, resourceId, resourceIdentifier, rollbackTransaction, savingsId, state, subResourceExternalId, subResourceId, transactionCode, transactionId, transferCode);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class InteropTransferResponseData {\n");
    sb.append("    changes: ").append(toIndentedString(changes)).append("\n");
    sb.append("    clientId: ").append(toIndentedString(clientId)).append("\n");
    sb.append("    commandId: ").append(toIndentedString(commandId)).append("\n");
    sb.append("    completedTimestamp: ").append(toIndentedString(completedTimestamp)).append("\n");
    sb.append("    creditBureauReportData: ").append(toIndentedString(creditBureauReportData)).append("\n");
    sb.append("    expiration: ").append(toIndentedString(expiration)).append("\n");
    sb.append("    extensionList: ").append(toIndentedString(extensionList)).append("\n");
    sb.append("    glimId: ").append(toIndentedString(glimId)).append("\n");
    sb.append("    groupId: ").append(toIndentedString(groupId)).append("\n");
    sb.append("    gsimId: ").append(toIndentedString(gsimId)).append("\n");
    sb.append("    loanExternalId: ").append(toIndentedString(loanExternalId)).append("\n");
    sb.append("    loanId: ").append(toIndentedString(loanId)).append("\n");
    sb.append("    officeId: ").append(toIndentedString(officeId)).append("\n");
    sb.append("    productId: ").append(toIndentedString(productId)).append("\n");
    sb.append("    resourceExternalId: ").append(toIndentedString(resourceExternalId)).append("\n");
    sb.append("    resourceId: ").append(toIndentedString(resourceId)).append("\n");
    sb.append("    resourceIdentifier: ").append(toIndentedString(resourceIdentifier)).append("\n");
    sb.append("    rollbackTransaction: ").append(toIndentedString(rollbackTransaction)).append("\n");
    sb.append("    savingsId: ").append(toIndentedString(savingsId)).append("\n");
    sb.append("    state: ").append(toIndentedString(state)).append("\n");
    sb.append("    subResourceExternalId: ").append(toIndentedString(subResourceExternalId)).append("\n");
    sb.append("    subResourceId: ").append(toIndentedString(subResourceId)).append("\n");
    sb.append("    transactionCode: ").append(toIndentedString(transactionCode)).append("\n");
    sb.append("    transactionId: ").append(toIndentedString(transactionId)).append("\n");
    sb.append("    transferCode: ").append(toIndentedString(transferCode)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

