/*
 * Apache Fineract REST API
 * Apache Fineract is a secure, multi-tenanted microfinance platform. The goal of the Apache Fineract API is to empower developers to build apps on top of the Apache Fineract Platform. The https://cui.fineract.dev[reference app] (username: mifos, password: password) works on the same demo tenant as the interactive links in this documentation. Until we complete the new REST API documentation you still have the legacy documentation available https://fineract.apache.org/legacy-docs/apiLive.htm[here]. Please check https://fineract.apache.org/docs/current[the Fineract documentation] for more information.
 *
 * The version of the OpenAPI document: 1.11.0
 * Contact: dev@fineract.apache.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.apache.fineract.client.models;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.fineract.client.models.LoanProduct;

/**
 * LoanProductPaymentAllocationRule
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", comments = "Generator version: 7.8.0")
public class LoanProductPaymentAllocationRule {
  /**
   * Gets or Sets allocationTypes
   */
  @JsonAdapter(AllocationTypesEnum.Adapter.class)
  public enum AllocationTypesEnum {
    PAST_DUE_PENALTY("PAST_DUE_PENALTY"),
    
    PAST_DUE_FEE("PAST_DUE_FEE"),
    
    PAST_DUE_PRINCIPAL("PAST_DUE_PRINCIPAL"),
    
    PAST_DUE_INTEREST("PAST_DUE_INTEREST"),
    
    DUE_PENALTY("DUE_PENALTY"),
    
    DUE_FEE("DUE_FEE"),
    
    DUE_PRINCIPAL("DUE_PRINCIPAL"),
    
    DUE_INTEREST("DUE_INTEREST"),
    
    IN_ADVANCE_PENALTY("IN_ADVANCE_PENALTY"),
    
    IN_ADVANCE_FEE("IN_ADVANCE_FEE"),
    
    IN_ADVANCE_PRINCIPAL("IN_ADVANCE_PRINCIPAL"),
    
    IN_ADVANCE_INTEREST("IN_ADVANCE_INTEREST");

    private String value;

    AllocationTypesEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static AllocationTypesEnum fromValue(String value) {
      for (AllocationTypesEnum b : AllocationTypesEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<AllocationTypesEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final AllocationTypesEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public AllocationTypesEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return AllocationTypesEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_ALLOCATION_TYPES = "allocationTypes";
  @SerializedName(SERIALIZED_NAME_ALLOCATION_TYPES)
  private List<AllocationTypesEnum> allocationTypes;

  public static final String SERIALIZED_NAME_CREATED_BY = "createdBy";
  @SerializedName(SERIALIZED_NAME_CREATED_BY)
  private Long createdBy;

  public static final String SERIALIZED_NAME_CREATED_DATE = "createdDate";
  @SerializedName(SERIALIZED_NAME_CREATED_DATE)
  private OffsetDateTime createdDate;

  /**
   * Gets or Sets futureInstallmentAllocationRule
   */
  @JsonAdapter(FutureInstallmentAllocationRuleEnum.Adapter.class)
  public enum FutureInstallmentAllocationRuleEnum {
    NEXT_INSTALLMENT("NEXT_INSTALLMENT"),
    
    LAST_INSTALLMENT("LAST_INSTALLMENT"),
    
    REAMORTIZATION("REAMORTIZATION");

    private String value;

    FutureInstallmentAllocationRuleEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static FutureInstallmentAllocationRuleEnum fromValue(String value) {
      for (FutureInstallmentAllocationRuleEnum b : FutureInstallmentAllocationRuleEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<FutureInstallmentAllocationRuleEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final FutureInstallmentAllocationRuleEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public FutureInstallmentAllocationRuleEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return FutureInstallmentAllocationRuleEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_FUTURE_INSTALLMENT_ALLOCATION_RULE = "futureInstallmentAllocationRule";
  @SerializedName(SERIALIZED_NAME_FUTURE_INSTALLMENT_ALLOCATION_RULE)
  private FutureInstallmentAllocationRuleEnum futureInstallmentAllocationRule;

  public static final String SERIALIZED_NAME_ID = "id";
  @SerializedName(SERIALIZED_NAME_ID)
  private Long id;

  public static final String SERIALIZED_NAME_LAST_MODIFIED_BY = "lastModifiedBy";
  @SerializedName(SERIALIZED_NAME_LAST_MODIFIED_BY)
  private Long lastModifiedBy;

  public static final String SERIALIZED_NAME_LAST_MODIFIED_DATE = "lastModifiedDate";
  @SerializedName(SERIALIZED_NAME_LAST_MODIFIED_DATE)
  private OffsetDateTime lastModifiedDate;

  public static final String SERIALIZED_NAME_LOAN_PRODUCT = "loanProduct";
  @SerializedName(SERIALIZED_NAME_LOAN_PRODUCT)
  private LoanProduct loanProduct;

  public static final String SERIALIZED_NAME_NEW = "new";
  @SerializedName(SERIALIZED_NAME_NEW)
  private Boolean _new;

  /**
   * Gets or Sets transactionType
   */
  @JsonAdapter(TransactionTypeEnum.Adapter.class)
  public enum TransactionTypeEnum {
    DEFAULT("DEFAULT"),
    
    REPAYMENT("REPAYMENT"),
    
    DOWN_PAYMENT("DOWN_PAYMENT"),
    
    MERCHANT_ISSUED_REFUND("MERCHANT_ISSUED_REFUND"),
    
    PAYOUT_REFUND("PAYOUT_REFUND"),
    
    GOODWILL_CREDIT("GOODWILL_CREDIT"),
    
    CHARGE_REFUND("CHARGE_REFUND"),
    
    CHARGE_ADJUSTMENT("CHARGE_ADJUSTMENT"),
    
    WAIVE_INTEREST("WAIVE_INTEREST"),
    
    CHARGE_PAYMENT("CHARGE_PAYMENT"),
    
    REFUND_FOR_ACTIVE_LOAN("REFUND_FOR_ACTIVE_LOAN"),
    
    INTEREST_PAYMENT_WAIVER("INTEREST_PAYMENT_WAIVER"),
    
    INTEREST_REFUND("INTEREST_REFUND");

    private String value;

    TransactionTypeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static TransactionTypeEnum fromValue(String value) {
      for (TransactionTypeEnum b : TransactionTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<TransactionTypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final TransactionTypeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public TransactionTypeEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return TransactionTypeEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_TRANSACTION_TYPE = "transactionType";
  @SerializedName(SERIALIZED_NAME_TRANSACTION_TYPE)
  private TransactionTypeEnum transactionType;

  public LoanProductPaymentAllocationRule() {
  }

  public LoanProductPaymentAllocationRule allocationTypes(List<AllocationTypesEnum> allocationTypes) {
    
    this.allocationTypes = allocationTypes;
    return this;
  }

  public LoanProductPaymentAllocationRule addAllocationTypesItem(AllocationTypesEnum allocationTypesItem) {
    if (this.allocationTypes == null) {
      this.allocationTypes = new ArrayList<>();
    }
    this.allocationTypes.add(allocationTypesItem);
    return this;
  }

  /**
   * Get allocationTypes
   * @return allocationTypes
   */
  @javax.annotation.Nullable

  public List<AllocationTypesEnum> getAllocationTypes() {
    return allocationTypes;
  }


  public void setAllocationTypes(List<AllocationTypesEnum> allocationTypes) {
    this.allocationTypes = allocationTypes;
  }

  public LoanProductPaymentAllocationRule createdBy(Long createdBy) {
    
    this.createdBy = createdBy;
    return this;
  }

  /**
   * Get createdBy
   * @return createdBy
   */
  @javax.annotation.Nonnull

  public Long getCreatedBy() {
    return createdBy;
  }


  public void setCreatedBy(Long createdBy) {
    this.createdBy = createdBy;
  }

  public LoanProductPaymentAllocationRule createdDate(OffsetDateTime createdDate) {
    
    this.createdDate = createdDate;
    return this;
  }

  /**
   * Get createdDate
   * @return createdDate
   */
  @javax.annotation.Nonnull

  public OffsetDateTime getCreatedDate() {
    return createdDate;
  }


  public void setCreatedDate(OffsetDateTime createdDate) {
    this.createdDate = createdDate;
  }

  public LoanProductPaymentAllocationRule futureInstallmentAllocationRule(FutureInstallmentAllocationRuleEnum futureInstallmentAllocationRule) {
    
    this.futureInstallmentAllocationRule = futureInstallmentAllocationRule;
    return this;
  }

  /**
   * Get futureInstallmentAllocationRule
   * @return futureInstallmentAllocationRule
   */
  @javax.annotation.Nullable

  public FutureInstallmentAllocationRuleEnum getFutureInstallmentAllocationRule() {
    return futureInstallmentAllocationRule;
  }


  public void setFutureInstallmentAllocationRule(FutureInstallmentAllocationRuleEnum futureInstallmentAllocationRule) {
    this.futureInstallmentAllocationRule = futureInstallmentAllocationRule;
  }

  public LoanProductPaymentAllocationRule id(Long id) {
    
    this.id = id;
    return this;
  }

  /**
   * Get id
   * @return id
   */
  @javax.annotation.Nullable

  public Long getId() {
    return id;
  }


  public void setId(Long id) {
    this.id = id;
  }

  public LoanProductPaymentAllocationRule lastModifiedBy(Long lastModifiedBy) {
    
    this.lastModifiedBy = lastModifiedBy;
    return this;
  }

  /**
   * Get lastModifiedBy
   * @return lastModifiedBy
   */
  @javax.annotation.Nonnull

  public Long getLastModifiedBy() {
    return lastModifiedBy;
  }


  public void setLastModifiedBy(Long lastModifiedBy) {
    this.lastModifiedBy = lastModifiedBy;
  }

  public LoanProductPaymentAllocationRule lastModifiedDate(OffsetDateTime lastModifiedDate) {
    
    this.lastModifiedDate = lastModifiedDate;
    return this;
  }

  /**
   * Get lastModifiedDate
   * @return lastModifiedDate
   */
  @javax.annotation.Nonnull

  public OffsetDateTime getLastModifiedDate() {
    return lastModifiedDate;
  }


  public void setLastModifiedDate(OffsetDateTime lastModifiedDate) {
    this.lastModifiedDate = lastModifiedDate;
  }

  public LoanProductPaymentAllocationRule loanProduct(LoanProduct loanProduct) {
    
    this.loanProduct = loanProduct;
    return this;
  }

  /**
   * Get loanProduct
   * @return loanProduct
   */
  @javax.annotation.Nullable

  public LoanProduct getLoanProduct() {
    return loanProduct;
  }


  public void setLoanProduct(LoanProduct loanProduct) {
    this.loanProduct = loanProduct;
  }

  public LoanProductPaymentAllocationRule _new(Boolean _new) {
    
    this._new = _new;
    return this;
  }

  /**
   * Get _new
   * @return _new
   */
  @javax.annotation.Nullable

  public Boolean getNew() {
    return _new;
  }


  public void setNew(Boolean _new) {
    this._new = _new;
  }

  public LoanProductPaymentAllocationRule transactionType(TransactionTypeEnum transactionType) {
    
    this.transactionType = transactionType;
    return this;
  }

  /**
   * Get transactionType
   * @return transactionType
   */
  @javax.annotation.Nullable

  public TransactionTypeEnum getTransactionType() {
    return transactionType;
  }


  public void setTransactionType(TransactionTypeEnum transactionType) {
    this.transactionType = transactionType;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    LoanProductPaymentAllocationRule loanProductPaymentAllocationRule = (LoanProductPaymentAllocationRule) o;
    return Objects.equals(this.allocationTypes, loanProductPaymentAllocationRule.allocationTypes) &&
        Objects.equals(this.createdBy, loanProductPaymentAllocationRule.createdBy) &&
        Objects.equals(this.createdDate, loanProductPaymentAllocationRule.createdDate) &&
        Objects.equals(this.futureInstallmentAllocationRule, loanProductPaymentAllocationRule.futureInstallmentAllocationRule) &&
        Objects.equals(this.id, loanProductPaymentAllocationRule.id) &&
        Objects.equals(this.lastModifiedBy, loanProductPaymentAllocationRule.lastModifiedBy) &&
        Objects.equals(this.lastModifiedDate, loanProductPaymentAllocationRule.lastModifiedDate) &&
        Objects.equals(this.loanProduct, loanProductPaymentAllocationRule.loanProduct) &&
        Objects.equals(this._new, loanProductPaymentAllocationRule._new) &&
        Objects.equals(this.transactionType, loanProductPaymentAllocationRule.transactionType);
  }

  @Override
  public int hashCode() {
    return Objects.hash(allocationTypes, createdBy, createdDate, futureInstallmentAllocationRule, id, lastModifiedBy, lastModifiedDate, loanProduct, _new, transactionType);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class LoanProductPaymentAllocationRule {\n");
    sb.append("    allocationTypes: ").append(toIndentedString(allocationTypes)).append("\n");
    sb.append("    createdBy: ").append(toIndentedString(createdBy)).append("\n");
    sb.append("    createdDate: ").append(toIndentedString(createdDate)).append("\n");
    sb.append("    futureInstallmentAllocationRule: ").append(toIndentedString(futureInstallmentAllocationRule)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    lastModifiedBy: ").append(toIndentedString(lastModifiedBy)).append("\n");
    sb.append("    lastModifiedDate: ").append(toIndentedString(lastModifiedDate)).append("\n");
    sb.append("    loanProduct: ").append(toIndentedString(loanProduct)).append("\n");
    sb.append("    _new: ").append(toIndentedString(_new)).append("\n");
    sb.append("    transactionType: ").append(toIndentedString(transactionType)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

