/*
 * Apache Fineract REST API
 * Apache Fineract is a secure, multi-tenanted microfinance platform. The goal of the Apache Fineract API is to empower developers to build apps on top of the Apache Fineract Platform. The https://cui.fineract.dev[reference app] (username: mifos, password: password) works on the same demo tenant as the interactive links in this documentation. Until we complete the new REST API documentation you still have the legacy documentation available https://fineract.apache.org/legacy-docs/apiLive.htm[here]. Please check https://fineract.apache.org/docs/current[the Fineract documentation] for more information.
 *
 * The version of the OpenAPI document: 1.11.0
 * Contact: dev@fineract.apache.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.apache.fineract.client.models;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.math.BigDecimal;
import org.apache.fineract.client.models.CurrencyData;
import org.apache.fineract.client.models.MonetaryCurrency;
import org.apache.fineract.client.models.MoneyMc;

/**
 * Money
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", comments = "Generator version: 7.8.0")
public class Money {
  public static final String SERIALIZED_NAME_AMOUNT = "amount";
  @SerializedName(SERIALIZED_NAME_AMOUNT)
  private BigDecimal amount;

  public static final String SERIALIZED_NAME_AMOUNT_DEFAULTED_TO_NULL_IF_ZERO = "amountDefaultedToNullIfZero";
  @SerializedName(SERIALIZED_NAME_AMOUNT_DEFAULTED_TO_NULL_IF_ZERO)
  private BigDecimal amountDefaultedToNullIfZero;

  public static final String SERIALIZED_NAME_CURRENCY = "currency";
  @SerializedName(SERIALIZED_NAME_CURRENCY)
  private MonetaryCurrency currency;

  public static final String SERIALIZED_NAME_CURRENCY_CODE = "currencyCode";
  @SerializedName(SERIALIZED_NAME_CURRENCY_CODE)
  private String currencyCode;

  public static final String SERIALIZED_NAME_CURRENCY_DATA = "currencyData";
  @SerializedName(SERIALIZED_NAME_CURRENCY_DATA)
  private CurrencyData currencyData;

  public static final String SERIALIZED_NAME_GREATER_THAN_ZERO = "greaterThanZero";
  @SerializedName(SERIALIZED_NAME_GREATER_THAN_ZERO)
  private Boolean greaterThanZero;

  public static final String SERIALIZED_NAME_IN_MULTIPLES_OF = "inMultiplesOf";
  @SerializedName(SERIALIZED_NAME_IN_MULTIPLES_OF)
  private Integer inMultiplesOf;

  public static final String SERIALIZED_NAME_LESS_THAN_ZERO = "lessThanZero";
  @SerializedName(SERIALIZED_NAME_LESS_THAN_ZERO)
  private Boolean lessThanZero;

  public static final String SERIALIZED_NAME_MC = "mc";
  @SerializedName(SERIALIZED_NAME_MC)
  private MoneyMc mc;

  public static final String SERIALIZED_NAME_ZERO = "zero";
  @SerializedName(SERIALIZED_NAME_ZERO)
  private Boolean zero;

  public Money() {
  }

  public Money amount(BigDecimal amount) {
    
    this.amount = amount;
    return this;
  }

  /**
   * Get amount
   * @return amount
   */
  @javax.annotation.Nullable

  public BigDecimal getAmount() {
    return amount;
  }


  public void setAmount(BigDecimal amount) {
    this.amount = amount;
  }

  public Money amountDefaultedToNullIfZero(BigDecimal amountDefaultedToNullIfZero) {
    
    this.amountDefaultedToNullIfZero = amountDefaultedToNullIfZero;
    return this;
  }

  /**
   * Get amountDefaultedToNullIfZero
   * @return amountDefaultedToNullIfZero
   */
  @javax.annotation.Nullable

  public BigDecimal getAmountDefaultedToNullIfZero() {
    return amountDefaultedToNullIfZero;
  }


  public void setAmountDefaultedToNullIfZero(BigDecimal amountDefaultedToNullIfZero) {
    this.amountDefaultedToNullIfZero = amountDefaultedToNullIfZero;
  }

  public Money currency(MonetaryCurrency currency) {
    
    this.currency = currency;
    return this;
  }

  /**
   * Get currency
   * @return currency
   */
  @javax.annotation.Nullable

  public MonetaryCurrency getCurrency() {
    return currency;
  }


  public void setCurrency(MonetaryCurrency currency) {
    this.currency = currency;
  }

  public Money currencyCode(String currencyCode) {
    
    this.currencyCode = currencyCode;
    return this;
  }

  /**
   * Get currencyCode
   * @return currencyCode
   */
  @javax.annotation.Nullable

  public String getCurrencyCode() {
    return currencyCode;
  }


  public void setCurrencyCode(String currencyCode) {
    this.currencyCode = currencyCode;
  }

  public Money currencyData(CurrencyData currencyData) {
    
    this.currencyData = currencyData;
    return this;
  }

  /**
   * Get currencyData
   * @return currencyData
   */
  @javax.annotation.Nullable

  public CurrencyData getCurrencyData() {
    return currencyData;
  }


  public void setCurrencyData(CurrencyData currencyData) {
    this.currencyData = currencyData;
  }

  public Money greaterThanZero(Boolean greaterThanZero) {
    
    this.greaterThanZero = greaterThanZero;
    return this;
  }

  /**
   * Get greaterThanZero
   * @return greaterThanZero
   */
  @javax.annotation.Nullable

  public Boolean getGreaterThanZero() {
    return greaterThanZero;
  }


  public void setGreaterThanZero(Boolean greaterThanZero) {
    this.greaterThanZero = greaterThanZero;
  }

  public Money inMultiplesOf(Integer inMultiplesOf) {
    
    this.inMultiplesOf = inMultiplesOf;
    return this;
  }

  /**
   * Get inMultiplesOf
   * @return inMultiplesOf
   */
  @javax.annotation.Nullable

  public Integer getInMultiplesOf() {
    return inMultiplesOf;
  }


  public void setInMultiplesOf(Integer inMultiplesOf) {
    this.inMultiplesOf = inMultiplesOf;
  }

  public Money lessThanZero(Boolean lessThanZero) {
    
    this.lessThanZero = lessThanZero;
    return this;
  }

  /**
   * Get lessThanZero
   * @return lessThanZero
   */
  @javax.annotation.Nullable

  public Boolean getLessThanZero() {
    return lessThanZero;
  }


  public void setLessThanZero(Boolean lessThanZero) {
    this.lessThanZero = lessThanZero;
  }

  public Money mc(MoneyMc mc) {
    
    this.mc = mc;
    return this;
  }

  /**
   * Get mc
   * @return mc
   */
  @javax.annotation.Nullable

  public MoneyMc getMc() {
    return mc;
  }


  public void setMc(MoneyMc mc) {
    this.mc = mc;
  }

  public Money zero(Boolean zero) {
    
    this.zero = zero;
    return this;
  }

  /**
   * Get zero
   * @return zero
   */
  @javax.annotation.Nullable

  public Boolean getZero() {
    return zero;
  }


  public void setZero(Boolean zero) {
    this.zero = zero;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Money money = (Money) o;
    return Objects.equals(this.amount, money.amount) &&
        Objects.equals(this.amountDefaultedToNullIfZero, money.amountDefaultedToNullIfZero) &&
        Objects.equals(this.currency, money.currency) &&
        Objects.equals(this.currencyCode, money.currencyCode) &&
        Objects.equals(this.currencyData, money.currencyData) &&
        Objects.equals(this.greaterThanZero, money.greaterThanZero) &&
        Objects.equals(this.inMultiplesOf, money.inMultiplesOf) &&
        Objects.equals(this.lessThanZero, money.lessThanZero) &&
        Objects.equals(this.mc, money.mc) &&
        Objects.equals(this.zero, money.zero);
  }

  @Override
  public int hashCode() {
    return Objects.hash(amount, amountDefaultedToNullIfZero, currency, currencyCode, currencyData, greaterThanZero, inMultiplesOf, lessThanZero, mc, zero);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Money {\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    amountDefaultedToNullIfZero: ").append(toIndentedString(amountDefaultedToNullIfZero)).append("\n");
    sb.append("    currency: ").append(toIndentedString(currency)).append("\n");
    sb.append("    currencyCode: ").append(toIndentedString(currencyCode)).append("\n");
    sb.append("    currencyData: ").append(toIndentedString(currencyData)).append("\n");
    sb.append("    greaterThanZero: ").append(toIndentedString(greaterThanZero)).append("\n");
    sb.append("    inMultiplesOf: ").append(toIndentedString(inMultiplesOf)).append("\n");
    sb.append("    lessThanZero: ").append(toIndentedString(lessThanZero)).append("\n");
    sb.append("    mc: ").append(toIndentedString(mc)).append("\n");
    sb.append("    zero: ").append(toIndentedString(zero)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

