package org.apache.fineract.client.services;

import org.apache.fineract.client.CollectionFormats.*;

    import retrofit2.Call;
import retrofit2.http.*;

import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import okhttp3.MultipartBody;

import org.apache.fineract.client.models.ExternalOwnerJournalEntryData;
import org.apache.fineract.client.models.ExternalOwnerTransferJournalEntryData;
import org.apache.fineract.client.models.ExternalTransferData;
import org.apache.fineract.client.models.PageExternalTransferData;
import org.apache.fineract.client.models.PagedRequestExternalAssetOwnerSearchRequest;
import org.apache.fineract.client.models.PostInitiateTransferRequest;
import org.apache.fineract.client.models.PostInitiateTransferResponse;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface ExternalAssetOwnersApi {
    /**
    * Retrieve Active Asset Owner Transfer
    * Retrieve Active External Asset Owner Transfer by transferExternalId, loanId or loanExternalId
        * @param transferExternalId transferExternalId (optional)
        * @param loanId loanId (optional)
        * @param loanExternalId loanExternalId (optional)
    * @return Call&lt;ExternalTransferData&gt;
    */
    @GET("v1/external-asset-owners/transfers/active-transfer")
    Call<ExternalTransferData> getActiveTransfer(@retrofit2.http.Query("transferExternalId") String transferExternalId, @retrofit2.http.Query("loanId") Long loanId, @retrofit2.http.Query("loanExternalId") String loanExternalId);

    /**
    * Retrieve Journal Entries of Owner
    * Retrieve Journal entries of owner by owner externalId
        * @param ownerExternalId ownerExternalId (required)
        * @param offset offset (optional)
        * @param limit limit (optional)
    * @return Call&lt;ExternalOwnerJournalEntryData&gt;
    */
    @GET("v1/external-asset-owners/owners/external-id/{ownerExternalId}/journal-entries")
    Call<ExternalOwnerJournalEntryData> getJournalEntriesOfOwner(@retrofit2.http.Path("ownerExternalId") String ownerExternalId, @retrofit2.http.Query("offset") Integer offset, @retrofit2.http.Query("limit") Integer limit);

    /**
    * Retrieve Journal Entries of Transfer
    * Retrieve Journal entries of transfer by transferId
        * @param transferId transferId (required)
        * @param offset offset (optional)
        * @param limit limit (optional)
    * @return Call&lt;ExternalOwnerTransferJournalEntryData&gt;
    */
    @GET("v1/external-asset-owners/transfers/{transferId}/journal-entries")
    Call<ExternalOwnerTransferJournalEntryData> getJournalEntriesOfTransfer(@retrofit2.http.Path("transferId") Long transferId, @retrofit2.http.Query("offset") Integer offset, @retrofit2.http.Query("limit") Integer limit);

    /**
    * Retrieve External Asset Owner Transfers
    * Retrieve External Asset Owner Transfer items by transferExternalId, loanId or loanExternalId
        * @param transferExternalId transferExternalId (optional)
        * @param loanId loanId (optional)
        * @param loanExternalId loanExternalId (optional)
        * @param offset offset (optional)
        * @param limit limit (optional)
    * @return Call&lt;PageExternalTransferData&gt;
    */
    @GET("v1/external-asset-owners/transfers")
    Call<PageExternalTransferData> getTransfers(@retrofit2.http.Query("transferExternalId") String transferExternalId, @retrofit2.http.Query("loanId") Long loanId, @retrofit2.http.Query("loanExternalId") String loanExternalId, @retrofit2.http.Query("offset") Integer offset, @retrofit2.http.Query("limit") Integer limit);

    /**
    * Search External Asset Owner Transfers by text or date ranges to settlement or effective dates
    * 
        * @param pagedRequestExternalAssetOwnerSearchRequest  (optional)
    * @return Call&lt;PageExternalTransferData&gt;
    */
                @Headers({
                "Content-Type:application/json"
                })
    @POST("v1/external-asset-owners/search")
    Call<PageExternalTransferData> searchInvestorData(@retrofit2.http.Body PagedRequestExternalAssetOwnerSearchRequest pagedRequestExternalAssetOwnerSearchRequest);

    /**
    * 
    * 
        * @param id  (required)
        * @param command command (optional)
    * @return Call&lt;PostInitiateTransferResponse&gt;
    */
    @POST("v1/external-asset-owners/transfers/{id}")
    Call<PostInitiateTransferResponse> transferRequestWithId(@retrofit2.http.Path("id") Long id, @retrofit2.http.Query("command") String command);

    /**
    * 
    * 
        * @param externalId  (required)
        * @param command command (optional)
    * @return Call&lt;PostInitiateTransferResponse&gt;
    */
    @POST("v1/external-asset-owners/transfers/external-id/{externalId}")
    Call<PostInitiateTransferResponse> transferRequestWithId1(@retrofit2.http.Path("externalId") String externalId, @retrofit2.http.Query("command") String command);

    /**
    * 
    * 
        * @param loanExternalId  (required)
        * @param postInitiateTransferRequest  (required)
        * @param command command (optional)
    * @return Call&lt;PostInitiateTransferResponse&gt;
    */
                @Headers({
                "Content-Type:application/json"
                })
    @POST("v1/external-asset-owners/transfers/loans/external-id/{loanExternalId}")
    Call<PostInitiateTransferResponse> transferRequestWithLoanExternalId(@retrofit2.http.Path("loanExternalId") String loanExternalId, @retrofit2.http.Body PostInitiateTransferRequest postInitiateTransferRequest, @retrofit2.http.Query("command") String command);

    /**
    * 
    * 
        * @param loanId  (required)
        * @param postInitiateTransferRequest  (required)
        * @param command command (optional)
    * @return Call&lt;PostInitiateTransferResponse&gt;
    */
                @Headers({
                "Content-Type:application/json"
                })
    @POST("v1/external-asset-owners/transfers/loans/{loanId}")
    Call<PostInitiateTransferResponse> transferRequestWithLoanId(@retrofit2.http.Path("loanId") Long loanId, @retrofit2.http.Body PostInitiateTransferRequest postInitiateTransferRequest, @retrofit2.http.Query("command") String command);


        /**
        * Search External Asset Owner Transfers by text or date ranges to settlement or effective dates
        * 
            * @param pagedRequestExternalAssetOwnerSearchRequest  (optional)
        * @return Call&lt;PageExternalTransferData&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @POST("v1/external-asset-owners/search")
    Call<PageExternalTransferData> searchInvestorData();

        /**
        * Retrieve Active Asset Owner Transfer
        * Retrieve Active External Asset Owner Transfer by transferExternalId, loanId or loanExternalId
            * @param transferExternalId transferExternalId (optional)
            * @param loanId loanId (optional)
            * @param loanExternalId loanExternalId (optional)
        * @return Call&lt;ExternalTransferData&gt;
        */
    @GET("v1/external-asset-owners/transfers/active-transfer")
    Call<ExternalTransferData> getActiveTransfer(@retrofit2.http.Query("transferExternalId") String transferExternalId, @retrofit2.http.Query("loanId") Long loanId, @retrofit2.http.Query("loanExternalId") String loanExternalId, @HeaderMap Map<String, String> headers);

        /**
        * Retrieve Journal Entries of Owner
        * Retrieve Journal entries of owner by owner externalId
            * @param ownerExternalId ownerExternalId (required)
            * @param offset offset (optional)
            * @param limit limit (optional)
        * @return Call&lt;ExternalOwnerJournalEntryData&gt;
        */
    @GET("v1/external-asset-owners/owners/external-id/{ownerExternalId}/journal-entries")
    Call<ExternalOwnerJournalEntryData> getJournalEntriesOfOwner(@retrofit2.http.Path("ownerExternalId") String ownerExternalId, @retrofit2.http.Query("offset") Integer offset, @retrofit2.http.Query("limit") Integer limit, @HeaderMap Map<String, String> headers);

        /**
        * Retrieve Journal Entries of Transfer
        * Retrieve Journal entries of transfer by transferId
            * @param transferId transferId (required)
            * @param offset offset (optional)
            * @param limit limit (optional)
        * @return Call&lt;ExternalOwnerTransferJournalEntryData&gt;
        */
    @GET("v1/external-asset-owners/transfers/{transferId}/journal-entries")
    Call<ExternalOwnerTransferJournalEntryData> getJournalEntriesOfTransfer(@retrofit2.http.Path("transferId") Long transferId, @retrofit2.http.Query("offset") Integer offset, @retrofit2.http.Query("limit") Integer limit, @HeaderMap Map<String, String> headers);

        /**
        * Retrieve External Asset Owner Transfers
        * Retrieve External Asset Owner Transfer items by transferExternalId, loanId or loanExternalId
            * @param transferExternalId transferExternalId (optional)
            * @param loanId loanId (optional)
            * @param loanExternalId loanExternalId (optional)
            * @param offset offset (optional)
            * @param limit limit (optional)
        * @return Call&lt;PageExternalTransferData&gt;
        */
    @GET("v1/external-asset-owners/transfers")
    Call<PageExternalTransferData> getTransfers(@retrofit2.http.Query("transferExternalId") String transferExternalId, @retrofit2.http.Query("loanId") Long loanId, @retrofit2.http.Query("loanExternalId") String loanExternalId, @retrofit2.http.Query("offset") Integer offset, @retrofit2.http.Query("limit") Integer limit, @HeaderMap Map<String, String> headers);

        /**
        * Search External Asset Owner Transfers by text or date ranges to settlement or effective dates
        * 
            * @param pagedRequestExternalAssetOwnerSearchRequest  (optional)
        * @return Call&lt;PageExternalTransferData&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @POST("v1/external-asset-owners/search")
    Call<PageExternalTransferData> searchInvestorData(@retrofit2.http.Body PagedRequestExternalAssetOwnerSearchRequest pagedRequestExternalAssetOwnerSearchRequest, @HeaderMap Map<String, String> headers);

        /**
        * 
        * 
            * @param id  (required)
            * @param command command (optional)
        * @return Call&lt;PostInitiateTransferResponse&gt;
        */
    @POST("v1/external-asset-owners/transfers/{id}")
    Call<PostInitiateTransferResponse> transferRequestWithId(@retrofit2.http.Path("id") Long id, @retrofit2.http.Query("command") String command, @HeaderMap Map<String, String> headers);

        /**
        * 
        * 
            * @param externalId  (required)
            * @param command command (optional)
        * @return Call&lt;PostInitiateTransferResponse&gt;
        */
    @POST("v1/external-asset-owners/transfers/external-id/{externalId}")
    Call<PostInitiateTransferResponse> transferRequestWithId1(@retrofit2.http.Path("externalId") String externalId, @retrofit2.http.Query("command") String command, @HeaderMap Map<String, String> headers);

        /**
        * 
        * 
            * @param loanExternalId  (required)
            * @param postInitiateTransferRequest  (required)
            * @param command command (optional)
        * @return Call&lt;PostInitiateTransferResponse&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @POST("v1/external-asset-owners/transfers/loans/external-id/{loanExternalId}")
    Call<PostInitiateTransferResponse> transferRequestWithLoanExternalId(@retrofit2.http.Path("loanExternalId") String loanExternalId, @retrofit2.http.Body PostInitiateTransferRequest postInitiateTransferRequest, @retrofit2.http.Query("command") String command, @HeaderMap Map<String, String> headers);

        /**
        * 
        * 
            * @param loanId  (required)
            * @param postInitiateTransferRequest  (required)
            * @param command command (optional)
        * @return Call&lt;PostInitiateTransferResponse&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @POST("v1/external-asset-owners/transfers/loans/{loanId}")
    Call<PostInitiateTransferResponse> transferRequestWithLoanId(@retrofit2.http.Path("loanId") Long loanId, @retrofit2.http.Body PostInitiateTransferRequest postInitiateTransferRequest, @retrofit2.http.Query("command") String command, @HeaderMap Map<String, String> headers);


        /**
        * Search External Asset Owner Transfers by text or date ranges to settlement or effective dates
        * 
            * @param pagedRequestExternalAssetOwnerSearchRequest  (optional)
        * @return Call&lt;PageExternalTransferData&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @POST("v1/external-asset-owners/search")
    Call<PageExternalTransferData> searchInvestorData(@HeaderMap Map<String, String> headers);
}
