package org.apache.fineract.client.services;

import org.apache.fineract.client.CollectionFormats.*;

    import retrofit2.Call;
import retrofit2.http.*;

import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import okhttp3.MultipartBody;

import org.apache.fineract.client.models.CommandProcessingResult;
import org.apache.fineract.client.models.GetExternalEventConfigurationsResponse;
import org.apache.fineract.client.models.PutExternalEventConfigurationsRequest;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface ExternalEventConfigurationApi {
    /**
    * List all external event configurations
    * 
    * @return Call&lt;GetExternalEventConfigurationsResponse&gt;
    */
    @GET("v1/externalevents/configuration")
    Call<GetExternalEventConfigurationsResponse> retrieveExternalEventConfiguration();

    /**
    * Enable/Disable external events posting
    * 
        * @param putExternalEventConfigurationsRequest  (required)
    * @return Call&lt;CommandProcessingResult&gt;
    */
                @Headers({
                "Content-Type:application/json"
                })
    @PUT("v1/externalevents/configuration")
    Call<CommandProcessingResult> updateExternalEventConfigurationsDetails(@retrofit2.http.Body PutExternalEventConfigurationsRequest putExternalEventConfigurationsRequest);



        /**
        * List all external event configurations
        * 
        * @return Call&lt;GetExternalEventConfigurationsResponse&gt;
        */
    @GET("v1/externalevents/configuration")
    Call<GetExternalEventConfigurationsResponse> retrieveExternalEventConfiguration(@HeaderMap Map<String, String> headers);

        /**
        * Enable/Disable external events posting
        * 
            * @param putExternalEventConfigurationsRequest  (required)
        * @return Call&lt;CommandProcessingResult&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @PUT("v1/externalevents/configuration")
    Call<CommandProcessingResult> updateExternalEventConfigurationsDetails(@retrofit2.http.Body PutExternalEventConfigurationsRequest putExternalEventConfigurationsRequest, @HeaderMap Map<String, String> headers);


}
