package org.apache.fineract.client.services;

import org.apache.fineract.client.CollectionFormats.*;

    import retrofit2.Call;
import retrofit2.http.*;

import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import okhttp3.MultipartBody;

import org.apache.fineract.client.models.GetLoanAccountLockResponse;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface LoanAccountLockApi {
    /**
    * List locked loan accounts
    * Returns the locked loan IDs
        * @param page  (optional)
        * @param limit  (optional)
    * @return Call&lt;GetLoanAccountLockResponse&gt;
    */
    @GET("v1/loans/locked")
    Call<GetLoanAccountLockResponse> retrieveLockedAccounts(@retrofit2.http.Query("page") Integer page, @retrofit2.http.Query("limit") Integer limit);



        /**
        * List locked loan accounts
        * Returns the locked loan IDs
            * @param page  (optional)
            * @param limit  (optional)
        * @return Call&lt;GetLoanAccountLockResponse&gt;
        */
    @GET("v1/loans/locked")
    Call<GetLoanAccountLockResponse> retrieveLockedAccounts(@retrofit2.http.Query("page") Integer page, @retrofit2.http.Query("limit") Integer limit, @HeaderMap Map<String, String> headers);


}
