/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.accounting.accrual.service;

import java.time.LocalDate;
import java.util.ArrayList;
import lombok.Generated;
import org.apache.fineract.accounting.accrual.serialization.AccrualAccountingDataValidator;
import org.apache.fineract.accounting.accrual.service.AccrualAccountingWritePlatformService;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.DataValidatorBuilder;
import org.apache.fineract.infrastructure.core.exception.MultiException;
import org.apache.fineract.infrastructure.core.exception.PlatformApiDataValidationException;
import org.apache.fineract.portfolio.loanaccount.service.LoanAccrualsProcessingService;

public class AccrualAccountingWritePlatformServiceImpl
implements AccrualAccountingWritePlatformService {
    private final LoanAccrualsProcessingService loanAccrualsProcessingService;
    private final AccrualAccountingDataValidator accountingDataValidator;

    public CommandProcessingResult executeLoansPeriodicAccrual(JsonCommand command) {
        this.accountingDataValidator.validateLoanPeriodicAccrualData(command.json());
        LocalDate tillDate = command.localDateValueOfParameterNamed("tillDate");
        try {
            this.loanAccrualsProcessingService.addPeriodicAccruals(tillDate);
        }
        catch (MultiException e) {
            ArrayList dataValidationErrors = new ArrayList();
            DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("periodicaccrual");
            baseDataValidator.reset().failWithCodeNoParameterAddedToErrorCode("execution.failed", new Object[]{e.getMessage()});
            throw new PlatformApiDataValidationException(dataValidationErrors, (Throwable)e);
        }
        return CommandProcessingResult.empty();
    }

    @Generated
    public AccrualAccountingWritePlatformServiceImpl(LoanAccrualsProcessingService loanAccrualsProcessingService, AccrualAccountingDataValidator accountingDataValidator) {
        this.loanAccrualsProcessingService = loanAccrualsProcessingService;
        this.accountingDataValidator = accountingDataValidator;
    }
}

