/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.accounting.journalentry.data;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import lombok.Generated;
import org.apache.fineract.accounting.journalentry.data.ChargePaymentDTO;
import org.apache.fineract.accounting.journalentry.data.TaxPaymentDTO;
import org.apache.fineract.portfolio.savings.data.SavingsAccountTransactionEnumData;

public class SavingsTransactionDTO {
    private final Long officeId;
    private final Long paymentTypeId;
    private final String transactionId;
    private final LocalDate transactionDate;
    private final SavingsAccountTransactionEnumData transactionType;
    private final BigDecimal amount;
    private final boolean reversed;
    private final List<ChargePaymentDTO> feePayments;
    private final List<ChargePaymentDTO> penaltyPayments;
    private final BigDecimal overdraftAmount;
    private final boolean isAccountTransfer;
    private final List<TaxPaymentDTO> taxPayments;

    public boolean isOverdraftTransaction() {
        return this.overdraftAmount != null && this.overdraftAmount.doubleValue() > 0.0;
    }

    @Generated
    public SavingsTransactionDTO(Long officeId, Long paymentTypeId, String transactionId, LocalDate transactionDate, SavingsAccountTransactionEnumData transactionType, BigDecimal amount, boolean reversed, List<ChargePaymentDTO> feePayments, List<ChargePaymentDTO> penaltyPayments, BigDecimal overdraftAmount, boolean isAccountTransfer, List<TaxPaymentDTO> taxPayments) {
        this.officeId = officeId;
        this.paymentTypeId = paymentTypeId;
        this.transactionId = transactionId;
        this.transactionDate = transactionDate;
        this.transactionType = transactionType;
        this.amount = amount;
        this.reversed = reversed;
        this.feePayments = feePayments;
        this.penaltyPayments = penaltyPayments;
        this.overdraftAmount = overdraftAmount;
        this.isAccountTransfer = isAccountTransfer;
        this.taxPayments = taxPayments;
    }

    @Generated
    public Long getOfficeId() {
        return this.officeId;
    }

    @Generated
    public Long getPaymentTypeId() {
        return this.paymentTypeId;
    }

    @Generated
    public String getTransactionId() {
        return this.transactionId;
    }

    @Generated
    public LocalDate getTransactionDate() {
        return this.transactionDate;
    }

    @Generated
    public SavingsAccountTransactionEnumData getTransactionType() {
        return this.transactionType;
    }

    @Generated
    public BigDecimal getAmount() {
        return this.amount;
    }

    @Generated
    public boolean isReversed() {
        return this.reversed;
    }

    @Generated
    public List<ChargePaymentDTO> getFeePayments() {
        return this.feePayments;
    }

    @Generated
    public List<ChargePaymentDTO> getPenaltyPayments() {
        return this.penaltyPayments;
    }

    @Generated
    public BigDecimal getOverdraftAmount() {
        return this.overdraftAmount;
    }

    @Generated
    public boolean isAccountTransfer() {
        return this.isAccountTransfer;
    }

    @Generated
    public List<TaxPaymentDTO> getTaxPayments() {
        return this.taxPayments;
    }
}

