/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.accounting.journalentry.service;

import lombok.Generated;
import org.apache.fineract.accounting.journalentry.data.LoanDTO;
import org.apache.fineract.accounting.journalentry.service.AccountingProcessorForLoan;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class AccountingProcessorForLoanFactory {
    private final ApplicationContext applicationContext;

    public AccountingProcessorForLoan determineProcessor(LoanDTO loanDTO) {
        AccountingProcessorForLoan accountingProcessorForLoan = null;
        if (loanDTO.isCashBasedAccountingEnabled()) {
            accountingProcessorForLoan = (AccountingProcessorForLoan)this.applicationContext.getBean("cashBasedAccountingProcessorForLoan", AccountingProcessorForLoan.class);
        } else if (loanDTO.isUpfrontAccrualBasedAccountingEnabled()) {
            accountingProcessorForLoan = (AccountingProcessorForLoan)this.applicationContext.getBean("accrualBasedAccountingProcessorForLoan", AccountingProcessorForLoan.class);
        } else if (loanDTO.isPeriodicAccrualBasedAccountingEnabled()) {
            accountingProcessorForLoan = (AccountingProcessorForLoan)this.applicationContext.getBean("accrualBasedAccountingProcessorForLoan", AccountingProcessorForLoan.class);
        }
        return accountingProcessorForLoan;
    }

    @Generated
    public AccountingProcessorForLoanFactory(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }
}

