/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.batch.command.internal;

import com.google.common.base.Splitter;
import jakarta.ws.rs.core.UriInfo;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.fineract.batch.command.CommandStrategy;
import org.apache.fineract.batch.command.CommandStrategyUtils;
import org.apache.fineract.batch.domain.BatchRequest;
import org.apache.fineract.batch.domain.BatchResponse;
import org.apache.fineract.portfolio.loanaccount.api.LoanTransactionsApiResource;
import org.springframework.stereotype.Component;

@Component
public class AdjustLoanTransactionCommandStrategy
implements CommandStrategy {
    private final LoanTransactionsApiResource loanTransactionsApiResource;

    public BatchResponse execute(BatchRequest request, UriInfo uriInfo) {
        BatchResponse response = new BatchResponse();
        response.setRequestId(request.getRequestId());
        response.setHeaders(request.getHeaders());
        String relativeUrl = CommandStrategyUtils.relativeUrlWithoutVersion((BatchRequest)request);
        List pathParameters = Splitter.on((char)'/').splitToList((CharSequence)relativeUrl);
        Long loanId = Long.parseLong((String)pathParameters.get(1));
        String transactionIdPathParameter = (String)pathParameters.get(3);
        Long transactionId = transactionIdPathParameter.contains("?") ? Long.valueOf(Long.parseLong(((String)pathParameters.get(3)).substring(0, ((String)pathParameters.get(3)).indexOf("?")))) : Long.valueOf(Long.parseLong((String)pathParameters.get(3)));
        Map queryParameters = CommandStrategyUtils.getQueryParameters((String)relativeUrl);
        String command = (String)queryParameters.get("command");
        String responseBody = this.loanTransactionsApiResource.adjustLoanTransaction(loanId, transactionId, request.getBody(), command);
        response.setStatusCode(Integer.valueOf(200));
        response.setBody(responseBody);
        return response;
    }

    @Generated
    public AdjustLoanTransactionCommandStrategy(LoanTransactionsApiResource loanTransactionsApiResource) {
        this.loanTransactionsApiResource = loanTransactionsApiResource;
    }
}

