/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.cob.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.List;
import lombok.Generated;
import org.apache.fineract.cob.data.ConfiguredJobNamesDTO;
import org.apache.fineract.cob.data.JobBusinessStepConfigData;
import org.apache.fineract.cob.data.JobBusinessStepDetail;
import org.apache.fineract.cob.data.request.BusinessStepRequest;
import org.apache.fineract.cob.service.ConfigJobParameterService;
import org.apache.fineract.commands.domain.CommandWrapper;
import org.apache.fineract.commands.service.CommandWrapperBuilder;
import org.apache.fineract.commands.service.PortfolioCommandSourceWritePlatformService;
import org.apache.fineract.infrastructure.core.serialization.DefaultToApiJsonSerializer;
import org.springframework.stereotype.Component;

@Path(value="/v1/jobs")
@Component
@Tag(name="Business Step Configuration", description="")
public class ConfigureBusinessStepApiResource {
    private final DefaultToApiJsonSerializer<String> toApiJsonSerializer;
    private final ConfigJobParameterService configJobParameterService;
    private final PortfolioCommandSourceWritePlatformService commandWritePlatformService;

    @GET
    @Path(value="/names")
    @Produces(value={"application/json"})
    @Operation(summary="List Business Jobs", description="Returns the configured Business Jobs")
    public ConfiguredJobNamesDTO retrieveAllConfiguredBusinessJobs() {
        List businessJobNames = this.configJobParameterService.getAllConfiguredJobNames();
        return new ConfiguredJobNamesDTO(businessJobNames);
    }

    @GET
    @Path(value="{jobName}/steps")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="List Business Step Configurations for a Job", description="Returns the configured Business Steps for a job")
    public JobBusinessStepConfigData retrieveAllConfiguredBusinessStep(@PathParam(value="jobName") @Parameter(description="jobName") String jobName) {
        return this.configJobParameterService.getBusinessStepConfigByJobName(jobName);
    }

    @PUT
    @Path(value="{jobName}/steps")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="List Business Step Configurations for a Job", description="Updates the Business steps execution order for a job")
    @RequestBody(content={@Content(schema=@Schema(implementation=BusinessStepRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="NO_CONTENT")})
    public Response updateJobBusinessStepConfig(@PathParam(value="jobName") @Parameter(description="jobName") String jobName, @Parameter(hidden=true) BusinessStepRequest businessStepRequest) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().updateBusinessStepConfig(jobName).withJson(this.toApiJsonSerializer.serialize((Object)businessStepRequest)).build();
        this.commandWritePlatformService.logCommandSource(commandRequest);
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    @GET
    @Path(value="{jobName}/available-steps")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="List Business Step Configurations for a Job", description="Returns the available Business Steps for a job")
    public JobBusinessStepDetail retrieveAllAvailableBusinessStep(@PathParam(value="jobName") @Parameter(description="jobName") String jobName) {
        return this.configJobParameterService.getAvailableBusinessStepsByJobName(jobName);
    }

    @Generated
    public ConfigureBusinessStepApiResource(DefaultToApiJsonSerializer<String> toApiJsonSerializer, ConfigJobParameterService configJobParameterService, PortfolioCommandSourceWritePlatformService commandWritePlatformService) {
        this.toApiJsonSerializer = toApiJsonSerializer;
        this.configJobParameterService = configJobParameterService;
        this.commandWritePlatformService = commandWritePlatformService;
    }
}

