/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.cob.loan;

import jakarta.transaction.Transactional;
import java.time.LocalDate;
import lombok.Generated;
import org.apache.fineract.cob.loan.LoanCOBBusinessStep;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.portfolio.loanaccount.domain.Loan;
import org.apache.fineract.portfolio.loanaccount.service.LoanBuyDownFeeAmortizationProcessingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class BuyDownFeeAmortizationBusinessStep
implements LoanCOBBusinessStep {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BuyDownFeeAmortizationBusinessStep.class);
    private final LoanBuyDownFeeAmortizationProcessingService loanBuyDownFeeAmortizationProcessingService;

    @Transactional
    public Loan execute(Loan loan) {
        if (!loan.getLoanProductRelatedDetail().isEnableBuyDownFee()) {
            return loan;
        }
        LocalDate businessDate = DateUtils.getBusinessLocalDate();
        this.loanBuyDownFeeAmortizationProcessingService.processBuyDownFeeAmortizationTillDate(loan, businessDate, true);
        return loan;
    }

    public String getEnumStyledName() {
        return "BUY_DOWN_FEE_AMORTIZATION";
    }

    public String getHumanReadableName() {
        return "Buy Down Fee amortization";
    }

    @Generated
    public BuyDownFeeAmortizationBusinessStep(LoanBuyDownFeeAmortizationProcessingService loanBuyDownFeeAmortizationProcessingService) {
        this.loanBuyDownFeeAmortizationProcessingService = loanBuyDownFeeAmortizationProcessingService;
    }
}

