/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.cob.loan;

import jakarta.transaction.Transactional;
import java.time.LocalDate;
import lombok.Generated;
import org.apache.fineract.cob.loan.LoanCOBBusinessStep;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.portfolio.loanaccount.domain.Loan;
import org.apache.fineract.portfolio.loanaccount.service.LoanCapitalizedIncomeAmortizationProcessingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class CapitalizedIncomeAmortizationBusinessStep
implements LoanCOBBusinessStep {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CapitalizedIncomeAmortizationBusinessStep.class);
    private final LoanCapitalizedIncomeAmortizationProcessingService loanCapitalizedIncomeAmortizationProcessingService;

    @Transactional
    public Loan execute(Loan loan) {
        LocalDate businessDate = DateUtils.getBusinessLocalDate();
        this.loanCapitalizedIncomeAmortizationProcessingService.processCapitalizedIncomeAmortizationTillDate(loan, businessDate, true);
        return loan;
    }

    public String getEnumStyledName() {
        return "CAPITALIZED_INCOME_AMORTIZATION";
    }

    public String getHumanReadableName() {
        return "Capitalized income amortization";
    }

    @Generated
    public CapitalizedIncomeAmortizationBusinessStep(LoanCapitalizedIncomeAmortizationProcessingService loanCapitalizedIncomeAmortizationProcessingService) {
        this.loanCapitalizedIncomeAmortizationProcessingService = loanCapitalizedIncomeAmortizationProcessingService;
    }
}

