/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.cob.service;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.cob.data.BusinessStep;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.exception.InvalidJsonException;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.springframework.stereotype.Component;

@Component
public class BusinessStepConfigDataParser {
    private final FromJsonHelper jsonHelper;

    public List<BusinessStep> parseUpdate(JsonCommand command) {
        JsonObject element = this.extractJsonObject(command);
        ArrayList<BusinessStep> businessSteps = new ArrayList<BusinessStep>();
        JsonArray jsonArray = this.jsonHelper.extractJsonArrayNamed("businessSteps", (JsonElement)element);
        for (JsonElement businessStepConfig : jsonArray) {
            String stepName = this.jsonHelper.extractStringNamed("stepName", businessStepConfig);
            Long order = this.jsonHelper.extractLongNamed("order", businessStepConfig);
            BusinessStep businessStep = new BusinessStep();
            businessStep.setStepName(stepName);
            businessStep.setOrder(order);
            businessSteps.add(businessStep);
        }
        return businessSteps;
    }

    private JsonObject extractJsonObject(JsonCommand command) {
        String json = command.json();
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        JsonElement element = this.jsonHelper.parse(json);
        return element.getAsJsonObject();
    }

    @Generated
    public BusinessStepConfigDataParser(FromJsonHelper jsonHelper) {
        this.jsonHelper = jsonHelper;
    }
}

