/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.accountnumberformat.domain;

import org.apache.fineract.infrastructure.accountnumberformat.domain.AccountNumberFormat;
import org.apache.fineract.infrastructure.accountnumberformat.domain.AccountNumberFormatRepository;
import org.apache.fineract.infrastructure.accountnumberformat.domain.EntityAccountType;
import org.apache.fineract.infrastructure.accountnumberformat.exception.AccountNumberFormatNotFoundException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class AccountNumberFormatRepositoryWrapper {
    private final AccountNumberFormatRepository repository;

    @Autowired
    public AccountNumberFormatRepositoryWrapper(AccountNumberFormatRepository repository) {
        this.repository = repository;
    }

    public AccountNumberFormat findOneWithNotFoundDetection(Long id) {
        return (AccountNumberFormat)this.repository.findById((Object)id).orElseThrow(() -> new AccountNumberFormatNotFoundException(id));
    }

    public void save(AccountNumberFormat accountNumberFormat) {
        this.repository.save((Object)accountNumberFormat);
    }

    public void saveAndFlush(AccountNumberFormat accountNumberFormat) {
        this.repository.saveAndFlush((Object)accountNumberFormat);
    }

    public void delete(AccountNumberFormat accountNumberFormat) {
        this.repository.delete((Object)accountNumberFormat);
    }

    public AccountNumberFormat findByAccountType(EntityAccountType entityAccountType) {
        return this.repository.findOneByAccountTypeEnum(entityAccountType.getValue());
    }
}

