/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.bulkimport.populator;

import java.util.ArrayList;
import java.util.List;
import org.apache.fineract.infrastructure.bulkimport.populator.AbstractWorkbookPopulator;
import org.apache.fineract.organisation.office.data.OfficeData;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class OfficeSheetPopulator
extends AbstractWorkbookPopulator {
    private List<OfficeData> offices;
    private static final int ID_COL = 0;
    private static final int OFFICE_NAME_COL = 1;

    public OfficeSheetPopulator(List<OfficeData> offices) {
        this.offices = offices;
    }

    public void populate(Workbook workbook, String dateFormat) {
        int rowIndex = 1;
        Sheet officeSheet = workbook.createSheet("Offices");
        this.setLayout(officeSheet);
        this.populateOffices(officeSheet, rowIndex);
        officeSheet.protectSheet("");
    }

    private void populateOffices(Sheet officeSheet, int rowIndex) {
        for (OfficeData office : this.offices) {
            Row row = officeSheet.createRow(rowIndex);
            this.writeLong(0, row, office.getId().longValue());
            this.writeString(1, row, office.getName().trim().replaceAll("[ )(]", "_"));
            ++rowIndex;
        }
    }

    private void setLayout(Sheet worksheet) {
        worksheet.setColumnWidth(0, 4000);
        worksheet.setColumnWidth(1, 6000);
        Row rowHeader = worksheet.createRow(0);
        rowHeader.setHeight((short)500);
        this.writeString(0, rowHeader, "ID");
        this.writeString(1, rowHeader, "Name");
    }

    public List<OfficeData> getOffices() {
        return this.offices;
    }

    public List<String> getOfficeNames() {
        ArrayList<String> officeNames = new ArrayList<String>();
        for (OfficeData office : this.offices) {
            officeNames.add(office.getName());
        }
        return officeNames;
    }
}

