/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.campaigns.email.domain;

import com.google.gson.JsonElement;
import org.apache.fineract.infrastructure.campaigns.email.domain.EmailMessage;
import org.apache.fineract.infrastructure.campaigns.email.domain.EmailMessageRepository;
import org.apache.fineract.infrastructure.campaigns.email.exception.EmailNotFoundException;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.apache.fineract.organisation.staff.domain.Staff;
import org.apache.fineract.organisation.staff.domain.StaffRepositoryWrapper;
import org.apache.fineract.portfolio.client.domain.Client;
import org.apache.fineract.portfolio.client.domain.ClientRepositoryWrapper;
import org.apache.fineract.portfolio.group.domain.Group;
import org.apache.fineract.portfolio.group.domain.GroupRepositoryWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EmailMessageAssembler {
    private final EmailMessageRepository emailMessageRepository;
    private final GroupRepositoryWrapper groupRepository;
    private final ClientRepositoryWrapper clientRepository;
    private final StaffRepositoryWrapper staffRepository;
    private final FromJsonHelper fromApiJsonHelper;

    @Autowired
    public EmailMessageAssembler(EmailMessageRepository emailMessageRepository, GroupRepositoryWrapper groupRepositoryWrapper, ClientRepositoryWrapper clientRepository, StaffRepositoryWrapper staffRepository, FromJsonHelper fromApiJsonHelper) {
        this.emailMessageRepository = emailMessageRepository;
        this.groupRepository = groupRepositoryWrapper;
        this.clientRepository = clientRepository;
        this.staffRepository = staffRepository;
        this.fromApiJsonHelper = fromApiJsonHelper;
    }

    public EmailMessage assembleFromJson(JsonCommand command) {
        JsonElement element = command.parsedJson();
        String emailAddress = null;
        Group group = null;
        if (this.fromApiJsonHelper.parameterExists("groupId", element)) {
            Long groupId = this.fromApiJsonHelper.extractLongNamed("groupId", element);
            group = this.groupRepository.findOneWithNotFoundDetection(groupId);
        }
        Client client = null;
        if (this.fromApiJsonHelper.parameterExists("clientId", element)) {
            Long clientId = this.fromApiJsonHelper.extractLongNamed("clientId", element);
            client = this.clientRepository.findOneWithNotFoundDetection(clientId);
            emailAddress = client.emailAddress();
        }
        Staff staff = null;
        if (this.fromApiJsonHelper.parameterExists("staffId", element)) {
            Long staffId = this.fromApiJsonHelper.extractLongNamed("staffId", element);
            staff = this.staffRepository.findOneWithNotFoundDetection(staffId);
            emailAddress = staff.emailAddress();
        }
        String message = this.fromApiJsonHelper.extractStringNamed("emailMessage", element);
        String emailSubject = this.fromApiJsonHelper.extractStringNamed("emailSubject", element);
        return EmailMessage.pendingEmail((Group)group, (Client)client, (Staff)staff, null, (String)emailSubject, (String)message, (String)emailAddress, null);
    }

    public EmailMessage assembleFromResourceId(Long resourceId) {
        return (EmailMessage)this.emailMessageRepository.findById((Object)resourceId).orElseThrow(() -> new EmailNotFoundException(resourceId));
    }
}

