/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.campaigns.jobs.executeemail;

import org.apache.fineract.infrastructure.campaigns.email.domain.EmailCampaignRepository;
import org.apache.fineract.infrastructure.campaigns.email.domain.EmailMessageRepository;
import org.apache.fineract.infrastructure.campaigns.email.service.EmailMessageJobEmailService;
import org.apache.fineract.infrastructure.campaigns.jobs.executeemail.ExecuteEmailTasklet;
import org.apache.fineract.infrastructure.core.config.FineractProperties;
import org.apache.fineract.infrastructure.dataqueries.service.ReadReportingService;
import org.apache.fineract.infrastructure.jobs.service.JobName;
import org.apache.fineract.infrastructure.reportmailingjob.validation.ReportMailingJobValidator;
import org.apache.fineract.portfolio.loanaccount.domain.LoanRepository;
import org.apache.fineract.portfolio.savings.domain.SavingsAccountRepository;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobParametersIncrementer;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.job.builder.JobBuilder;
import org.springframework.batch.core.job.builder.SimpleJobBuilder;
import org.springframework.batch.core.launch.support.RunIdIncrementer;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.core.step.builder.StepBuilder;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration
public class ExecuteEmailConfig {
    @Autowired
    private JobRepository jobRepository;
    @Autowired
    private PlatformTransactionManager transactionManager;
    @Autowired
    private EmailMessageRepository emailMessageRepository;
    @Autowired
    private EmailCampaignRepository emailCampaignRepository;
    @Autowired
    private LoanRepository loanRepository;
    @Autowired
    private SavingsAccountRepository savingsAccountRepository;
    @Autowired
    private EmailMessageJobEmailService emailMessageJobEmailService;
    @Autowired
    private ReadReportingService readReportingService;
    @Autowired
    private ReportMailingJobValidator reportMailingJobValidator;
    @Autowired
    private FineractProperties fineractProperties;

    @Bean
    protected Step executeEmailStep() {
        return new StepBuilder(JobName.EXECUTE_EMAIL.name(), this.jobRepository).tasklet((Tasklet)this.executeEmailTasklet(), this.transactionManager).build();
    }

    @Bean
    public Job executeEmailJob() {
        return ((SimpleJobBuilder)new JobBuilder(JobName.EXECUTE_EMAIL.name(), this.jobRepository).start(this.executeEmailStep()).incrementer((JobParametersIncrementer)new RunIdIncrementer())).build();
    }

    @Bean
    public ExecuteEmailTasklet executeEmailTasklet() {
        return new ExecuteEmailTasklet(this.emailMessageRepository, this.emailCampaignRepository, this.loanRepository, this.savingsAccountRepository, this.emailMessageJobEmailService, this.readReportingService, this.reportMailingJobValidator, this.fineractProperties);
    }
}

