/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.configuration.domain;

import lombok.Generated;
import org.apache.fineract.infrastructure.configuration.domain.GlobalConfigurationProperty;
import org.apache.fineract.infrastructure.configuration.domain.GlobalConfigurationRepository;
import org.apache.fineract.infrastructure.configuration.exception.GlobalConfigurationPropertyNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service
public class GlobalConfigurationRepositoryWrapper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GlobalConfigurationRepositoryWrapper.class);
    private final GlobalConfigurationRepository repository;

    @Autowired
    public GlobalConfigurationRepositoryWrapper(GlobalConfigurationRepository repository) {
        this.repository = repository;
    }

    @Cacheable(value={"configByName"}, key="T(org.apache.fineract.infrastructure.core.service.ThreadLocalContextUtil).getTenant().getTenantIdentifier().concat(#propertyName)")
    public GlobalConfigurationProperty findOneByNameWithNotFoundDetection(String propertyName) {
        GlobalConfigurationProperty property = this.repository.findOneByName(propertyName);
        if (property == null) {
            throw new GlobalConfigurationPropertyNotFoundException(propertyName);
        }
        return property;
    }

    public GlobalConfigurationProperty findOneWithNotFoundDetection(Long configId) {
        return (GlobalConfigurationProperty)this.repository.findById((Object)configId).orElseThrow(() -> new GlobalConfigurationPropertyNotFoundException(configId));
    }

    public void save(GlobalConfigurationProperty globalConfigurationProperty) {
        this.repository.save((Object)globalConfigurationProperty);
    }

    public void saveAndFlush(GlobalConfigurationProperty globalConfigurationProperty) {
        this.repository.saveAndFlush((Object)globalConfigurationProperty);
    }

    public void delete(GlobalConfigurationProperty globalConfigurationProperty) {
        this.repository.delete((Object)globalConfigurationProperty);
    }

    @CacheEvict(value={"configByName"}, key="T(org.apache.fineract.infrastructure.core.service.ThreadLocalContextUtil).getTenant().getTenantIdentifier().concat(#propertyName)")
    public void removeFromCache(String propertyName) {
        log.debug("Cache entry evicted {}", (Object)propertyName);
    }
}

