/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.configuration.service;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apache.fineract.infrastructure.configuration.data.ExternalServicesData;
import org.apache.fineract.infrastructure.configuration.domain.ExternalServicesProperties;
import org.apache.fineract.infrastructure.configuration.domain.ExternalServicesPropertiesRepository;
import org.apache.fineract.infrastructure.configuration.domain.ExternalServicesPropertiesRepositoryWrapper;
import org.apache.fineract.infrastructure.configuration.serialization.ExternalServicesPropertiesCommandFromApiJsonDeserializer;
import org.apache.fineract.infrastructure.configuration.service.ExternalServiceWritePlatformService;
import org.apache.fineract.infrastructure.configuration.service.ExternalServicesReadPlatformService;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResultBuilder;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ExternalServiceWritePlatformServiceJpaRepositoryImpl
implements ExternalServiceWritePlatformService {
    private static final Logger LOG = LoggerFactory.getLogger(ExternalServiceWritePlatformServiceJpaRepositoryImpl.class);
    private final PlatformSecurityContext context;
    private final ExternalServicesPropertiesRepositoryWrapper repositoryWrapper;
    private final ExternalServicesPropertiesRepository repository;
    private final ExternalServicesPropertiesCommandFromApiJsonDeserializer fromApiJsonDeserializer;
    private final ExternalServicesReadPlatformService readPlatformService;

    @Transactional
    public CommandProcessingResult updateExternalServicesProperties(String externalServiceName, JsonCommand command) {
        this.context.authenticatedUser();
        this.fromApiJsonDeserializer.validateForUpdate(command.json(), externalServiceName);
        Set keyName = this.fromApiJsonDeserializer.getNameKeys(command.json());
        ExternalServicesData external = this.readPlatformService.getExternalServiceDetailsByServiceName(externalServiceName);
        Long externalServiceId = external.getId();
        Iterator it = keyName.iterator();
        LinkedHashMap changesList = new LinkedHashMap();
        while (it.hasNext()) {
            String name = (String)it.next();
            ExternalServicesProperties externalServicesProperties = this.repositoryWrapper.findOneByIdAndName(externalServiceId, name, externalServiceName);
            Map changes = externalServicesProperties.update(command, name);
            changesList.putAll(changes);
            if (changes.isEmpty()) continue;
            this.repository.saveAndFlush((Object)externalServicesProperties);
        }
        return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId(externalServiceId).with(changesList).build();
    }

    @Generated
    public ExternalServiceWritePlatformServiceJpaRepositoryImpl(PlatformSecurityContext context, ExternalServicesPropertiesRepositoryWrapper repositoryWrapper, ExternalServicesPropertiesRepository repository, ExternalServicesPropertiesCommandFromApiJsonDeserializer fromApiJsonDeserializer, ExternalServicesReadPlatformService readPlatformService) {
        this.context = context;
        this.repositoryWrapper = repositoryWrapper;
        this.repository = repository;
        this.fromApiJsonDeserializer = fromApiJsonDeserializer;
        this.readPlatformService = readPlatformService;
    }
}

