/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.core.config;

import jakarta.servlet.Filter;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.fineract.infrastructure.businessdate.service.BusinessDateReadPlatformService;
import org.apache.fineract.infrastructure.cache.service.CacheWritePlatformService;
import org.apache.fineract.infrastructure.configuration.domain.ConfigurationDomainService;
import org.apache.fineract.infrastructure.core.config.FineractProperties;
import org.apache.fineract.infrastructure.core.exceptionmapper.OAuth2ExceptionEntryPoint;
import org.apache.fineract.infrastructure.core.serialization.ToApiJsonSerializer;
import org.apache.fineract.infrastructure.security.data.FineractJwtAuthenticationToken;
import org.apache.fineract.infrastructure.security.data.PlatformRequestLog;
import org.apache.fineract.infrastructure.security.filter.InsecureTwoFactorAuthenticationFilter;
import org.apache.fineract.infrastructure.security.filter.TenantAwareTenantIdentifierFilter;
import org.apache.fineract.infrastructure.security.filter.TwoFactorAuthenticationFilter;
import org.apache.fineract.infrastructure.security.service.BasicAuthTenantDetailsService;
import org.apache.fineract.infrastructure.security.service.TenantAwareJpaPlatformUserDetailsService;
import org.apache.fineract.infrastructure.security.service.TwoFactorService;
import org.apache.fineract.infrastructure.security.vote.SelfServiceUserAuthorizationManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.converter.Converter;
import org.springframework.http.HttpMethod;
import org.springframework.security.authorization.AuthenticatedAuthorizationManager;
import org.springframework.security.authorization.AuthorityAuthorizationManager;
import org.springframework.security.authorization.AuthorizationManager;
import org.springframework.security.authorization.AuthorizationManagers;
import org.springframework.security.config.annotation.method.configuration.EnableMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.annotation.web.configurers.ChannelSecurityConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.crypto.factory.PasswordEncoderFactories;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.server.resource.authentication.JwtGrantedAuthoritiesConverter;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;
import org.springframework.security.web.context.SecurityContextHolderFilter;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

@Configuration
@ConditionalOnProperty(value={"fineract.security.oauth.enabled"})
@EnableMethodSecurity
public class OAuth2SecurityConfig {
    @Autowired
    private TenantAwareJpaPlatformUserDetailsService userDetailsService;
    @Autowired
    private ServerProperties serverProperties;
    @Autowired
    private FineractProperties fineractProperties;
    @Autowired
    private BasicAuthTenantDetailsService basicAuthTenantDetailsService;
    @Autowired
    private ToApiJsonSerializer<PlatformRequestLog> toApiJsonSerializer;
    @Autowired
    private ConfigurationDomainService configurationDomainService;
    @Autowired
    private CacheWritePlatformService cacheWritePlatformService;
    @Autowired
    private BusinessDateReadPlatformService businessDateReadPlatformService;
    @Autowired
    private ApplicationContext applicationContext;
    private static final JwtGrantedAuthoritiesConverter jwtGrantedAuthoritiesConverter = new JwtGrantedAuthoritiesConverter();

    @Bean
    public SecurityFilterChain filterChain(HttpSecurity http) throws Exception {
        http.securityMatcher((RequestMatcher)AntPathRequestMatcher.antMatcher((String)"/api/**")).authorizeHttpRequests(auth -> {
            ArrayList<Object> authorizationManagers = new ArrayList<Object>();
            authorizationManagers.add(AuthenticatedAuthorizationManager.fullyAuthenticated());
            authorizationManagers.add(AuthorityAuthorizationManager.hasAuthority((String)"TWOFACTOR_AUTHENTICATED"));
            if (this.fineractProperties.getModule().getSelfService().isEnabled()) {
                ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)auth.requestMatchers(new RequestMatcher[]{AntPathRequestMatcher.antMatcher((HttpMethod)HttpMethod.POST, (String)"/api/*/self/authentication")})).permitAll().requestMatchers(new RequestMatcher[]{AntPathRequestMatcher.antMatcher((HttpMethod)HttpMethod.POST, (String)"/api/*/self/registration")})).permitAll().requestMatchers(new RequestMatcher[]{AntPathRequestMatcher.antMatcher((HttpMethod)HttpMethod.POST, (String)"/api/*/self/registration/user")})).permitAll();
                authorizationManagers.add(SelfServiceUserAuthorizationManager.selfServiceUserAuthManager());
            }
            ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)auth.requestMatchers(new RequestMatcher[]{AntPathRequestMatcher.antMatcher((HttpMethod)HttpMethod.OPTIONS, (String)"/api/**")})).permitAll().requestMatchers(new RequestMatcher[]{AntPathRequestMatcher.antMatcher((HttpMethod)HttpMethod.POST, (String)"/api/*/echo")})).permitAll().requestMatchers(new RequestMatcher[]{AntPathRequestMatcher.antMatcher((HttpMethod)HttpMethod.POST, (String)"/api/*/authentication")})).permitAll().requestMatchers(new RequestMatcher[]{AntPathRequestMatcher.antMatcher((HttpMethod)HttpMethod.POST, (String)"/api/*/twofactor/validate")})).fullyAuthenticated().requestMatchers(new RequestMatcher[]{AntPathRequestMatcher.antMatcher((String)"/api/*/twofactor")})).fullyAuthenticated().requestMatchers(new RequestMatcher[]{AntPathRequestMatcher.antMatcher((String)"/api/**")})).access(AuthorizationManagers.allOf((AuthorizationManager[])authorizationManagers.toArray(new AuthorizationManager[0])));
        }).csrf(AbstractHttpConfigurer::disable).exceptionHandling(ehc -> ehc.authenticationEntryPoint((AuthenticationEntryPoint)new OAuth2ExceptionEntryPoint())).oauth2ResourceServer(oauth2 -> oauth2.jwt(jwt -> jwt.jwtAuthenticationConverter(this.authenticationConverter())).authenticationEntryPoint((AuthenticationEntryPoint)new OAuth2ExceptionEntryPoint())).sessionManagement(smc -> smc.sessionCreationPolicy(SessionCreationPolicy.STATELESS)).addFilterAfter((Filter)this.tenantAwareTenantIdentifierFilter(), SecurityContextHolderFilter.class);
        if (this.fineractProperties.getSecurity().getTwoFactor().isEnabled()) {
            http.addFilterAfter((Filter)this.twoFactorAuthenticationFilter(), BasicAuthenticationFilter.class);
        } else {
            http.addFilterAfter((Filter)this.insecureTwoFactorAuthenticationFilter(), BasicAuthenticationFilter.class);
        }
        if (this.serverProperties.getSsl().isEnabled()) {
            http.requiresChannel(channel -> ((ChannelSecurityConfigurer.RequiresChannelUrl)channel.requestMatchers(new RequestMatcher[]{AntPathRequestMatcher.antMatcher((String)"/api/**")})).requiresSecure());
        }
        if (this.fineractProperties.getSecurity().getHsts().isEnabled()) {
            http.requiresChannel(channel -> ((ChannelSecurityConfigurer.RequiresChannelUrl)channel.anyRequest()).requiresSecure()).headers(headers -> headers.httpStrictTransportSecurity(hsts -> hsts.includeSubDomains(true).maxAgeInSeconds(31536000L)));
        }
        return (SecurityFilterChain)http.build();
    }

    public TenantAwareTenantIdentifierFilter tenantAwareTenantIdentifierFilter() {
        return new TenantAwareTenantIdentifierFilter(this.basicAuthTenantDetailsService, this.toApiJsonSerializer, this.configurationDomainService, this.cacheWritePlatformService, this.businessDateReadPlatformService);
    }

    public TwoFactorAuthenticationFilter twoFactorAuthenticationFilter() {
        TwoFactorService twoFactorService = (TwoFactorService)this.applicationContext.getBean(TwoFactorService.class);
        return new TwoFactorAuthenticationFilter(twoFactorService);
    }

    public InsecureTwoFactorAuthenticationFilter insecureTwoFactorAuthenticationFilter() {
        return new InsecureTwoFactorAuthenticationFilter();
    }

    @Bean
    public PasswordEncoder passwordEncoder() {
        return PasswordEncoderFactories.createDelegatingPasswordEncoder();
    }

    private Converter<Jwt, FineractJwtAuthenticationToken> authenticationConverter() {
        return jwt -> {
            try {
                UserDetails user = this.userDetailsService.loadUserByUsername(jwt.getSubject());
                jwtGrantedAuthoritiesConverter.setAuthorityPrefix("");
                Collection authorities = jwtGrantedAuthoritiesConverter.convert(jwt);
                return new FineractJwtAuthenticationToken(jwt, authorities, user);
            }
            catch (UsernameNotFoundException ex) {
                throw new OAuth2AuthenticationException(new OAuth2Error("invalid_token"), (Throwable)ex);
            }
        };
    }
}

