/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.core.config;

import org.apache.fineract.infrastructure.core.config.FineractProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@Configuration
public class TaskExecutorConfig {
    @Autowired
    private FineractProperties fineractProperties;

    @Bean(value={"fineractDefaultThreadPoolTaskExecutor"})
    public ThreadPoolTaskExecutor fineractDefaultThreadPoolTaskExecutor() {
        ThreadPoolTaskExecutor threadPoolTaskExecutor = new ThreadPoolTaskExecutor();
        threadPoolTaskExecutor.setCorePoolSize(this.fineractProperties.getTaskExecutor().getDefaultTaskExecutorCorePoolSize());
        threadPoolTaskExecutor.setMaxPoolSize(this.fineractProperties.getTaskExecutor().getDefaultTaskExecutorMaxPoolSize());
        return threadPoolTaskExecutor;
    }

    @Bean(value={"fineractConfigurableThreadPoolTaskExecutor"})
    @Scope(scopeName="prototype")
    public ThreadPoolTaskExecutor fineractConfigurableThreadPoolTaskExecutor() {
        ThreadPoolTaskExecutor threadPoolTaskExecutor = new ThreadPoolTaskExecutor();
        threadPoolTaskExecutor.setCorePoolSize(this.fineractProperties.getTaskExecutor().getDefaultTaskExecutorCorePoolSize());
        threadPoolTaskExecutor.setMaxPoolSize(this.fineractProperties.getTaskExecutor().getDefaultTaskExecutorMaxPoolSize());
        return threadPoolTaskExecutor;
    }
}

