/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.creditbureau.service;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import jakarta.annotation.Nullable;
import jakarta.validation.constraints.NotNull;
import java.io.File;
import java.io.IOException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import lombok.Generated;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.commands.domain.CommandWrapper;
import org.apache.fineract.commands.service.CommandWrapperBuilder;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.DataValidatorBuilder;
import org.apache.fineract.infrastructure.core.domain.ExternalId;
import org.apache.fineract.infrastructure.core.exception.PlatformApiDataValidationException;
import org.apache.fineract.infrastructure.core.exception.PlatformDataIntegrityException;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.infrastructure.creditbureau.data.CreditBureauConfigurations;
import org.apache.fineract.infrastructure.creditbureau.data.CreditBureauReportData;
import org.apache.fineract.infrastructure.creditbureau.domain.CreditBureauConfiguration;
import org.apache.fineract.infrastructure.creditbureau.domain.CreditBureauConfigurationRepositoryWrapper;
import org.apache.fineract.infrastructure.creditbureau.domain.CreditBureauToken;
import org.apache.fineract.infrastructure.creditbureau.domain.TokenRepositoryWrapper;
import org.apache.fineract.infrastructure.creditbureau.serialization.CreditBureauTokenCommandFromApiJsonDeserializer;
import org.apache.fineract.infrastructure.creditbureau.service.ThitsaWorksCreditBureauIntegrationWritePlatformService;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ThitsaWorksCreditBureauIntegrationWritePlatformServiceImpl
implements ThitsaWorksCreditBureauIntegrationWritePlatformService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ThitsaWorksCreditBureauIntegrationWritePlatformServiceImpl.class);
    public static final String UPLOAD_CREDIT_REPORT = "UploadCreditReport";
    public static final String RESPONSE_MESSAGE = "ResponseMessage";
    public static final String IS_NOT_AVAILABLE_SUFFIX = ".is.not.available";
    private final PlatformSecurityContext context;
    private final FromJsonHelper fromApiJsonHelper;
    private final TokenRepositoryWrapper tokenRepositoryWrapper;
    private final CreditBureauConfigurationRepositoryWrapper configDataRepository;
    private final CreditBureauTokenCommandFromApiJsonDeserializer fromApiJsonDeserializer;
    private final OkHttpClient client;

    @Transactional
    public String okHttpConnectionMethod(String userName, String password, String subscriptionKey, String subscriptionId, String url, String token, File file, FormDataContentDisposition fileData, Long uniqueId, String nrcId, @NotNull String process) {
        String responseMessage = null;
        if (StringUtils.isBlank((CharSequence)url)) {
            throw new PlatformDataIntegrityException("error.msg.url.is.null.or.empty", "URL is null or empty", new Object[0]);
        }
        HttpUrl urlBuilder = HttpUrl.parse((String)url);
        if (urlBuilder == null) {
            throw new PlatformDataIntegrityException("error.url.not.parsed", "URL not parsed", new Object[0]);
        }
        String okHttpUrl = urlBuilder.toString();
        Request request = null;
        Request.Builder baseRequestBuilder = this.createRequestBuilder(subscriptionKey, subscriptionId, token, okHttpUrl);
        switch (process) {
            case "UploadCreditReport": {
                request = this.createRequest(baseRequestBuilder, () -> new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("file", fileData.getFileName(), RequestBody.create((File)file, (MediaType)MediaType.parse((String)"multipart/form-data"))).addFormDataPart("BODY", "formdata").addFormDataPart("userName", userName).build(), (requestBody, builder) -> builder.header("Content-Type", "multipart/form-data").post(requestBody).build());
                break;
            }
            case "CreditReport": {
                request = this.createRequest(baseRequestBuilder, builder -> builder.header("Content-Type", "application/x-www-form-urlencoded").get().build());
                break;
            }
            case "token": {
                request = this.createRequest(baseRequestBuilder, () -> RequestBody.create((String)("BODY=x-www-form-urlencoded&\rgrant_type=password&\ruserName=" + userName + "&\rpassword=" + password + "&\r"), (MediaType)MediaType.parse((String)"application/x-www-form-urlencoded")), (requestBody, builder) -> builder.header("Content-Type", "application/x-www-form-urlencoded").post(requestBody).build());
                break;
            }
            case "NRC": {
                request = this.createRequest(baseRequestBuilder, () -> RequestBody.create((String)("BODY=x-www-form-urlencoded&nrc=" + nrcId + "&"), (MediaType)MediaType.parse((String)"application/x-www-form-urlencoded")), (requestBody, builder) -> builder.header("Content-Type", "application/x-www-form-urlencoded").post(requestBody).build());
                break;
            }
            default: {
                this.handleAPIIntegrityIssues("Invalid Process");
            }
        }
        int responseCode = 0;
        try {
            Response response = this.client.newCall(request).execute();
            responseCode = response.code();
            responseMessage = response.body().string();
        }
        catch (IOException e) {
            log.error("error occured in HTTP request-response method.", (Throwable)e);
        }
        if (responseCode != 200) {
            this.httpResponse(Integer.valueOf(responseCode), responseMessage);
        }
        if (process.equals(UPLOAD_CREDIT_REPORT)) {
            JsonObject reportObject = JsonParser.parseString((String)responseMessage).getAsJsonObject();
            String responseMessageJson = reportObject.get(RESPONSE_MESSAGE).getAsString();
            this.handleAPIIntegrityIssues(responseMessageJson);
        }
        return responseMessage;
    }

    private Request createRequest(Request.Builder builder, Function<Request.Builder, Request> requestBuilder) {
        return requestBuilder.apply(builder);
    }

    private Request createRequest(Request.Builder builder, Supplier<RequestBody> requestBodySupplier, BiFunction<RequestBody, Request.Builder, Request> requestBuilder) {
        return requestBuilder.apply(requestBodySupplier.get(), builder);
    }

    private Request.Builder createRequestBuilder(String subscriptionKey, String subscriptionId, @Nullable String token, String url) {
        Request.Builder base = new Request.Builder().header("mcix-subscription-key", subscriptionKey).header("mcix-subscription-id", subscriptionId).url(url);
        if (token != null) {
            return base.header("Authorization", "Bearer " + token);
        }
        return base;
    }

    private void httpResponse(Integer responseCode, String responseMessage) {
        if (responseCode == 401) {
            String httpResponse = "HTTP_UNAUTHORIZED";
            this.handleAPIIntegrityIssues(httpResponse);
        } else if (responseCode == 403) {
            String httpResponse = "HTTP_FORBIDDEN";
            this.handleAPIIntegrityIssues(httpResponse);
        } else {
            String responseResult = "HTTP Response Code: " + responseCode + "/Response Message: " + responseMessage;
            this.handleAPIIntegrityIssues(responseResult);
        }
    }

    @Transactional
    public CreditBureauReportData getCreditReportFromThitsaWorks(JsonCommand command) {
        this.context.authenticatedUser();
        String nrcId = command.stringValueOfParameterNamed("NRC");
        String bureauID = command.stringValueOfParameterNamed("creditBureauID");
        Integer creditBureauId = Integer.parseInt(bureauID);
        String userName = this.getCreditBureauConfiguration(creditBureauId, CreditBureauConfigurations.USERNAME.toString());
        String password = this.getCreditBureauConfiguration(creditBureauId, CreditBureauConfigurations.PASSWORD.toString());
        String subscriptionId = this.getCreditBureauConfiguration(creditBureauId, CreditBureauConfigurations.SUBSCRIPTIONID.toString());
        String subscriptionKey = this.getCreditBureauConfiguration(creditBureauId, CreditBureauConfigurations.SUBSCRIPTIONKEY.toString());
        CreditBureauToken creditbureautoken = this.createToken(Long.valueOf(creditBureauId.longValue()));
        String token = creditbureautoken.getAccessToken();
        String process = "NRC";
        String url = this.getCreditBureauConfiguration(creditBureauId, CreditBureauConfigurations.SEARCHURL.toString());
        String nrcUrl = url + nrcId;
        String searchResult = this.okHttpConnectionMethod(userName, password, subscriptionKey, subscriptionId, nrcUrl, token, null, null, Long.valueOf(0L), nrcId, process);
        Long uniqueID = this.extractUniqueId(searchResult);
        process = "CreditReport";
        url = this.getCreditBureauConfiguration(creditBureauId, CreditBureauConfigurations.CREDITREPORTURL.toString());
        String creditReportUrl = url + uniqueID;
        searchResult = this.okHttpConnectionMethod(userName, password, subscriptionKey, subscriptionId, creditReportUrl, token, null, null, uniqueID, null, process);
        JsonObject reportObject = JsonParser.parseString((String)searchResult).getAsJsonObject();
        Optional<JsonObject> jsonData = Optional.ofNullable(reportObject.get("Data")).filter(JsonElement::isJsonObject).map(JsonElement::getAsJsonObject);
        Optional<JsonElement> element = jsonData.map(data -> data.get("BorrowerInfo"));
        Optional<JsonObject> borrowerInfos = element.filter(JsonElement::isJsonObject).map(JsonElement::getAsJsonObject);
        String borrowerInfo = borrowerInfos.map(data -> new Gson().toJson((JsonElement)data)).orElse(null);
        String name = borrowerInfos.map(data -> data.get("Name")).map(JsonElement::toString).orElse(null);
        String gender = borrowerInfos.map(data -> data.get("Gender")).map(JsonElement::toString).orElse(null);
        String address = borrowerInfos.map(data -> data.get("Address")).map(JsonElement::toString).orElse(null);
        String creditScore = "CreditScore";
        creditScore = this.getJsonObjectToString(creditScore, jsonData);
        String activeLoans = "ActiveLoans";
        String[] activeLoanStringArray = Optional.ofNullable(this.getJsonObjectToArray(activeLoans, jsonData)).map(arg_0 -> this.convertArrayintoStringArray(arg_0)).orElse(null);
        String writeOffLoans = "WriteOffLoans";
        String[] writeoffLoanStringArray = Optional.ofNullable(this.getJsonObjectToArray(writeOffLoans, jsonData)).map(arg_0 -> this.convertArrayintoStringArray(arg_0)).orElse(null);
        return CreditBureauReportData.instance((String)name, (String)gender, (String)address, (String)creditScore, (String)borrowerInfo, (String[])activeLoanStringArray, (String[])writeoffLoanStringArray);
    }

    @Transactional
    public String addCreditReport(Long bureauId, File creditReport, FormDataContentDisposition fileDetail) {
        Integer creditBureauId = bureauId.intValue();
        String userName = this.getCreditBureauConfiguration(creditBureauId, CreditBureauConfigurations.USERNAME.toString());
        String password = this.getCreditBureauConfiguration(creditBureauId, CreditBureauConfigurations.PASSWORD.toString());
        String subscriptionId = this.getCreditBureauConfiguration(creditBureauId, CreditBureauConfigurations.SUBSCRIPTIONID.toString());
        String subscriptionKey = this.getCreditBureauConfiguration(creditBureauId, CreditBureauConfigurations.SUBSCRIPTIONKEY.toString());
        CreditBureauToken creditbureautoken = this.createToken(Long.valueOf(creditBureauId.longValue()));
        String token = creditbureautoken.getAccessToken();
        CreditBureauConfiguration addReportURL = this.configDataRepository.getCreditBureauConfigData(creditBureauId, "addCreditReporturl");
        String url = addReportURL.getValue();
        return this.okHttpConnectionMethod(userName, password, subscriptionKey, subscriptionId, url, token, creditReport, fileDetail, Long.valueOf(0L), null, UPLOAD_CREDIT_REPORT);
    }

    private String[] convertArrayintoStringArray(JsonArray jsonResult) {
        String[] loanAccounts = new String[jsonResult.size()];
        int i = 0;
        for (JsonElement ele : jsonResult) {
            loanAccounts[i++] = ele.toString();
        }
        return loanAccounts;
    }

    @Transactional
    public Long extractUniqueId(String jsonResult) {
        JsonObject reportObject = JsonParser.parseString((String)jsonResult).getAsJsonObject();
        JsonElement element = reportObject.get("Data");
        if (element.isJsonNull()) {
            String responseMessage = reportObject.get(RESPONSE_MESSAGE).getAsString();
            this.handleAPIIntegrityIssues(responseMessage);
        }
        JsonObject jsonObject = JsonParser.parseString((String)jsonResult).getAsJsonObject();
        long uniqueID = 0L;
        try {
            JsonArray dataArray = jsonObject.getAsJsonArray("Data");
            if (dataArray.size() == 1) {
                JsonObject jobject = dataArray.get(0).getAsJsonObject();
                String uniqueIdString = jobject.get("UniqueID").toString();
                String trimUniqueId = uniqueIdString.substring(1, uniqueIdString.length() - 1);
                uniqueID = Long.parseLong(trimUniqueId);
            } else if (dataArray.size() == 0) {
                String responseMessage = reportObject.get(RESPONSE_MESSAGE).getAsString();
                this.handleAPIIntegrityIssues(responseMessage);
            } else {
                ArrayList<String> arrlist = new ArrayList<String>();
                for (int i = 0; i < dataArray.size(); ++i) {
                    JsonObject data = dataArray.get(i).getAsJsonObject();
                    String nrc = data.get("NRC").toString();
                    arrlist.add(nrc);
                }
                String listString = String.join((CharSequence)", ", arrlist);
                this.handleMultipleNRC(listString);
            }
        }
        catch (IndexOutOfBoundsException e) {
            String responseMessage = jsonObject.get(RESPONSE_MESSAGE).getAsString();
            this.handleAPIIntegrityIssues(responseMessage);
        }
        return uniqueID;
    }

    private String getJsonObjectToString(String fetchData, Optional<JsonObject> jsonData) {
        return jsonData.map(data -> data.get(fetchData)).filter(JsonElement::isJsonObject).map(JsonElement::getAsJsonObject).map(data -> new Gson().toJson((JsonElement)data)).orElse(null);
    }

    private JsonArray getJsonObjectToArray(String fetchData, Optional<JsonObject> jsonData) {
        return jsonData.map(data -> data.get(fetchData)).filter(JsonElement::isJsonArray).map(JsonElement::getAsJsonArray).orElse(null);
    }

    @Transactional
    public CreditBureauToken createToken(Long bureauID) {
        CreditBureauToken creditBureauToken = this.tokenRepositoryWrapper.getToken();
        if (creditBureauToken != null) {
            LocalDate current = DateUtils.getLocalDateOfTenant();
            LocalDate getExpiryDate = creditBureauToken.getExpires();
            if (DateUtils.isBefore((LocalDate)getExpiryDate, (LocalDate)current)) {
                this.tokenRepositoryWrapper.delete(creditBureauToken);
                creditBureauToken = null;
            }
        }
        if (creditBureauToken != null) {
            creditBureauToken = this.tokenRepositoryWrapper.getToken();
        }
        String userName = this.getCreditBureauConfiguration(Integer.valueOf(bureauID.intValue()), CreditBureauConfigurations.USERNAME.toString());
        String password = this.getCreditBureauConfiguration(Integer.valueOf(bureauID.intValue()), CreditBureauConfigurations.PASSWORD.toString());
        String subscriptionId = this.getCreditBureauConfiguration(Integer.valueOf(bureauID.intValue()), CreditBureauConfigurations.SUBSCRIPTIONID.toString());
        String subscriptionKey = this.getCreditBureauConfiguration(Integer.valueOf(bureauID.intValue()), CreditBureauConfigurations.SUBSCRIPTIONKEY.toString());
        if (creditBureauToken == null) {
            String url = this.getCreditBureauConfiguration(Integer.valueOf(bureauID.intValue()), CreditBureauConfigurations.TOKENURL.toString());
            String process = "token";
            Long uniqueID = 0L;
            String result = this.okHttpConnectionMethod(userName, password, subscriptionKey, subscriptionId, url, null, null, null, uniqueID, null, process);
            CommandWrapper wrapper = new CommandWrapperBuilder().withJson(result).build();
            String json = wrapper.getJson();
            JsonElement parsedCommand = this.fromApiJsonHelper.parse(json);
            JsonCommand apicommand = JsonCommand.from((String)json, (JsonElement)parsedCommand, (FromJsonHelper)this.fromApiJsonHelper, (String)wrapper.getEntityName(), (Long)wrapper.getEntityId(), (Long)wrapper.getSubentityId(), (Long)wrapper.getGroupId(), (Long)wrapper.getClientId(), (Long)wrapper.getLoanId(), (Long)wrapper.getSavingsId(), (String)wrapper.getTransactionId(), (String)wrapper.getHref(), (Long)wrapper.getProductId(), (Long)wrapper.getCreditBureauId(), (Long)wrapper.getOrganisationCreditBureauId(), (String)wrapper.getJobName(), (ExternalId)wrapper.getLoanExternalId());
            this.fromApiJsonDeserializer.validateForCreate(apicommand.json());
            CreditBureauToken generatedtoken = CreditBureauToken.fromJson((JsonCommand)apicommand);
            CreditBureauToken credittoken = this.tokenRepositoryWrapper.getToken();
            if (credittoken != null) {
                this.tokenRepositoryWrapper.delete(credittoken);
            }
            this.tokenRepositoryWrapper.save(generatedtoken);
            creditBureauToken = this.tokenRepositoryWrapper.getToken();
        }
        return creditBureauToken;
    }

    public String getCreditBureauConfiguration(Integer creditBureauId, String configurationParameterName) {
        String creditBureauConfigurationValue;
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("ThitsaWorksCreditBureauIntegration");
        try {
            CreditBureauConfiguration configurationParameterValue = this.configDataRepository.getCreditBureauConfigData(creditBureauId, configurationParameterName);
            creditBureauConfigurationValue = configurationParameterValue.getValue();
            if (creditBureauConfigurationValue.isEmpty()) {
                baseDataValidator.reset().failWithCode("creditBureau.configuration." + configurationParameterName + IS_NOT_AVAILABLE_SUFFIX, new Object[0]);
                throw new PlatformDataIntegrityException("creditBureau.Configuration." + configurationParameterName + IS_NOT_AVAILABLE_SUFFIX, "creditBureau.Configuration." + configurationParameterName + IS_NOT_AVAILABLE_SUFFIX, new Object[0]);
            }
        }
        catch (Exception ex) {
            baseDataValidator.reset().failWithCode("creditBureau.configuration.is.not.available", new Object[0]);
            throw new PlatformApiDataValidationException("creditBureau.Configuration.is.not.available" + String.valueOf(ex), "creditBureau.Configuration.is.not.available", dataValidationErrors);
        }
        return creditBureauConfigurationValue;
    }

    private void handleAPIIntegrityIssues(String httpResponse) {
        throw new PlatformDataIntegrityException(httpResponse, httpResponse, new Object[0]);
    }

    private void handleMultipleNRC(String nrc) {
        String showMessageForMultipleNRC = "Found Multiple NRC's, Enter one from the given:" + nrc + ".";
        throw new PlatformDataIntegrityException(showMessageForMultipleNRC, showMessageForMultipleNRC, new Object[0]);
    }

    @Generated
    public ThitsaWorksCreditBureauIntegrationWritePlatformServiceImpl(PlatformSecurityContext context, FromJsonHelper fromApiJsonHelper, TokenRepositoryWrapper tokenRepositoryWrapper, CreditBureauConfigurationRepositoryWrapper configDataRepository, CreditBureauTokenCommandFromApiJsonDeserializer fromApiJsonDeserializer, OkHttpClient client) {
        this.context = context;
        this.fromApiJsonHelper = fromApiJsonHelper;
        this.tokenRepositoryWrapper = tokenRepositoryWrapper;
        this.configDataRepository = configDataRepository;
        this.fromApiJsonDeserializer = fromApiJsonDeserializer;
        this.client = client;
    }
}

