/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.dataqueries.service;

import jakarta.validation.constraints.NotNull;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResultBuilder;
import org.apache.fineract.infrastructure.core.exception.PlatformDataIntegrityException;
import org.apache.fineract.infrastructure.core.service.database.DatabaseSpecificSQLGenerator;
import org.apache.fineract.infrastructure.dataqueries.data.EntityTables;
import org.apache.fineract.infrastructure.dataqueries.data.GenericResultsetData;
import org.apache.fineract.infrastructure.dataqueries.data.ResultsetColumnHeaderData;
import org.apache.fineract.infrastructure.dataqueries.exception.DatatableNotFoundException;
import org.apache.fineract.infrastructure.dataqueries.exception.DatatableSystemErrorException;
import org.apache.fineract.infrastructure.dataqueries.service.DatatableUtil;
import org.apache.fineract.infrastructure.dataqueries.service.GenericDataService;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.infrastructure.security.service.SqlValidator;
import org.apache.fineract.infrastructure.security.utils.ColumnValidator;
import org.apache.fineract.portfolio.search.service.SearchUtil;
import org.apache.fineract.useradministration.domain.AppUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.stereotype.Service;

@Service
public class DatatableUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DatatableUtil.class);
    private static final String APPLICATION_TABLE_NAME = "application_table_name";
    private final SearchUtil searchUtil;
    private final JdbcTemplate jdbcTemplate;
    private final SqlValidator sqlValidator;
    private final PlatformSecurityContext context;
    private final GenericDataService genericDataService;
    private final DatabaseSpecificSQLGenerator sqlGenerator;
    private final ColumnValidator columnValidator;

    public boolean isMultirowDatatable(List<ResultsetColumnHeaderData> columnHeaders) {
        return this.searchUtil.findFiltered(columnHeaders, e -> e.isNamed("id")) != null;
    }

    public String getFKField(EntityTables entityTable) {
        return entityTable.getForeignKeyColumnNameOnDatatable();
    }

    public String validateDatatableRegistered(String datatable) {
        this.validateDatatableName(datatable);
        if (!this.isRegisteredDataTable(datatable)) {
            throw new DatatableNotFoundException(datatable);
        }
        return datatable;
    }

    public void validateDatatableName(String name) {
        if (name == null || name.isEmpty()) {
            throw new PlatformDataIntegrityException("error.msg.datatables.datatable.null.name", "Data table name must not be blank.", new Object[0]);
        }
        if (!name.matches("^[a-zA-Z][a-zA-Z0-9\\-_\\s]{0,48}[a-zA-Z0-9]$")) {
            throw new PlatformDataIntegrityException("error.msg.datatables.datatable.invalid.name.regex", "Invalid data table name.", name, new Object[0]);
        }
        this.sqlValidator.validate(name);
    }

    public EntityTables resolveEntity(String entityName) {
        EntityTables entityTable = EntityTables.fromEntityName((String)entityName);
        if (entityTable == null) {
            throw new PlatformDataIntegrityException("error.msg.invalid.application.table", "Invalid Datatable entity: " + entityName, "name", new Object[]{entityName});
        }
        return entityTable;
    }

    @NotNull
    public EntityTables queryForApplicationEntity(String datatable) {
        this.sqlValidator.validate(datatable);
        String sql = "SELECT application_table_name FROM x_registered_table where registered_table_name = ?";
        SqlRowSet rowSet = this.jdbcTemplate.queryForRowSet("SELECT application_table_name FROM x_registered_table where registered_table_name = ?", new Object[]{datatable});
        if (!rowSet.next()) {
            throw new DatatableNotFoundException(datatable);
        }
        String applicationTableName = rowSet.getString(APPLICATION_TABLE_NAME);
        return this.resolveEntity(applicationTableName);
    }

    public CommandProcessingResult checkMainResourceExistsWithinScope(@NotNull EntityTables entityTable, Long appTableId) {
        String sql = this.dataScopedSQL(entityTable, appTableId);
        log.debug("data scoped sql: {}", (Object)sql);
        SqlRowSet rs = this.jdbcTemplate.queryForRowSet(sql);
        if (!rs.next()) {
            throw new DatatableNotFoundException(entityTable, appTableId);
        }
        Long officeId = (Long)rs.getObject("officeId");
        Long groupId = (Long)rs.getObject("groupId");
        Long clientId = (Long)rs.getObject("clientId");
        Long savingsId = (Long)rs.getObject("savingsId");
        Long loanId = (Long)rs.getObject("loanId");
        Long transactionId = (Long)rs.getObject("transactionId");
        Long entityId = (Long)rs.getObject("entityId");
        if (rs.next()) {
            throw new DatatableSystemErrorException("System Error: More than one row returned from data scoping query");
        }
        return new CommandProcessingResultBuilder().withOfficeId(officeId).withGroupId(groupId).withClientId(clientId).withSavingsId(savingsId).withLoanId(loanId).withTransactionId(transactionId == null ? null : String.valueOf(transactionId)).withEntityId(entityId).build();
    }

    public String dataScopedSQL(@NotNull EntityTables entityTable, Long appTableId) {
        AppUser currentUser = this.context.authenticatedUser();
        String officeHierarchy = currentUser.getOffice().getHierarchy();
        return switch (1.$SwitchMap$org$apache$fineract$infrastructure$dataqueries$data$EntityTables[entityTable.ordinal()]) {
            case 1 -> "select distinct x.* from ( (select o.id as officeId, l.group_id as groupId, l.client_id as clientId, null as savingsId, l.id as loanId, null as transactionId, null as entityId from m_loan l " + this.getClientOfficeJoinCondition(officeHierarchy, "l") + " where l.id = " + appTableId + ") union all (select o.id as officeId, l.group_id as groupId, l.client_id as clientId, null as savingsId, l.id as loanId, null as transactionId, null as entityId from m_loan l " + this.getGroupOfficeJoinCondition(officeHierarchy, "l") + " where l.id = " + appTableId + ") ) as x";
            case 2 -> "select distinct x.* from ( (select o.id as officeId, s.group_id as groupId, s.client_id as clientId, s.id as savingsId, null as loanId, null as transactionId, null as entityId from m_savings_account s " + this.getClientOfficeJoinCondition(officeHierarchy, "s") + " where s.id = " + appTableId + ") union all (select o.id as officeId, s.group_id as groupId, s.client_id as clientId, s.id as savingsId, null as loanId, null as transactionId, null as entityId from m_savings_account s " + this.getGroupOfficeJoinCondition(officeHierarchy, "s") + " where s.id = " + appTableId + ") ) as x";
            case 3 -> "select distinct x.* from ( (select o.id as officeId, s.group_id as groupId, s.client_id as clientId, s.id as savingsId, null as loanId, t.id as transactionId, null as entityId from m_savings_account_transaction t join m_savings_account s on t.savings_account_id = s.id " + this.getClientOfficeJoinCondition(officeHierarchy, "s") + " where t.id = " + appTableId + ") union all (select o.id as officeId, s.group_id as groupId, s.client_id as clientId, s.id as savingsId, null as loanId, t.id as transactionId, null as entityId from m_savings_account_transaction t join m_savings_account s on t.savings_account_id = s.id " + this.getGroupOfficeJoinCondition(officeHierarchy, "s") + " where t.id = " + appTableId + ") ) as x";
            case 4 -> "select o.id as officeId, null as groupId, c.id as clientId, null as savingsId, null as loanId, null as transactionId, null as entityId from m_client c " + this.getOfficeJoinCondition(officeHierarchy, "c") + " where c.id = " + appTableId;
            case 5, 6 -> "select o.id as officeId, g.id as groupId, null as clientId, null as savingsId, null as loanId, null as transactionId, null as entityId from m_group g " + this.getOfficeJoinCondition(officeHierarchy, "g") + " where g.id = " + appTableId;
            case 7 -> "select o.id as officeId, null as groupId, null as clientId, null as savingsId, null as loanId, null as transactionId, null as entityId from m_office o where o.hierarchy like '" + officeHierarchy + "%' and o.id = " + appTableId;
            case 8, 9, 10 -> "select null as officeId, null as groupId, null as clientId, null as savingsId, null as loanId, null as transactionId, p.id as entityId from " + entityTable.getName() + " as p WHERE p.id = " + appTableId;
            default -> throw new PlatformDataIntegrityException("error.msg.invalid.dataScopeCriteria", "Application Table: " + entityTable.getName() + " not catered for in data Scoping", new Object[0]);
        };
    }

    public String getOfficeJoinCondition(String officeHierarchy, String joinTableAlias) {
        return " join m_office o on o.id = " + joinTableAlias + ".office_id and o.hierarchy like '" + officeHierarchy + "%' ";
    }

    public String getGroupOfficeJoinCondition(String officeHierarchy, String appTableAlias) {
        return " join m_group g on g.id = " + appTableAlias + ".group_id " + this.getOfficeJoinCondition(officeHierarchy, "g");
    }

    public String getClientOfficeJoinCondition(String officeHierarchy, String appTableAlias) {
        return " join m_client c on c.id = " + appTableAlias + ".client_id " + this.getOfficeJoinCondition(officeHierarchy, "c");
    }

    public GenericResultsetData retrieveDataTableGenericResultSet(EntityTables entityTable, String dataTableName, Long appTableId, String order, Long id) {
        List columnHeaders = this.genericDataService.fillResultsetColumnHeaders(dataTableName);
        boolean multiRow = this.isMultirowDatatable(columnHeaders);
        String whereClause = this.getFKField(entityTable) + " = " + appTableId;
        this.sqlValidator.validate(whereClause);
        String sql = "select * from " + this.sqlGenerator.escape(dataTableName) + " where " + whereClause;
        if (multiRow && id != null) {
            sql = sql + " and id = " + id;
        }
        if (StringUtils.isNotBlank((CharSequence)order)) {
            this.columnValidator.validateSqlInjection(sql, new String[]{order});
            sql = sql + " order by " + order;
        }
        List result = this.genericDataService.fillResultsetRowData(sql, columnHeaders);
        return new GenericResultsetData(columnHeaders, result);
    }

    private boolean isRegisteredDataTable(String datatable) {
        String sql = "SELECT COUNT(application_table_name) FROM x_registered_table WHERE registered_table_name = ?";
        Integer count = (Integer)this.jdbcTemplate.queryForObject("SELECT COUNT(application_table_name) FROM x_registered_table WHERE registered_table_name = ?", Integer.class, new Object[]{datatable});
        return count != null && count > 0;
    }

    @Generated
    public DatatableUtil(SearchUtil searchUtil, JdbcTemplate jdbcTemplate, SqlValidator sqlValidator, PlatformSecurityContext context, GenericDataService genericDataService, DatabaseSpecificSQLGenerator sqlGenerator, ColumnValidator columnValidator) {
        this.searchUtil = searchUtil;
        this.jdbcTemplate = jdbcTemplate;
        this.sqlValidator = sqlValidator;
        this.context = context;
        this.genericDataService = genericDataService;
        this.sqlGenerator = sqlGenerator;
        this.columnValidator = columnValidator;
    }
}

