/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.dataqueries.service;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import jakarta.persistence.PersistenceException;
import jakarta.validation.constraints.NotNull;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.fineract.infrastructure.codes.service.CodeReadPlatformService;
import org.apache.fineract.infrastructure.configuration.domain.ConfigurationDomainService;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResultBuilder;
import org.apache.fineract.infrastructure.core.data.DataValidatorBuilder;
import org.apache.fineract.infrastructure.core.exception.ErrorHandler;
import org.apache.fineract.infrastructure.core.exception.GeneralPlatformDomainRuleException;
import org.apache.fineract.infrastructure.core.exception.PlatformDataIntegrityException;
import org.apache.fineract.infrastructure.core.exception.PlatformServiceUnavailableException;
import org.apache.fineract.infrastructure.core.serialization.DatatableCommandFromApiJsonDeserializer;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.apache.fineract.infrastructure.core.serialization.JsonParserHelper;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.infrastructure.core.service.MathUtil;
import org.apache.fineract.infrastructure.core.service.database.DatabaseSpecificSQLGenerator;
import org.apache.fineract.infrastructure.core.service.database.DatabaseType;
import org.apache.fineract.infrastructure.core.service.database.DatabaseTypeResolver;
import org.apache.fineract.infrastructure.core.service.database.JdbcJavaType;
import org.apache.fineract.infrastructure.core.service.database.SqlOperator;
import org.apache.fineract.infrastructure.dataqueries.api.DataTableApiConstant;
import org.apache.fineract.infrastructure.dataqueries.data.DataTableValidator;
import org.apache.fineract.infrastructure.dataqueries.data.EntityTables;
import org.apache.fineract.infrastructure.dataqueries.data.GenericResultsetData;
import org.apache.fineract.infrastructure.dataqueries.data.ResultsetColumnHeaderData;
import org.apache.fineract.infrastructure.dataqueries.data.ResultsetRowData;
import org.apache.fineract.infrastructure.dataqueries.exception.DatatableEntryRequiredException;
import org.apache.fineract.infrastructure.dataqueries.exception.DatatableNotFoundException;
import org.apache.fineract.infrastructure.dataqueries.service.DatatableKeywordGenerator;
import org.apache.fineract.infrastructure.dataqueries.service.DatatableReadService;
import org.apache.fineract.infrastructure.dataqueries.service.DatatableUtil;
import org.apache.fineract.infrastructure.dataqueries.service.DatatableWriteService;
import org.apache.fineract.infrastructure.dataqueries.service.GenericDataService;
import org.apache.fineract.infrastructure.event.business.domain.BusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.datatable.DatatableEntryCreatedBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.datatable.DatatableEntryDeletedBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.datatable.DatatableEntryDetails;
import org.apache.fineract.infrastructure.event.business.domain.datatable.DatatableEntryUpdatedBusinessEvent;
import org.apache.fineract.infrastructure.event.business.service.BusinessEventNotifierService;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.portfolio.search.service.SearchUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.orm.jpa.JpaSystemException;
import org.springframework.transaction.annotation.Transactional;

/*
 * Exception performing whole class analysis ignored.
 */
public class DatatableWriteServiceImpl
implements DatatableWriteService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DatatableWriteServiceImpl.class);
    private static final String CODE_VALUES_TABLE = "m_code_value";
    private static final String ENTITY_SUB_TYPE = "entity_subtype";
    private static final String ERROR_MSG_DATATABLE_COLUMN_MISSING_UPDATE_PARSE = "error.msg.datatable.column.missing.update.parse";
    private static final String DOES_NOT_EXIST = "does.not.exist";
    private static final String ALTER_TABLE = "ALTER TABLE ";
    private static final String RESOURCE_DATATABLE = "datatable";
    private static final String DEFAULT_NULL = " DEFAULT NULL";
    private static final String FOREIGN_KEY_CLAUSE = " FOREIGN KEY (";
    private static final String REFERENCES_CLAUSE = "REFERENCES ";
    private static final String NOT_NULL_CLAUSE = " NOT NULL";
    private final JdbcTemplate jdbcTemplate;
    private final DatabaseTypeResolver databaseTypeResolver;
    private final DatabaseSpecificSQLGenerator sqlGenerator;
    private final PlatformSecurityContext context;
    private final FromJsonHelper fromJsonHelper;
    private final GenericDataService genericDataService;
    private final DatatableCommandFromApiJsonDeserializer fromApiJsonDeserializer;
    private final ConfigurationDomainService configurationDomainService;
    private final CodeReadPlatformService codeReadPlatformService;
    private final DataTableValidator dataTableValidator;
    private final NamedParameterJdbcTemplate namedParameterJdbcTemplate;
    private final DatatableKeywordGenerator datatableKeywordGenerator;
    private final SearchUtil searchUtil;
    private final BusinessEventNotifierService businessEventNotifierService;
    private final DatatableReadService datatableReadService;
    private final DatatableUtil datatableUtil;

    @Transactional
    public void registerDatatable(String dataTableName, String entityName, String entitySubType) {
        Integer category = DataTableApiConstant.CATEGORY_DEFAULT;
        String permissionSql = this.getPermissionSql(dataTableName);
        this.registerDataTable(entityName, dataTableName, entitySubType, category, permissionSql);
    }

    @Transactional
    public void registerDatatable(JsonCommand command) {
        String applicationTableName = this.datatableReadService.getTableName(command.getUrl());
        String dataTableName = this.datatableReadService.getDataTableName(command.getUrl());
        String entitySubType = command.stringValueOfParameterNamed("entity_subtype");
        Integer category = this.getCategory(command);
        this.dataTableValidator.validateDataTableRegistration(command.json());
        String permissionSql = this.getPermissionSql(dataTableName);
        this.registerDataTable(applicationTableName, dataTableName, entitySubType, category, permissionSql);
    }

    @Transactional
    public void registerDatatable(JsonCommand command, String permissionSql) {
        String applicationTableName = this.datatableReadService.getTableName(command.getUrl());
        String dataTableName = this.datatableReadService.getDataTableName(command.getUrl());
        String entitySubType = command.stringValueOfParameterNamed("entity_subtype");
        Integer category = this.getCategory(command);
        this.dataTableValidator.validateDataTableRegistration(command.json());
        this.registerDataTable(applicationTableName, dataTableName, entitySubType, category, permissionSql);
    }

    @Transactional
    public void deregisterDatatable(String datatable) {
        this.datatableUtil.validateDatatableRegistered(datatable);
        String permissionList = "('CREATE_" + datatable + "', 'CREATE_" + datatable + "_CHECKER', 'READ_" + datatable + "', 'UPDATE_" + datatable + "', 'UPDATE_" + datatable + "_CHECKER', 'DELETE_" + datatable + "', 'DELETE_" + datatable + "_CHECKER')";
        String deleteRolePermissionsSql = "delete from m_role_permission where m_role_permission.permission_id in (select id from m_permission where code in " + permissionList + ")";
        String deletePermissionsSql = "delete from m_permission where code in " + permissionList;
        String deleteRegisteredDatatableSql = "delete from x_registered_table where registered_table_name = '" + datatable + "'";
        String deleteFromConfigurationSql = "delete from c_configuration where name ='" + datatable + "'";
        String[] sqlArray = new String[]{deleteRolePermissionsSql, deletePermissionsSql, deleteRegisteredDatatableSql, deleteFromConfigurationSql};
        this.jdbcTemplate.batchUpdate(sqlArray);
    }

    @Transactional
    public CommandProcessingResult createDatatable(JsonCommand command) {
        String datatableName = null;
        try {
            this.context.authenticatedUser();
            this.fromApiJsonDeserializer.validateForCreate(command.json());
            JsonElement element = this.fromJsonHelper.parse(command.json());
            JsonArray columns = this.fromJsonHelper.extractJsonArrayNamed("columns", element);
            datatableName = this.fromJsonHelper.extractStringNamed("datatableName", element);
            String entitySubType = this.fromJsonHelper.extractStringNamed("entitySubType", element);
            String entityName = this.fromJsonHelper.extractStringNamed("apptableName", element);
            Boolean multiRow = this.fromJsonHelper.extractBooleanNamed("multiRow", element);
            if (multiRow == null) {
                multiRow = false;
            }
            this.datatableUtil.validateDatatableName(datatableName);
            EntityTables entityTable = this.datatableUtil.resolveEntity(entityName);
            boolean isConstraintApproach = this.configurationDomainService.isConstraintApproachEnabledForDatatables();
            String fkColumnName = this.datatableUtil.getFKField(entityTable);
            String dataTableNameAlias = datatableName.toLowerCase().replaceAll("\\s", "_");
            String fkName = dataTableNameAlias + "_" + fkColumnName;
            StringBuilder sqlBuilder = new StringBuilder();
            sqlBuilder.append("CREATE TABLE ").append(this.sqlGenerator.escape(datatableName)).append(" (");
            if (multiRow.booleanValue()) {
                if (this.databaseTypeResolver.isMySQL()) {
                    sqlBuilder.append("id").append(" BIGINT NOT NULL AUTO_INCREMENT, ");
                } else if (this.databaseTypeResolver.isPostgreSQL()) {
                    sqlBuilder.append("id").append(" bigint NOT NULL GENERATED BY DEFAULT AS IDENTITY ( INCREMENT 1 START 1 MINVALUE 1 MAXVALUE 9223372036854775807 CACHE 1 ), ");
                } else {
                    throw new IllegalStateException("Current database is not supported");
                }
            }
            sqlBuilder.append(this.sqlGenerator.escape(fkColumnName)).append(" BIGINT NOT NULL, ");
            columns.add(this.addColumn("created_at", JdbcJavaType.DATETIME, false, null, false, false));
            columns.add(this.addColumn("updated_at", JdbcJavaType.DATETIME, false, null, false, false));
            HashMap codeMappings = new HashMap();
            StringBuilder constrainBuilder = new StringBuilder();
            for (JsonElement column : columns) {
                this.parseDatatableColumnObjectForCreate(column.getAsJsonObject(), sqlBuilder, constrainBuilder, dataTableNameAlias, codeMappings, isConstraintApproach);
            }
            sqlBuilder.delete(sqlBuilder.length() - 2, sqlBuilder.length());
            String fullFkName = "fk_" + fkName;
            if (multiRow.booleanValue()) {
                sqlBuilder.append(", PRIMARY KEY (").append("id").append(")");
                if (this.databaseTypeResolver.isMySQL()) {
                    sqlBuilder.append(", KEY ").append(this.sqlGenerator.escape("fk_" + fkColumnName)).append(" (").append(this.sqlGenerator.escape(fkColumnName)).append(")");
                }
                sqlBuilder.append(", CONSTRAINT ").append(this.sqlGenerator.escape(fullFkName)).append(" FOREIGN KEY (").append(this.sqlGenerator.escape(fkColumnName)).append(") ").append("REFERENCES ").append(this.sqlGenerator.escape(entityTable.getApptableName())).append(" (").append("id").append(")");
            } else {
                sqlBuilder.append(", PRIMARY KEY (").append(this.sqlGenerator.escape(fkColumnName)).append(")").append(", CONSTRAINT ").append(this.sqlGenerator.escape(fullFkName)).append(" FOREIGN KEY (").append(this.sqlGenerator.escape(fkColumnName)).append(") ").append("REFERENCES ").append(this.sqlGenerator.escape(entityTable.getApptableName())).append(" (").append("id").append(")");
            }
            sqlBuilder.append((CharSequence)constrainBuilder);
            sqlBuilder.append(")");
            if (this.databaseTypeResolver.isMySQL()) {
                sqlBuilder.append(" ENGINE=InnoDB DEFAULT CHARSET=UTF8MB4;");
            }
            log.debug("SQL:: {}", (Object)sqlBuilder);
            this.jdbcTemplate.execute(sqlBuilder.toString());
            if (multiRow.booleanValue()) {
                this.createFkIndex(datatableName, fkColumnName);
            }
            this.createIndexesForTable(datatableName, columns);
            this.registerDatatable(datatableName, entityName, entitySubType);
            this.registerColumnCodeMapping(codeMappings);
        }
        catch (PersistenceException | DataAccessException e) {
            Throwable realCause = e.getCause();
            ArrayList dataValidationErrors = new ArrayList();
            DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("datatable");
            if (realCause.getMessage().toLowerCase().contains("duplicate column name")) {
                baseDataValidator.reset().parameter("name").failWithCode("duplicate.column.name", new Object[0]);
            } else if ((realCause.getMessage().contains("Table") || realCause.getMessage().contains("relation")) && realCause.getMessage().contains("already exists")) {
                baseDataValidator.reset().parameter("datatableName").value((Object)datatableName).failWithCode("datatable.already.exists", new Object[0]);
            } else if (realCause.getMessage().contains("Column") && realCause.getMessage().contains("big")) {
                baseDataValidator.reset().parameter("column").failWithCode("length.too.big", new Object[0]);
            } else if (realCause.getMessage().contains("Row") && realCause.getMessage().contains("large")) {
                baseDataValidator.reset().parameter("row").failWithCode("size.too.large", new Object[0]);
            }
            baseDataValidator.throwValidationErrors();
        }
        return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withResourceIdAsString(datatableName).build();
    }

    @Transactional
    public void updateDatatable(String datatableName, JsonCommand command) {
        block38: {
            try {
                Cloneable codeMappings;
                StringBuilder constrainBuilder;
                StringBuilder sqlBuilder;
                EntityTables oldEntityTable;
                EntityTables entityTable;
                this.context.authenticatedUser();
                this.fromApiJsonDeserializer.validateForUpdate(command.json());
                JsonElement element = this.fromJsonHelper.parse(command.json());
                JsonArray changeColumns = this.fromJsonHelper.extractJsonArrayNamed("changeColumns", element);
                JsonArray addColumns = this.fromJsonHelper.extractJsonArrayNamed("addColumns", element);
                JsonArray dropColumns = this.fromJsonHelper.extractJsonArrayNamed("dropColumns", element);
                String entityName = this.fromJsonHelper.extractStringNamed("apptableName", element);
                String entitySubType = this.fromJsonHelper.extractStringNamed("entitySubType", element);
                this.datatableUtil.validateDatatableName(datatableName);
                int rowCount = this.getDatatableRowCount(datatableName);
                List columnHeaderData = this.genericDataService.fillResultsetColumnHeaders(datatableName);
                Map mapColumnNameDefinition = this.searchUtil.mapHeadersToName((Collection)columnHeaderData);
                boolean isConstraintApproach = this.configurationDomainService.isConstraintApproachEnabledForDatatables();
                if (!StringUtils.isBlank((CharSequence)entitySubType)) {
                    this.jdbcTemplate.update("update x_registered_table SET entity_subtype=? WHERE registered_table_name = ?", new Object[]{entitySubType, datatableName});
                }
                if (!StringUtils.isBlank((CharSequence)entityName) && (entityTable = this.datatableUtil.resolveEntity(entityName)) != (oldEntityTable = this.datatableUtil.queryForApplicationEntity(datatableName))) {
                    String oldFKName = this.datatableUtil.getFKField(oldEntityTable);
                    String newFKName = this.datatableUtil.getFKField(entityTable);
                    String oldConstraintName = datatableName.toLowerCase().replaceAll("\\s", "_") + "_" + oldFKName;
                    String newConstraintName = datatableName.toLowerCase().replaceAll("\\s", "_") + "_" + (String)newFKName;
                    StringBuilder sqlBuilder2 = new StringBuilder();
                    String fullOldFk = "fk_" + oldFKName;
                    String fullOldConstraint = "fk_" + oldConstraintName;
                    String fullNewFk = "fk_" + (String)newFKName;
                    String fullNewConstraint = "fk_" + newConstraintName;
                    if (mapColumnNameDefinition.containsKey("id")) {
                        sqlBuilder2.append("ALTER TABLE ").append(this.sqlGenerator.escape(datatableName)).append(" DROP KEY ").append(this.sqlGenerator.escape(fullOldFk)).append(",").append("DROP FOREIGN KEY ").append(this.sqlGenerator.escape(fullOldConstraint)).append(",").append("CHANGE COLUMN ").append(this.sqlGenerator.escape(oldFKName)).append(" ").append(this.sqlGenerator.escape(newFKName)).append(" BIGINT NOT NULL,").append("ADD KEY ").append(this.sqlGenerator.escape(fullNewFk)).append(" (").append(this.sqlGenerator.escape(newFKName)).append("),").append("ADD CONSTRAINT ").append(this.sqlGenerator.escape(fullNewConstraint)).append(" FOREIGN KEY (").append(this.sqlGenerator.escape(newFKName)).append(") ").append("REFERENCES ").append(this.sqlGenerator.escape(entityTable.getApptableName())).append(" (").append("id").append(")");
                    } else {
                        sqlBuilder2.append("ALTER TABLE ").append(this.sqlGenerator.escape(datatableName)).append(" DROP FOREIGN KEY ").append(this.sqlGenerator.escape(fullOldConstraint)).append(",").append("CHANGE COLUMN ").append(this.sqlGenerator.escape(oldFKName)).append(" ").append(this.sqlGenerator.escape(newFKName)).append(" BIGINT NOT NULL,").append("ADD CONSTRAINT ").append(this.sqlGenerator.escape(fullNewConstraint)).append(" FOREIGN KEY (").append(this.sqlGenerator.escape(newFKName)).append(") ").append("REFERENCES ").append(this.sqlGenerator.escape(entityTable.getApptableName())).append(" (").append("id").append(")");
                    }
                    this.jdbcTemplate.execute(sqlBuilder2.toString());
                    this.deregisterDatatable(datatableName);
                    this.registerDatatable(datatableName, entityName, entitySubType);
                }
                if (changeColumns == null && addColumns == null && dropColumns == null) {
                    return;
                }
                if (dropColumns != null) {
                    if (rowCount > 0) {
                        throw new GeneralPlatformDomainRuleException("error.msg.non.empty.datatable.column.cannot.be.deleted", "Non-empty datatable columns can not be deleted.", new Object[0]);
                    }
                    sqlBuilder = new StringBuilder("ALTER TABLE " + this.sqlGenerator.escape(datatableName));
                    constrainBuilder = new StringBuilder();
                    codeMappings = new ArrayList();
                    for (JsonElement column : dropColumns) {
                        this.parseDatatableColumnForDrop(column.getAsJsonObject(), sqlBuilder, datatableName, constrainBuilder, codeMappings);
                    }
                    int indexOfFirstComma = sqlBuilder.indexOf(",");
                    if (indexOfFirstComma != -1) {
                        sqlBuilder.deleteCharAt(indexOfFirstComma);
                    }
                    sqlBuilder.append((CharSequence)constrainBuilder);
                    this.jdbcTemplate.execute(sqlBuilder.toString());
                    this.deleteColumnCodeMapping(codeMappings);
                }
                if (addColumns != null) {
                    sqlBuilder = new StringBuilder("ALTER TABLE " + this.sqlGenerator.escape(datatableName));
                    constrainBuilder = new StringBuilder();
                    codeMappings = new HashMap();
                    for (JsonElement column : addColumns) {
                        Iterator columnAsJson = column.getAsJsonObject();
                        if (rowCount > 0 && columnAsJson.has("mandatory") && columnAsJson.get("mandatory").getAsBoolean()) {
                            throw new GeneralPlatformDomainRuleException("error.msg.non.empty.datatable.mandatory.column.cannot.be.added", "Non empty datatable mandatory columns can not be added.", new Object[0]);
                        }
                        this.parseDatatableColumnForAdd((JsonObject)columnAsJson, sqlBuilder, datatableName.toLowerCase().replaceAll("\\s", "_"), constrainBuilder, codeMappings, isConstraintApproach);
                    }
                    int indexOfFirstComma = sqlBuilder.indexOf(",");
                    if (indexOfFirstComma != -1) {
                        sqlBuilder.deleteCharAt(indexOfFirstComma);
                    }
                    sqlBuilder.append((CharSequence)constrainBuilder);
                    this.jdbcTemplate.execute(sqlBuilder.toString());
                    this.createIndexesForTable(datatableName, addColumns);
                    this.registerColumnCodeMapping(codeMappings);
                }
                if (changeColumns == null) break block38;
                StringBuilder renameBuilder = new StringBuilder();
                StringBuilder changeBuilder = new StringBuilder();
                StringBuilder constrainBuilder2 = new StringBuilder();
                HashMap codeMappings2 = new HashMap();
                ArrayList removeMappings = new ArrayList();
                for (JsonElement column : changeColumns) {
                    this.removeNullValuesFromStringColumn(datatableName, column.getAsJsonObject(), mapColumnNameDefinition);
                    this.parseDatatableColumnForUpdate(column.getAsJsonObject(), mapColumnNameDefinition, datatableName, renameBuilder, changeBuilder, constrainBuilder2, codeMappings2, removeMappings, isConstraintApproach);
                }
                StringBuilder sqlBuilder3 = renameBuilder;
                if (!changeBuilder.isEmpty() || !constrainBuilder2.isEmpty()) {
                    int idx = changeBuilder.indexOf(",");
                    if (idx > -1) {
                        changeBuilder.deleteCharAt(idx);
                    } else {
                        idx = constrainBuilder2.indexOf(",");
                        if (idx > -1) {
                            constrainBuilder2.deleteCharAt(idx);
                        }
                    }
                    sqlBuilder3.append("ALTER TABLE " + this.sqlGenerator.escape(datatableName)).append((CharSequence)changeBuilder).append((CharSequence)constrainBuilder2);
                }
                try {
                    if (!sqlBuilder3.isEmpty()) {
                        this.jdbcTemplate.execute(sqlBuilder3.toString());
                    }
                    this.deleteColumnCodeMapping(removeMappings);
                    this.registerColumnCodeMapping(codeMappings2);
                    this.updateUniqueConstraintsForTable(datatableName, changeColumns, mapColumnNameDefinition);
                    this.updateIndexesForTable(datatableName, changeColumns, mapColumnNameDefinition);
                }
                catch (Exception e) {
                    log.error("Exception while modifying a datatable", (Throwable)e);
                    if (e.getMessage().contains("Error on rename")) {
                        throw new PlatformServiceUnavailableException("error.msg.datatable.column.update.not.allowed", "One of the column name modification not allowed", new Object[]{e});
                    }
                    if (e.getMessage().toLowerCase().contains("invalid use of null value")) {
                        throw new PlatformServiceUnavailableException("error.msg.datatable.column.update.not.allowed", "One of the data table columns contains null values", new Object[]{e});
                    }
                }
            }
            catch (DataIntegrityViolationException | JpaSystemException e) {
                Throwable realCause = e.getCause();
                ArrayList dataValidationErrors = new ArrayList();
                DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("datatable");
                if (realCause.getMessage().toLowerCase().contains("unknown column")) {
                    baseDataValidator.reset().parameter("name").failWithCode("does.not.exist", new Object[0]);
                } else if (realCause.getMessage().toLowerCase().contains("can't drop")) {
                    baseDataValidator.reset().parameter("name").failWithCode("does.not.exist", new Object[0]);
                } else if (realCause.getMessage().toLowerCase().contains("duplicate column")) {
                    baseDataValidator.reset().parameter("name").failWithCode("column.already.exists", new Object[0]);
                }
                baseDataValidator.throwValidationErrors();
            }
            catch (PersistenceException ee) {
                Throwable realCause = ExceptionUtils.getRootCause((Throwable)ee.getCause());
                ArrayList dataValidationErrors = new ArrayList();
                DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("datatable");
                if (realCause.getMessage().toLowerCase().contains("duplicate column name")) {
                    baseDataValidator.reset().parameter("name").failWithCode("duplicate.column.name", new Object[0]);
                } else if ((realCause.getMessage().contains("Table") || realCause.getMessage().contains("relation")) && realCause.getMessage().contains("already exists")) {
                    baseDataValidator.reset().parameter("datatableName").value((Object)datatableName).failWithCode("datatable.already.exists", new Object[0]);
                } else if (realCause.getMessage().contains("Column") && realCause.getMessage().contains("big")) {
                    baseDataValidator.reset().parameter("column").failWithCode("length.too.big", new Object[0]);
                } else if (realCause.getMessage().contains("Row") && realCause.getMessage().contains("large")) {
                    baseDataValidator.reset().parameter("row").failWithCode("size.too.large", new Object[0]);
                }
                baseDataValidator.throwValidationErrors();
            }
        }
    }

    @Transactional
    public void deleteDatatable(String datatableName) {
        try {
            String[] sqlArray;
            this.context.authenticatedUser();
            this.datatableUtil.validateDatatableName(datatableName);
            this.assertDataTableEmpty(datatableName);
            this.deregisterDatatable(datatableName);
            if (this.configurationDomainService.isConstraintApproachEnabledForDatatables()) {
                String deleteColumnCodeSql = "delete from x_table_column_code_mappings where column_alias_name like'" + datatableName.toLowerCase().replaceAll("\\s", "_") + "_%'";
                sqlArray = new String[2];
                sqlArray[1] = deleteColumnCodeSql;
            } else {
                sqlArray = new String[1];
            }
            String sql = "DROP TABLE " + this.sqlGenerator.escape(datatableName);
            sqlArray[0] = sql;
            this.jdbcTemplate.batchUpdate(sqlArray);
        }
        catch (DataIntegrityViolationException | JpaSystemException e) {
            Throwable realCause = e.getCause();
            ArrayList dataValidationErrors = new ArrayList();
            DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("datatable");
            if (realCause.getMessage().contains("Unknown table")) {
                baseDataValidator.reset().parameter("datatableName").failWithCode("does.not.exist", new Object[0]);
            }
            baseDataValidator.throwValidationErrors();
        }
    }

    @Transactional
    public CommandProcessingResult createNewDatatableEntry(String dataTableName, Long appTableId, JsonCommand command) {
        return this.createNewDatatableEntry(dataTableName, appTableId, command.json(), false);
    }

    @Transactional
    public CommandProcessingResult createNewDatatableEntry(String dataTableName, Long appTableId, String json) {
        return this.createNewDatatableEntry(dataTableName, appTableId, json, false);
    }

    @Transactional
    public CommandProcessingResult createPPIEntry(String dataTableName, Long appTableId, JsonCommand command) {
        return this.createNewDatatableEntry(dataTableName, appTableId, command.json(), true);
    }

    @Transactional
    public CommandProcessingResult updateDatatableEntryOneToOne(String dataTableName, Long appTableId, JsonCommand command) {
        return this.updateDatatableEntry(dataTableName, appTableId, null, command);
    }

    @Transactional
    public CommandProcessingResult updateDatatableEntryOneToMany(String dataTableName, Long appTableId, Long datatableId, JsonCommand command) {
        return this.updateDatatableEntry(dataTableName, appTableId, datatableId, command);
    }

    @Transactional
    public CommandProcessingResult deleteDatatableEntries(String dataTableName, Long appTableId, JsonCommand command) {
        return this.deleteDatatableEntries(dataTableName, appTableId, null, command);
    }

    @Transactional
    public CommandProcessingResult deleteDatatableEntry(String dataTableName, Long appTableId, Long datatableId, JsonCommand command) {
        return this.deleteDatatableEntries(dataTableName, appTableId, datatableId, command);
    }

    private void registerDataTable(String entityName, String dataTableName, String entitySubType, Integer category, String permissionsSql) {
        this.datatableUtil.resolveEntity(entityName);
        this.datatableUtil.validateDatatableName(dataTableName);
        this.validateDataTableExists(dataTableName);
        HashMap<String, Object> paramMap = new HashMap<String, Object>(3);
        String registerDatatableSql = "insert into x_registered_table (registered_table_name, application_table_name, entity_subtype, category) values (:dataTableName, :applicationTableName, :entitySubType, :category)";
        paramMap.put("dataTableName", dataTableName);
        paramMap.put("applicationTableName", entityName);
        paramMap.put("entitySubType", entitySubType);
        paramMap.put("category", category);
        try {
            this.namedParameterJdbcTemplate.update("insert into x_registered_table (registered_table_name, application_table_name, entity_subtype, category) values (:dataTableName, :applicationTableName, :entitySubType, :category)", paramMap);
            this.jdbcTemplate.update(permissionsSql);
            if (category.equals(DataTableApiConstant.CATEGORY_PPI)) {
                this.namedParameterJdbcTemplate.update("insert into c_configuration (name, value, enabled ) values( :dataTableName, '0', false)", paramMap);
            }
        }
        catch (DataIntegrityViolationException | JpaSystemException dve) {
            this.handleDataIntegrityIssues(dataTableName, null, dve.getMostSpecificCause(), (Exception)dve);
        }
        catch (PersistenceException dve) {
            this.handleDataIntegrityIssues(dataTableName, null, ExceptionUtils.getRootCause((Throwable)dve.getCause()), (Exception)((Object)dve));
        }
    }

    private String getPermissionSql(String dataTableName) {
        String createPermission = "'CREATE_" + dataTableName + "'";
        String createPermissionChecker = "'CREATE_" + dataTableName + "_CHECKER'";
        String readPermission = "'READ_" + dataTableName + "'";
        String updatePermission = "'UPDATE_" + dataTableName + "'";
        String updatePermissionChecker = "'UPDATE_" + dataTableName + "_CHECKER'";
        String deletePermission = "'DELETE_" + dataTableName + "'";
        String deletePermissionChecker = "'DELETE_" + dataTableName + "_CHECKER'";
        List<String> escapedColumns = Stream.of("grouping", "code", "action_name", "entity_name", "can_maker_checker").map(arg_0 -> ((DatabaseSpecificSQLGenerator)this.sqlGenerator).escape(arg_0)).toList();
        String columns = String.join((CharSequence)", ", escapedColumns);
        return "insert into m_permission (" + columns + ") values ('datatable', " + createPermission + ", 'CREATE', '" + dataTableName + "', true),('datatable', " + createPermissionChecker + ", 'CREATE', '" + dataTableName + "', false),('datatable', " + readPermission + ", 'READ', '" + dataTableName + "', false),('datatable', " + updatePermission + ", 'UPDATE', '" + dataTableName + "', true),('datatable', " + updatePermissionChecker + ", 'UPDATE', '" + dataTableName + "', false),('datatable', " + deletePermission + ", 'DELETE', '" + dataTableName + "', true),('datatable', " + deletePermissionChecker + ", 'DELETE', '" + dataTableName + "', false)";
    }

    private Integer getCategory(JsonCommand command) {
        Integer category = command.integerValueOfParameterNamedDefaultToNullIfZero("category");
        return category == null ? DataTableApiConstant.CATEGORY_DEFAULT : category;
    }

    private JsonElement addColumn(String name, JdbcJavaType dataType, boolean isMandatory, Integer length, boolean isUnique, boolean isIndexed) {
        JsonObject column = new JsonObject();
        column.addProperty("name", name);
        column.addProperty("type", dataType.formatSql(this.databaseTypeResolver.databaseType()));
        if (dataType.isStringType()) {
            column.addProperty("length", (Number)length);
        }
        column.addProperty("mandatory", Boolean.toString(isMandatory));
        column.addProperty("unique", Boolean.toString(isUnique));
        column.addProperty("indexed", Boolean.toString(isIndexed));
        return column;
    }

    private void parseDatatableColumnObjectForCreate(JsonObject column, StringBuilder sqlBuilder, StringBuilder constrainBuilder, String dataTableNameAlias, Map<String, Long> codeMappings, boolean isConstraintApproach) {
        String code;
        String name = column.has("name") ? column.get("name").getAsString() : null;
        String type = column.has("type") ? column.get("type").getAsString().toLowerCase() : null;
        Integer length = column.has("length") ? Integer.valueOf(column.get("length").getAsInt()) : null;
        boolean mandatory = column.has("mandatory") && column.get("mandatory").getAsBoolean();
        boolean unique = column.has("unique") && column.get("unique").getAsBoolean();
        String string = code = column.has("code") ? column.get("code").getAsString() : null;
        if (StringUtils.isNotBlank((CharSequence)code)) {
            if (isConstraintApproach) {
                codeMappings.put(dataTableNameAlias + "_" + name, this.codeReadPlatformService.retriveCode(code).getId());
                String fkName = "fk_" + dataTableNameAlias + "_" + name;
                constrainBuilder.append(", CONSTRAINT ").append(this.sqlGenerator.escape(fkName)).append(" ").append("FOREIGN KEY (").append(this.sqlGenerator.escape(name)).append(") ").append("REFERENCES ").append(this.sqlGenerator.escape("m_code_value")).append(" (id)");
            } else {
                name = this.datatableColumnNameToCodeValueName(name, code);
            }
        }
        sqlBuilder.append(this.sqlGenerator.escape(name));
        if (type != null) {
            sqlBuilder.append(" ").append(this.mapApiTypeToDbType(type, length));
        }
        if (unique) {
            String uniqueKeyName = this.datatableKeywordGenerator.generateUniqueKeyName(dataTableNameAlias, name);
            constrainBuilder.append(", CONSTRAINT ").append(this.sqlGenerator.escape(uniqueKeyName)).append(" ").append("UNIQUE (").append(this.sqlGenerator.escape(name)).append(")");
        }
        if (mandatory) {
            sqlBuilder.append(" NOT NULL");
        } else {
            sqlBuilder.append(" DEFAULT NULL");
        }
        sqlBuilder.append(", ");
    }

    private void createFkIndex(String datatableName, String fkColumnName) {
        String indexName = this.datatableKeywordGenerator.generateIndexName(datatableName, fkColumnName);
        this.createIndex(indexName, datatableName, fkColumnName);
    }

    private void createIndexesForTable(String datatableName, JsonArray columns) {
        for (JsonElement column : columns) {
            this.createIndexForColumn(datatableName, column.getAsJsonObject());
        }
    }

    private void createIndexForColumn(String datatableName, JsonObject column) {
        boolean indexed;
        String name = column.has("name") ? column.get("name").getAsString() : null;
        boolean unique = column.has("unique") && column.get("unique").getAsBoolean();
        boolean bl = indexed = column.has("indexed") && column.get("indexed").getAsBoolean();
        if (!unique && indexed) {
            String indexName = this.datatableKeywordGenerator.generateIndexName(datatableName, name);
            this.createIndex(indexName, datatableName, name);
        }
    }

    private void parseDatatableColumnForAdd(JsonObject column, StringBuilder sqlBuilder, String dataTableNameAlias, StringBuilder constrainBuilder, Map<String, Long> codeMappings, boolean isConstraintApproach) {
        String code;
        String name = column.has("name") ? column.get("name").getAsString() : null;
        String type = column.has("type") ? column.get("type").getAsString().toLowerCase() : null;
        Integer length = column.has("length") ? Integer.valueOf(column.get("length").getAsInt()) : null;
        boolean mandatory = column.has("mandatory") && column.get("mandatory").getAsBoolean();
        boolean unique = column.has("unique") && column.get("unique").getAsBoolean();
        String after = column.has("after") ? column.get("after").getAsString() : null;
        String string = code = column.has("code") ? column.get("code").getAsString() : null;
        if (StringUtils.isNotBlank((CharSequence)code)) {
            if (isConstraintApproach) {
                String fkName = "fk_" + dataTableNameAlias + "_" + name;
                codeMappings.put(dataTableNameAlias + "_" + name, this.codeReadPlatformService.retriveCode(code).getId());
                constrainBuilder.append(",ADD CONSTRAINT  ").append(this.sqlGenerator.escape(fkName)).append(" ").append("FOREIGN KEY (").append(this.sqlGenerator.escape(name)).append(") ").append("REFERENCES ").append(this.sqlGenerator.escape("m_code_value")).append(" (").append("id").append(")");
            } else {
                name = this.datatableColumnNameToCodeValueName(name, code);
            }
        }
        sqlBuilder.append(", ADD ").append(this.sqlGenerator.escape(name)).append(" ").append(this.mapApiTypeToDbType(type, length));
        if (unique) {
            String uniqueKeyName = this.datatableKeywordGenerator.generateUniqueKeyName(dataTableNameAlias, name);
            constrainBuilder.append(",ADD CONSTRAINT  ").append(this.sqlGenerator.escape(uniqueKeyName)).append(" ").append("UNIQUE (").append(this.sqlGenerator.escape(name)).append(")");
        }
        if (mandatory) {
            sqlBuilder.append(" NOT NULL");
        } else {
            sqlBuilder.append(" DEFAULT NULL");
        }
        if (after != null) {
            sqlBuilder.append(" AFTER ").append(this.sqlGenerator.escape(after));
        }
    }

    private void parseDatatableColumnForUpdate(JsonObject column, Map<String, ResultsetColumnHeaderData> mapColumnNameDefinition, String datatableName, StringBuilder renameBuilder, StringBuilder changeBuilder, StringBuilder constrainBuilder, Map<String, Long> codeMappings, List<String> removeMappings, boolean isConstraintApproach) {
        boolean afterChanged;
        String oldName;
        String string = oldName = column.has("name") ? column.get("name").getAsString() : null;
        if (!mapColumnNameDefinition.containsKey(oldName)) {
            throw new PlatformDataIntegrityException("error.msg.datatable.column.missing.update.parse", "Column " + oldName + " does not exist.", oldName, new Object[0]);
        }
        String lengthStr = column.has("length") ? column.get("length").getAsString() : null;
        Long length = StringUtils.isNotBlank((CharSequence)lengthStr) ? Long.valueOf(Long.parseLong(lengthStr)) : null;
        String newName = column.has("newName") ? column.get("newName").getAsString() : null;
        Boolean newMandatory = column.has("mandatory") ? Boolean.valueOf(column.get("mandatory").getAsBoolean()) : null;
        String after = column.has("after") ? column.get("after").getAsString() : null;
        String code = column.has("code") ? column.get("code").getAsString() : null;
        String newCode = column.has("newCode") ? column.get("newCode").getAsString() : null;
        String dataTableNameAlias = datatableName.toLowerCase().replaceAll("\\s", "_");
        if (isConstraintApproach) {
            if (StringUtils.isBlank((CharSequence)newName)) {
                newName = oldName;
            }
            String fkName = "fk_" + dataTableNameAlias + "_" + oldName;
            String newFkName = "fk_" + dataTableNameAlias + "_" + newName;
            if (!StringUtils.equalsIgnoreCase((CharSequence)code, (CharSequence)newCode) || !StringUtils.equalsIgnoreCase((CharSequence)oldName, (CharSequence)newName)) {
                if (StringUtils.equalsIgnoreCase((CharSequence)code, (CharSequence)newCode)) {
                    int codeId = this.getCodeIdForColumn(dataTableNameAlias, oldName);
                    if (codeId > 0) {
                        removeMappings.add(dataTableNameAlias + "_" + oldName);
                        constrainBuilder.append(", DROP CONSTRAINT ").append(this.sqlGenerator.escape(fkName)).append(" ");
                        codeMappings.put(dataTableNameAlias + "_" + newName, Long.valueOf(codeId));
                        constrainBuilder.append(", ADD CONSTRAINT ").append(this.sqlGenerator.escape(newFkName)).append(" ").append("FOREIGN KEY (").append(this.sqlGenerator.escape(newName)).append(") ").append("REFERENCES ").append(this.sqlGenerator.escape("m_code_value")).append(" (").append("id").append(")");
                    }
                } else {
                    if (code != null) {
                        removeMappings.add(dataTableNameAlias + "_" + oldName);
                        if (newCode == null || !StringUtils.equalsIgnoreCase((CharSequence)oldName, (CharSequence)newName)) {
                            constrainBuilder.append(", DROP CONSTRAINT ").append(this.sqlGenerator.escape(fkName)).append(" ");
                        }
                    }
                    if (newCode != null) {
                        codeMappings.put(dataTableNameAlias + "_" + newName, this.codeReadPlatformService.retriveCode(newCode).getId());
                        if (code == null || !StringUtils.equalsIgnoreCase((CharSequence)oldName, (CharSequence)newName)) {
                            constrainBuilder.append(", ADD CONSTRAINT  ").append(this.sqlGenerator.escape(newFkName)).append(" ").append("FOREIGN KEY (").append(this.sqlGenerator.escape(newName)).append(") ").append("REFERENCES ").append(this.sqlGenerator.escape("m_code_value")).append(" (").append("id").append(")");
                        }
                    }
                }
            }
        } else if (StringUtils.isNotBlank((CharSequence)code)) {
            oldName = this.datatableColumnNameToCodeValueName(oldName, code);
            newName = StringUtils.isNotBlank((CharSequence)newCode) ? this.datatableColumnNameToCodeValueName(newName, newCode) : this.datatableColumnNameToCodeValueName(newName, code);
        }
        DatabaseType dialect = this.databaseTypeResolver.databaseType();
        ResultsetColumnHeaderData columnHeader = mapColumnNameDefinition.get(oldName);
        JdbcJavaType type = columnHeader.getColumnType();
        boolean nameChanged = !StringUtils.isBlank((CharSequence)newName) && !newName.equals(oldName);
        boolean lengthChanged = length != null && !length.equals(columnHeader.getColumnLength()) && type.hasPrecision(dialect);
        boolean nullityChanged = newMandatory != null && newMandatory.booleanValue() != columnHeader.isMandatory();
        boolean bl = afterChanged = after != null && this.databaseTypeResolver.isMySQL();
        if (nameChanged || lengthChanged || nullityChanged || afterChanged) {
            boolean mandatory;
            Integer precision = length == null ? null : Integer.valueOf(length.intValue());
            Integer scale = null;
            if (type.isDecimalType()) {
                precision = 19;
                scale = 6;
            }
            String colName = StringUtils.isBlank((CharSequence)newName) ? oldName : newName;
            boolean bl2 = mandatory = newMandatory == null ? columnHeader.isMandatory() : newMandatory.booleanValue();
            if (this.databaseTypeResolver.isMySQL()) {
                String modifySql = nameChanged ? "CHANGE " + this.sqlGenerator.escape(oldName) + " " + this.sqlGenerator.escape(colName) : " MODIFY " + this.sqlGenerator.escape(colName);
                changeBuilder.append(", ").append(modifySql).append(" ").append(type.formatSql(dialect, precision, scale)).append(mandatory ? " NOT NULL" : " DEFAULT NULL");
                if (after != null) {
                    changeBuilder.append(" AFTER ").append(this.sqlGenerator.escape(after));
                }
            } else {
                if (nameChanged) {
                    renameBuilder.append("ALTER TABLE ").append(this.sqlGenerator.escape(datatableName)).append(" RENAME COLUMN ").append(this.sqlGenerator.escape(oldName)).append(" TO ").append(this.sqlGenerator.escape(newName)).append("; ");
                }
                if (lengthChanged) {
                    changeBuilder.append(", ALTER ").append(this.sqlGenerator.escape(colName)).append(" type ").append(type.formatSql(dialect, precision, scale));
                }
                if (nullityChanged) {
                    changeBuilder.append(", ALTER ").append(this.sqlGenerator.escape(colName)).append(mandatory ? " set not null" : " drop not null");
                }
            }
        }
    }

    private void parseDatatableColumnForDrop(JsonObject column, StringBuilder sqlBuilder, String datatableName, StringBuilder constrainBuilder, List<String> codeMappings) {
        String name;
        String datatableAlias = datatableName.toLowerCase().replaceAll("\\s", "_");
        String string = name = column.has("name") ? column.get("name").getAsString() : null;
        if (name == null) {
            throw new GeneralPlatformDomainRuleException("error.msg.missing.datatable.column.name", "Datatable column name to drop is missing.", new Object[0]);
        }
        sqlBuilder.append(", DROP COLUMN ").append(this.sqlGenerator.escape(name)).append(" ");
        String fkName = "fk_" + datatableAlias + "_" + name;
        String schemaSql = this.databaseTypeResolver.isMySQL() ? "i.TABLE_SCHEMA = SCHEMA()" : "i.table_catalog = current_catalog AND i.table_schema = current_schema";
        String findFKSql = "SELECT count(*) FROM information_schema.TABLE_CONSTRAINTS i WHERE i.CONSTRAINT_TYPE = 'FOREIGN KEY' AND " + schemaSql + " AND i.TABLE_NAME = '" + datatableName + "' AND i.CONSTRAINT_NAME = '" + fkName + "' ";
        Integer count = (Integer)this.jdbcTemplate.queryForObject(findFKSql, Integer.class);
        if (count != null && count > 0) {
            codeMappings.add(datatableAlias + "_" + name);
            constrainBuilder.append(", DROP FOREIGN KEY ").append(this.sqlGenerator.escape(fkName)).append(" ");
        }
    }

    private void registerColumnCodeMapping(Map<String, Long> codeMappings) {
        if (codeMappings != null && !codeMappings.isEmpty()) {
            String[] addSqlList = new String[codeMappings.size()];
            int i = 0;
            for (Map.Entry<String, Long> mapEntry : codeMappings.entrySet()) {
                addSqlList[i++] = "insert into x_table_column_code_mappings (column_alias_name, code_id) values ('" + mapEntry.getKey() + "'," + String.valueOf(mapEntry.getValue()) + ");";
            }
            this.jdbcTemplate.batchUpdate(addSqlList);
        }
    }

    private void deleteColumnCodeMapping(List<String> columnNames) {
        if (columnNames != null && !columnNames.isEmpty()) {
            String[] deleteSqlList = new String[columnNames.size()];
            int i = 0;
            for (String columnName : columnNames) {
                deleteSqlList[i++] = "DELETE FROM x_table_column_code_mappings WHERE  column_alias_name='" + columnName + "';";
            }
            this.jdbcTemplate.batchUpdate(deleteSqlList);
        }
    }

    private int getCodeIdForColumn(String dataTableNameAlias, String name) {
        StringBuilder checkColumnCodeMapping = new StringBuilder();
        checkColumnCodeMapping.append("select ccm.code_id from x_table_column_code_mappings ccm where ccm.column_alias_name='").append(dataTableNameAlias).append("_").append(name).append("'");
        Integer codeId = 0;
        try {
            codeId = (Integer)this.jdbcTemplate.queryForObject(checkColumnCodeMapping.toString(), Integer.class);
        }
        catch (EmptyResultDataAccessException e) {
            log.warn("Error occurred.", (Throwable)e);
        }
        return (Integer)ObjectUtils.defaultIfNull((Object)codeId, (Object)0);
    }

    private void removeNullValuesFromStringColumn(String datatableName, JsonObject column, Map<String, ResultsetColumnHeaderData> mapColumnNameDefinition) {
        JdbcJavaType type;
        boolean mandatory = column.has("mandatory") && column.get("mandatory").getAsBoolean();
        String name = column.has("name") ? column.get("name").getAsString() : "";
        JdbcJavaType jdbcJavaType = type = mapColumnNameDefinition.containsKey(name) ? mapColumnNameDefinition.get(name).getColumnType() : null;
        if (type != null && mandatory && type.isStringType()) {
            String sql = "UPDATE " + this.sqlGenerator.escape(datatableName) + " SET " + this.sqlGenerator.escape(name) + " = '' WHERE " + this.sqlGenerator.escape(name) + " IS NULL";
            this.jdbcTemplate.update(sql);
        }
    }

    private void updateUniqueConstraintsForTable(String datatableName, JsonArray changeColumns, Map<String, ResultsetColumnHeaderData> mapColumnNameDefinition) {
        for (JsonElement column : changeColumns) {
            String name;
            String string = name = column.getAsJsonObject().has("name") ? column.getAsJsonObject().get("name").getAsString() : null;
            if (!mapColumnNameDefinition.containsKey(name)) {
                throw new PlatformDataIntegrityException("error.msg.datatable.column.missing.update.parse", "Column " + name + " does not exist.", name, new Object[0]);
            }
            this.updateColumnUniqueConstraints(datatableName, column.getAsJsonObject(), mapColumnNameDefinition.get(column.getAsJsonObject().get("name").getAsString()));
        }
    }

    private void updateColumnUniqueConstraints(String datatableName, JsonObject column, ResultsetColumnHeaderData columnMetaData) {
        String name = column.has("name") ? column.get("name").getAsString() : null;
        String columnNewName = column.has("newName") ? column.get("newName").getAsString() : null;
        boolean isAlreadyUnique = this.genericDataService.isExplicitlyUnique(datatableName, name);
        boolean setUnique = column.has("unique") ? column.get("unique").getAsBoolean() : isAlreadyUnique;
        String uniqueKeyName = this.datatableKeywordGenerator.generateUniqueKeyName(datatableName, name);
        if (isAlreadyUnique) {
            if (!setUnique) {
                this.dropUniqueConstraint(datatableName, uniqueKeyName);
            } else {
                this.checkColumnRenameAndModifyUniqueConstraint(datatableName, columnNewName, uniqueKeyName);
            }
        } else if (setUnique) {
            this.checkColumnRenameAndCreateUniqueConstraint(datatableName, name, columnNewName, uniqueKeyName);
        }
    }

    private void checkColumnRenameAndCreateUniqueConstraint(String datatableName, String name, String columnNewName, String constraintKey) {
        if (columnNewName != null) {
            String uniqueKeyName = this.datatableKeywordGenerator.generateUniqueKeyName(datatableName, columnNewName);
            this.createUniqueConstraint(datatableName, columnNewName, uniqueKeyName);
        } else {
            this.createUniqueConstraint(datatableName, name, constraintKey);
        }
    }

    private void checkColumnRenameAndModifyUniqueConstraint(String datatableName, String columnNewName, String existingConstraint) {
        if (columnNewName != null) {
            this.dropUniqueConstraint(datatableName, existingConstraint);
            String uniqueKeyName = this.datatableKeywordGenerator.generateUniqueKeyName(datatableName, columnNewName);
            this.createUniqueConstraint(datatableName, columnNewName, uniqueKeyName);
        }
    }

    private void createUniqueConstraint(String datatableName, String columnName, String uniqueKeyName) {
        String sql = "ALTER TABLE " + this.sqlGenerator.escape(datatableName) + " ADD CONSTRAINT " + this.sqlGenerator.escape(uniqueKeyName) + " UNIQUE (" + this.sqlGenerator.escape(columnName) + ");";
        this.jdbcTemplate.execute(sql);
    }

    private void dropUniqueConstraint(String datatableName, String uniqueKeyName) {
        String sql = "ALTER TABLE " + this.sqlGenerator.escape(datatableName) + " DROP CONSTRAINT " + this.sqlGenerator.escape(uniqueKeyName) + ";";
        this.jdbcTemplate.execute(sql);
    }

    private void updateIndexesForTable(String datatableName, JsonArray changeColumns, Map<String, ResultsetColumnHeaderData> mapColumnNameDefinition) {
        for (JsonElement column : changeColumns) {
            String name;
            String string = name = column.getAsJsonObject().has("name") ? column.getAsJsonObject().get("name").getAsString() : null;
            if (!mapColumnNameDefinition.containsKey(name)) {
                throw new PlatformDataIntegrityException("error.msg.datatable.column.missing.update.parse", "Column " + name + " does not exist.", name, new Object[0]);
            }
            this.updateIndexForColumn(datatableName, column.getAsJsonObject(), mapColumnNameDefinition.get(column.getAsJsonObject().get("name").getAsString()));
        }
    }

    private void updateIndexForColumn(String datatableName, JsonObject column, ResultsetColumnHeaderData columnMetaData) {
        boolean setForUnique;
        String name = column.has("name") ? column.get("name").getAsString() : null;
        String columnNewName = column.has("newName") ? column.get("newName").getAsString() : null;
        boolean isAlreadyUnique = this.genericDataService.isExplicitlyUnique(datatableName, name);
        boolean bl = setForUnique = column.has("unique") ? column.get("unique").getAsBoolean() : isAlreadyUnique;
        if (setForUnique) {
            return;
        }
        boolean isAlreadyIndexed = this.genericDataService.isExplicitlyIndexed(datatableName, name);
        boolean setForIndexed = column.has("indexed") ? column.get("indexed").getAsBoolean() : isAlreadyIndexed;
        String indexName = this.datatableKeywordGenerator.generateIndexName(datatableName, name);
        if (isAlreadyIndexed) {
            if (!setForIndexed) {
                this.dropIndex(datatableName, indexName);
            } else {
                this.checkColumnRenameAndModifyIndex(datatableName, columnNewName, indexName);
            }
        } else if (setForIndexed) {
            this.checkColumnRenameAndCreateIndex(datatableName, name, columnNewName, indexName);
        }
    }

    private void checkColumnRenameAndCreateIndex(String datatableName, String columnExistingName, String columnNewName, String indexName) {
        if (columnNewName != null) {
            String newIndexName = this.datatableKeywordGenerator.generateIndexName(datatableName, columnNewName);
            this.createIndex(newIndexName, datatableName, columnNewName);
        } else {
            this.createIndex(indexName, datatableName, columnExistingName);
        }
    }

    private void checkColumnRenameAndModifyIndex(String datatableName, String columnNewName, String existingIndex) {
        if (columnNewName != null) {
            this.dropIndex(datatableName, existingIndex);
            String newIndexName = this.datatableKeywordGenerator.generateIndexName(datatableName, columnNewName);
            this.createIndex(newIndexName, datatableName, columnNewName);
        }
    }

    private void createIndex(String indexName, String tableName, String columnName) {
        String safeIndexName = this.sqlGenerator.escape(indexName);
        String safeTableName = this.sqlGenerator.escape(tableName);
        String safeColumnName = this.sqlGenerator.escape(columnName);
        String sqlIndexUpdateBuilder = "CREATE INDEX %s ON %s (%s);".formatted(safeIndexName, safeTableName, safeColumnName);
        this.jdbcTemplate.execute(sqlIndexUpdateBuilder);
    }

    private void dropIndex(String datatableName, String uniqueIndexName) {
        StringBuilder sqlIndexUpdateBuilder = new StringBuilder();
        if (this.databaseTypeResolver.isMySQL()) {
            sqlIndexUpdateBuilder.append("ALTER TABLE ").append(this.sqlGenerator.escape(datatableName)).append(" ");
        }
        sqlIndexUpdateBuilder.append("DROP INDEX ").append(this.sqlGenerator.escape(uniqueIndexName)).append(";");
        this.jdbcTemplate.execute(sqlIndexUpdateBuilder.toString());
    }

    private CommandProcessingResult createNewDatatableEntry(String dataTableName, Long appTableId, String json, boolean addScore) {
        EntityTables entityTable = this.datatableUtil.queryForApplicationEntity(dataTableName);
        CommandProcessingResult commandProcessingResult = this.datatableUtil.checkMainResourceExistsWithinScope(entityTable, appTableId);
        List columnHeaders = this.genericDataService.fillResultsetColumnHeaders(dataTableName);
        Map headersByName = this.searchUtil.mapHeadersToName((Collection)columnHeaders);
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        Map dataParams = this.fromJsonHelper.extractDataMap(typeOfMap, json);
        String dateFormat = (String)dataParams.get("dateFormat");
        String dateTimeFormat = dataParams.getOrDefault("dateTimeFormat", dateFormat);
        String localeString = (String)dataParams.get("locale");
        Locale locale = localeString == null ? null : JsonParserHelper.localeFromString((String)localeString);
        ArrayList<String> insertColumns = new ArrayList<String>(List.of(entityTable.getForeignKeyColumnNameOnDatatable(), "created_at", "updated_at"));
        LocalDateTime auditDateTime = DateUtils.getAuditLocalDateTime();
        ArrayList<LocalDateTime> params = new ArrayList<LocalDateTime>(List.of(appTableId, auditDateTime, auditDateTime));
        HashMap<String, Object> dataObjectParams = new HashMap<String, Object>();
        for (Map.Entry entry : dataParams.entrySet()) {
            ResultsetColumnHeaderData columnHeader;
            if (DatatableWriteServiceImpl.isTechnicalParam((String)((String)entry.getKey())) || !DatatableWriteServiceImpl.isUserInsertable((EntityTables)entityTable, (ResultsetColumnHeaderData)(columnHeader = this.searchUtil.validateToJdbcColumn((String)entry.getKey(), headersByName, false)))) continue;
            insertColumns.add(columnHeader.getColumnName());
            Object valueParam = this.searchUtil.parseJdbcColumnValue(columnHeader, (String)entry.getValue(), dateFormat, dateTimeFormat, locale, false, this.sqlGenerator);
            params.add((LocalDateTime)valueParam);
            dataObjectParams.put((String)entry.getKey(), valueParam);
        }
        if (addScore) {
            int scoreValue;
            List<Object> scoreIds = params.stream().filter(e -> e != null && !String.valueOf(e).isBlank()).toList();
            if (scoreIds.isEmpty()) {
                scoreValue = 0;
            } else {
                StringBuilder scoreSql = new StringBuilder("SELECT SUM(code_score) FROM m_code_value WHERE m_code_value.");
                ArrayList scoreParams = new ArrayList();
                this.searchUtil.buildCondition("id", JdbcJavaType.BIGINT, SqlOperator.IN, scoreIds, scoreSql, scoreParams, null, this.sqlGenerator);
                Integer score = (Integer)this.jdbcTemplate.queryForObject(scoreSql.toString(), Integer.class, (Object[])scoreParams.toArray(Object[]::new));
                scoreValue = score == null ? 0 : score;
            }
            insertColumns.add("score");
            params.add((LocalDateTime)((Object)Integer.valueOf(scoreValue)));
        }
        GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
        String sql = this.sqlGenerator.buildInsert(dataTableName, insertColumns, headersByName);
        try {
            int updated = this.jdbcTemplate.update(con -> {
                PreparedStatement ps = con.prepareStatement(sql, 1);
                DatatableWriteServiceImpl.setParameters((ArrayList)params, (PreparedStatement)ps);
                return ps;
            }, (KeyHolder)keyHolder);
            if (updated != 1) {
                throw new PlatformDataIntegrityException("error.msg.invalid.insert", "Expected one inserted row.", new Object[0]);
            }
            Long resourceId = appTableId;
            if (this.datatableUtil.isMultirowDatatable(columnHeaders)) {
                resourceId = this.sqlGenerator.fetchPK(keyHolder);
            }
            DatatableEntryDetails datatableEntryDetails = new DatatableEntryDetails(dataTableName, entityTable, resourceId, appTableId, dataObjectParams);
            this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new DatatableEntryCreatedBusinessEvent(datatableEntryDetails));
            return CommandProcessingResult.fromCommandProcessingResult((CommandProcessingResult)commandProcessingResult, (Long)resourceId);
        }
        catch (DataAccessException dve) {
            this.handleDataIntegrityIssues(dataTableName, appTableId, dve.getMostSpecificCause(), (Exception)((Object)dve));
            return CommandProcessingResult.empty();
        }
        catch (PersistenceException e2) {
            this.handleDataIntegrityIssues(dataTableName, appTableId, ExceptionUtils.getRootCause((Throwable)e2.getCause()), (Exception)((Object)e2));
            return CommandProcessingResult.empty();
        }
    }

    private static void setParameters(ArrayList<Object> params, PreparedStatement ps) {
        AtomicInteger parameterIndex = new AtomicInteger(1);
        params.forEach(param -> {
            try {
                ps.setObject(parameterIndex.getAndIncrement(), param);
            }
            catch (SQLException e) {
                throw new IllegalArgumentException(e);
            }
        });
    }

    private static boolean isUserInsertable(@NotNull EntityTables entityTable, @NotNull ResultsetColumnHeaderData columnHeader) {
        String columnName = columnHeader.getColumnName();
        return !columnHeader.getIsColumnPrimaryKey() && !"created_at".equals(columnName) && !"updated_at".equals(columnName) && !entityTable.getForeignKeyColumnNameOnDatatable().equals(columnName);
    }

    private CommandProcessingResult updateDatatableEntry(String dataTableName, Long appTableId, Long datatableId, JsonCommand command) {
        Long primaryKey;
        EntityTables entityTable = this.datatableUtil.queryForApplicationEntity(dataTableName);
        CommandProcessingResult commandProcessingResult = this.datatableUtil.checkMainResourceExistsWithinScope(entityTable, appTableId);
        GenericResultsetData existingRows = this.datatableUtil.retrieveDataTableGenericResultSet(entityTable, dataTableName, appTableId, null, datatableId);
        if (existingRows.hasNoEntries()) {
            throw new DatatableNotFoundException(dataTableName, appTableId);
        }
        if (existingRows.hasMoreThanOneEntry()) {
            throw new PlatformDataIntegrityException("error.msg.attempting.multiple.update", "Application table: " + dataTableName + " Foreign key id: " + appTableId, new Object[0]);
        }
        List columnHeaders = existingRows.getColumnHeaders();
        if (this.datatableUtil.isMultirowDatatable(columnHeaders) && datatableId == null) {
            throw new PlatformDataIntegrityException("error.msg.attempting.multiple.update", "Application table: " + dataTableName + " Foreign key id: " + appTableId, new Object[0]);
        }
        Map headersByName = this.searchUtil.mapHeadersToName((Collection)columnHeaders);
        List existingValues = ((ResultsetRowData)existingRows.getData().get(0)).getRow();
        HashMap valuesByHeader = columnHeaders.stream().collect(HashMap::new, (map, e) -> map.put(e, existingValues.get(map.size())), (map, map2) -> {});
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        Map dataParams = this.fromJsonHelper.extractDataMap(typeOfMap, command.json());
        HashMap<String, Object> dataObjectParams = new HashMap<String, Object>();
        String dateFormat = (String)dataParams.get("dateFormat");
        String dateTimeFormat = dataParams.getOrDefault("dateTimeFormat", dateFormat);
        String localeString = (String)dataParams.get("locale");
        Locale locale = localeString == null ? null : JsonParserHelper.localeFromString((String)localeString);
        DatabaseType dialect = this.sqlGenerator.getDialect();
        ArrayList<String> updateColumns = new ArrayList<String>(List.of("updated_at"));
        ArrayList<LocalDateTime> params = new ArrayList<LocalDateTime>(List.of(DateUtils.getAuditLocalDateTime()));
        HashMap<String, Object> changes = new HashMap<String, Object>();
        for (Map.Entry entry : dataParams.entrySet()) {
            ResultsetColumnHeaderData columnHeader;
            if (DatatableWriteServiceImpl.isTechnicalParam((String)((String)entry.getKey())) || !DatatableWriteServiceImpl.isUserUpdatable((EntityTables)entityTable, (ResultsetColumnHeaderData)(columnHeader = this.searchUtil.validateToJdbcColumn((String)entry.getKey(), headersByName, false)))) continue;
            String columnName = columnHeader.getColumnName();
            Object existingValue = valuesByHeader.get(columnHeader);
            Object columnValue = this.searchUtil.parseColumnValue(columnHeader, (String)entry.getValue(), dateFormat, dateTimeFormat, locale, false, this.sqlGenerator);
            dataObjectParams.put((String)entry.getKey(), columnValue);
            if (columnHeader.getColumnType().isDecimalType() && MathUtil.isEqualTo((BigDecimal)((BigDecimal)existingValue), (BigDecimal)((BigDecimal)columnValue)) || (existingValue == null ? columnValue == null : existingValue.equals(columnValue))) {
                log.debug("Ignore change on update {}:{}", (Object)dataTableName, (Object)columnName);
                continue;
            }
            updateColumns.add(columnName);
            params.add((LocalDateTime)columnHeader.getColumnType().toJdbcValue(dialect, columnValue, false));
            changes.put(columnName, columnValue);
        }
        Long l = primaryKey = datatableId == null ? appTableId : datatableId;
        if (!updateColumns.isEmpty()) {
            ResultsetColumnHeaderData pkColumn = this.searchUtil.getFiltered((Collection)columnHeaders, ResultsetColumnHeaderData::getIsColumnPrimaryKey);
            if (pkColumn != null) {
                params.add((LocalDateTime)((Object)primaryKey));
                String sql = this.sqlGenerator.buildUpdate(dataTableName, updateColumns, headersByName) + " WHERE " + pkColumn.getColumnName() + " = ?";
                int updated = this.jdbcTemplate.update(sql, (Object[])params.toArray(Object[]::new));
                if (updated != 1) {
                    throw new PlatformDataIntegrityException("error.msg.invalid.update", "Expected one updated row.", new Object[0]);
                }
            }
        } else {
            log.debug("No change on update {}", (Object)dataTableName);
        }
        DatatableEntryDetails datatableEntryDetails = new DatatableEntryDetails(dataTableName, entityTable, datatableId, appTableId, dataObjectParams);
        this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new DatatableEntryUpdatedBusinessEvent(datatableEntryDetails));
        return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId(primaryKey).withOfficeId(commandProcessingResult.getOfficeId()).withGroupId(commandProcessingResult.getGroupId()).withClientId(commandProcessingResult.getClientId()).withSavingsId(commandProcessingResult.getSavingsId()).withLoanId(commandProcessingResult.getLoanId()).withTransactionId(commandProcessingResult.getTransactionId()).with(changes).build();
    }

    private static boolean isUserUpdatable(@NotNull EntityTables entityTable, @NotNull ResultsetColumnHeaderData columnHeader) {
        return DatatableWriteServiceImpl.isUserInsertable((EntityTables)entityTable, (ResultsetColumnHeaderData)columnHeader);
    }

    private CommandProcessingResult deleteDatatableEntries(String dataTableName, Long appTableId, Long datatableId, JsonCommand command) {
        Long whereValue;
        String whereColumn;
        this.datatableUtil.validateDatatableName(dataTableName);
        if (this.isDatatableAttachedToEntityDatatableCheck(dataTableName)) {
            throw new DatatableEntryRequiredException(dataTableName, appTableId);
        }
        EntityTables entityTable = this.datatableUtil.queryForApplicationEntity(dataTableName);
        CommandProcessingResult commandProcessingResult = this.datatableUtil.checkMainResourceExistsWithinScope(entityTable, appTableId);
        if (datatableId == null) {
            whereColumn = this.datatableUtil.getFKField(entityTable);
            whereValue = appTableId;
        } else {
            whereColumn = "id";
            whereValue = datatableId;
        }
        String sql = "DELETE FROM " + this.sqlGenerator.escape(dataTableName) + " WHERE " + this.sqlGenerator.escape(whereColumn) + " = " + whereValue;
        this.jdbcTemplate.update(sql);
        Map dataParams = null;
        DatatableEntryDetails datatableEntryDetails = new DatatableEntryDetails(dataTableName, entityTable, datatableId, appTableId, dataParams);
        this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new DatatableEntryDeletedBusinessEvent(datatableEntryDetails));
        return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId(whereValue).withOfficeId(commandProcessingResult.getOfficeId()).withGroupId(commandProcessingResult.getGroupId()).withClientId(commandProcessingResult.getClientId()).withSavingsId(commandProcessingResult.getSavingsId()).withLoanId(commandProcessingResult.getLoanId()).withTransactionId(commandProcessingResult.getTransactionId()).build();
    }

    private boolean isDatatableAttachedToEntityDatatableCheck(String datatableName) {
        String sql = "SELECT COUNT(edc.x_registered_table_name) FROM x_registered_table xrt JOIN m_entity_datatable_check edc ON edc.x_registered_table_name = xrt.registered_table_name WHERE edc.x_registered_table_name = '" + datatableName + "'";
        Long count = (Long)this.jdbcTemplate.queryForObject(sql, Long.class);
        return count != null && count > 0L;
    }

    private void validateDataTableExists(String datatableName) {
        String sql = "select (CASE WHEN exists (select 1 from information_schema.tables where table_schema = " + this.sqlGenerator.currentSchema() + " and table_name = ?) THEN 'true' ELSE 'false' END)";
        boolean dataTableExists = Boolean.parseBoolean((String)this.jdbcTemplate.queryForObject(sql, String.class, new Object[]{datatableName}));
        if (!dataTableExists) {
            throw new PlatformDataIntegrityException("error.msg.invalid.datatable", "Invalid Data Table: " + datatableName, "name", new Object[]{datatableName});
        }
    }

    private void assertDataTableEmpty(String datatableName) {
        int rowCount = this.getDatatableRowCount(datatableName);
        if (rowCount != 0) {
            throw new GeneralPlatformDomainRuleException("error.msg.non.empty.datatable.cannot.be.deleted", "Non-empty datatable cannot be deleted.", new Object[0]);
        }
    }

    @NotNull
    private String mapApiTypeToDbType(String apiType, Integer length) {
        if (StringUtils.isEmpty((CharSequence)apiType)) {
            return "";
        }
        JdbcJavaType jdbcType = DatatableCommandFromApiJsonDeserializer.mapApiTypeToJdbcType((String)apiType);
        DatabaseType dialect = this.databaseTypeResolver.databaseType();
        if (jdbcType.isDecimalType()) {
            return jdbcType.formatSql(dialect, Integer.valueOf(19), Integer.valueOf(6));
        }
        if (apiType.equalsIgnoreCase("dropdown")) {
            return jdbcType.formatSql(dialect, Integer.valueOf(11));
        }
        return jdbcType.formatSql(dialect, length);
    }

    private int getDatatableRowCount(String datatableName) {
        String sql = "select count(*) from " + this.sqlGenerator.escape(datatableName);
        Integer count = (Integer)this.jdbcTemplate.queryForObject(sql, Integer.class);
        return count == null ? 0 : count;
    }

    private static boolean isTechnicalParam(String param) {
        return "dateFormat".equals(param) || "dateTimeFormat".equals(param) || "locale".equals(param);
    }

    private String datatableColumnNameToCodeValueName(String columnName, String code) {
        return code + "_cd_" + columnName;
    }

    private void handleDataIntegrityIssues(String dataTableName, Long appTableId, Throwable realCause, Exception e) {
        Object[] msgArgs;
        Object msgCode = "error.msg.datatable";
        String msg = "Unknown data integrity issue with datatable `" + dataTableName + "`";
        String param = null;
        Throwable cause = e.getCause();
        if (realCause != null && realCause.getMessage().contains("Duplicate entry") || cause != null && cause.getMessage().contains("Duplicate entry")) {
            msgCode = (String)msgCode + ".entry.duplicate";
            param = "datatableName";
            if (appTableId == null) {
                msg = "Datatable `" + dataTableName + "` is already registered against an application table.";
                msgArgs = new Object[]{dataTableName, e};
            } else {
                msg = "An entry already exists for datatable `" + dataTableName + "` and application table with identifier `" + appTableId + "`.";
                msgArgs = new Object[]{dataTableName, appTableId, e};
            }
        } else if (realCause != null && realCause.getMessage().contains("doesn't have a default value") || cause != null && cause.getMessage().contains("doesn't have a default value")) {
            msgCode = (String)msgCode + ".no.value.provided.for.required.fields";
            msg = "No values provided for the datatable `" + dataTableName + "` and application table with identifier `" + appTableId + "`.";
            param = "datatableName";
            msgArgs = new Object[]{dataTableName, appTableId, e};
        } else {
            msgCode = (String)msgCode + ".unknown.data.integrity.issue";
            msgArgs = new Object[]{dataTableName, e};
        }
        log.error("Error occured.", (Throwable)e);
        throw ErrorHandler.getMappable((Throwable)e, (String)msgCode, (String)msg, (String)param, (Object[])msgArgs);
    }

    @Generated
    public DatatableWriteServiceImpl(JdbcTemplate jdbcTemplate, DatabaseTypeResolver databaseTypeResolver, DatabaseSpecificSQLGenerator sqlGenerator, PlatformSecurityContext context, FromJsonHelper fromJsonHelper, GenericDataService genericDataService, DatatableCommandFromApiJsonDeserializer fromApiJsonDeserializer, ConfigurationDomainService configurationDomainService, CodeReadPlatformService codeReadPlatformService, DataTableValidator dataTableValidator, NamedParameterJdbcTemplate namedParameterJdbcTemplate, DatatableKeywordGenerator datatableKeywordGenerator, SearchUtil searchUtil, BusinessEventNotifierService businessEventNotifierService, DatatableReadService datatableReadService, DatatableUtil datatableUtil) {
        this.jdbcTemplate = jdbcTemplate;
        this.databaseTypeResolver = databaseTypeResolver;
        this.sqlGenerator = sqlGenerator;
        this.context = context;
        this.fromJsonHelper = fromJsonHelper;
        this.genericDataService = genericDataService;
        this.fromApiJsonDeserializer = fromApiJsonDeserializer;
        this.configurationDomainService = configurationDomainService;
        this.codeReadPlatformService = codeReadPlatformService;
        this.dataTableValidator = dataTableValidator;
        this.namedParameterJdbcTemplate = namedParameterJdbcTemplate;
        this.datatableKeywordGenerator = datatableKeywordGenerator;
        this.searchUtil = searchUtil;
        this.businessEventNotifierService = businessEventNotifierService;
        this.datatableReadService = datatableReadService;
        this.datatableUtil = datatableUtil;
    }
}

