/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.documentmanagement.service;

import java.io.InputStream;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.domain.Base64EncodedImage;
import org.apache.fineract.infrastructure.documentmanagement.api.ImagesApiResource;
import org.apache.fineract.infrastructure.documentmanagement.contentrepository.ContentRepository;
import org.apache.fineract.infrastructure.documentmanagement.contentrepository.ContentRepositoryFactory;
import org.apache.fineract.infrastructure.documentmanagement.domain.Image;
import org.apache.fineract.infrastructure.documentmanagement.domain.ImageRepository;
import org.apache.fineract.infrastructure.documentmanagement.domain.StorageType;
import org.apache.fineract.infrastructure.documentmanagement.service.ImageWritePlatformService;
import org.apache.fineract.organisation.staff.domain.Staff;
import org.apache.fineract.organisation.staff.domain.StaffRepositoryWrapper;
import org.apache.fineract.portfolio.client.domain.Client;
import org.apache.fineract.portfolio.client.domain.ClientRepositoryWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ImageWritePlatformServiceJpaRepositoryImpl
implements ImageWritePlatformService {
    private final ContentRepositoryFactory contentRepositoryFactory;
    private final ClientRepositoryWrapper clientRepositoryWrapper;
    private final ImageRepository imageRepository;
    private final StaffRepositoryWrapper staffRepositoryWrapper;

    @Autowired
    public ImageWritePlatformServiceJpaRepositoryImpl(ContentRepositoryFactory documentStoreFactory, ClientRepositoryWrapper clientRepositoryWrapper, ImageRepository imageRepository, StaffRepositoryWrapper staffRepositoryWrapper) {
        this.contentRepositoryFactory = documentStoreFactory;
        this.clientRepositoryWrapper = clientRepositoryWrapper;
        this.imageRepository = imageRepository;
        this.staffRepositoryWrapper = staffRepositoryWrapper;
    }

    @Transactional
    public CommandProcessingResult saveOrUpdateImage(String entityName, Long clientId, String imageName, InputStream inputStream, Long fileSize) {
        Object owner = this.deletePreviousImage(entityName, clientId);
        ContentRepository contentRepository = this.contentRepositoryFactory.getRepository();
        String imageLocation = contentRepository.saveImage(inputStream, clientId, imageName, fileSize);
        return this.updateImage(owner, imageLocation, contentRepository.getStorageType());
    }

    @Transactional
    public CommandProcessingResult saveOrUpdateImage(String entityName, Long clientId, Base64EncodedImage encodedImage) {
        Object owner = this.deletePreviousImage(entityName, clientId);
        ContentRepository contenRepository = this.contentRepositoryFactory.getRepository();
        String imageLocation = contenRepository.saveImage(encodedImage, clientId, "image");
        return this.updateImage(owner, imageLocation, contenRepository.getStorageType());
    }

    @Transactional
    public CommandProcessingResult deleteImage(String entityName, Long clientId) {
        Client owner = null;
        Image image = null;
        if (ImagesApiResource.EntityTypeForImages.CLIENTS.toString().equals(entityName)) {
            Client client = owner = this.clientRepositoryWrapper.findOneWithNotFoundDetection(clientId);
            image = client.getImage();
            client.setImage(null);
            this.clientRepositoryWrapper.save(client);
        } else if (ImagesApiResource.EntityTypeForImages.STAFF.toString().equals(entityName)) {
            owner = this.staffRepositoryWrapper.findOneWithNotFoundDetection(clientId);
            Staff staff = (Staff)owner;
            image = staff.getImage();
            staff.setImage(null);
            this.staffRepositoryWrapper.save(staff);
        }
        if (image != null) {
            ContentRepository contentRepository = this.contentRepositoryFactory.getRepository(StorageType.fromInt((int)image.getStorageType()));
            contentRepository.deleteImage(image.getLocation());
            this.imageRepository.delete((Object)image);
        }
        return CommandProcessingResult.resourceResult((Long)clientId);
    }

    private Object deletePreviousImage(String entityName, Long entityId) {
        Client owner = null;
        Image image = null;
        if (ImagesApiResource.EntityTypeForImages.CLIENTS.toString().equals(entityName)) {
            Client client = this.clientRepositoryWrapper.findOneWithNotFoundDetection(entityId);
            image = client.getImage();
            owner = client;
        } else if (ImagesApiResource.EntityTypeForImages.STAFF.toString().equals(entityName)) {
            Staff staff = this.staffRepositoryWrapper.findOneWithNotFoundDetection(entityId);
            image = staff.getImage();
            owner = staff;
        }
        if (image != null) {
            ContentRepository contentRepository = this.contentRepositoryFactory.getRepository(StorageType.fromInt((int)image.getStorageType()));
            contentRepository.deleteImage(image.getLocation());
        }
        return owner;
    }

    private CommandProcessingResult updateImage(Object owner, String imageLocation, StorageType storageType) {
        Image image = null;
        Long clientId = null;
        if (owner instanceof Client) {
            Client client = (Client)owner;
            image = client.getImage();
            clientId = (Long)client.getId();
            image = this.createImage(image, imageLocation, storageType);
            client.setImage(image);
            this.clientRepositoryWrapper.save(client);
        } else if (owner instanceof Staff) {
            Staff staff = (Staff)owner;
            image = staff.getImage();
            clientId = (Long)staff.getId();
            image = this.createImage(image, imageLocation, storageType);
            staff.setImage(image);
            this.staffRepositoryWrapper.save(staff);
        }
        if (image != null) {
            this.imageRepository.save((Object)image);
        }
        return CommandProcessingResult.resourceResult(clientId);
    }

    private Image createImage(Image image, String imageLocation, StorageType storageType) {
        if (image == null) {
            image = new Image(imageLocation, storageType);
        } else {
            image.setLocation(imageLocation);
            image.setStorageType(storageType.getValue());
        }
        return image;
    }
}

